FasdUAS 1.101.10        
  k           
  l          _Y
	Application.applescript

	Copyright  2002-2003 by Terry Teague. All Rights Reserved Worldwide.
	Portions Copyright  2002-2003 Sun Microsystems Inc.

PRODUCT
	Start OpenOffice.org

FILE
	Application.applescript

DEVELOPED BY
	Terry Teague						terry_teague@users.sourceforge.net

DESCRIPTION
	Start OpenOffice.org (Start_OOo) is an AppleScript Studio (ASS) application that provides a front-end to the
	OpenOffice.org (OOo) productivity suite of programs running on Mac OS X, using a X11 XWindow server.
            
	This file implements the main AppleScript handlers.
        
	Ideas based on earlier work by other developers working on the OpenOffice.org port to Mac OS X, and
	tidbits from other AppleScript Studio developers :
            
	Ed Peterlin
	"asxless"
	Stuart Roebuck
	and others...
        
MODIFICATION HISTORY
	dd mmm yy	-	xxx	-	x.xRx	description of patch

	26 Aug 02	-	TRT	-	1.0b1	Initial version based on earlier work.
	11 Oct 02	-	TRT	-	1.0b2	Add support for OOo 1.0.1 Beta - direct to
	-		-		-		PostScript printing and use of URL or pathname to OOo.
	20 Oct 02	-	TRT	-	1.0b3	Add support for OroborOSX.
	25 Dec 02	-	TRT	-	1.0b3	Add support for ooqstart. Add Preferences panel to
	-		-		-		allow user to select defaults. Using Dec 2002 Developer
	-		-		-		Tools (should now allow Start_OOo to run in Mac OS X
	-		-		-		10.1.x). Fix problems with opening OOo documents after 
	-		-		-		Start_OOo is running.
	29 Dec 02	-	TRT	-	1.0b3	Tidy up the code. Always launch the XServer, if only to
	-		-		-		just bring the process to the front (activate).
	30 Dec 02	-	TRT	-	1.0b3	More tweaks for Mac OS X 10.1.x - hiding the
	-		-		-		"Information" floating window when necessary.
	04 Jan 03	-	TRT	-	1.0b4	Removed support for ooqstart. Wait for XDarwin
			-		-		process to be running before executing OOo. Let the
			-		-		default XServer be what is chosen at first launch of
			-		-		Start_OOo.
	13 Jan 03	-	TRT	-	1.0b5	Add support for Apple's X11.app.
	19 Jan 03	-	TRT	-	1.0b6	Fix bug when there are spaces in the paths.
	26 Jan 03	-	TRT	-	1.0b7	Add support for configuring printers.
	05 Feb 03	-	TRT	-	1.0b7	Patch the "soffice" script, if necessary.
	15 Feb 03	-	TRT	-	1.0b7	Add support for multiple versions of OOo in the
	-		-		-		"~/.sversionrc" file.
	16 Feb 03	-	TRT	-	1.0b7	Various tidy-ups. Check if running on valid system.                                          
	23 Feb 03	-	TRT	-	1.0b7	Do additional checks for existence of OOo pieces, and
	-		-		-		 fix the case of a missing "~/.sversionrc" file. Replace
	-		-		-		"pathFromURL()" handler and move code from
	-		-		-		"on Launched()" handler to new "Initialize()" handler to
	-		-		-		avoid strange problems in Mac OS X 10.1.x.
	02 Mar 03	-	TRT	-	1.0b7	Report error if the XServer or OOo can't be launched
	-		-		-		successfully. Redirect errors and output to a temporary
	-		-		-		file rather than /dev/null and use this file to provide
	-		-		-		details when errors are reported.
	06 Apr 03	-	TRT	-	1.0b8	Fix problem with this script being too long to
	-		-		-		edit with Script Editor - moved some handlers to
	-		-		-		separate "Utility.applescript".
	24 Apr 03	-	TRT	-	1.0b8	Add support for converting font files dragged to
	-		-		-		Start_OOo application icon into OOo font format -
	-		-		-		no longer launch XServer until necessary.
 	25 Apr 03	-	TRT	-	1.0b8	Add support for localized strings.
	-		-		-		Various tidy-ups.
 	29 Apr 03	-	TRT	-	1.0b8	Make sure documents to be opened are files, and
	-		-		-		not folders or disks.
	03 May 03	-	TRT	-	1.0b8	More workarounds for Mac OS X 10.1.x.
	09 May 03	-	TRT	-	1.0b8	Add support for multi-user launch script.
	25 May 03	-	TRT	-	1.0b8	Add support for default module to launch.
	-		-		-		Add more checking for launch failures.
	30 May 03	-	TRT	-	1.0b8	Use an alternate setting for X11 DISPLAY
	-		-		-		environment variable.
	-		-		-		Fix bug in first time use of X11.app.
                
       	
  l          	  
 
 
 l             ==== Properties ===       
 
 
 l          G A properties are NOT persistent in AppleScript Studio applications       
  l             
  l          / ) used for loading additional AppleScripts       
  j       0 
scriptsloaded 
scriptsLoaded
  m     
 boovfals    
  p        0 
utilitylib 
utilityLib      
  p        0 utility Utility      
  l              !
   l      "   "   path to OOo install    !  # $
 # j     % 0 
oooinstallurl 
oooInstallURL
 % m     & &       $  ' (
 ' j     )  0 oooinstallpath oooInstallPath
 ) m     * *       (  + ,
 + j   	  - &0 oooinstallescpath oooInstallEscPath
 - m   	 
 . .       ,  / 0
 / p     1 1   0 oooversionlist oooVersionList   0  2 3
 2 l          3  4 5
 4 l      6   6   Prefs panel    5  7 8
 7 j     9 0 prefswindow prefsWindow
 9 m    
 
null 8  : ;
 : l          ;  < =
 < l      >   >   Prefs    =  ? @
 ? l      A   A * $ Use XDarwin, OroborOSX, or X11.app?    @  B C
 B l      D E
 D j     F 0 whichxserver whichXServer
 F m       E   let user decide default    C  G H
 G l      I J
 I j     K 0 xservername XServerName
 K m     L L       J   let user decide default    H  M N
 M j     O 0 xserverpath XServerPath
 O m     P P       N  Q R
 Q j     S "0 oooversionindex oooVersionIndex
 S m      R  T U
 T j     V 0 
directtops 
directToPS
 V m    
 boovtrue U  W X
 W l          X  Y Z
 Y l      [   [   Info window    Z  \ ]
 \ j      ^ 0 
infowindow 
infoWindow
 ^ m    
 
null ]  _ `
 _ l          `  a b
 a l      c   c    list of documents to open    b  d e
 d j   ! $ f 0 filelist fileList
 f J   ! #   e  g h
 g l          h  i j
 i l      k   k ^ X Variables shared between launching Start_OOo/XServer and opening OOo documents/programs    j  l m
 l l      n o
 n j   % ) p 0 xdisplay XDISPLAY
 p m   % ( q q 
 :0.0    o   or "localhost:0"    m  r s
 r j   * , t .0 alreadyrunningxserver alreadyRunningXServer
 t m   * +
 boovfals s  u v
 u j   - 1 w 0 
defaultmodule 
defaultModule
 w m   - 0 x x 
 soffice    v  y z
 y j   2 4 { $0 sofficeisrunning sofficeIsRunning
 { m   2 3
 boovfals z  | }
 | j   5 9 ~ $0 spadminisrunning spadminIsRunning
 ~ m   5 6
 boovfals }   
  l       
  j   : >  0 	firsttime 	firstTime
  m   : ;
 boovfals    multi-user first time?       
  l       
  j   ? E  &0 initiallaunchtime initialLaunchTime
  m   ? B 
  9 3 wait for up to 10 secs for OOo to initially launch       
  p   F F    0 	erroutput 	errOutput      
  l             
  l             ==== Handlers ====        
  l             
  l          O I This handler will read the Start_OOo prefs from the Start_OOo prefs file       
  l          : 4 "~/Library/Preferences/org.OpenOffice.Start.plist".       
  l             
  i   F I  
  I       &0 readstartoooprefs readStartOOoPrefs    
  k          
  l          K E Initialize the user defaults (only happens if the prefs don't exist)       
  I      
 .appScalM****       ****
  m        % registerDefaultObjects:forKeys:      
 
witP
  J         
  J         
  m          
  m                
  m        
  m    
 boovtrue     
  J         
  m    	   
 xserver       
  m   	 
    xserverpath       
  m   
     
oooversion      
  m        directps             
  l           
  l        "  requires ASS v1.1 and later       
  l          make new default entry at end of default entries of user defaults with properties {xserver:0", xserverpath:"", oooversion:1, directps:true}       
  l           
  Q    ^  
  k    U     
  r    %  
  I     
 .appScalM****       ****
  m        defaultObjectForKey:      
 
witQ
  m       
 xserver     
  o       0 whichxserver whichXServer    
  r   & 3  
  I  & -  
 .appScalM****       ****
  m   & '    defaultObjectForKey:      
 
witQ
  m   ( )    xserverpath     
  o       0 xserverpath XServerPath    
  r   4 A  
  I  4 ;  
 .appScalM****       ****
  m   4 5    defaultObjectForKey:      
 
witQ
  m   6 7    
oooversion     
  o       "0 oooversionindex oooVersionIndex    
  r   B S  
  I  B M  
 .appScalM****       ****
  m   B E    defaultObjectForKey:      
 
witQ
  m   F I    directps     
  o       0 
directtops 
directToPS   
  l   T T      
        on error errStr number errNum
		-- *** Debug ***
		--display dialog "Error reading Start_OOo Prefs = " & errStr
		
		set whichXServer to 0
		set XServerPath to ""
		set oooVersionIndex to 1
		set directToPS to true
	     
  R      
 .ascrerr ****       ****          
  l  _ _        
  Z   _   
  G   _ z  
  l  _ f 
  A   _ f 
  o   _ d "0 oooversionindex oooVersionIndex
 m   d e   
  l  i v
 ?   i v
 o   i n "0 oooversionindex oooVersionIndex
 l  n u
 I  n u
 .corecnte****       ****
 o   n q~~  0 oooversionlist oooVersionList      
  k   }  	
 l  } }}
}  
   *** Debug ***   	 
 l  } }|
|  
 9 3display dialog "Need to reset oooVersionIndex to 1"    {
 r   } 
 m   } ~zz 
 o      yy "0 oooversionindex oooVersionIndex{        x
 l   wvw  v  x    
 l     utu  t   
 l     ss   Y S This handler will prompt the user to choose the XWindow Server application path if    
 l     rr   @ : it has not been specified, or the application is missing.    
 l     qpq  p   
 i   J M
 I      onmo  0 getxserverpath getXServerPathn  m  
 k    _   !"
! l     l#l  #   which XServer to launch   " $%
$ r     &'
& m     ((      
' o      kk 0 xservername XServerName% )*
) O    n+,
+ k    m-- ./
. r    01
0 I    j2ij (0 getlocalizedstring getLocalizedString2 3h
3 m   
 44  Preferred_XServer_Key   h  i  
1 o      gg 0 
xserverprompt 
XServerPrompt/ 5f
5 Z    m678e
6 =    9:
9 o    dd 0 whichxserver whichXServer
: m    cc 
7 k    /;; <=
< r    &>?
> m     @@ 
 XDarwin   
? o      bb 0 xservername XServerName= Aa
A r   ' /BC
B I   ' -`D_` (0 getlocalizedstring getLocalizedStringD E^
E m   ( )FF  XDarwin_XServer_Key   ^  _  
C o      ]] 0 
xserverprompt 
XServerPrompta  8 GH
G =   2 9IJ
I o   2 7\\ 0 whichxserver whichXServer
J m   7 8[[ H KL
K k   < LMM NO
N r   < CPQ
P m   < =RR  	OroborOSX   
Q o      ZZ 0 xservername XServerNameO SY
S r   D LTU
T I   D JXVWX (0 getlocalizedstring getLocalizedStringV WV
W m   E FXX  OroborOSX_XServer_Key   V  W  
U o      UU 0 
xserverprompt 
XServerPromptY  L YZ
Y =   O V[\
[ o   O TTT 0 whichxserver whichXServer
\ m   T USS Z ]R
] k   Y i^^ _`
_ r   Y `ab
a m   Y Zcc 
 X11.app   
b o      QQ 0 xservername XServerName` dP
d r   a ief
e I   a gOgNO (0 getlocalizedstring getLocalizedStringg hM
h m   b cii  X11App_XServer_Key   M  N  
f o      LL 0 
xserverprompt 
XServerPromptP  R  e  f  
, o    	KK 0 utility Utility* jk
j l  o oJIJ  I  k lm
l l  o oHnH  n V P check to see if an application bundle exists in the specified location (if any)   m oG
o Q   o_pqr
p I  r FsE
F .sysoexecTEXT     TEXT
s b   r }tu
t b   r {vw
v b   r uxy
x m   r szz  test -d    
y m   s t{{  "   
w o   u zDD 0 xserverpath XServerPath
u m   { |||  "   E  
q R      CBA
C .ascrerr ****       ****B  A  
r k   _}} ~
~ l   @@   O I no valid application bundle found - prompt for the location of a XServer    
 l   ?>?  >   
 Z    =<
 =    
 o    ;; 0 
infowindow 
infoWindow
 m    :
: 
null
 r    
 4    9
9 
cwin
 m     
 info   
 o      88 0 
infowindow 
infoWindow=  <   
 l   767  6   
 l   55     Show the info window    
 r    
 m    4
4 boovtrue
 n      
 1    3
3 
pvis
 o    22 0 
infowindow 
infoWindow 
 l   101  0   
 Q   Q
 k   4 
 l   
 r    
 l   /
 I   .-
. .sysoppcbcapp     null-   ,
, 
prmp
 o    ++ 0 
xserverprompt 
XServerPrompt *)
* 
rtyp
 m    (
( 
alis)  /  
 o      '' 0 xserverpath XServerPath  	as string    
 l   &&   = 7 default Prefs to what XServer user has actually chosen    
 Z   (
 E    
 l   %
 c    
 o    $$ 0 xserverpath XServerPath
 m    #
# 
TEXT%  
 m      	OroborOSX   
 k     
 r    
 m    "" 
 o      !! 0 whichxserver whichXServer  
 r    
 m      	OroborOSX   
 o       0 xservername XServerName    
 E    
 l   
 c    
 o     0 xserverpath XServerPath
 m    
 
TEXT  
 m     
 X11.app    
 k   
 r  

 m   
 o       0 whichxserver whichXServer 
 r  
 m   
 X11.app   
 o       0 xservername XServerName    
 k  ( 
 l    &   default to XDarwin - at present    
 r  
 m   
 o       0 whichxserver whichXServer 
 r  (
 m  " 
 XDarwin   
 o       0 xservername XServerName   
 l ))     
 I  ).
 (0 writestartoooprefs writeStartOOoPrefs  
   
 l //   U O reload the Prefs - the XServer pathname gets converted to POSIX in the process    
 I  /4
	
 &0 readstartoooprefs readStartOOoPrefs	      
 R      
 .ascrerr ****       ****   
 
errn
 o       0 errnum errNum  
 Z  <Q
 =  <A
 o  <=   0 errnum errNum
 m  =@
 k  DM 
 l DD   ( " user cancelled Choose Application    
 r  DM
 m  DG      
 o       0 xserverpath XServerPath       
 l RR     
 l RR     Hide the info window    
 r  R]
 m  RS
 boovfals
 n       
  1  X\
 
pvis
 o  SX 0 
infowindow 
infoWindow 
 l ^^      G   
 l          
 l        N H This handler will write the Start_OOo prefs to the Start_OOo prefs file    	
 l     
  
 4 . "~/Library/Preferences/org.OpenOffice.Start".   	 
 l          


 i   N Q
 I       (0 writestartoooprefs writeStartOOoPrefs    
 k     = 
 I    
 .appScalM****       ****
 m       setDefaultObject:forKey:    
 
witP
 J    
 
 o     0 whichxserver whichXServer 
 m     
 xserver        
 I    
 .appScalM****       ****
 m    !!  setDefaultObject:forKey:     "
 
witP
" J    ## $%
$ o     0 xserverpath XServerPath% &
& m    ''  xserverpath        ()
( I   ,*+
 .appScalM****       ****
* m    ,,  setDefaultObject:forKey:   + -
 
witP
- J     (.. /0
/ o     % "0 oooversionindex oooVersionIndex0 1
1 m   % &22  
oooversion       ) 34
3 I  - ;56
 .appScalM****       ****
5 m   - .77  setDefaultObject:forKey:   6 8
 
witP
8 J   / 799 :;
: o   / 4 0 
directtops 
directToPS; <
< m   4 5==  directps       4 >?
> l  < <    ? @A
@ l  < <B  B 
  ???   A C
C l  < <D  D 7 1call method "synchronize" of object user defaults      EF
E l         F GH
G l     I  I [ U This handler will load the Start_OOo prefs into the UI elements of the Prefs window.   H JK
J l         K LM
L i   R UNO
N I       0 	loadprefs 	loadPrefs    
O k     PP QR
Q I      &0 readstartoooprefs readStartOOoPrefs    R ST
S l       T U
U O    VW
V k    XX YZ
Y r    [\
[ o     0 whichxserver whichXServer
\ n      ]^
] m    
 
curR
^ 4    _
 
matT
_ m    `` 
 xserver   Z ab
a Z    cd
c ?    "ef
e l    g
g I    h
 .corecnte****       ****
h o      0 oooversionlist oooVersionList    
f m     !  
d k   % ii jk
j I  % 1l
 .coredelonull    obj 
l n   % -mn
m 2   + -
 
menI
n n   % +op
o m   ) +
 
menE
p 4   % )q
 
popB
q m   ' (rr  
oooversion     k st
s l  2 2    t uv
u l  2 2w  w ? 9 Add each of the OOo versions as menu items to the pop-up   v xy
x Y   2 tz{|
z k   @ o}} ~
~ r   @ H
 n   @ F
 o   D F 0 vers  
 l  @ D
 n   @ D
 4   A D
 
cobj
 o   B C 0 i  
 o   @ A  0 oooversionlist oooVersionList  
 o       0 
oooversion 
oooVersion 
 I  I o
 .corecrel****       null   
 
kocl
 m   K L
 
menI 
 
insh
 l  M V
 n   M V
  ;   U V
 n   M U
 2   S U
 
menI
 n   M S
 m   Q S
 
menE
 4   M Q
 
popB
 l 	 O P
 m   O P  
oooversion        
 
prdt
 K   Y i 
 
titl
 o   \ ] 0 
oooversion 
oooVersion 
 
enaB
 m   ` a
 boovtrue 
 
tagA
 o   d e 0 i         0 i  
{ m   5 6 
| l  6 ;
 I  6 ;
 .corecnte****       ****
 o   6 7  0 oooversionlist oooVersionList      y 
 r   u 
 n   u 
 o   }  0 vers  
 l  u }
 n   u }
 4   v }
 
cobj
 o   w | "0 oooversionindex oooVersionIndex
 o   u v  0 oooversionlist oooVersionList  
 n      
 m    
 
titl
 4    
 
popB
 m      
oooversion         b 
 r    
 o     0 
directtops 
directToPS
 n      
 1    
 
pcnt
 4    
 
butT
 m      directps     
W o     0 prefswindow prefsWindow  M 
 l          
 l        \ V This handler will store the Start_OOo prefs from the UI elements of the Prefs window.    
 l     ~  ~   
 i   V Y
 I      }|{} 0 
storeprefs 
storePrefs|  {  
 k     b 
 l     zz     *** Debug ***    
 l     yy   ( "display dialog "start Store Prefs"    
 l     xwx  w   
 r     
 o     vv 0 whichxserver whichXServer
 o      uu 0 
oldxserver 
oldXServer 
 l   tst  s   
 O    *
 k    ) 
 r    
 n    
 m    r
r 
curR
 4    q
q 
matT
 m     
 xserver   
 o      pp 0 whichxserver whichXServer 
 l   oo   E ?the oooVersionIndex pref is set in the choose menu item handler    n
 r    )
 n    #
 1   ! #m
m 
pcnt
 4    !l
l 
butT
 m       directps   
 o      kk 0 
directtops 
directToPSn  
 o    
jj 0 prefswindow prefsWindow 
 l  + +ihi  h   
 Z   + @gf
 >   + 2
 o   + ,ee 0 
oldxserver 
oldXServer
 o   , 1dd 0 whichxserver whichXServer
 k   5 < 
 l  5 5cc   P J clear old application path if user has chosen a different XWindow Server     b
 r   5 <
 m   5 6      
 o      aa 0 xserverpath XServerPathb  g  f   
 l  A A`_`  _   
 Q   A \
 I   D I^]\^  0 getxserverpath getXServerPath]  \  
 R      [Z
[ .ascrerr ****       ****Z   YX
Y 
errn
 o      WW 0 errnum errNumX  
 Z   Q \ VU
 =   Q T
 o   Q RTT 0 errnum errNum
 m   R SSS
  l  W WRR   ( " user cancelled Choose Application   V  U   
 l  ] ]QPQ  P   
 l  ] ]OO     *** Debug ***    	

	 l  ] ]NN   + %display dialog "about to write Prefs"   
 

 l  ] ]MLM  L  
 K
 I   ] bJIHJ (0 writestartoooprefs writeStartOOoPrefsI  H  K   
 l     GFG  F   
 l     EE   M G This handler will launch XDarwin, OroborOSX, X11.app or other XServer.    
 l     DD   ^ X If an XServer is already running, the process will be brought to the front (activated).    
 l     CC   - ' Any launching errors will be reported.    
 l     BAB  A   
 i   Z ]
 I      @?>@ 0 
launchxserver 
launchXServer?  >  
 k        !"
! r     #$
# m     =
= boovfals
$ o      <<  0 runningxserver runningXServer" %&
% l   ;:;  :  & '(
' I    	9879  0 getxserverpath getXServerPath8  7  ( )*
) l  
 
656  5  * +,
+ Z   
 -.4/
- =   
 01
0 o   
 33 0 xserverpath XServerPath
1 m    22      
. k    733 45
4 O    167
6 k    088 9:
9 I    2;12 0 doalert doAlert; <0
< m    /
/ boovtrue0  1  : =>
= I   ).?-
. .panSdisA****       ****
? I    %,@+, (0 getlocalizedstring getLocalizedString@ A*
A m     !BB  Cancelled_XServer_Key   *  +  -  > C)
C I   * 0(D'( 0 doalert doAlertD E&
E m   + ,%
% boovfals&  '  )  
7 o    $$ 0 utility Utility5 F#
F I  2 7"! 
" .aevtquitnull  null!     #  4  
/ k   : GG HI
H Q   : JKL
J k   = }MM NO
N l  = =P  P   *** Debug ***   O QR
Q l  = =S  S L Fdisplay dialog "About to launch " & XServerName & " at " & XServerPath   R TU
T l  = =    U VW
V O   = {XY
X k   A zZZ [\
[ r   A R]^
] I   A L_ $0 isxserverrunning isXServerRunning_ `a
` o   B G 0 whichxserver whichXServera b
b m   G H     
^ o       .0 alreadyrunningxserver alreadyRunningXServer\ cd
c l  S S    d ef
e r   S jgh
g I  S hi
 .sysoexecTEXT     TEXT
i b   S djk
j b   S blm
l b   S `no
n b   S ^pq
p b   S \rs
r b   S Vtu
t m   S Tvv  open    
u m   T Uww  "   
s o   V [ 0 xserverpath XServerPath
q m   \ ]xx  "   
o m   ^ _yy 
  >>    
m o   ` a 0 	erroutput 	errOutput
k m   b czz   2>&1     
h o       0 	theresult 	theResultf {|
{ l  k k
  
  | }
} r   k z~
~ I   k x
 $0 isxserverrunning isXServerRunning 
 o   l q		 0 whichxserver whichXServer 
 m   q t   
  
 o        0 runningxserver runningXServer  
Y o   = > 0 utility UtilityW 
 l  | |      
K R      
 .ascrerr ****       ****
 o         0 errstr errStr 
 
errn
 o       0 errnum errNum  
L k     
 l        *** Debug ***    
 l      7 1display dialog "XServer launch error = " & errStr    
 l        
 Z    
 =    
 o     0 errnum errNum
 m    @
 O    
 k     
 I     0 doalert doAlert 
 m    
 boovtrue     
 I   
 .panSdisA****       ****
 I     (0 getlocalizedstring getLocalizedString 
 m      Missing_XServer_Key          
 I     0 doalert doAlert 
 m    
 boovfals      
 o     0 utility Utility      I 
 l        
 Z    
 H    
 o      0 runningxserver runningXServer
 O    
 I     ,0 displaylaunchfailure displayLaunchFailure 
 o     0 xservername XServerName 
 o     0 	erroutput 	errOutput    
 o     0 utility Utility      , 
 l        
 L    
 o      0 runningxserver runningXServer   
 l          
 l        8 2 This handler will launch a specified OOo program.    
 l        4 . An optional document to open can be specified    
 l          
 i   ^ a
 I       0 	launchooo 	launchOOo 
 o       0 
theprogram 
theProgram 
 o       0 afile aFile    
 k    r 
 l          *** Debug ***    
 l        G Adisplay dialog "theProgram = " & theProgram & " aFile = " & aFile    
 l          
 r     
 b     

 b     
 b     	
 b     
 m      
 sh "   
 o      0 oooinstallpath oooInstallPath
 m      	/program/   
 o   	 
 0 
theprogram 
theProgram
 m     S M" -invisible "-accept=socket,host=0,port=8100;urp;StarOffice.ServiceManager"    
 o       
0 thecmd   
 l        
 l      / ) check to see if requested program exists    
 O    ?
 Z    >
 E    
 o     0 
theprogram 
theProgram
 m     
 spadmin   
 r    *
 I    ( $0 oooprogramexists oooProgramExists 
 o       0 oooinstallpath oooInstallPath 
 J     $ 
 m     ! 
 spadmin    
 m   ! "  spadmin.bin         
 o       0 
programexists 
programExists  
 k   - > 
 l  - -   b \ See if OOo exists (even if "theProgram" is "swriter" etc, eventually "soffice" must launch)    
 r   - > 
  I   - < $0 oooprogramexists oooProgramExists 
 o   . 3  0 oooinstallpath oooInstallPath 
 J   3 8 
 o   3 4 0 
theprogram 
theProgram 	

	 m   4 5 
 soffice   
 
 m   5 6

  soffice.bin         
 o       0 
programexists 
programExists  
 o     0 utility Utility 
 l  @ @     
 Z   @r
 o   @ A 0 
programexists 
programExists
 k   Dn 
 r   D K
 I   D I 0 
launchxserver 
launchXServer    
 o       "0 launchedxserver launchedXServer 
 l  L L     
 Z   Ln
 o   L M "0 launchedxserver launchedXServer
 k   Pj 
 l  P P      !
  l  P P"  " L F Check if a multi-user version of OOo exists, and is being run for the   ! #$
# l  P P%  % + % first time for this particular user.   $ &'
& l  P P(  ( ^ X We could also check for the presence of the multi-user startup script "soffice.startup"   ' )*
) Z   P e+,
+ o   P U 0 	firsttime 	firstTime
, k   X a-- ./
. l  X X0  0 : 4 wait for up to 30 secs for OOo to initially launch.   / 12
1 l  X X3  3 C = we allow more time because the multi-user startup script may   2 45
4 l  X X6  6 / ) take some time to do a first time setup.   5 78
7 r   X _9:
9 m   X Y 
: o       &0 initiallaunchtime initialLaunchTime8 ;
; l   ` `<  <  
            if infoWindow = null then
                    set infoWindow to window "info"
            end if
            
            -- Show the info window
            set visible of infoWindow to true
                     * =>
= l  f f    > ?@
? Q   f ABC
A k   i DD EF
E l  i iG  G 2 , Is Direct To PostScript printing supported?   F HI
H l  i iJ  J 6 0 If so, set the appropriate environment variable   I KL
K r   i lMN
M m   i jOO      
N o       0 
directtopsenv 
directToPSEnvL PQ
P l  m m    Q RS
R Z   m ~TU
T =   m tVW
V o   m r 0 
directtops 
directToPS
W m   r s 
U r   w zXY
X m   w xZZ % export OOO_PRINT_PS_DIRECTLY=1;   
Y o       0 
directtopsenv 
directToPSEnv    S [\
[ l       \ ]^
] r    _`
_ b    ab
a b    cd
c b    ef
e o     0 
directtopsenv 
directToPSEnv
f l 	  g
g m    hh  export DISPLAY=     
d o    ~~ 0 xdisplay XDISPLAY
b m    ii  ;    
` o      }} 0 theenv theEnv^ jk
j l   |{|  {  k lm
l Z    nozp
n =    qr
q o    yy 0 whichxserver whichXServer
r m    xx 
o l   wsw  s   special case for X11.app   z  
p r    tu
t b    vw
v b    xy
x b    z{
z b    |}
| b    ~
~ b    
 o    vv 0 theenv theEnv
 l 	  u
 m       export DYLD_LIBRARY_PATH="   u  
 l 	  t
 o    ss  0 oooinstallpath oooInstallPatht  
} m      /program":"   
{ l 	  r
 o    qq  0 oooinstallpath oooInstallPathr  
y m      /program/filter":   
w l 	  p
 m      /usr/X11R6/lib;    p  
u o      oo 0 theenv theEnvm 
 l   nn   &  display dialog "env = " & theEnv    
 l   mlm  l   k
 l   
 I   ji
j .sysoexecTEXT     TEXT
 b    
 b    
 b    
 b    
 b    
 o    hh 0 theenv theEnv
 o    gg 
0 thecmd  
 o    ff 0 afile aFile
 m     
  >>    
 o    ee 0 	erroutput 	errOutput
 m     
  2>&1 &   i     launch in the background   k  
B R      d
d .ascrerr ****       ****
 o      cc 0 errstr errStr ba
b 
errn
 o      `` 0 errnum errNuma  
C k     
 l   __     *** Debug ***    ^
 l   ]]   6 0display dialog "Error launching OOo = " & errNum   ^  @ 
 l   \[\  [   
 O   J
 Z   IZ
 E    
 o    YY 0 
theprogram 
theProgram
 m     
 spadmin   
 r    
 I    XWX 0 isooorunning isOOoRunning 
 m      spadmin.bin    
 m    VV  U
 o    TT 0 	erroutput 	errOutputU  W  
 o      SS $0 spadminisrunning spadminIsRunningZ  
 k   I 
 l  
 r   
 I   
RQR 0 isooorunning isOOoRunning 
 m     	soffice.*    
 o  PP &0 initiallaunchtime initialLaunchTime O
 o  	NN 0 	erroutput 	errOutputO  Q  
 o      MM $0 sofficeisrunning sofficeIsRunning R L allow "soffice.bin", or "soffice.startup.bin" for multi-user startup script    L
 Z  IKJ
 o  II $0 sofficeisrunning sofficeIsRunning
 k  E 
 l HH   3 - check to see if soffice is still running and    
 l GG   A ; didn't die an early death (e.g. missing symbols in dylibs)    
 l FF     *** Debug ***    
 l EE   > 8display dialog "About to check if OOo  is still running"    
 Z  1D
 o  !CC .0 alreadyrunningxserver alreadyRunningXServer
 r  $)
 m  $'BB 
 o      AA 0 thewaittime theWaitTimeD  
 r  ,1
 m  ,/@@ 

 o      ?? 0 thewaittime theWaitTime >
 r  2E
 I  2?=<= 0 isooorunning isOOoRunning 
 m  36  	soffice.*    
 d  68
 o  67;; 0 thewaittime theWaitTime :
 o  8;99 0 	erroutput 	errOutput:  <  
 o      88 $0 sofficeisrunning sofficeIsRunning>  K  J  L  
 o    77 0 utility Utility 
 l KK656  5   4
 Z  Kj32
 o  KP11 0 	firsttime 	firstTime
 k  Sf 
 r  SZ
 m  ST0
0 boovfals
 o      // 0 	firsttime 	firstTime 
 l [d
 r  [d
 m  [^.. 

 o      -- &0 initiallaunchtime initialLaunchTime $  reset the initial launch time    ,
 l  ee+ +    Z T
        -- Hide the info window
        set visible of infoWindow to false
           ,  3  2  4               
 l     *)*  )   
 l     ((   B < This handler is called when OOo documents are to be opened.    
 l     ''   C = It does the actual launching of OOo or "fondu" as necessary.    	

	 l     &%&  %  
 
 i   b e


 I      $#"$ $0 openooodocuments openOOoDocuments#  "  
 k      
 Z     {! 
 ?     
 l    	
 I    	
 .corecnte****       ****
 o      0 filelist fileList    
 m   	 
  
 Y    w
 k     r 
 r     *
 l    ( 
  n     (!"
! 4   % (#
 
cobj
# o   & ' 0 i  
" o     % 0 filelist fileList  
 o       0 thedocument theDocument $%
$ r   + 4&'
& b   + 2()
( b   + 0*+
* m   + ,,,   "   
+ l  , /-
- n   , /./
. 1   - /
 
psxp
/ o   , - 0 thedocument theDocument  
) m   0 100  "   
' o       0 thefilepath theFilePath% 12
1 l  5 5    2 34
3 l  5 5
5
  5   *** Debug ***   4 67
6 l  5 58  8 3 -display dialog "theFilePath = " & theFilePath   7 9:
9 l  5 5
  
  : ;<
; r   5 <=>
= l  5 :?	
? I  5 :@
 .sysonfo4asfe       ****
@ o   5 6 0 thedocument theDocument  	  
> o       0 thefileinfo theFileInfo< A
A Z   = rBC
B H   = AD
D n   = @EF
E 1   > @
 
asdr
F o   = >   0 thefileinfo theFileInfo
C l  D nGH
G Z   D nIJK
I G   D QLM
L l  D GN
N D   D GOP
O o   D E 0 thefilepath theFilePath
P m   E FQQ 
 .dfont"     
M l  J OR
R =   J OST
S l  J MU
U n   J MVW
V 1   K M
 
asty
W o   J K 0 thefileinfo theFileInfo  
T m   M NXX 
 FFIL     
J O   T dYZ
Y I   X c[ 0 convertfont convertFont[ \]
\ o   Y ^  0 oooinstallpath oooInstallPath] ^
^ o   ^ _ 0 thefilepath theFilePath    
Z o   T U 0 utility Utility  
K I   g n_ 0 	launchooo 	launchOOo_ `a
` m   h ibb 
 soffice   a c
c o   i j 0 thefilepath theFilePath    H &   don't support folders/disks yet          0 i  
 m     
 l   d
d I   e
 .corecnte****       ****
e o     0 filelist fileList      !      f
f r   | gh
g J   | ~  
h o       0 filelist fileList   ij
i l         j kl
k l     m  m < 6 This handler locates the Scripts folder in our bundle   l no
n l         o pq
p i   f irs
r I       0 
pathtoscripts 
pathToScripts    
s k     tt uv
u r     wx
w c     	yz
y l    {
{ I    |}
 .earsffdralis        afdr
|  f     } ~
 
from
~ m    
 fldmfldu    
z m    
 
ctxt
x o       0 apppath appPathv 
 r    
 c    
 l   
 b    
 o    
 0 apppath appPath
 m   
  ! Contents:Resources:Scripts:     
 m    
 
ctxt
 o        0 thescriptspath theScriptsPath 
 l        *** Debug ***    
 l      7 1display dialog "Scripts path = " & theScriptsPath    
 L    
 o      0 thescriptspath theScriptsPath  q 
 l          
 l        8 2 This handler loads an AppleScript from our bundle    
 l          
 i   j m
 I       0 
loadscript 
loadScript 
 o       0 
scriptname 
scriptName    
 k      
 l          more modern way    
 l        r lset theScriptObject to load script POSIX file ((path for script scriptName extension "scpt") of main bundle)    
 l          more compatible way    
 r     
 b     	
 b     
 I      0 
pathtoscripts 
pathToScripts    
 o     0 
scriptname 
scriptName
 m      .scpt   
 o       0 
thescriptpath 
theScriptPath 
 l        *** Debug ***    
 l      5 /display dialog "Script path = " & theScriptPath    
 r    
 I   
 .sysoloadscpt        alis
 4    
 
file
 o     0 
thescriptpath 
theScriptPath  
 o       "0 thescriptobject theScriptObject 
 l        *** Debug ***    
 l      C =display dialog "Script object = " --& (id of theScriptObject)    
 L    
 o     "0 thescriptobject theScriptObject   
 l          
 l        M G This handler loads any additional AppleScripts we need from our bundle    
 l          
 i   n q
 I       0 loadscripts loadScripts    
 Z     /
 H     
 o      0 
scriptsloaded 
scriptsLoaded
 Q   	 +
 k    " 
 r    
 I     0 
loadscript 
loadScript 
 m   
  
 Utility       
 o       0 
utilitylib 
utilityLib 
 r    
 n    
 o     0 utility Utility
 o     0 
utilitylib 
utilityLib
 o       0 utility Utility 
 l        *** Debug ***    
 l      3 -display dialog "loadScript Utility succeeded"    
 r    "
 m    
 boovtrue
 o       0 
scriptsloaded 
scriptsLoaded  
 R      
 .ascrerr ****       ****
 o       0 errstr errStr 
 
errn
 o       0 errnum errNum  
 k   * * 
 l  * *     *** Debug ***    
 l  * *   : 4display dialog "loadScript Utility failed " & errStr       
 k   . . 
 l  . .     *** Debug ***    
 l  . .   - 'display dialog "scripts already loaded"      
 l           
 l        > 8 This handler does most of the Start_OOo initialization.     
 l        C = Made it a separate handler in an attempt to workaround weird    
 l        6 0 bugs with AppleScript Studio on Mac OS X 10.1.x    	
 l         	 


 i   r u

 I       0 
initialize 
Initialize    

 k    > 
 l          *** Debug ***    
 l        0 *set StartOOoPath to (path to me as string)    
 l        7 1display dialog "Start_OOo Path = " & StartOOoPath    
 l          
 r     
 m     
 boovfals
 o       &0 foundoooprefsfile foundOOoPrefsFile 
 r     !
  J      
! o        0 oooversionlist oooVersionList "#
" l  	 	~  ~  # $%
$ Q   	 &'}
& k    (( )*
) l   |+|  +   *** Debug ***   * ,-
, l   {.{  . 8 2display dialog "About to try and find .sversionrc"   - /0
/ l   zyz  y  0 12
1 I   x3w
x .sysoexecTEXT     TEXT
3 m    
44  test -f ~/.sversionrc   w  2 5v
5 r    67
6 m    u
u boovtrue
7 o      tt &0 foundoooprefsfile foundOOoPrefsFilev  
' R      s89
s .ascrerr ****       ****
8 o      rr 0 errstr errStr9 q:p
q 
errn
: o      oo 0 errnum errNump  }  % ;<
; l   nmn  m  < =>
= l   l?l  ?   *** Debug ***   > @A
@ l   kBk  B ? 9display dialog "foundOOoPrefsFile = " & foundOOoPrefsFile   A CD
C l   jij  i  D EF
E Z    9GHhI
G o     gg &0 foundoooprefsfile foundOOoPrefsFile
H O   # /JK
J r   ' .LM
L I   ' ,fedf 0 readoooprefs readOOoPrefse  d  
M o      cc  0 oooversionlist oooVersionList
K o   # $bb 0 utility Utilityh  
I k   2 9NN OP
O l  2 2aQa  Q ^ X we could also check for the presence of the multi-user startup script "soffice.startup"   P R`
R r   2 9ST
S m   2 3_
_ boovtrue
T o      ^^ 0 	firsttime 	firstTime`  F UV
U l  : :]\]  \  V WX
W Z   : YZ[Z
Y =   : A[\
[ l  : ?]Y
] I  : ?X^W
X .corecnte****       ****
^ o   : ;VV  0 oooversionlist oooVersionListW  Y  
\ m   ? @UU  
Z k   D __ `a
` l  D DTbT  b   *** Debug ***   a cd
c l  D DSeS  e / )display dialog "No OOo .sversionrc found"   d fg
f l  D DRQR  Q  g hi
h r   D Qjk
j l  D OlP
l N   D Om
m 4   D NOn
O 
file
n l  F MoN
o I  F MMpq
M .earsffdralis        afdr
p  f   F Gq LrK
L 
rtyp
r m   H IJ
J 
TEXTK  N  P  
k o      II 0 thefile theFilei st
s r   R Wuv
u l  R UwH
w n   R Uxy
x 1   S UG
G 
psxp
y o   R SFF 0 thefile theFileH  
v o      EE 0 thepath thePatht z{
z l  X XD|D  |   *** Debug ***   { }~
} l  X XCC   2 ,display dialog "Start_OOo path = " & thePath   ~ 
 r   X [
 m   X Y  (.*)/   
 o      BB  0 thepathpattern thePathPattern 
 l  \ \AA   7 1 Start_OOo is an "app/" and for the POSIX path on    
 l  \ \@@   P J some versions of Mac OS X/AppleScript the trailing "/" is present, and on    
 l  \ \??   M G other versions of Mac OS X/AppleScript the trailing "/" is not present    
 Z   \ y>
 D   \ _
 o   \ ]== 0 thepath thePath
 m   ] ^ 
 app/   
 r   b e
 m   b c  
(.*)/(.*)/   
 o      <<  0 thepathpattern thePathPattern 
 D   h m
 o   h i;; 0 thepath thePath
 m   i l 	 app    :
 r   p u
 m   p s  (.*/.*)/   
 o      99  0 thepathpattern thePathPattern:  >   
 l  z z878  7   
 r   z 
 I  z 65
6 .sysoexecTEXT     TEXT
 b   z 
 b   z 
 b   z 
 b   z 
 m   z }  echo "   
 o   } ~44 0 thepath thePath
 l 	  3
 m       " | perl -e '$s=<>; $s=~s%   3  
 o    22  0 thepathpattern thePathPattern
 m      .*%$1%; print $s'   5  
 o      11 0 
oooinstallurl 
oooInstallURL 
 l   0/0  /   
 l   ..     *** Debug ***    
 l   --   1 +display dialog "OOo URL = " & oooInstallURL    
 r    
 m      OpenOffice.org 1.0.3   
 o      ,, 0 
oooversion 
oooVersion 
 l   ++   H B could get actual version of OOo (see multi-user "soffice" script)    *
 r    
 J     )
 K     (( 0 vers  
 o    '' 0 
oooversion 
oooVersion &%& 0 urlpath  
 o    $$ 0 
oooinstallurl 
oooInstallURL%  )  
 o      ##  0 oooversionlist oooVersionList*  [  Z  X 
 l   "!"  !   
 l          *** Debug ***    
 l      $ display dialog "Got OOo Prefs"    
 l        
 I     &0 readstartoooprefs readStartOOoPrefs     
 l        
 l        *** Debug ***    
 l      * $display dialog "Got Start_OOo Prefs"    
 l        
 r    
 n    
 o     0 vers  
 l   
 n    
 4    
 
cobj
 o     "0 oooversionindex oooVersionIndex
 o      0 oooversionlist oooVersionList  
 o       0 
oooversion 
oooVersion 
 r    
 c    
 n    
 o    

 0 urlpath  
 l   
 n    
 4    
 
cobj
 o    

 "0 oooversionindex oooVersionIndex
 o    		  0 oooversionlist oooVersionList  
 m    
 
TEXT
 o       0 
oooinstallurl 
oooInstallURL 
 l        
 l        *** Debug ***     
 l      2 ,display dialog "OOo version = " & oooVersion     
 l      9 3display dialog "OOo Install URL = " & oooInstallURL    
 l          
 l   	  	 W Q hack workaround for some weird AppleScript Studio bugs on Mac OS X 10.1.x/10.2.x    


 l      b \set oooInstallPath to pathFromURL(oooInstallURL) --as string -- in case it is actually a URL    


 l      7 1copy pathFromURL(oooInstallURL) to oooInstallPath    
 Z   $
 C   
 l   
 c    
 o     0 
oooinstallurl 
oooInstallURL
 m    
 
TEXT  
 m     
 file://   
 k    
 l        *** Debug ***     
 l   !  ! $ display dialog "Strip file://"     "#
" r    $%
$ l   &
& n    '(
' 1    
 
leng
( o     0 
oooinstallurl 
oooInstallURL  
% o       0 
thepathlen 
thePathLen# )
) l  *+
* s   ,-
, l  .
. n   /0
/ l  1
1 7  23
 
cha 
2 m  
 
3 o  
 0 
thepathlen 
thePathLen  
0 o     0 
oooinstallurl 
oooInstallURL  
- o        0 oooinstallpath oooInstallPath+   strip "file://"       
 s  $45
4 o   0 
oooinstallurl 
oooInstallURL
5 o        0 oooinstallpath oooInstallPath 67
6 l %%    7 89
8 l %%:  :   *** Debug ***   9 ;<
; l %%=  = ; 5display dialog "OOo Install Path = " & oooInstallPath   < >?
> l %%    ? @A
@ r  %<BC
B I %6D
 .sysoexecTEXT     TEXT
D b  %2EF
E b  %.GH
G m  %(II  echo "   
H o  (-  0 oooinstallpath oooInstallPath
F m  .1JJ  " | sed "s/ /\\\ /g"     
C o       &0 oooinstallescpath oooInstallEscPathA KL
K l ==M  M   *** Debug ***   L N
N l ==O  O ? 9display dialog "oooInstallEscPath = " & oooInstallEscPath      PQ
P l         Q RS
R l      T  T    ==== Event Handlers ====    S UV
U l         V WX
W l     Y  Y ? 9 This event handler is called when a menu item is chosen.   X Z[
Z l         [ \]
\ i   v y^_
^ I     `
 .menSchMI****       ****
` o       0 	theobject 	theObject  
_ k    .aa bc
b r     de
d m     ff      
e o       0 apptolaunch appToLaunchc gh
g l       h ij
i Z   klm
k =    	no
n n    pq
p 1    
 
pnam
q o     0 	theobject 	theObject
o m    rr  	prefsmenu   
l k    6ss tu
t l   v  v 3 - the "Preferences" menu item has been chosen   u wx
w Z    $yz
y =    {|
{ o     0 prefswindow prefsWindow
| m    
 
null
z r     }~
} 4    
 
cwin
 m      preferences   
~ o       0 prefswindow prefsWindow    x 
 l  % %     
 l  % %     Load in the prefs    
 I   % * 0 	loadprefs 	loadPrefs     
 l  + +     
 l  + +     Show the prefs window    
 r   + 4
 m   + ,
 boovtrue
 n      
 1   1 3
 
pvis
 o   , 1 0 prefswindow prefsWindow 
 l  5 5     
 l  5 5      "New" document menu items    
 l  5 5      m 
 =   9 >
 l  9 <
 n   9 <
 1   : <
 
pnam
 o   9 : 0 	theobject 	theObject  
 m   < =  	newWriter    
 r   A D
 m   A B 
 swriter   
 o       0 apptolaunch appToLaunch 
 =   G L
 l  G J
 n   G J
 1   H J
 
pnam
 o   G H 0 	theobject 	theObject  
 m   J K 
 newCalc    
 r   O R
 m   O P  scalc   
 o       0 apptolaunch appToLaunch 
 =   U Z
 l  U X
 n   U X
 1   V X
 
pnam
 o   U V 0 	theobject 	theObject  
 m   X Y  
newImpress    
 r   ] `
 m   ] ^  simpress   
 o       0 apptolaunch appToLaunch 
 =   c h
 l  c f
 n   c f
 1   d f
 
pnam
 o   c d 0 	theobject 	theObject  
 m   f g 
 newDraw    
 k   k p 
 r   k n
 m   k l  sdraw   
 o       0 apptolaunch appToLaunch 
 l  o o       
 =   s z
 l  s v
 n   s v
 1   t v
 
pnam
 o   s t 0 	theobject 	theObject  
 m   v y  configurePrinters    
 k   }  
 l  } }   9 3 the "Configure Printers menu item has been chosen    
 l  } }   ( " See if OOo spadmin program exists    
 O   } 
 r    
 I     $0 oooprogramexists oooProgramExists 
 o      0 oooinstallpath oooInstallPath 
 J     
 m     
 spadmin    
 m      spadmin.bin         
 o       0 
spadminexists 
spadminExists
 o   }  0 utility Utility 
 Z    
 o     0 
spadminexists 
spadminExists
 k     
 l      F @ patch the "soffice" (or "spadmin") shell script if necessary to    
 l      : 4 support OOo installation paths that contain spaces.    
 O    
 I       0 patchoooscript patchOOoScript  
 o      0 oooinstallpath oooInstallPath    
 o     0 utility Utility 
 l        
 l   
 r    	
 I     0 
launchxserver 
launchXServer    
	 o       "0 launchedxserver launchedXServer . ( launch the X Window server if necessary    


 l        
 Z    
~}

 o    || "0 launchedxserver launchedXServer
 k     
 l   {{   1 + check to see if spadmin is already running    
 r    
 m    z
z boovfals
 o      yy $0 spadminisrunning spadminIsRunning 
 O    
 r    
 I    xwx $0 isprocessrunning isProcessRunning 
 m        spadmin.bin    !v
! m    uu v  w  
 o      tt $0 spadminisrunning spadminIsRunning
 o    ss 0 utility Utility "r
" Z    #$qp
# H    %
% o    oo $0 spadminisrunning spadminIsRunning
$ k    && '(
' l   n)n  ) + % spadmin is not running, so launch it   ( *m
* r    +,
+ m    -- 
 spadmin   
, o      ll 0 apptolaunch appToLaunchm  q  p  r  ~  }           ./
. =    01
0 l   2k
2 n    34
3 1    j
j 
pnam
4 o    ii 0 	theobject 	theObjectk  
1 m    55  
oooversion   / 6h
6 k  77 89
8 l g:g  :   *** Debug ***   9 ;<
; l f=f  = + %display dialog "Got oooVersion popup"   < >?
> r  @A
@ n  
BC
B m  
e
e 
tagA
C n  DE
D m  d
d 
cuMI
E o  cc 0 	theobject 	theObject
A o      bb "0 oooversionindex oooVersionIndex? FG
F l aHa  H   *** Debug ***   G I`
I l _J_  J ; 5display dialog "oooVersionIndex = " & oooVersionIndex   `  h    j KL
K l ^]^  ]  L MN
M Z  ,OP\[
O >  QR
Q o  ZZ 0 apptolaunch appToLaunch
R m  SS      
P I  (YTXY 0 	launchooo 	launchOOoT UV
U o   !WW 0 apptolaunch appToLaunchV WV
W m  !$XX      V  X  \  [  N YU
Y l --TST  S  U  ] Z[
Z l     RQR  Q  [ \]
\ l     P^P  ^ I C This event handler is called when a menu item needs to be updated.   ] _`
_ l     ONO  N  ` ab
a i   z }cd
c I     MeL
M .menSupMI****       ****
e o      KK 0 	theobject 	theObjectL  
d k     ff gh
g Z     ijJI
i =     kl
k l    mH
m n     no
n 1    G
G 
pnam
o o     FF 0 	theobject 	theObjectH  
l m    pp  configurePrinters   
j k    qq rs
r l   EtE  t 1 + check to see if spadmin is already running   s uD
u Z    vwCB
v o    
AA $0 spadminisrunning spadminIsRunning
w l   xy
x L    z
z m    @
@ boovfalsy , & disable menu until user quits spadmin   C  B  D  J  I  h {?
{ L    |
| m    >
> boovtrue?  b }~
} l     =<=  <  ~ 
 l     ;;   s m This event handler is called when either the "Cancel" or "OK" buttons are clicked in the Preferences window.    
 l     :9:  9   
 i   ~ 
 I     87
8 .coVScliI****       ****
 o      66 0 	theobject 	theObject7  
 Z     K54
 =     
 n     
 1    3
3 
pnam
 l    2
 n     
 m    1
1 
cwin
 o     00 0 	theobject 	theObject2  
 m      preferences   
 Q   
 G
 k   
 4 
 Z   
 */
 =   
 
 n   
 
 1    .
. 
pnam
 o   
 -- 0 	theobject 	theObject
 m      ok   
 k     
 l   ,,     Save out the prefs    +
 I    *)(* 0 
storeprefs 
storePrefs)  (  +   
 =    "
 n     
 1     '
' 
pnam
 o    && 0 	theobject 	theObject
 m     !  cancel    %
 k   % % 
 l  % %$$     *** Debug ***    #
 l  % %""     display dialog "Cancelled"   #  %  /   
 l  + +! !      
 l  + +     Hide the prefs window    
 r   + 4
 m   + ,
 boovfals
 n      
 1   1 3
 
pvis
 o   , 1 0 prefswindow prefsWindow  
 R      
 .ascrerr ****       ****   
 
errn
 o       0 errnum errNum  
 Z   < G
 =   < ?
 o   < = 0 errnum errNum
 m   = >
 l  B B   ( " user cancelled Choose Application       5  4   
 l          
 l        \ V This event handler is called when documents are opened from Finder (or command line).    
 l     

   I C It can be called before the "on launched" event handler is called.    
 l          
 i    
 I     
	

 .aevtodocnull      alis
 o       0 thefiles theFiles	  
 k      
 l          *** Debug ***    
 l        2 ,display dialog "Got some files to be opened"    
 l          
 r     
 o      0 thefiles theFiles
 o       0 filelist fileList 
 Z     
 o    
 $0 sofficeisrunning sofficeIsRunning
 k     
 l      0 * Start_OOo was launched previously and the    
 l      9 3 user has decided to open some (more) OOo documents    
 I     $0 openooodocuments openOOoDocuments              
 l          
 l        ^ X This event handler is called when the application is about done launching (first call).    
 l          
 l          z
on will finish launching theObject
	-- *** Debug ***
	--display dialog "Will finish launching"
end will finish launching
    
 l          
 l        V P This event handler is called when the application is starting up (second call).    
 l          
 l          
-- requires ASS v1.1 runtime
on awake from nib theObject
	-- *** Debug ***
	--display dialog "Awake from nib"
end awake from nib
    	 	
	  l         	 		
	 l     	  	 R L This event handler is called when the application is launched (third call).   	 		
	 l         	 		
	 i    			

		 I     	
 .appSlauN****       ****
	 o       0 	theobject 	theObject  
	
 k     		 	
	
	
 r     		
	 m     
 boovfals
	 o       0 oktorun okToRun	 		
	 l       	 		
	 l   	  	 P J hack workaround for some weird AppleScript Studio bugs on Mac OS X 10.1.x   	 		
	 l   	  	 / ) See Utility.applescript for more details   	 		
	 O    		
	 k    		 		
	 r    	 	!
	  l   
	"
	" I   
	#
 .fndrgstlns          type
	# m    		$	$ 
 sysv       
	! o       0 sysvers sysVers	 	%	&
	% l   	'  	'   *** Debug ***   	& 	(
	( l   	)  	) 2 ,display dialog "System version = " & sysVers     
	 m    	*	*null     ߀  x
Finder.app0 0 7`   Z (   )       ( ߀ MACS   alis    n  Panther-142                H)H+    x
Finder.app                                                       yл+          	                CoreServices    Hu            x  r  r  2Panther-142:System:Library:CoreServices:Finder.app   
 F i n d e r . a p p    P a n t h e r - 1 4 2  &System/Library/CoreServices/Finder.app  /   	 	+	,
	+ l       	, 	-	.
	- r    	/	0
	/ m    	1	1      
	0 o       0 hackstr hackStr	. 	2	3
	2 Z    I	4	5
	4 A    	6	7
	6 o     0 sysvers sysVers
	7 m     
	5 l   E	8	9
	8 k    E	:	: 	;	<
	; Q    7	=	>	?
	= r     ,	@	A
	@ l    *	B
	B I    *	C	D
 .appScalM****       ****
	C m     !	E	E &  localizedStringForKey:fromTable:   	D 	F
 
witP
	F J   " &	G	G 	H	I
	H m   " #	J	J  MacOSX101xHack_Key   	I 	K
	K m   # $	L	L  	Localized         
	A o       0 hackstr hackStr
	> R      	M	N
 .ascrerr ****       ****
	M o       0 errstr errStr	N 	O
 
errn
	O o       0 errnum errNum  
	? r   4 7	P	Q
	P m   4 5	R	R &  Configuring for Mac OS X 10.1.x.   
	Q o       0 hackstr hackStr	< 	S	T
	S l  8 8    	T 	U	V
	U l  8 8	W  	W   *** Debug ***   	V 	X	Y
	X l  8 8	Z  	Z 8 2display dialog "About to put up workaround dialog"   	Y 	[
	[ I  8 E	\	]
 .panSdlog****       ****
	\ o   8 9 0 hackstr hackStr	] 	^	_
 
btns
	^ J   : =	`	` 	a
	a m   : ;	b	b       	_ 	c
 
givu
	c m   > ?     	9 1 + 2457 = 0x999, 4112 = 0x1010, 4128 = 0x1020       	3 	d	e
	d l  J J    	e 	f	g
	f l  J J	h  	h   try to load AppleScripts   	g 	i	j
	i Z   J 	k	l
	k H   J P	m
	m o   J O 0 
scriptsloaded 
scriptsLoaded
	l k   S 	n	n 	o	p
	o l  S S	q  	q   *** Debug ***   	p 	r	s
	r l  S S	t  	t , &display dialog "About to load scripts"   	s 	u	v
	u I   S X 0 loadscripts loadScripts    	v 	w	x
	w l  Y Y    	x 	y	z
	y l  Y Y	{  	{   *** Debug ***   	z 	|	}
	| l  Y Y	~  	~ J Ddisplay dialog "Done loading scripts = " & (scriptsLoaded as string)   	} 		
	 l  Y Y    	 	
	 Z   Y 		
	 H   Y _	
	 o   Y ^ 0 
scriptsloaded 
scriptsLoaded
	 k   b 		 		
	 l  b b	  	   *** Debug ***   	 		
	 l  b b	  	 - 'display dialog "Loading scripts failed"   	 		
	 l  b b    	 		
	 r   b g		
	 m   b e		      
	 o       0 
loaderrstr 
loadErrStr	 		
	 l  h h    	 		
	 Q   h 			
	 r   k }		
	 l  k {	
	 I  k {		
 .appScalM****       ****
	 m   k n		 &  localizedStringForKey:fromTable:   	 	
 
witP
	 J   o w		 		
	 m   o r		  LoadScript_error_Key   	 	
	 m   r u		  	Localized         
	 o       0 
loaderrstr 
loadErrStr
	 R      		
 .ascrerr ****       ****
	 o       0 errstr errStr	 	
 
errn
	 o       0 errnum errNum  
	 r    		
	 m    		 r lThere was a problem loading an AppleScript required by this application. Start OpenOffice.org will now quit.   
	 o       0 
loaderrstr 
loadErrStr	 		
	 l       	 		
	 l   	  	   *** Debug ***   	 		
	 l   	  	 = 7display dialog "About to report loading scripts failed"   	 		
	 I   	
 .panSdisA****       ****
	 o     0 
loaderrstr 
loadErrStr  	 		
	 l       	 	
	 I   
 .aevtquitnull  null                	j 		
	 l       	 		
	 Z    		
	 o    ~~ 0 
scriptsloaded 
scriptsLoaded
	 r    		
	 m    }
} boovtrue
	 o      || 0 oktorun okToRun    	 		
	 l   {z{  z  	 		
	 l    y	y  	  
        if okToRun then
		-- check if we can run on current system
		try
			tell Utility
				set okToRun to checkSystem()
			end tell
		on error errStr number errNum
			set okToRun to false
		end try
	end if
	   	 		
	 l   xwx  w  	 	v
	 Z    		u	
	 H    	
	 o    tt 0 oktorun okToRun
	 k    		 		
	 l   s	s  	 - ' comment out following at your own risk   	 	r
	 I   qpo
q .aevtquitnull  nullp  o  r  u  
	 k    		 		
	 l   n	n  	   *** Debug ***   	 		
	 l   m	m  	 * $display dialog "About to initialize"   	 		
	 l   lkl  k  	 		
	 I    jihj 0 
initialize 
Initializei  h  	 		
	 l   gfg  f  	 		
	 l   e	e  	   *** Debug ***   	 		
	 l   d	d  	 , &display dialog "Finished initializing"   	 		
	 l   cbc  b  	 		
	 l   a	a  	   *** Debug ***   	 		
	 l   `	`  	 H Bdisplay dialog "Num of documents to open = " & (count of fileList)   	 		
	 l   _^_  ^  	 		
	 l   ]	]  	 H Bset errOutput to /dev/null" -- redirect errors/output to /dev/null   	 		
	 r    		
	 c    		
	 b    		
	 m    		  
/tmp/Start_OO   
	 l   	\
	 I   [ZY
[ .sysorandnmbr     nmbrZ  Y  \  
	 m    X
X 
TEXT
	 o      WW 0 	erroutput 	errOutput	 		
	 l   VUV  U  	 
 

  l   T
T  
   *** Debug ***   
 


 l   S
S  
 / )display dialog "errOutput = " & errOutput   
 


 l   RQR  Q  
 
P
 Z    
	

O

	 ?    



 l   
N
 I   M
L
M .corecnte****       ****
 o    KK 0 filelist fileListL  N  

 m    JJ  

 k    

 


 l   I
I  
 9 3 Open initial list of OOo documents user has chosen   
 


 I    HGFH $0 openooodocuments openOOoDocumentsG  F  
 


 l   EDE  D  
 


 l   C
C  
 W Q comment following line if you want the application to be a stay-open application   
 
B
 I   A@?
A .aevtquitnull  null@  ?  B  O  
 k    

 


 l   >
>  
 ' ! launch OOo without any documents   
 
 
!
  l   =<=  <  
! 
"
#
" l   ;
$;  
$   *** Debug ***   
# 
%
&
% l   :
':  
' $ display dialog "Launching OOo"   
& 
(
)
( l   989  8  
) 
*
+
* I    7
,67 0 	launchooo 	launchOOo
, 
-
.
- o    55 0 
defaultmodule 
defaultModule
. 
/4
/ m    
0
0      4  6  
+ 
13
1 l   2
22  
2 A ; leave the application open so people can choose menu items   3  P  v  	 
3
4
3 l     101  0  
4 
5
6
5 l     /
7/  
7 ` Z This event handler is called when the application is about to be activated (fourth call).   
6 
8
9
8 l     .-.  -  
9 
:
;
: l      ,
<,  
<  z
on will become activated theObject
	-- *** Debug ***
	--display dialog "Will become activated"
end will become activated
   
; 
=
>
= l     +*+  *  
> 
?
@
? l     )
A)  
A S M This event handler is called when the application is activated (fifth call).   
@ 
B
C
B l     ('(  '  
C 
D
E
D i    
F
G
F I     &
H%
& .appSactV****       ****
H o      $$ 0 	theobject 	theObject%  
G k     +
I
I 
J
K
J l     #
L#  
L   *** Debug ***   
K 
M
N
M l     "
O"  
O ( "display dialog "About to activate"   
N 
P
Q
P l     ! !     
Q 
R
S
R l     
T  
T L F wait for the Utility script object to be loaded in a different thread   
S 
U
U Z     +
V
W
V o      0 
scriptsloaded 
scriptsLoaded
W k    '
X
X 
Y
Z
Y l   
[  
[ 1 + check to see if spadmin is already running   
Z 
\
\ O    '
]
^
] Z    &
_
`
_ H    
a
a I     0 	isalertup 	isAlertUp    
` r    "
b
c
b I    
d $0 isprocessrunning isProcessRunning
d 
e
f
e m    
g
g  spadmin.bin   
f 
h
h m         
c o       $0 spadminisrunning spadminIsRunning    
^ o    	 0 utility Utility        
E 
i
j
i l     

    
j 
k
l
k l     
m  
m N H This event handler is called when the application is idle (sixth call).   
l 
n
o
n l     

p
  
p #  We get called once a second.   
o 
q
r
q l     		    
r 
s
t
s i    
u
v
u I     
w
 .appSidle****       ****
w o       0 	theobject 	theObject  
v k     )
x
x 
y
z
y l     
{  
{   *** Debug ***   
z 
|
}
| l     
~  
~ $ display dialog "About to idle"   
} 


 Z     &


 >     


 o        0 
infowindow 
infoWindow
 m    
 
null
 Z   
 "


 n   
 


 1    
 
pvis
 o   
  0 
infowindow 
infoWindow
 k    

 


 l   
  
   *** Debug ***   
 


 l   
  
 ? 9display dialog "Info window has been idle at least 1 sec"   
 


 l       
 


 l    
  

                We use the floating "Information" window to indicate "Please Wait" for the
        "Choose Application" window to become available.
        The Idle handler will be called after the "Choose Application" window has
        become available, so now we need to hide the floating "Information" window
        because in Mac OS X 10.1.x, the "Information" window floats above the "Choose Application" window;
                in Mac OS X 10.2.x, the problem doesn't occur.
                   
 

 r    


 m    
 boovfals
 n      


 1    
 
pvis
 o     0 
infowindow 
infoWindow          
 


 l  ' '    
 

 L   ' )

 m   ' (   
t 


 l         
 


 l     
  
 J D This event handler is called when the application is about to quit.   
 


 l         
 


 i    


 I     

 .appSwilQ****       ****
 o       0 	theobject 	theObject  
 k     

 


 l     
  
   *** Debug ***   
 


 l     
  
 $ display dialog "About to quit"   
 


 l         
 


 r     


 m     
 boovfals
 o       $0 sofficeisrunning sofficeIsRunning
 


 l       
 


 Q    



 k    

 


 l   
  
 ' ! remove current error output file   
 

 I   

 .sysoexecTEXT     TEXT
 b    


 m    

  rm -f    
 o    
 0 	erroutput 	errOutput    
 R      


 .ascrerr ****       ****
 o       0 errstr errStr
 

 
errn
 o       0 errnum errNum  
 k    

 


 l   
  
   *** Debug ***   
 

 l   
  
 @ :display dialog "rm -f " & errOutput & " error = " & errNum     
 

 l         
 


 l         
 


 l         
 

 j    
 60 asdscriptuniqueidentifier ASDScriptUniqueIdentifier
 m    

  Application.applescript          *
 & * . L P
 q x




















  
 ( 0 
scriptsloaded 
scriptsLoaded 0 
oooinstallurl 
oooInstallURL  0 oooinstallpath oooInstallPath &0 oooinstallescpath oooInstallEscPath 0 prefswindow prefsWindow 0 whichxserver whichXServer 0 xservername XServerName 0 xserverpath XServerPath "0 oooversionindex oooVersionIndex 0 
directtops 
directToPS 0 
infowindow 
infoWindow 0 filelist fileList 0 xdisplay XDISPLAY .0 alreadyrunningxserver alreadyRunningXServer 0 
defaultmodule 
defaultModule $0 sofficeisrunning sofficeIsRunning $0 spadminisrunning spadminIsRunning 0 	firsttime 	firstTime &0 initiallaunchtime initialLaunchTime &0 readstartoooprefs readStartOOoPrefs  0 getxserverpath getXServerPath (0 writestartoooprefs writeStartOOoPrefs 0 	loadprefs 	loadPrefs 0 
storeprefs 
storePrefs 0 
launchxserver 
launchXServer 0 	launchooo 	launchOOo $0 openooodocuments openOOoDocuments 0 
pathtoscripts 
pathToScripts 0 
loadscript 
loadScript 0 loadscripts loadScripts 0 
initialize 
Initialize
 .menSchMI****       ****
 .menSupMI****       ****
 .coVScliI****       ****
 .aevtodocnull      alis
 .appSlauN****       ****
 .appSactV****       ****
 .appSidle****       ****
 .appSwilQ****       **** 60 asdscriptuniqueidentifier ASDScriptUniqueIdentifier
 boovfals
 
null   
 boovtrue
 
null
     
 boovfals
 boovfals
 boovfals
 boovfals 

  

 &0 readstartoooprefs readStartOOoPrefs    
  
               
 
witP 
 .appScalM****       ****
 
witQ      0 oooversionlist oooVersionList
 .corecnte****       ****
 
bool jkevvlvl O Bl Ec  Ol Ec  Ol Ec  Oa a l Ec  	OPW X  hOb  k
 b  _ j a & kEc  Y hOP
 

  0 getxserverpath getXServerPath    
  0 
xserverprompt 
XServerPrompt 0 errnum errNum
 $(~4}@FRXciz{||{zyxwvutsrqpo
n~ 0 utility Utility} (0 getlocalizedstring getLocalizedString
| .sysoexecTEXT     TEXT{  z  
y 
null
x 
cwin
w 
pvis
v 
prmp
u 
rtyp
t 
aliss 
r .sysoppcbcapp     null
q 
TEXTp (0 writestartoooprefs writeStartOOoPrefso &0 readstartoooprefs readStartOOoPrefs
 mlk
m 
errnl 0 errnum errNumk  n`Ec  O c*k+ EOb  k  Ec  O*k+ EY =b  l  Ec  O*k+ EY  b  m  Ec  O*k+ EY hUO %b  %%j 
W X  b  
a   *a a /Ec  
Y hOeb  
a ,FO *a a a a  Ec  Ob  a &a  lEc  Oa Ec  Y 7b  a &a  mEc  Oa Ec  Y kEc  Oa Ec  O*j+ O*j+  W X  !a "  a #Ec  Y hOfb  
a ,FOP
 jih

gj (0 writestartoooprefs writeStartOOoPrefsi  h  
  
 
fe!',27=
f 
witP
e .appScalM****       ****g >b  lvl Ob  lvl Ob  lvl Ob  	lvl OP
 dOcb

ad 0 	loadprefs 	loadPrefsc  b  
 `_` 0 i  _ 0 
oooversion 
oooVersion
 ^]`\[ZYrXWVUTSRQPONMLKJ^ &0 readstartoooprefs readStartOOoPrefs
] 
matT
\ 
curR[  0 oooversionlist oooVersionList
Z .corecnte****       ****
Y 
popB
X 
menE
W 
menI
V .coredelonull    obj 
U 
cobjT 0 vers  
S 
kocl
R 
insh
Q 
prdt
P 
titl
O 
enaB
N 
tagAM 
L .corecrel****       null
K 
butT
J 
pcnta *j+  Ob   b  */,FOj j j*/,-j 
O Akj kh  /,EO**/,-6a a a ea a a  [OYOb  /,*a /a ,FY hOb  	*a a /a ,FU
 IHG

FI 0 
storeprefs 
storePrefsH  G  
 EDE 0 
oldxserver 
oldXServerD 0 errnum errNum
 CBA@?>
=<
C 
matT
B 
curR
A 
butT
@ 
pcnt?  0 getxserverpath getXServerPath>  
 ;:9
; 
errn: 0 errnum errNum9  =< (0 writestartoooprefs writeStartOOoPrefsF cb  EOb   */,Ec  O*/,Ec  	UOb   Ec  Y hO 
*j+ W X  	  hY hO*j+ 
 876

58 0 
launchxserver 
launchXServer7  6  
 43214  0 runningxserver runningXServer3 0 	theresult 	theResult2 0 errstr errStr1 0 errnum errNum
 02/.B-,+*vwxy)z('&
%$0  0 getxserverpath getXServerPath/ 0 utility Utility. 0 doalert doAlert- (0 getlocalizedstring getLocalizedString
, .panSdisA****       ****
+ .aevtquitnull  null* $0 isxserverrunning isXServerRunning) 0 	erroutput 	errOutput
( .sysoexecTEXT     TEXT' & 0 errstr errStr
 #"!
# 
errn" 0 errnum errNum!  %@$ ,0 displaylaunchfailure displayLaunchFailure5 fEO*j+  Ob    ( *ek+ O*k+ j O*fk+ UO*j Y  E ;*b  kl+ Ec  
O%b  %%%%%j EO*b  a l+ EUOPW 2X  a   $ *ek+ O*a k+ j O*fk+ UY hO  
*b  l+ UY hO
  

  0 	launchooo 	launchOOo 
 
   0 
theprogram 
theProgram 0 afile aFile  
 
 0 
theprogram 
theProgram 0 afile aFile 
0 thecmd   0 
programexists 
programExists "0 launchedxserver launchedXServer 0 
directtopsenv 
directToPSEnv 0 theenv theEnv 0 errstr errStr 0 errnum errNum 0 thewaittime theWaitTime
 !

OZhi
	  0 utility Utility $0 oooprogramexists oooProgramExists
 0 
launchxserver 
launchXServer  0 	erroutput 	errOutput

 .sysoexecTEXT     TEXT	 0 errstr errStr  
 
errn 0 errnum errNum    0 isooorunning isOOoRunning 
sb  %%%%EO , *b  lvl+ EY *b  mvl+ EUO/*j+ 
EOb   Ec  OPY hO lEOb  	k  EY hO%b  %%EOb  m  hY !a %b  %a %b  %a %a %EO%%a %_ %a %j W X  hO ma  *a a _ m+ Ec  Y N*a b  _ m+ Ec  Ob   .b  
 
a EY a EO*a  '_ m+ Ec  Y hUOb   fEc  Oa Ec  OPY hY hY h
   $0 openooodocuments openOOoDocuments       0 i   0 thedocument theDocument 0 thefilepath theFilePath 0 thefileinfo theFileInfo ,0QXb
 .corecnte****       ****
 
cobj
 
psxp
 .sysonfo4asfe       ****
 
asdr
 
asty
 
bool 0 utility Utility 0 convertfont convertFont 0 	launchooo 	launchOOo b  j  j n hkb  j  kh  b  /EO,%%EOj EO, /
 	, &  
*b  l+ UY 	*l+ Y h[OYY hOjvEc  
 s 0 
pathtoscripts 
pathToScripts      0 apppath appPath  0 thescriptspath theScriptsPath 
 
from
 fldmfldu
 .earsffdralis        afdr
 
ctxt )l &EO%&EO
  0 
loadscript 
loadScript     0 
scriptname 
scriptName    0 
scriptname 
scriptName 0 
thescriptpath 
theScriptPath "0 thescriptobject theScriptObject  0 
pathtoscripts 
pathToScripts
 
file
 .sysoloadscpt        alis *j+  %%EO*/j EO
 	 0 loadscripts loadScripts      0 errstr errStr 0 errnum errNum	 
 0 
loadscript 
loadScript 0 
utilitylib 
utilityLib 0 utility Utility 0 errstr errStr
 
 
errn 0 errnum errNum   0b    ' *k+ EO,EOeEc   W X  hY h
 
 0 
initialize 
Initialize      &0 foundoooprefsfile foundOOoPrefsFile 0 errstr errStr 0 errnum errNum 0 thefile theFile 0 thepath thePath  0 thepathpattern thePathPattern 0 
oooversion 
oooVersion 0 
thepathlen 
thePathLen !4
IJ  0 oooversionlist oooVersionList
 .sysoexecTEXT     TEXT 0 errstr errStr
 
 
errn 0 errnum errNum   0 utility Utility 0 readoooprefs readOOoPrefs
 .corecnte****       ****
 
file
 
rtyp
 
TEXT
 .earsffdralis        afdr
 
psxp 0 vers   0 urlpath    &0 readstartoooprefs readStartOOoPrefs
 
cobj
 
leng
 
cha  ?fEOjvEO j OeEW X  hO  	*j+ EUY 	eEc  Oj j  o*)l /EO,EOEO EY a  
a EY hOa %a %%a %j Ec  Oa EOa a b  a kvEY hO*j+ Oa b  /a ,EOa b  /a ,&Ec  Ob  &a  +b  a ,EOb  [a \[Za \Z2EQc  Y b  EQc  Oa b  %a  %j Ec  OP
 _
 .menSchMI****       **** 0 	theobject 	theObject    0 	theobject 	theObject 0 apptolaunch appToLaunch 0 
spadminexists 
spadminExists "0 launchedxserver launchedXServer  fr -5SX
 
pnam
 
null
 
cwin 0 	loadprefs 	loadPrefs
 
pvis 0 utility Utility $0 oooprogramexists oooProgramExists  0 patchoooscript patchOOoScript 0 
launchxserver 
launchXServer $0 isprocessrunning isProcessRunning
 
cuMI
 
tagA 0 	launchooo 	launchOOo/EO,  /b    */Ec  Y hO*j+ Oeb  ,FOPY ߠ,  EY Ѡ,  EY à,  EY ,  
EOPY ,a   |_  *b  a a lvl+ EUO X_  *b  k+ UO*j+ EO 6fEc  O_  *a kl+ Ec  UOb   
a EY hY hY hY !,a   a ,a ,Ec  OPY hOa  *a l+ Y hOP
 d
 .menSupMI****       **** 0 	theobject 	theObject    0 	theobject 	theObject p
 
pnam ,  b   fY hY hOe
 
 .coVScliI****       **** 0 	theobject 	theObject    0 	theobject 	theObject 0 errnum errNum 

 
cwin
 
pnam 0 
storeprefs 
storePrefs
 
pvis   
 
errn 0 errnum errNum   L,,  B ,,  
*j+ Y ,  hY hOfb  ,FW X    hY hY h
 ~
 .aevtodocnull      alis 0 thefiles theFiles   }} 0 thefiles theFiles || $0 openooodocuments openOOoDocuments~ Ec  Ob   
*j+  Y h
 {	
zyx
{ .appSlauN****       ****z 0 	theobject 	theObjecty   wvutsrqw 0 	theobject 	theObjectv 0 oktorun okToRunu 0 sysvers sysVerst 0 hackstr hackStrs 0 errstr errStrr 0 errnum errNumq 0 
loaderrstr 
loadErrStr #	*	$p	1o	En	J	Lml	Rk	bjihg					fed	cba`_
0^
p .fndrgstlns          typeo 
n 
witP
m .appScalM****       ****l 0 errstr errStr ]\[
] 
errn\ 0 errnum errNum[  
k 
btns
j 
givui 
h .panSdlog****       ****g 0 loadscripts loadScripts
f .panSdisA****       ****
e .aevtquitnull  nulld 0 
initialize 
Initialize
c .sysorandnmbr     nmbr
b 
TEXTa 0 	erroutput 	errOutput
` .corecnte****       ****_ $0 openooodocuments openOOoDocuments^ 0 	launchooo 	launchOOox fEO j EOPUOEO - lvl 	EW 
X 
 EOkvka  Y hOb    L*j+ Ob    9a EO a a a lvl 	EW X 
 a EOj O*j Y hY hOb    eEY hO 
*j Y E*j+ Oa *j %a &E` Ob  j j *j+  O*j Y *b  a !l+ "OP
 Z
GYXW
Z .appSactV****       ****Y 0 	theobject 	theObjectX   VV 0 	theobject 	theObject UT
gSU 0 utility UtilityT 0 	isalertup 	isAlertUpS $0 isprocessrunning isProcessRunningW ,b    $ *j+  *kl+ Ec  Y hUY h
 R
vQPO
R .appSidle****       ****Q 0 	theobject 	theObjectP   NN 0 	theobject 	theObject ML
M 
null
L 
pvisO *b  
 b  
,E fb  
,FY hY hOk
 K
JIH
K .appSwilQ****       ****J 0 	theobject 	theObjectI   GFEG 0 	theobject 	theObjectF 0 errstr errStrE 0 errnum errNum 
DCB D 0 	erroutput 	errOutput
C .sysoexecTEXT     TEXTB 0 errstr errStr  A@?
A 
errn@ 0 errnum errNum?  H fEc  O %j W X  hOP ascr  
ޭ