/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx.core.metrics;

import ch.qos.logback.classic.Level;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.core.metrics.MetricsInstance;
import com.elluminate.jinx.core.metrics.MetricsLogger;
import com.elluminate.jinx.core.metrics.MetricsLoggerFactory;
import org.slf4j.Logger;

class DefaultMetricsInstanceImpl
implements MetricsInstance {
    private Logger logger;
    private String loggerName;
    private final MetricsLogger instance = MetricsLoggerFactory.getInstance();

    DefaultMetricsInstanceImpl(Logger logger, String loggerName) {
        this.logger = logger;
        this.loggerName = MetricsLoggerFactory.escapeString(loggerName);
    }

    @Override
    public void setLoggerLevel(Level loggerLevel) {
        if (this.logger instanceof ch.qos.logback.classic.Logger) {
            ((ch.qos.logback.classic.Logger)this.logger).setLevel(loggerLevel);
        }
    }

    @Override
    public void enableLogger(boolean enable) {
        if (this.logger instanceof ch.qos.logback.classic.Logger) {
            ((ch.qos.logback.classic.Logger)this.logger).setLevel(enable ? Level.INFO : Level.OFF);
        }
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public void log(String conferenceName, String metricName, String ... arguments) {
        if (this.instance.isLoggingEnabled() && this.logger != null && this.logger.isInfoEnabled()) {
            StringBuilder message = new StringBuilder();
            message.append(MetricsLoggerFactory.escapeString(conferenceName));
            message.append('|');
            message.append(MetricsLoggerFactory.escapeString(metricName));
            for (String arg : arguments) {
                if (arg == null) continue;
                message.append('|');
                message.append(MetricsLoggerFactory.escapeString(arg));
            }
            this.logger.info(message.toString());
        }
    }

    @Override
    public void log(ClientList clientList, String metricName, String ... arguments) {
        if (this.instance.isLoggingEnabled() && this.logger != null && this.logger.isInfoEnabled()) {
            String sessionName = clientList.getConnection().getConferenceName().getCanonicalName();
            this.log(sessionName, metricName, arguments);
        }
    }
}

