/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.XmitWindowListener;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.log.LogSupport;

public class XmitWindow {
    private int min;
    private int max;
    private long msec;
    private int size;
    private int sent;
    private long last = -1L;
    private volatile XmitWindowListener listener = null;
    private Object context = null;
    private DebugFlag trace = null;

    public XmitWindow(long msec, int min, int max) {
        this.min = min;
        this.max = max;
        this.msec = msec;
        this.size = (min + min + max) / 3;
        this.sent = 0;
    }

    public void setListener(XmitWindowListener lst, Object ctxt) {
        this.listener = lst;
        this.context = ctxt;
    }

    public void setTraceFlag(DebugFlag trace) {
        this.trace = trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean xmit(int nBytes) {
        boolean closed;
        if (this.trace != null && this.trace.show()) {
            LogSupport.message((Object)this, (String)"xmit", (String)("Xmit " + nBytes + " (sent=" + (this.sent + nBytes) + ")"));
        }
        XmitWindow xmitWindow = this;
        synchronized (xmitWindow) {
            this.sent += nBytes;
            if (this.last < 0L) {
                this.last = System.currentTimeMillis();
            }
            closed = this.sent >= this.size;
        }
        if (closed) {
            this.doNotify(closed);
        }
        return !closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ack(int nBytes) {
        boolean closed;
        boolean was;
        long now = System.currentTimeMillis();
        long interval = Math.max(1L, now - this.last);
        boolean bl = was = this.sent >= this.size;
        if (this.trace != null && this.trace.show()) {
            LogSupport.message((Object)this, (String)"ack", (String)("Ack  " + nBytes + " (sent=" + (this.sent - nBytes) + ")"));
        }
        XmitWindow xmitWindow = this;
        synchronized (xmitWindow) {
            this.sent -= nBytes;
            if (this.sent <= 0) {
                this.sent = 0;
                this.last = -1L;
            } else {
                this.last = now;
            }
            int computed = (int)(this.msec * (long)nBytes / interval);
            computed = Math.min(Math.max(computed, this.min), this.max);
            this.size = (this.size + computed) / 2;
            closed = this.sent >= this.size;
        }
        if (was != closed) {
            this.doNotify(closed);
        }
        return !closed;
    }

    public boolean isOpen() {
        return this.sent < this.size;
    }

    public int getWindowSize() {
        return this.size;
    }

    public int getSent() {
        return this.sent;
    }

    public void reset() {
        this.sent = 0;
        this.last = -1L;
    }

    private void doNotify(boolean closed) {
        Object ctx = this.context;
        XmitWindowListener lst = this.listener;
        DebugFlag t = this.trace;
        if (t != null && t.show()) {
            LogSupport.message((Object)this, (String)"doNotify", (String)("Xmit window " + (closed ? "closed" : "opened") + "(" + this.size + "," + ctx + ")"));
        }
        if (lst == null) {
            return;
        }
        if (closed) {
            lst.xmitWindowClosed(this, ctx);
        } else {
            lst.xmitWindowOpened(this, ctx);
        }
    }
}

