/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.Bytes;
import com.elluminate.util.ShortList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;

public class PropertyValue {
    public static final byte INVALID_PROP = 0;
    public static final byte BOOLEAN_PROP = 1;
    public static final byte BYTE_PROP = 2;
    public static final byte SHORT_PROP = 3;
    public static final byte INTEGER_PROP = 4;
    public static final byte LONG_PROP = 5;
    public static final byte FLOAT_PROP = 6;
    public static final byte DOUBLE_PROP = 7;
    public static final byte CHAR_PROP = 8;
    public static final byte STRING_PROP = 9;
    public static final byte ARRAY_PROP = 16;
    public static final String[] TYPES = new String[]{"INVALID", "Boolean", "Byte", "Short", "Integer", "Long", "Float", "Double", "Char", "String"};
    private Object value;
    private byte type;
    private byte comp = 0;

    private PropertyValue(byte t, byte c, Object v) {
        this.type = t;
        this.comp = c;
        this.value = v;
    }

    public PropertyValue(Object o) {
        this.type = PropertyValue.getType(o);
        if (o.getClass().isArray()) {
            this.comp = this.type;
            this.type = (byte)16;
        } else {
            this.comp = 0;
        }
        this.value = o;
    }

    public PropertyValue(Boolean b) {
        this.value = b;
        this.type = 1;
    }

    public PropertyValue(boolean[] ba) {
        this.value = ba;
        this.type = (byte)16;
        this.comp = 1;
    }

    public PropertyValue(Byte b) {
        this.value = b;
        this.type = (byte)2;
    }

    public PropertyValue(byte[] ba) {
        this.value = ba;
        this.type = (byte)16;
        this.comp = (byte)2;
    }

    public PropertyValue(Character c) {
        this.value = c;
        this.type = (byte)8;
    }

    public PropertyValue(char[] ca) {
        this.value = ca;
        this.type = (byte)16;
        this.comp = (byte)8;
    }

    public PropertyValue(Short s) {
        this.value = s;
        this.type = (byte)3;
    }

    public PropertyValue(short[] sa) {
        this.value = sa;
        this.type = (byte)16;
        this.comp = (byte)3;
    }

    public PropertyValue(Integer i) {
        this.value = i;
        this.type = (byte)4;
    }

    public PropertyValue(int[] ia) {
        this.value = ia;
        this.type = (byte)16;
        this.comp = (byte)4;
    }

    public PropertyValue(Long l) {
        this.value = l;
        this.type = (byte)5;
    }

    public PropertyValue(long[] la) {
        this.value = la;
        this.type = (byte)16;
        this.comp = (byte)5;
    }

    public PropertyValue(Float f) {
        this.value = f;
        this.type = (byte)6;
    }

    public PropertyValue(float[] fa) {
        this.value = fa;
        this.type = (byte)16;
        this.comp = (byte)6;
    }

    public PropertyValue(Double d) {
        this.value = d;
        this.type = (byte)7;
    }

    public PropertyValue(double[] da) {
        this.value = da;
        this.type = (byte)16;
        this.comp = (byte)7;
    }

    public PropertyValue(String s) {
        this.value = s;
        this.type = (byte)9;
    }

    public PropertyValue(String[] sa) {
        this.value = sa;
        this.type = (byte)16;
        this.comp = (byte)9;
    }

    public boolean isShareable() {
        return this.type != 0;
    }

    public Object rawValue() {
        return this.value;
    }

    public boolean booleanValue() {
        return (Boolean)this.value;
    }

    public byte byteValue() {
        return (Byte)this.value;
    }

    public char charValue() {
        return ((Character)this.value).charValue();
    }

    public short shortValue() {
        return (Short)this.value;
    }

    public int intValue() {
        return (Integer)this.value;
    }

    public long longValue() {
        return (Long)this.value;
    }

    public float floatValue() {
        return ((Float)this.value).floatValue();
    }

    public double doubleValue() {
        return (Double)this.value;
    }

    public String stringValue() {
        return (String)this.value;
    }

    public boolean[] booleanArray() {
        return (boolean[])this.value;
    }

    public byte[] byteArray() {
        return (byte[])this.value;
    }

    public char[] charArray() {
        return (char[])this.value;
    }

    public short[] shortArray() {
        return (short[])this.value;
    }

    public int[] intArray() {
        return (int[])this.value;
    }

    public long[] longArray() {
        return (long[])this.value;
    }

    public float[] floatArray() {
        return (float[])this.value;
    }

    public double[] doubleArray() {
        return (double[])this.value;
    }

    public String[] stringArray() {
        return (String[])this.value;
    }

    public static PropertyValue getLocalOnlyValue(Object o) {
        return new PropertyValue(0, 0, o);
    }

    public boolean equals(Object other) {
        if (other instanceof PropertyValue) {
            PropertyValue otherValue = (PropertyValue)other;
            return this.value.equals(otherValue.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        if (this.type == 16) {
            StringBuffer buf = new StringBuffer(TYPES[this.comp] + " Array [");
            buf.append(Array.getLength(this.value));
            buf.append("]");
            return buf.toString();
        }
        return TYPES[this.type] + " " + this.value;
    }

    public static PropertyValue decode(DataInputStream str) throws IOException {
        byte kind = str.readByte();
        PropertyValue pv = null;
        if (kind == 16) {
            int len = str.readInt();
            byte elem = str.readByte();
            Class<?> cls = PropertyValue.getClass(elem);
            if (cls == null) {
                throw new IOException("Invalid property value coding.");
            }
            Object val = Array.newInstance(cls, len);
            block22: for (int i = 0; i < len; ++i) {
                switch (elem) {
                    case 1: {
                        Array.setBoolean(val, i, str.readBoolean());
                        continue block22;
                    }
                    case 2: {
                        Array.setByte(val, i, str.readByte());
                        continue block22;
                    }
                    case 3: {
                        Array.setShort(val, i, str.readShort());
                        continue block22;
                    }
                    case 4: {
                        Array.setInt(val, i, str.readInt());
                        continue block22;
                    }
                    case 5: {
                        Array.setLong(val, i, str.readLong());
                        continue block22;
                    }
                    case 6: {
                        Array.setFloat(val, i, str.readFloat());
                        continue block22;
                    }
                    case 7: {
                        Array.setDouble(val, i, str.readDouble());
                        continue block22;
                    }
                    case 8: {
                        Array.setChar(val, i, str.readChar());
                        continue block22;
                    }
                    case 9: {
                        Array.set(val, i, str.readUTF());
                    }
                }
            }
            pv = new PropertyValue(16, elem, val);
        } else {
            Object val;
            switch (kind) {
                case 1: {
                    val = str.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 2: {
                    val = Bytes.get(str.readByte());
                    break;
                }
                case 8: {
                    val = new Character(str.readChar());
                    break;
                }
                case 3: {
                    val = ShortList.get((short)str.readShort());
                    break;
                }
                case 4: {
                    val = new Integer(str.readInt());
                    break;
                }
                case 5: {
                    val = new Long(str.readLong());
                    break;
                }
                case 6: {
                    val = new Float(str.readFloat());
                    break;
                }
                case 7: {
                    val = new Double(str.readDouble());
                    break;
                }
                case 9: {
                    val = str.readUTF();
                    break;
                }
                default: {
                    throw new IOException("Invalid property value coding.");
                }
            }
            pv = new PropertyValue(kind, 0, val);
        }
        return pv;
    }

    public void encode(DataOutputStream str) throws IOException {
        if (this.type == 0) {
            throw new IOException("Property value of type " + this.value.getClass().getName() + " is not shareable");
        }
        str.writeByte(this.type);
        if (this.type == 16) {
            int len = Array.getLength(this.value);
            str.writeInt(len);
            str.writeByte(this.comp);
            block22: for (int i = 0; i < len; ++i) {
                switch (this.comp) {
                    case 1: {
                        str.writeBoolean(Array.getBoolean(this.value, i));
                        continue block22;
                    }
                    case 2: {
                        str.writeByte(Array.getByte(this.value, i));
                        continue block22;
                    }
                    case 3: {
                        str.writeShort(Array.getShort(this.value, i));
                        continue block22;
                    }
                    case 4: {
                        str.writeInt(Array.getInt(this.value, i));
                        continue block22;
                    }
                    case 5: {
                        str.writeLong(Array.getLong(this.value, i));
                        continue block22;
                    }
                    case 6: {
                        str.writeFloat(Array.getFloat(this.value, i));
                        continue block22;
                    }
                    case 7: {
                        str.writeDouble(Array.getDouble(this.value, i));
                        continue block22;
                    }
                    case 8: {
                        str.writeChar(Array.getChar(this.value, i));
                        continue block22;
                    }
                    case 9: {
                        str.writeUTF((String)Array.get(this.value, i));
                    }
                }
            }
        } else {
            switch (this.type) {
                case 1: {
                    str.writeBoolean((Boolean)this.value);
                    break;
                }
                case 2: {
                    str.writeByte(((Byte)this.value).byteValue());
                    break;
                }
                case 3: {
                    str.writeShort(((Short)this.value).shortValue());
                    break;
                }
                case 4: {
                    str.writeInt((Integer)this.value);
                    break;
                }
                case 5: {
                    str.writeLong((Long)this.value);
                    break;
                }
                case 6: {
                    str.writeFloat(((Float)this.value).floatValue());
                    break;
                }
                case 7: {
                    str.writeDouble((Double)this.value);
                    break;
                }
                case 8: {
                    str.writeChar(((Character)this.value).charValue());
                    break;
                }
                case 9: {
                    str.writeUTF((String)this.value);
                }
            }
        }
    }

    private static Class<?> getClass(byte type) throws IOException {
        switch (type) {
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return Byte.TYPE;
            }
            case 3: {
                return Short.TYPE;
            }
            case 4: {
                return Integer.TYPE;
            }
            case 5: {
                return Long.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Double.TYPE;
            }
            case 8: {
                return Character.TYPE;
            }
            case 9: {
                return String.class;
            }
        }
        throw new IOException("Unknown propertry value type '" + type + "'");
    }

    private static byte getType(Object o) {
        Class<?> cls = o.getClass();
        if (cls.isArray()) {
            cls = cls.getComponentType();
        }
        if (cls.equals(Boolean.TYPE) || cls.equals(Boolean.class)) {
            return 1;
        }
        if (cls.equals(Byte.TYPE) || cls.equals(Byte.class)) {
            return 2;
        }
        if (cls.equals(Character.TYPE) || cls.equals(Character.class)) {
            return 8;
        }
        if (cls.equals(Short.TYPE) || cls.equals(Short.class)) {
            return 3;
        }
        if (cls.equals(Integer.TYPE) || cls.equals(Integer.class)) {
            return 4;
        }
        if (cls.equals(Long.TYPE) || cls.equals(Long.class)) {
            return 5;
        }
        if (cls.equals(Float.TYPE) || cls.equals(Float.class)) {
            return 6;
        }
        if (cls.equals(Double.TYPE) || cls.equals(Double.class)) {
            return 7;
        }
        throw new IllegalArgumentException("Invalid type for PropertyValue - " + cls.getName());
    }
}

