/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.Connection;
import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.DefaultPropertyStore;
import com.elluminate.jinx.Property;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.jinx.PropertyAccessController;
import com.elluminate.jinx.PropertyChangeSet;
import com.elluminate.jinx.PropertyValue;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.util.CPropertyChangeSupport;
import com.elluminate.util.Debug;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PropertyStore
implements PropertyAccessAPI {
    protected PropertyAccessController defaultAccess = null;
    private Connection connection;
    private short address;
    private byte scope;
    private CPropertyChangeSupport changeSupport;
    protected String dbWhich;
    private short propertyID = 1;
    private volatile boolean resetting = false;
    private Object propertyLock = new Object();
    private HashMap<String, Property> byName = new HashMap();
    private HashMap<Short, Property> byID = new HashMap();

    public PropertyStore(Connection connection) {
        this.connection = connection;
        this.address = (short)-32767;
        this.scope = 1;
        this.dbWhich = "";
        this.changeSupport = new CPropertyChangeSupport((Object)this);
    }

    public PropertyStore(Connection connection, byte scope, short address) {
        String addrDesc = "";
        this.connection = connection;
        this.address = address;
        this.scope = scope;
        this.changeSupport = new CPropertyChangeSupport((Object)this);
        if (address == -1) {
            addrDesc = "[Template]";
        } else if (scope == 1) {
            this.address = (short)-32767;
        } else if (address >= 0) {
            addrDesc = "[" + address + "]";
        } else {
            throw new IllegalArgumentException("Invalid address argument " + address + " for scope " + scope);
        }
        switch (scope) {
            case 1: {
                this.dbWhich = "";
                break;
            }
            case 0: {
                this.dbWhich = "client" + addrDesc;
                break;
            }
            case 2: {
                this.dbWhich = "group" + addrDesc;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid property store scope - " + scope);
            }
        }
    }

    @Override
    public byte getScope() {
        return this.scope;
    }

    protected boolean isOnServer() {
        return this.connection.getAddress() == 0;
    }

    protected boolean contains(String name) {
        return this.byName.containsKey(name);
    }

    protected boolean isShared(String name) {
        Property prop = this.byName.get(name);
        if (prop == null) {
            return false;
        }
        return prop.isShared();
    }

    protected short getPropertyStoreOwner() {
        return this.address;
    }

    protected short declareSharedProperty(String prop, PropertyValue value) {
        if (!this.isOnServer()) {
            throw new IllegalStateException("declareSharedProperty may only be called from the server.");
        }
        if (this.contains(prop)) {
            throw new IllegalArgumentException("Property " + prop + " is already defined.");
        }
        if (this.resetting) {
            return -1;
        }
        short s = this.propertyID;
        this.propertyID = (short)(s + 1);
        short id = s;
        if (DebugFlags.PROPERTIES.show()) {
            LogSupport.message((Object)this, (String)("declareSharedProperty" + this.dbWhich), (String)("Declared " + prop + "(" + id + ")=" + value));
        }
        this.defineSharedProperty(prop, id, value);
        ProtocolBuffer buf = ProtocolBuffer.getInstance();
        DataOutputStream str = buf.addPayload();
        this.connection.encodePropertyDef(str, prop, id, this.scope, value);
        this.connection.sendPropertyDef(str, buf, (short)-2);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void defineSharedProperty(String prop, short id, PropertyValue value) {
        if (this.resetting) {
            return;
        }
        Property p = new Property(prop, value, id);
        Debug.lockEnter((Object)this, (String)"defineSharedProperty", (String)"propertyLock", (Object)this.propertyLock);
        Object object = this.propertyLock;
        synchronized (object) {
            HashMap<String, Property> byNameCopy = new HashMap<String, Property>(this.byName);
            HashMap<Short, Property> byIDCopy = new HashMap<Short, Property>(this.byID);
            byNameCopy.put(prop, p);
            byIDCopy.put(ShortList.get((short)id), p);
            this.byName = byNameCopy;
            this.byID = byIDCopy;
        }
        Debug.lockLeave((Object)this, (String)"defineSharedProperty", (String)"propertyLock", (Object)this.propertyLock);
        if (DebugFlags.PROPERTIES.show()) {
            LogSupport.message((Object)this, (String)("defineSharedProperty" + this.dbWhich), (String)("Defining property " + prop + "(" + id + ")=" + value));
        }
        this.firePropertyChange(prop, null, value.rawValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProperty(String prop) {
        PropertyValue value = null;
        if (!this.contains(prop)) {
            return;
        }
        if (this.isShared(prop)) {
            throw new IllegalStateException("Shared properties cannot currently be deleted.");
        }
        Debug.lockEnter((Object)this, (String)"deleteProperty", (String)"propertyLock", (Object)this.propertyLock);
        Object object = this.propertyLock;
        synchronized (object) {
            HashMap<String, Property> byNameCopy = new HashMap<String, Property>(this.byName);
            Property p = byNameCopy.remove(prop);
            if (p != null) {
                this.byName = byNameCopy;
                value = p.getValue();
            }
        }
        Debug.lockLeave((Object)this, (String)"deleteProperty", (String)"propertyLock", (Object)this.propertyLock);
        if (value != null) {
            try {
                this.firePropertyChange(prop, value, null);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"deleteProperty", (Throwable)ex, (boolean)true);
            }
        }
    }

    protected void setAccessController(String prop, PropertyAccessController ctl) {
        Property p = this.byName.get(prop);
        if (p != null) {
            p.setAccessController(ctl);
        }
    }

    PropertyAccessController getDefaultAccess() {
        return this.defaultAccess;
    }

    @Override
    public Object getProperty(String prop) {
        Property p = this.byName.get(prop);
        if (p == null) {
            return null;
        }
        return p.getValue().rawValue();
    }

    @Override
    public boolean getProperty(String prop, boolean dft) {
        Boolean value = (Boolean)this.getProperty(prop);
        if (value == null) {
            return dft;
        }
        return value;
    }

    @Override
    public byte getProperty(String prop, byte dft) {
        Byte value = (Byte)this.getProperty(prop);
        if (value == null) {
            return dft;
        }
        return value;
    }

    @Override
    public char getProperty(String prop, char dft) {
        Character value = (Character)this.getProperty(prop);
        if (value == null) {
            return dft;
        }
        return value.charValue();
    }

    @Override
    public short getProperty(String prop, short dft) {
        Short value = (Short)this.getProperty(prop);
        if (value == null) {
            return dft;
        }
        return value;
    }

    @Override
    public int getProperty(String prop, int dft) {
        Integer value = (Integer)this.getProperty(prop);
        if (value == null) {
            return dft;
        }
        return value;
    }

    @Override
    public long getProperty(String prop, long dft) {
        Long value = (Long)this.getProperty(prop);
        if (value == null) {
            return dft;
        }
        return value;
    }

    @Override
    public String getProperty(String prop, String dft) {
        String value = (String)this.getProperty(prop);
        if (value == null) {
            return dft;
        }
        return value;
    }

    protected void onSetProperty(PropertyChangeSet changeSet, short id, short from, PropertyValue value) {
        if (this.resetting) {
            return;
        }
        Short key = ShortList.get((short)id);
        Property p = this.byID.get(key);
        if (p != null) {
            boolean modified;
            if (DebugFlags.PROPERTIES.show()) {
                LogSupport.message((Object)this, (String)("onSetProperty" + this.dbWhich), (String)("Received " + p.getName() + "(" + id + ")=" + value));
            }
            if ((modified = p.set(this, from, value)) && this.isOnServer()) {
                changeSet.encodeProperty(this.scope, this.address, id, value);
            }
        } else if (DebugFlags.PROPERTIES.show()) {
            LogSupport.message((Object)this, (String)("onSetProperty" + this.dbWhich), (String)("Shared property " + id + " not found."));
        }
    }

    @Override
    public void setProperty(String prop, PropertyValue value) {
        PropertyChangeSet changeSet = this.connection.getPropertyChangeSet();
        this.setProperty(changeSet, prop, value);
        changeSet.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(PropertyChangeSet changeSet, String prop, PropertyValue value) {
        if (this.resetting) {
            return;
        }
        Property p = this.byName.get(prop);
        if (p == null) {
            Object object = this.propertyLock;
            synchronized (object) {
                p = this.byName.get(prop);
                if (p == null) {
                    HashMap<String, Property> copy = new HashMap<String, Property>(this.byName);
                    p = new Property(prop, value);
                    copy.put(prop, p);
                    this.byName = copy;
                }
            }
            this.firePropertyChange(prop, null, value.rawValue());
            return;
        }
        if (p.isShared()) {
            if (value.rawValue().equals(p.getValue().rawValue())) {
                return;
            }
            if (!value.isShareable()) {
                throw new IllegalArgumentException("Unshareable property value " + value.rawValue().getClass().getName());
            }
            if (this.isOnServer()) {
                p.set(this, (short)0, value);
                changeSet.encodeProperty(this.scope, this.address, p.getID(), value);
            } else {
                changeSet.encodeProperty(this.scope, this.address, p.getID(), value);
            }
        } else {
            p.set(this, this.connection.getAddress(), value);
        }
    }

    @Override
    public void setProperty(String prop, boolean value) {
        this.setProperty(prop, new PropertyValue(value));
    }

    @Override
    public void setProperty(PropertyChangeSet changeSet, String prop, boolean value) {
        this.setProperty(changeSet, prop, new PropertyValue(value));
    }

    @Override
    public void setProperty(String prop, byte value) {
        this.setProperty(prop, new PropertyValue(value));
    }

    @Override
    public void setProperty(PropertyChangeSet changeSet, String prop, byte value) {
        this.setProperty(changeSet, prop, new PropertyValue(value));
    }

    @Override
    public void setProperty(String prop, int value) {
        this.setProperty(prop, new PropertyValue(value));
    }

    @Override
    public void setProperty(PropertyChangeSet changeSet, String prop, int value) {
        this.setProperty(changeSet, prop, new PropertyValue(value));
    }

    @Override
    public void setProperty(String prop, long value) {
        this.setProperty(prop, new PropertyValue(value));
    }

    @Override
    public void setProperty(PropertyChangeSet changeSet, String prop, long value) {
        this.setProperty(changeSet, prop, new PropertyValue(value));
    }

    @Override
    public void setProperty(String prop, short value) {
        this.setProperty(prop, new PropertyValue(value));
    }

    @Override
    public void setProperty(PropertyChangeSet changeSet, String prop, short value) {
        this.setProperty(changeSet, prop, new PropertyValue(value));
    }

    @Override
    public void setProperty(String prop, char value) {
        this.setProperty(prop, new PropertyValue(Character.valueOf(value)));
    }

    @Override
    public void setProperty(PropertyChangeSet changeSet, String prop, char value) {
        this.setProperty(changeSet, prop, new PropertyValue(Character.valueOf(value)));
    }

    public void setProperty(String prop, String value) {
        this.setProperty(prop, new PropertyValue(value));
    }

    public void setProperty(PropertyChangeSet changeSet, String prop, String value) {
        this.setProperty(changeSet, prop, new PropertyValue(value));
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected int encodePropertyDefs(DataOutputStream str) {
        int count = 0;
        for (Property p : this.byName.values()) {
            if (!p.isShared()) continue;
            this.connection.encodePropertyDef(str, p.getName(), p.getID(), this.scope, p.getValue());
            ++count;
        }
        return count;
    }

    protected int encodeProperties(DataOutputStream str) {
        int count = 0;
        for (Property p : this.byName.values()) {
            if (!p.isShared()) continue;
            this.connection.encodeProperty(str, this.scope, this.address, p.getID(), p.getValue());
            ++count;
        }
        return count;
    }

    protected int encodeProperties(DataOutputStream str, DefaultPropertyStore dft) {
        int count = 0;
        for (Property p : this.byName.values()) {
            if (!p.isShared() || p.getValue().equals(dft.getProperty(p.getName()))) continue;
            this.connection.encodeProperty(str, this.scope, this.address, p.getID(), p.getValue());
            ++count;
        }
        return count;
    }

    public void copy(PropertyStore to) {
        this.copy(to, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(PropertyStore to, Map<String, PropertyAccessController> access) {
        HashMap<Short, Property> idCopy = new HashMap<Short, Property>();
        HashMap<String, Property> nameCopy = new HashMap<String, Property>();
        Object object = this.propertyLock;
        synchronized (object) {
            for (Property p : this.byName.values()) {
                if (!p.isShared()) continue;
                Property clone = (Property)p.clone();
                Short id = ShortList.get((short)p.getID());
                if (access != null) {
                    clone.setAccessController(access.get(clone.getName()));
                }
                nameCopy.put(p.getName(), clone);
                idCopy.put(id, clone);
            }
        }
        object = to.propertyLock;
        synchronized (object) {
            to.byName = nameCopy;
            to.byID = idCopy;
        }
        for (String k : this.byName.keySet()) {
            Property p;
            p = (Property)nameCopy.get(k);
            if (p == null) continue;
            to.firePropertyChange(k, null, p.getValue().rawValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetProperties() {
        while (true) {
            Property p = null;
            Debug.lockEnter((Object)this, (String)"resetProperties", (String)"propertyLock", (Object)this.propertyLock);
            try {
                Object object = this.propertyLock;
                synchronized (object) {
                    block15: {
                        if (!this.byName.isEmpty()) break block15;
                        return;
                    }
                    Iterator<Property> i = this.byName.values().iterator();
                    p = i.next();
                    i.remove();
                    if (p.getID() != -1) {
                        this.byID.remove(ShortList.get((short)p.getID()));
                    }
                }
            }
            finally {
                Debug.lockLeave((Object)this, (String)"resetProperties", (String)"propertyLock", (Object)this.propertyLock);
            }
            try {
                this.firePropertyChange(p.getName(), p.getValue().rawValue(), null);
            }
            catch (Exception exception) {}
            continue;
            finally {
                this.byName.remove(p.getName());
                if (p.getID() == -1) continue;
                this.byID.remove(ShortList.get((short)p.getID()));
                continue;
            }
            break;
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener lst) {
        this.changeSupport.addPropertyChangeListener(lst);
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener lst) {
        this.changeSupport.addPropertyChangeListener(prop, lst);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener lst) {
        this.changeSupport.removePropertyChangeListener(lst);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener lst) {
        this.changeSupport.removePropertyChangeListener(prop, lst);
    }

    protected void firePropertyChange(PropertyChangeEvent e) {
        if (DebugFlags.PROPERTIES.show()) {
            LogSupport.message((Object)this, (String)("firePropertyChange" + this.dbWhich), (String)("firing " + e.getPropertyName() + ": " + e.getOldValue() + " -> " + e.getNewValue()));
        }
        this.changeSupport.firePropertyChange(e);
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.firePropertyChange(new PropertyChangeEvent(this, name, oldValue, newValue));
    }
}

