/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.BandwidthLimit;
import com.elluminate.jinx.XmitClock;

public class LimitSet {
    private Limit[] set;

    public LimitSet(BandwidthLimit[] limits) {
        this.set = new Limit[limits.length];
        for (int i = 0; i < limits.length; ++i) {
            this.set[i] = new Limit(limits[i]);
        }
    }

    public long getHorizon() {
        long time = 0L;
        for (int i = 0; i < this.set.length; ++i) {
            long t = this.set[i].computeNext();
            if (t <= time) continue;
            time = t;
        }
        return time;
    }

    public long schedule(int nBytes) {
        return this.schedule(System.currentTimeMillis(), nBytes);
    }

    public long schedule(long now, int nBytes) {
        long time = this.getHorizon();
        long actual = 0L;
        for (int i = 0; i < this.set.length; ++i) {
            long a;
            if (this.set[i].getNext() < time || (a = this.set[i].credit(now, nBytes)) <= actual) continue;
            actual = a;
        }
        time = actual;
        return time;
    }

    public void actual(int nBytes) {
        this.actual(System.currentTimeMillis(), nBytes);
    }

    public void actual(long now, int nBytes) {
        for (int i = 0; i < this.set.length; ++i) {
            this.set[i].actual(now, nBytes);
        }
    }

    class Limit {
        XmitClock clock;
        private int credit;
        private long next;

        public Limit(BandwidthLimit limit) {
            this.clock = limit.getXmitClock();
            this.credit = 0;
            this.next = -1L;
        }

        public long computeNext() {
            this.next = this.clock.getAvailability();
            return this.next;
        }

        public long getNext() {
            return this.next;
        }

        public long credit(long now, int n) {
            this.credit += n;
            return this.clock.schedule(now, n);
        }

        public void actual(long now, int n) {
            if (this.credit > 0) {
                if (n > this.credit) {
                    int delta = n - this.credit;
                    this.clock.schedule(now, delta);
                    this.credit = 0;
                } else {
                    this.credit -= n;
                }
            } else {
                this.clock.schedule(now, n);
            }
        }
    }
}

