/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.Bytes;
import com.elluminate.jinx.JinxException;
import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.jinx.PropertyValue;
import com.elluminate.util.ShortList;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Date;

public class ControlProtocol
extends JinxProtocolAdapter {
    public static final byte REQUEST_CHANNEL = 1;
    public static final byte DEFINE_CHANNEL = 2;
    public static final byte RELEASE_CHANNEL = 3;
    public static final byte ABORT_CHANNEL = 4;
    public static final byte WATCH_CHANNELS = 5;
    public static final byte NEW_CHANNEL = 6;
    public static final byte CHANNEL_UP = 7;
    public static final byte WATCH_CHANNEL = 8;
    public static final byte JOIN_CHANNEL = 9;
    public static final byte LEAVE_CHANNEL = 10;
    public static final byte GET_PROTOCOL = 11;
    public static final byte CHANNEL_PROTOCOL = 12;
    public static final byte ADD_MEMBER = 17;
    public static final byte REMOVE_MEMBER = 18;
    public static final byte DEFINE_PROPERTIES = 33;
    public static final byte SET_PROPERTIES = 34;
    public static final byte CREATE_GROUP = 49;
    public static final byte DELETE_GROUP = 50;
    public static final byte JOIN_GROUP = 51;
    public static final byte RENAME_GROUP = 52;
    public static final byte SESSION_TIME = 65;
    public static final String CHANNEL = "control";
    public static final byte PRIORITY = 1;
    public static final byte BOOLEAN_PROP = 1;
    public static final byte BYTE_PROP = 2;
    public static final byte SHORT_PROP = 3;
    public static final byte INTEGER_PROP = 4;
    public static final byte LONG_PROP = 5;
    public static final byte FLOAT_PROP = 6;
    public static final byte DOUBLE_PROP = 7;
    public static final byte CHAR_PROP = 8;
    public static final byte STRING_PROP = 9;
    public static final byte ARRAY_PROP = 16;
    public static final byte CLIENT_SCOPE = 0;
    public static final byte GLOBAL_SCOPE = 1;
    public static final byte GROUP_SCOPE = 2;
    public static final String DEVICE_PROP = "jinx.deviceType";

    public ControlProtocol() {
        this.defineChannel(CHANNEL, (byte)1);
    }

    @Override
    public String commandToString(byte cmd) {
        switch (cmd) {
            case 1: {
                return "RequestChannel";
            }
            case 3: {
                return "ReleaseChannel";
            }
            case 2: {
                return "DefineChannel";
            }
            case 4: {
                return "AbortChannel";
            }
            case 5: {
                return "WatchChannels";
            }
            case 6: {
                return "NewChannel";
            }
            case 7: {
                return "ChannelUp";
            }
            case 8: {
                return "WatchChannel";
            }
            case 9: {
                return "JoinChannel";
            }
            case 10: {
                return "LeaveChannel";
            }
            case 11: {
                return "GetProtocol";
            }
            case 12: {
                return "ChannelProtocol";
            }
            case 17: {
                return "AddMember";
            }
            case 18: {
                return "RemoveMember";
            }
            case 33: {
                return "DefineProperties";
            }
            case 34: {
                return "SetProperties";
            }
            case 49: {
                return "CreateGroup";
            }
            case 50: {
                return "DeleteGroup";
            }
            case 51: {
                return "JoinGroup";
            }
            case 52: {
                return "RenameGroup";
            }
            case 65: {
                return "SessionTime";
            }
        }
        return "[ unknown control command - " + cmd + " ]";
    }

    @Override
    public String messageToString(byte cmd, DataInputStream str) {
        String desc = this.commandToString(cmd);
        try {
            switch (cmd) {
                case 1: 
                case 4: {
                    String name = str.readUTF();
                    desc = desc + " - " + name;
                    break;
                }
                case 3: {
                    byte id = str.readByte();
                    desc = desc + " - " + id;
                    break;
                }
                case 2: {
                    String name = str.readUTF();
                    byte id = str.readByte();
                    desc = desc + " - " + name + "=" + id;
                    break;
                }
                case 5: {
                    boolean enable = str.readBoolean();
                    desc = desc + " - " + enable;
                    break;
                }
                case 6: {
                    int count;
                    desc = desc + " - " + count + " channels:";
                    for (count = str.readByte(); count > 0; --count) {
                        String name = str.readUTF();
                        desc = desc + "\n  " + name;
                    }
                    break;
                }
                case 7: {
                    byte id = str.readByte();
                    desc = desc + " - " + id;
                    break;
                }
                case 8: {
                    byte id = str.readByte();
                    boolean enable = str.readBoolean();
                    desc = desc + " - " + id + "=" + enable;
                    break;
                }
                case 9: 
                case 10: {
                    byte id = str.readByte();
                    int count = str.readShort();
                    desc = desc + " - " + count + " members on channel " + id + ": ";
                    while (count-- > 0) {
                        short addr = str.readShort();
                        if (count == 0) {
                            desc = desc + addr + " ";
                            continue;
                        }
                        desc = desc + addr + ", ";
                    }
                    break;
                }
                case 11: {
                    String name = str.readUTF();
                    desc = desc + " - " + name;
                    break;
                }
                case 12: {
                    String name = str.readUTF();
                    String proto = str.readUTF();
                    desc = desc + " - protocol[" + name + "] = " + proto;
                    break;
                }
                case 17: {
                    int count = str.readInt();
                    while (count-- > 0) {
                        String name = str.readUTF();
                        String disp = str.readUTF();
                        short addr = str.readShort();
                        short grp = str.readShort();
                        desc = desc + "\n   " + disp + "[" + name + "]=" + addr + "(" + grp + ")";
                    }
                    break;
                }
                case 18: {
                    short addr = str.readShort();
                    desc = desc + " - " + addr;
                    break;
                }
                case 33: {
                    short prop = str.readShort();
                    while (prop > 0) {
                        String name = str.readUTF();
                        byte scope = str.readByte();
                        PropertyValue value = PropertyValue.decode(str);
                        switch (scope) {
                            case 1: {
                                desc = desc + "\n   global(" + prop + "): " + name + "=" + value;
                                break;
                            }
                            case 0: {
                                desc = desc + "\n   client(" + prop + "): " + name + "=" + value;
                                break;
                            }
                            case 2: {
                                desc = desc + "\n   group(" + prop + "): " + name + "=" + value;
                                break;
                            }
                            default: {
                                desc = desc + "\n   INVALID SCOPE(" + prop + "): " + name;
                            }
                        }
                        prop = str.readShort();
                    }
                    break;
                }
                case 34: {
                    short prop = str.readShort();
                    while (prop > 0) {
                        byte scope = str.readByte();
                        int addr = scope == 0 || scope == 2 ? str.readShort() : -32767;
                        PropertyValue value = PropertyValue.decode(str);
                        switch (scope) {
                            case 1: {
                                desc = desc + "\n   global(" + prop + ")=" + value;
                                break;
                            }
                            case 0: {
                                desc = desc + "\n   client(" + prop + "," + addr + ")=" + value;
                                break;
                            }
                            case 2: {
                                desc = desc + "\n   group(" + prop + "," + addr + ")=" + value;
                                break;
                            }
                            default: {
                                desc = desc + "\n   INVALID SCOPE - " + scope + ": " + prop;
                            }
                        }
                        prop = str.readShort();
                    }
                    break;
                }
                case 49: {
                    int count = str.readShort();
                    for (int i = 0; i < count; ++i) {
                        short grp = str.readShort();
                        String name = str.readUTF();
                        boolean temp = str.readBoolean();
                        desc = desc + "\n   " + name + "(" + grp + "," + (temp ? "temp)" : "permanent)");
                    }
                    break;
                }
                case 50: {
                    int count = str.readShort();
                    for (int i = 0; i < count; ++i) {
                        short grp = str.readShort();
                        desc = desc + "\n    " + grp;
                    }
                    break;
                }
                case 51: {
                    short grp = str.readShort();
                    int count = str.readShort();
                    desc = desc + "  adding ";
                    for (int i = 0; i < count; ++i) {
                        short addr = str.readShort();
                        desc = i == 0 ? desc + addr : desc + "," + addr;
                    }
                    desc = desc + " to group " + grp;
                    break;
                }
                case 52: {
                    short grp = str.readShort();
                    String name = str.readUTF();
                    desc = desc + " - " + grp + " renamed to '" + name + "'";
                    break;
                }
                case 65: {
                    long base = str.readLong();
                    long offset = str.readLong();
                    desc = desc + " - " + new Date(base);
                    desc = offset < 0L ? desc + offset + "ms" : desc + "+" + offset + "ms";
                }
            }
        }
        catch (Exception ex) {
            desc = desc + "  [ exception " + ex + " while decoding packet ]";
        }
        return desc;
    }

    public static boolean validatePropertyValue(Serializable value) {
        if (value instanceof Boolean) {
            return true;
        }
        if (value instanceof Byte) {
            return true;
        }
        if (value instanceof Short) {
            return true;
        }
        if (value instanceof Integer) {
            return true;
        }
        if (value instanceof Long) {
            return true;
        }
        if (value instanceof Float) {
            return true;
        }
        if (value instanceof Double) {
            return true;
        }
        if (value instanceof Character) {
            return true;
        }
        if (value instanceof String) {
            return true;
        }
        if (value instanceof boolean[]) {
            return true;
        }
        if (value instanceof byte[]) {
            return true;
        }
        if (value instanceof short[]) {
            return true;
        }
        if (value instanceof int[]) {
            return true;
        }
        if (value instanceof long[]) {
            return true;
        }
        if (value instanceof float[]) {
            return true;
        }
        if (value instanceof double[]) {
            return true;
        }
        if (value instanceof char[]) {
            return true;
        }
        return value instanceof String[];
    }

    public static void encodePropertyValue(ObjectOutputStream str, Serializable value) throws IOException {
        if (ControlProtocol.isArray(value)) {
            ControlProtocol.encodeArrayValue(str, value);
            return;
        }
        byte type = ControlProtocol.getTypeCode(value);
        str.writeByte(type);
        switch (type) {
            case 1: {
                str.writeBoolean((Boolean)value);
                break;
            }
            case 2: {
                str.writeByte(((Byte)value).byteValue());
                break;
            }
            case 3: {
                str.writeShort(((Short)value).shortValue());
                break;
            }
            case 4: {
                str.writeInt((Integer)value);
                break;
            }
            case 5: {
                str.writeLong((Long)value);
                break;
            }
            case 6: {
                str.writeFloat(((Float)value).floatValue());
                break;
            }
            case 7: {
                str.writeDouble((Double)value);
                break;
            }
            case 8: {
                str.writeChar(((Character)value).charValue());
                break;
            }
            case 9: {
                str.writeUTF((String)((Object)value));
                break;
            }
            default: {
                str.writeObject(value);
            }
        }
    }

    private static boolean isArray(Serializable value) {
        Class<?> cls = value.getClass();
        return cls.isArray();
    }

    private static byte getTypeCode(Serializable value) {
        Class<?> cls = value.getClass();
        if (cls.isArray()) {
            cls = cls.getComponentType();
        }
        if (cls.equals(Boolean.TYPE) || cls.equals(Boolean.class)) {
            return 1;
        }
        if (cls.equals(Byte.TYPE) || cls.equals(Byte.class)) {
            return 2;
        }
        if (cls.equals(Short.TYPE) || cls.equals(Short.class)) {
            return 3;
        }
        if (cls.equals(Integer.TYPE) || cls.equals(Integer.class)) {
            return 4;
        }
        if (cls.equals(Long.TYPE) || cls.equals(Long.class)) {
            return 5;
        }
        if (cls.equals(Float.TYPE) || cls.equals(Float.class)) {
            return 6;
        }
        if (cls.equals(Double.TYPE) || cls.equals(Double.class)) {
            return 7;
        }
        if (cls.equals(Character.TYPE) || cls.equals(Character.class)) {
            return 8;
        }
        if (cls.equals(String.class)) {
            return 9;
        }
        throw new IllegalArgumentException("Unvalid property type " + cls.getName());
    }

    private static Class<?> getClass(byte type) {
        switch (type) {
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return Byte.TYPE;
            }
            case 3: {
                return Short.TYPE;
            }
            case 4: {
                return Integer.TYPE;
            }
            case 5: {
                return Long.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Double.TYPE;
            }
            case 8: {
                return Character.TYPE;
            }
            case 9: {
                return String.class;
            }
        }
        return Serializable.class;
    }

    private static void encodeArrayValue(ObjectOutputStream str, Serializable value) throws IOException {
        byte type = ControlProtocol.getTypeCode(value);
        int len = Array.getLength(value);
        str.writeByte(16);
        str.writeInt(len);
        str.writeByte(type);
        block11: for (int i = 0; i < len; ++i) {
            switch (type) {
                case 1: {
                    str.writeBoolean(Array.getBoolean(value, i));
                    continue block11;
                }
                case 2: {
                    str.writeByte(Array.getByte(value, i));
                    continue block11;
                }
                case 3: {
                    str.writeShort(Array.getShort(value, i));
                    continue block11;
                }
                case 4: {
                    str.writeInt(Array.getInt(value, i));
                    continue block11;
                }
                case 5: {
                    str.writeLong(Array.getLong(value, i));
                    continue block11;
                }
                case 6: {
                    str.writeFloat(Array.getFloat(value, i));
                    continue block11;
                }
                case 7: {
                    str.writeDouble(Array.getDouble(value, i));
                    continue block11;
                }
                case 8: {
                    str.writeChar(Array.getChar(value, i));
                    continue block11;
                }
                case 9: {
                    str.writeUTF((String)Array.get(value, i));
                }
            }
        }
    }

    public static Serializable decodePropertyValue(DataInputStream str) throws Exception {
        byte kind = str.readByte();
        switch (kind) {
            case 1: {
                return str.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return Bytes.get(str.readByte());
            }
            case 3: {
                return ShortList.get((short)str.readShort());
            }
            case 4: {
                return new Integer(str.readInt());
            }
            case 5: {
                return new Long(str.readLong());
            }
            case 6: {
                return new Float(str.readFloat());
            }
            case 7: {
                return new Double(str.readDouble());
            }
            case 8: {
                return new Character(str.readChar());
            }
            case 9: {
                return str.readUTF();
            }
            case 16: {
                return ControlProtocol.decodeArrayValue(str);
            }
        }
        throw new JinxException("Invalid property value coding.");
    }

    private static Serializable decodeArrayValue(DataInputStream str) throws Exception {
        int len = str.readInt();
        byte type = str.readByte();
        Class<?> cls = ControlProtocol.getClass(type);
        Serializable obj = (Serializable)Array.newInstance(cls, len);
        block11: for (int i = 0; i < len; ++i) {
            switch (type) {
                case 1: {
                    Array.setBoolean(obj, i, str.readBoolean());
                    continue block11;
                }
                case 2: {
                    Array.setByte(obj, i, str.readByte());
                    continue block11;
                }
                case 3: {
                    Array.setShort(obj, i, str.readShort());
                    continue block11;
                }
                case 4: {
                    Array.setInt(obj, i, str.readInt());
                    continue block11;
                }
                case 5: {
                    Array.setLong(obj, i, str.readLong());
                    continue block11;
                }
                case 6: {
                    Array.setFloat(obj, i, str.readFloat());
                    continue block11;
                }
                case 7: {
                    Array.setDouble(obj, i, str.readDouble());
                    continue block11;
                }
                case 8: {
                    Array.setChar(obj, i, str.readChar());
                    continue block11;
                }
                case 9: {
                    Array.set(obj, i, str.readUTF());
                    continue block11;
                }
                default: {
                    throw new JinxException("Invalid property value coding.");
                }
            }
        }
        return obj;
    }
}

