/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientStats;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.PropertyStore;

public class ClientInfo
extends PropertyStore {
    public static final byte INVALID = 0;
    public static final byte RESERVED = 1;
    public static final byte CONNECTED = 2;
    public static final byte DISPOSED = 3;
    private static Obfuscator obfuscator = null;
    private static final Object obufuscatorLock = new Object();
    private String name = null;
    private String displayName = null;
    private String obfuscatedDisplayName = null;
    private short addr = (short)-32767;
    private short grp = (short)-32767;
    private boolean me = false;
    private byte state = 0;
    private ClientStats stats = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setObfuscator(Obfuscator obf) {
        Object object = obufuscatorLock;
        synchronized (object) {
            if (obfuscator != null) {
                throw new RuntimeException("Obfuscator already set");
            }
            obfuscator = obf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetObfuscator() {
        Object object = obufuscatorLock;
        synchronized (object) {
            if (obfuscator != null) {
                obfuscator.resetObfuscator();
            }
        }
    }

    ClientInfo(Connection connection, String name, short addr, boolean me) {
        super(connection, (byte)0, addr);
        this.name = name.intern();
        this.addr = addr;
        this.me = me;
        int idx = name.indexOf(35);
        this.displayName = idx > 0 ? name.substring(0, idx).intern() : name;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name.intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayName() {
        Object object = obufuscatorLock;
        synchronized (object) {
            if (obfuscator != null) {
                return obfuscator.obfuscate(this, this.displayName);
            }
        }
        return this.displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayName(String nm) {
        Object object = obufuscatorLock;
        synchronized (object) {
            this.displayName = nm.intern();
        }
    }

    public short getAddress() {
        return this.addr;
    }

    public short getGroupID() {
        return this.grp;
    }

    public ClientGroup getGroup() {
        return this.getClientList().getClientGroup(this.grp);
    }

    void setGroupID(short group) {
        if (group == this.grp) {
            return;
        }
        ClientList clients = this.getClientList();
        ClientGroup oldGroup = null;
        ClientGroup newGroup = null;
        if (this.grp != -32767) {
            oldGroup = clients.getClientGroup(this.grp);
        }
        if (group != -32767) {
            newGroup = clients.getClientGroup(group);
        }
        this.grp = group;
        if (oldGroup != null) {
            oldGroup.remove(this);
        }
        if (newGroup != null) {
            newGroup.add(this);
        }
    }

    public ClientList getClientList() {
        return this.getConnection().getClientList();
    }

    void setState(byte newState) {
        this.state = newState;
    }

    public byte getState() {
        return this.state;
    }

    public boolean isVisible() {
        try {
            return this.name.charAt(0) != ' ';
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isServer() {
        return this.addr == 0;
    }

    public boolean isMe() {
        return this.me;
    }

    public void setClientStats(ClientStats stats) {
        this.stats = stats;
    }

    public ClientStats getClientStats() {
        return this.stats;
    }

    public String toString() {
        return "ClientInfo [name='" + this.name + "', addr=" + this.addr + ", group=" + this.grp + "]";
    }

    public static interface Obfuscator {
        public String obfuscate(ClientInfo var1, String var2);

        public void resetObfuscator();
    }
}

