/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.PropertyStore;
import com.elluminate.util.Debug;
import java.util.HashSet;
import java.util.Iterator;

public class ClientGroup
extends PropertyStore
implements Iterable<ClientInfo> {
    private short grp = (short)-32767;
    private String name = null;
    private HashSet<ClientInfo> members = new HashSet();
    private HashSet<ClientInfo> visible = new HashSet();
    private boolean isTransient = false;

    ClientGroup(Connection connection, short id, String nm, boolean closeOnEmpty) {
        super(connection, (byte)2, id);
        this.grp = id;
        this.name = nm;
        this.isTransient = closeOnEmpty;
    }

    public String toString() {
        return super.toString() + " grp=" + this.grp + " name=" + this.name + " isTransient=" + this.isTransient;
    }

    void setName(String nm) {
        this.name = nm;
    }

    public short getGroupID() {
        return this.grp;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public ClientList getClientList() {
        return this.getConnection().getClientList();
    }

    public ClientInfo[] getMembers() {
        return this.members.toArray(new ClientInfo[this.members.size()]);
    }

    @Override
    public Iterator<ClientInfo> iterator() {
        return this.members.iterator();
    }

    public int size() {
        return this.members.size();
    }

    public Iterator<ClientInfo> visibleIterator() {
        return this.visible.iterator();
    }

    public int getVisibleSize() {
        return this.visible.size();
    }

    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(ClientInfo ci) {
        if (this.members.contains(ci)) {
            return;
        }
        Debug.lockEnter((Object)this, (String)"add", null, (Object)this);
        ClientGroup clientGroup = this;
        synchronized (clientGroup) {
            HashSet<ClientInfo> copy = new HashSet<ClientInfo>(this.members);
            copy.add(ci);
            if (ci.getGroupID() != this.grp) {
                ci.setGroupID(this.grp);
            }
            this.members = copy;
            if (ci.isVisible()) {
                copy = new HashSet<ClientInfo>(this.visible);
                copy.add(ci);
                this.visible = copy;
            }
        }
        Debug.lockLeave((Object)this, (String)"add", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ClientInfo ci) {
        Debug.lockEnter((Object)this, (String)"remove", null, (Object)this);
        ClientGroup clientGroup = this;
        synchronized (clientGroup) {
            HashSet<ClientInfo> copy = new HashSet<ClientInfo>(this.members);
            if (copy.remove(ci)) {
                if (ci.getGroupID() == this.grp) {
                    ci.setGroupID((short)-32767);
                }
                this.members = copy;
                copy = new HashSet<ClientInfo>(this.visible);
                if (copy.remove(ci)) {
                    this.visible = copy;
                }
            }
        }
        Debug.lockLeave((Object)this, (String)"remove", null, (Object)this);
    }
}

