/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.util.I18n;
import com.elluminate.util.QuotedStringTokenizer;
import java.util.StringTokenizer;

public class AuthResponse {
    public static final int OK = 200;
    public static final int ADDRESS = 201;
    public static final int SECURE = 202;
    public static final int LOGIN = 301;
    public static final int CHALLENGE = 302;
    public static final int VERSION_NOT_SUPPORTED = 303;
    public static final int FAILED = 400;
    public static final int SYNTAX_ERROR = 401;
    public static final int ALREADY_JOINED = 402;
    public static final int ACCESS_DENIED = 403;
    public static final int CONFERENCE_NOT_FOUND = 404;
    public static final int TIMEOUT = 405;
    public static final int SERVER_ERROR = 406;
    public static final int UNDECIPHERABLE_RESPONSE = 407;
    public static final int USER_LIMIT_REACHED = 408;
    public static final int PROTOCOL_UNAVAILABLE = 409;
    public static final int CONFERENCE_LOCKED = 410;
    public static final int DEVICE_NOT_ALLOWED = 411;
    public static final int VERSION_MISMATCH = 412;
    private static I18n i18n = I18n.create(AuthResponse.class);
    private int code;
    private String message;
    private String localized;

    public AuthResponse(String reply) {
        this(reply, true);
    }

    public AuthResponse(String reply, boolean localize) {
        this.code = 407;
        this.message = reply;
        this.localized = reply;
        for (int i = 0; i < 3; ++i) {
            if (Character.isDigit(reply.charAt(i))) continue;
            return;
        }
        if (reply.charAt(3) != ' ') {
            return;
        }
        String codeStr = reply.substring(0, 3);
        this.code = Integer.parseInt(codeStr);
        this.localized = this.message = reply.substring(4);
        if (this.message.startsWith("*") && localize) {
            StringTokenizer parser = new StringTokenizer(this.message.substring(1));
            try {
                String fmt = parser.nextToken();
                String raw = parser.nextToken("").trim();
                QuotedStringTokenizer p2 = new QuotedStringTokenizer(raw, "'", '\\');
                String user = "";
                String conf = "";
                String arg = "";
                if (p2.hasMoreTokens()) {
                    user = p2.nextToken();
                    if (p2.hasMoreTokens()) {
                        conf = p2.nextToken();
                        if (p2.hasMoreTokens()) {
                            arg = p2.nextToken();
                        }
                    }
                }
                this.localized = i18n.getStringLegacy("AuthResponse." + fmt, new Object[]{user, conf, arg});
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public AuthResponse(int respCode, String msg) {
        this.code = respCode;
        if (this.code < 100 || this.code > 599) {
            this.code = 406;
        }
        this.message = msg;
        this.localized = msg;
    }

    public AuthResponse(int respCode, String fmt, String name, String conf, String arg) {
        this(respCode, "*" + fmt + " " + AuthResponse.buildArgs(name, conf, arg));
        try {
            this.localized = i18n.getStringLegacy("AuthResponse." + fmt, new Object[]{name, conf, arg});
        }
        catch (Throwable t) {
            this.localized = this.message;
        }
    }

    private static String buildArgs(String a0, String a1, String a2) {
        if (a0 == null) {
            return "";
        }
        if (a1 == null) {
            return AuthResponse.escape(a0);
        }
        if (a2 == null) {
            return AuthResponse.escape(a0) + "'" + AuthResponse.escape(a1);
        }
        return AuthResponse.escape(a0) + "'" + AuthResponse.escape(a1) + "'" + AuthResponse.escape(a2);
    }

    private static String escape(String raw) {
        if (raw.indexOf(39) < 0) {
            return raw;
        }
        StringBuffer buf = new StringBuffer();
        int off = 0;
        int idx = 0;
        while ((idx = raw.indexOf(39, off)) >= 0) {
            buf.append(raw.substring(off, idx));
            buf.append("\\'");
            off = idx + 1;
        }
        buf.append(raw.substring(off));
        return buf.toString();
    }

    public int getResponseCode() {
        return this.code;
    }

    public String getResponseMessage() {
        return this.localized;
    }

    public String getRawResponseMessage() {
        return this.message;
    }

    public boolean isSuccess() {
        return this.code / 100 == 2;
    }

    public boolean isError() {
        return this.code / 100 == 4;
    }

    public String toString() {
        return this.code + " " + this.message;
    }

    public static void main(String[] args) {
        AuthResponse resp = new AuthResponse("400 *launchFailed \"BOB\"'\"BAD\"'\"BUSTED ROOM\"");
        System.out.println(resp.getResponseMessage());
        resp = new AuthResponse(400, "launchFailed", "bob", "bad'room", "everything is 'busted'");
        System.out.println(resp.getResponseMessage());
    }
}

