/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.AsyncWriteBuffer;
import com.elluminate.jinx.DebugFlags;
import com.elluminate.net.AsyncEndpoint;
import com.elluminate.net.AsyncIOAdapter;
import com.elluminate.net.AsyncIOListener;
import com.elluminate.net.AsyncIORequest;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;

public class AsyncWriteQueue
extends AsyncIOAdapter {
    private AsyncWriteBuffer head = null;
    private AsyncWriteBuffer tail = null;
    private AsyncEndpoint endpoint;
    private WriteQueueListener listener;
    private Object lock = new Object();

    public AsyncWriteQueue(AsyncEndpoint ep, WriteQueueListener lst) {
        this.endpoint = ep;
        this.listener = lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(AsyncWriteBuffer buf) {
        AsyncWriteBuffer toSend = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.head == null) {
                this.head = buf;
                toSend = buf;
                if (DebugFlags.ASYNC_WRITES.show()) {
                    LogSupport.message((Object)((Object)this), (String)"send", (String)("Sending " + buf.size() + " bytes"));
                }
            } else {
                this.tail.setNext(buf);
                if (DebugFlags.ASYNC_WRITES.show()) {
                    LogSupport.message((Object)((Object)this), (String)"send", (String)("Queued " + buf.size() + " bytes"));
                }
            }
            this.tail = buf;
            buf.setNext(null);
        }
        this.processQueue(toSend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean empty;
        Object object = this.lock;
        synchronized (object) {
            empty = this.head == null;
        }
        return empty;
    }

    public void writeComplete(AsyncIORequest req) {
        try {
            req.finishRequest();
        }
        catch (IOException iox) {
            this.listener.writeFailed(this, iox);
            return;
        }
        AsyncWriteBuffer buf = this.finish();
        this.processQueue(buf);
    }

    private void processQueue(AsyncWriteBuffer toSend) {
        try {
            while (toSend != null && toSend.flush(this.endpoint, (AsyncIOListener)this)) {
                toSend = this.finish();
            }
        }
        catch (IOException iox) {
            this.listener.writeFailed(this, iox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncWriteBuffer finish() {
        AsyncWriteBuffer next;
        AsyncWriteBuffer curr;
        Object object = this.lock;
        synchronized (object) {
            curr = this.head;
            this.head = next = this.head.getNext();
            if (this.head == null) {
                this.tail = null;
            }
        }
        if (next == null) {
            this.listener.writeIdle(this);
        }
        if (DebugFlags.ASYNC_WRITES.show()) {
            if (next == null) {
                LogSupport.message((Object)((Object)this), (String)"finish", (String)("Sent " + curr.size() + " bytes (idle)."));
            } else {
                LogSupport.message((Object)((Object)this), (String)"finish", (String)("Sent " + curr.size() + " bytes."));
            }
        }
        curr.dispose();
        return next;
    }

    public static interface WriteQueueListener {
        public void writeFailed(AsyncWriteQueue var1, IOException var2);

        public void writeIdle(AsyncWriteQueue var1);
    }
}

