/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.video.module.qtkit;

import com.elluminate.groupware.video.VideoDebug;
import com.elluminate.groupware.video.module.VideoBean;
import com.elluminate.groupware.video.module.VideoSupport;
import com.elluminate.groupware.video.module.qtkit.DeviceInfo;
import com.elluminate.platform.Platform;
import com.elluminate.util.Preferences;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.util.ArrayList;

public class QTKitVideo
implements VideoSupport {
    private static final int FRAME_TIMEOUT = 2000;
    private final Object lock = new Object();
    private DeviceInfo device = null;
    private int width = 0;
    private int height = 0;
    private int rate = 0;
    private long capturer = 0L;
    private boolean capturing = false;

    public void dispose() {
        this.disconnect();
    }

    private static native int getLibraryVersionNative();

    private static native long createCapturerNative();

    private static native void disposeCapturerNative(long var0);

    private static native void enumerateDevicesNative(ArrayList var0);

    private static native DeviceInfo findDeviceNative(String var0);

    private static native void capturerStartNative(long var0, String var2, int var3, int var4);

    private static native void capturerStopNative(long var0);

    private static native boolean blitFrameNative(long var0, int[] var2, int var3, int var4);

    private static native boolean isDeviceConnectedNative(long var0);

    private static native void setDebugNative(boolean var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (VideoDebug.NATIVE.show()) {
            LogSupport.message((Object)this, (String)"close", (String)(this.device + " " + Long.toHexString(this.capturer)));
        }
        Object object = this.lock;
        synchronized (object) {
            QTKitVideo.capturerStopNative(this.capturer);
            this.capturing = false;
            this.height = 0;
            this.width = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(String sourceDesc) {
        if (sourceDesc == null) {
            throw new NullPointerException("Video source device is null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.device != null) {
                throw new IllegalStateException("Already connected to " + this.device);
            }
            if (this.capturer != 0L) {
                throw new IllegalStateException("Capturer already created.");
            }
            this.capturer = QTKitVideo.createCapturerNative();
            DeviceInfo di = new DeviceInfo(sourceDesc);
            if (QTKitVideo.findDeviceNative(di.getDeviceUID()) == null) {
                throw new IllegalArgumentException("Unrecognized device: " + this.device);
            }
            this.device = di;
        }
        if (VideoDebug.NATIVE.show()) {
            LogSupport.message((Object)this, (String)"connect", (String)(this.device + " " + Long.toHexString(this.capturer)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            if (this.device == null) {
                return;
            }
            if (this.capturing) {
                this.close();
            }
            this.device = null;
            if (this.capturer != 0L) {
                if (VideoDebug.NATIVE.show()) {
                    LogSupport.message((Object)this, (String)"disconnect", (String)(this.device + " " + Long.toHexString(this.capturer)));
                }
                long tmp = this.capturer;
                this.capturer = 0L;
                QTKitVideo.disposeCapturerNative(tmp);
            }
        }
    }

    @Override
    public String[] enumerate() {
        ArrayList deviceList = new ArrayList();
        QTKitVideo.enumerateDevicesNative(deviceList);
        String[] result = new String[deviceList.size()];
        for (int ix = 0; ix < result.length; ++ix) {
            result[ix] = ((DeviceInfo)deviceList.get(ix)).getMultiplexed();
        }
        return result;
    }

    @Override
    public String getDisplayName(String sourceDesc) {
        DeviceInfo di;
        String result = null;
        if (sourceDesc != null && ((result = (di = new DeviceInfo(sourceDesc)).getDisplayName()) == null || result.trim().equals(""))) {
            result = "???";
        }
        return result;
    }

    @Override
    public boolean havePropsDialog() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(int frameWidth, int frameHeight, int maxFrameRate) {
        Object object = this.lock;
        synchronized (object) {
            if (this.device == null) {
                throw new IllegalStateException("No device connected");
            }
            if (this.capturer == 0L) {
                throw new IllegalStateException("Connection failed " + this.device);
            }
            if (frameWidth < 1) {
                throw new IllegalArgumentException("Invalid frame width: " + frameWidth);
            }
            if (frameHeight < 1) {
                throw new IllegalArgumentException("Invalid frame height: " + frameHeight);
            }
            if (maxFrameRate < 1) {
                throw new IllegalArgumentException("Invalid frame rate: " + maxFrameRate);
            }
            QTKitVideo.capturerStartNative(this.capturer, this.device.getDeviceUID(), frameWidth, frameHeight);
            this.capturing = true;
            this.width = frameWidth;
            this.height = frameHeight;
            this.rate = maxFrameRate;
        }
        if (VideoDebug.NATIVE.show()) {
            LogSupport.message((Object)this, (String)"open", (String)(this.device + " " + Long.toHexString(this.capturer) + " " + this.width + "x" + this.height + "@" + this.rate));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(int[] pixels) {
        Object object = this.lock;
        synchronized (object) {
            if (pixels.length < this.width * this.height) {
                throw new IllegalArgumentException("Pixel buffer is too small");
            }
            if (this.device == null) {
                throw new IllegalStateException("No video source connected");
            }
            if (this.capturer == 0L) {
                throw new IllegalStateException("Connection failed " + this.device);
            }
            if (!this.capturing) {
                throw new IllegalStateException("Video source " + this.device + " is not open");
            }
            long abortTime = System.currentTimeMillis() + 2000L;
            while (!QTKitVideo.blitFrameNative(this.capturer, pixels, this.width, this.height)) {
                if (System.currentTimeMillis() > abortTime) {
                    if (!QTKitVideo.isDeviceConnectedNative(this.capturer)) {
                        throw new RuntimeException("Device has been disconnected");
                    }
                    throw new RuntimeException("Video stream stalled");
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException intx) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    @Override
    public void loadPreferences(String prefix, Preferences preferences) {
    }

    @Override
    public void savePreferences(String prefix, Preferences preferences) {
    }

    @Override
    public void setBean(VideoBean bean) {
    }

    @Override
    public void setDebug(boolean enable) {
        QTKitVideo.setDebugNative(enable);
    }

    @Override
    public void showPropsDialog(Component videoPane) {
    }

    static {
        if (!Platform.checkOSVersion((int)202, (String)"10.5+")) {
            throw new RuntimeException("Unsupported OS X version " + Platform.getVersionString() + ", 10.5+ required.");
        }
        System.loadLibrary("QTKitVideo");
        int vers = QTKitVideo.getLibraryVersionNative();
        LogSupport.message((String)("Loaded native library QTKitVideo, version " + (vers >> 16) + "." + (vers >> 8 & 0xFF) + "." + (vers & 0xFF)));
    }
}

