/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.video.module.qtkit;

import com.elluminate.util.StringUtils;

public class DeviceInfo {
    private static final String DELIMITER = "$";
    private static final char ESCAPE = '\\';
    private String name = null;
    private String model = null;
    private String id = null;

    DeviceInfo(String name, String model, String id) {
        this.name = name;
        this.model = model;
        this.id = id;
    }

    DeviceInfo(String multiplexed) {
        int pos = StringUtils.indexOfEscaped((String)multiplexed, (String)DELIMITER, (char)'\\');
        if (pos < 0) {
            this.name = multiplexed;
            this.id = multiplexed;
            this.model = "";
        } else {
            this.name = StringUtils.unescape((String)multiplexed.substring(0, pos), (char)'\\');
            this.id = StringUtils.unescape((String)multiplexed.substring(pos + 1), (char)'\\');
            this.model = "";
        }
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getDeviceUID() {
        return this.id;
    }

    public String getMultiplexed() {
        return StringUtils.escape((String)this.name, (String)DELIMITER, (char)'\\') + DELIMITER + StringUtils.escape((String)this.id, (String)DELIMITER, (char)'\\');
    }

    public String toString() {
        return this.getDisplayName();
    }
}

