/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.video.module.linux;

import com.elluminate.groupware.video.module.VideoBean;
import com.elluminate.groupware.video.module.VideoSupport;
import com.elluminate.groupware.video.module.linux.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LinuxVideo
implements VideoSupport {
    private static final int CTL_BRIGHTNESS = 0;
    private static final int CTL_CONTRAST = 1;
    private static final int CTL_HUE = 2;
    private static final int CTL_SATURATION = 3;
    private static final int CTL_WHITENESS = 4;
    private static final String LIB_NAME = "LinuxVideo";
    private static final int MAX_CTRL_VAL = 100;
    private static final int MIN_CTRL_VAL = 0;
    private static final int NUM_CTRLS = 5;
    private final String PropsDlgTitle;
    private final I18n i18n = I18n.create((Object)this);
    private JLabel brightnessLbl = new JLabel();
    private JSlider brightnessSld = new JSlider(0, 100);
    private JLabel contrastLbl = new JLabel();
    private JSlider contrastSld = new JSlider(0, 100);
    private int[] curCtrlVals = new int[5];
    private boolean debug = false;
    private JLabel hueLbl = new JLabel();
    private JSlider hueSld = new JSlider(0, 100);
    private int[] oldCtrlVals = new int[5];
    private VideoBean videoBean = null;
    private JLabel saturationLbl = new JLabel();
    private JSlider saturationSld = new JSlider(0, 100);
    private JLabel whitenessLbl = new JLabel();
    private JSlider whitenessSld = new JSlider(0, 100);
    private Object[] videoCtrls = new Object[]{this.brightnessLbl, this.brightnessSld, this.contrastLbl, this.contrastSld, this.hueLbl, this.hueSld, this.saturationLbl, this.saturationSld, this.whitenessLbl, this.whitenessSld};

    private static native void nativeClose();

    private static native void nativeConnect(String var0);

    private static native void nativeDisconnect();

    private static native String[] nativeEnumerate();

    private static native void nativeGetControlValues(int[] var0);

    private static native String nativeGetDisplayName(String var0);

    private static native String nativeGetVersion();

    private static native void nativeOpen(int var0, int var1, int var2);

    private static native void nativeRead(int[] var0);

    private static native void nativeSetControlValues(int[] var0);

    private static native void nativeSetDebug(boolean var0);

    public LinuxVideo() {
        this.PropsDlgTitle = this.i18n.getString((PropertiesEnum)StringsProperties.LINUX_VIDEO_PROPS_DLG_TITLE);
        this.brightnessLbl.setText(this.i18n.getString((PropertiesEnum)StringsProperties.LINUX_VIDEO_BRIGHTNESS_LAB));
        this.brightnessSld.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.LINUX_VIDEO_BRIGHTNESS_TIP));
        this.brightnessSld.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int oldBrightness;
                if (LinuxVideo.this.brightnessSld.getValueIsAdjusting()) {
                    return;
                }
                int newBrightness = LinuxVideo.this.brightnessSld.getValue();
                if (newBrightness != (oldBrightness = LinuxVideo.this.curCtrlVals[0])) {
                    ((LinuxVideo)LinuxVideo.this).curCtrlVals[0] = newBrightness;
                    try {
                        LinuxVideo.nativeSetControlValues(LinuxVideo.this.curCtrlVals);
                    }
                    catch (Throwable t) {
                        if (LinuxVideo.this.debug) {
                            LogSupport.message((Object)this, (String)"stateChanged", (String)("Cannot set brightness to " + newBrightness + ": " + t));
                        }
                        ((LinuxVideo)LinuxVideo.this).curCtrlVals[0] = oldBrightness;
                        LinuxVideo.this.brightnessSld.setValue(oldBrightness);
                    }
                }
            }
        });
        this.contrastLbl.setText(this.i18n.getString((PropertiesEnum)StringsProperties.LINUX_VIDEO_CONTRAST_LAB));
        this.contrastSld.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.LINUX_VIDEO_CONTRAST_TIP));
        this.contrastSld.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int oldContrast;
                if (LinuxVideo.this.contrastSld.getValueIsAdjusting()) {
                    return;
                }
                int newContrast = LinuxVideo.this.contrastSld.getValue();
                if (newContrast != (oldContrast = LinuxVideo.this.curCtrlVals[1])) {
                    ((LinuxVideo)LinuxVideo.this).curCtrlVals[1] = newContrast;
                    try {
                        LinuxVideo.nativeSetControlValues(LinuxVideo.this.curCtrlVals);
                    }
                    catch (Throwable t) {
                        if (LinuxVideo.this.debug) {
                            LogSupport.message((Object)this, (String)"stateChanged", (String)("Cannot set contrast to " + newContrast + ": " + t));
                        }
                        ((LinuxVideo)LinuxVideo.this).curCtrlVals[1] = oldContrast;
                        LinuxVideo.this.contrastSld.setValue(oldContrast);
                    }
                }
            }
        });
        this.hueLbl.setText(this.i18n.getString((PropertiesEnum)StringsProperties.LINUX_VIDEO_HUE_LAB));
        this.hueSld.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.LINUX_VIDEO_HUE_TIP));
        this.hueSld.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int oldHue;
                if (LinuxVideo.this.hueSld.getValueIsAdjusting()) {
                    return;
                }
                int newHue = LinuxVideo.this.hueSld.getValue();
                if (newHue != (oldHue = LinuxVideo.this.curCtrlVals[2])) {
                    ((LinuxVideo)LinuxVideo.this).curCtrlVals[2] = newHue;
                    try {
                        LinuxVideo.nativeSetControlValues(LinuxVideo.this.curCtrlVals);
                    }
                    catch (Throwable t) {
                        if (LinuxVideo.this.debug) {
                            LogSupport.message((Object)this, (String)"stateChanged", (String)("Cannot set hue to " + newHue + ": " + t));
                        }
                        ((LinuxVideo)LinuxVideo.this).curCtrlVals[2] = oldHue;
                        LinuxVideo.this.hueSld.setValue(oldHue);
                    }
                }
            }
        });
        this.saturationLbl.setText(this.i18n.getString((PropertiesEnum)StringsProperties.LINUX_VIDEO_SATURATION_LAB));
        this.saturationSld.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.LINUX_VIDEO_SATURATION_TIP));
        this.saturationSld.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int oldSaturation;
                if (LinuxVideo.this.saturationSld.getValueIsAdjusting()) {
                    return;
                }
                int newSaturation = LinuxVideo.this.saturationSld.getValue();
                if (newSaturation != (oldSaturation = LinuxVideo.this.curCtrlVals[3])) {
                    ((LinuxVideo)LinuxVideo.this).curCtrlVals[3] = newSaturation;
                    try {
                        LinuxVideo.nativeSetControlValues(LinuxVideo.this.curCtrlVals);
                    }
                    catch (Throwable t) {
                        if (LinuxVideo.this.debug) {
                            LogSupport.message((Object)this, (String)"stateChanged", (String)("Cannot set saturation to " + newSaturation + ": " + t));
                        }
                        ((LinuxVideo)LinuxVideo.this).curCtrlVals[3] = oldSaturation;
                        LinuxVideo.this.saturationSld.setValue(oldSaturation);
                    }
                }
            }
        });
        this.whitenessLbl.setText(this.i18n.getString((PropertiesEnum)StringsProperties.LINUX_VIDEO_WHITENESS_LAB));
        this.whitenessSld.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.LINUX_VIDEO_WHITENESS_TIP));
        this.whitenessSld.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int oldWhiteness;
                if (LinuxVideo.this.whitenessSld.getValueIsAdjusting()) {
                    return;
                }
                int newWhiteness = LinuxVideo.this.whitenessSld.getValue();
                if (newWhiteness != (oldWhiteness = LinuxVideo.this.curCtrlVals[4])) {
                    ((LinuxVideo)LinuxVideo.this).curCtrlVals[4] = newWhiteness;
                    try {
                        LinuxVideo.nativeSetControlValues(LinuxVideo.this.curCtrlVals);
                    }
                    catch (Throwable t) {
                        if (LinuxVideo.this.debug) {
                            LogSupport.message((Object)this, (String)"stateChanged", (String)("Cannot set whiteness to " + newWhiteness + ": " + t));
                        }
                        ((LinuxVideo)LinuxVideo.this).curCtrlVals[4] = oldWhiteness;
                        LinuxVideo.this.whitenessSld.setValue(oldWhiteness);
                    }
                }
            }
        });
    }

    @Override
    public void close() {
        LinuxVideo.nativeClose();
    }

    @Override
    public void connect(String sourceDesc) {
        LinuxVideo.nativeConnect(sourceDesc);
    }

    @Override
    public void disconnect() {
        LinuxVideo.nativeDisconnect();
    }

    @Override
    public String[] enumerate() {
        return LinuxVideo.nativeEnumerate();
    }

    @Override
    public String getDisplayName(String sourceDesc) {
        return LinuxVideo.nativeGetDisplayName(sourceDesc);
    }

    @Override
    public boolean havePropsDialog() {
        try {
            LinuxVideo.nativeGetControlValues(this.curCtrlVals);
        }
        catch (Throwable t) {
            if (this.debug) {
                LogSupport.message((Object)this, (String)"havePropsDialog", (String)("nativeGetControlValues failed: " + t));
            }
            return false;
        }
        try {
            LinuxVideo.nativeSetControlValues(this.curCtrlVals);
        }
        catch (Throwable t) {
            if (this.debug) {
                LogSupport.message((Object)this, (String)"havePropsDialog", (String)("nativeSetControlValues failed: " + t));
            }
            return false;
        }
        return true;
    }

    @Override
    public void open(int frameWidth, int frameHeight, int maxFrameRate) {
        LinuxVideo.nativeOpen(frameWidth, frameHeight, maxFrameRate);
    }

    @Override
    public void read(int[] pixels) {
        LinuxVideo.nativeRead(pixels);
    }

    @Override
    public void loadPreferences(String prefix, Preferences preferences) {
    }

    @Override
    public void savePreferences(String prefix, Preferences preferences) {
    }

    @Override
    public void setBean(VideoBean bean) {
        this.videoBean = bean;
    }

    @Override
    public void setDebug(boolean enable) {
        LinuxVideo.nativeSetDebug(enable);
        this.debug = enable;
    }

    @Override
    public void showPropsDialog(Component videoPane) {
        block4: {
            try {
                LinuxVideo.nativeGetControlValues(this.curCtrlVals);
            }
            catch (Throwable t) {
                if (!this.debug) break block4;
                LogSupport.message((Object)this, (String)"showPropsDialog", (String)("nativeGetControlValues failed: " + t));
            }
        }
        System.arraycopy(this.curCtrlVals, 0, this.oldCtrlVals, 0, 5);
        for (int i = 0; i < 5; ++i) {
            JSlider slider = (JSlider)this.videoCtrls[2 * i + 1];
            if (this.curCtrlVals[i] < 0 || this.curCtrlVals[i] > 100) {
                slider.setEnabled(false);
                slider.setValue(0);
                continue;
            }
            slider.setEnabled(true);
            slider.setValue(this.curCtrlVals[i]);
        }
        this.videoBean.startPreview();
        this.videoBean.stopPreview();
    }

    static {
        System.loadLibrary(LIB_NAME);
        LogSupport.message((String)("Loaded native library LinuxVideo, version " + LinuxVideo.nativeGetVersion()));
    }
}

