/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.video.module;

import com.elluminate.groupware.video.VideoDebug;
import com.elluminate.groupware.video.module.VideoBean;
import com.elluminate.groupware.video.module.VideoSupport;
import com.elluminate.util.Preferences;
import java.awt.Component;
import java.awt.Polygon;

public class VideoSupportExt
implements VideoSupport {
    private static final String[] TestPatternNames = new String[]{"Tetragon Generator", "Tetrastar Generator", "Pentagon Generator", "Pentastar Generator", "Hexagon Generator", "Hexastar Generator"};
    private VideoSupport nativeVideoSupport;
    private int testPatternHeight = 0;
    private int testPatternIdx = -1;
    private int[] testPatternPixels = null;
    private Polygon testPatternPolygon = new Polygon();
    private int testPatternWidth = 0;

    public VideoSupportExt(VideoSupport nativeVideoSupport) {
        this.nativeVideoSupport = nativeVideoSupport;
    }

    @Override
    public void close() {
        if (this.testPatternIdx >= 0) {
            this.testPatternPixels = null;
        } else if (this.nativeVideoSupport != null) {
            this.nativeVideoSupport.close();
        }
    }

    @Override
    public void connect(String sourceDesc) {
        for (int i = 0; i < TestPatternNames.length; ++i) {
            if (!sourceDesc.equals(TestPatternNames[i])) continue;
            this.testPatternIdx = i;
            return;
        }
        this.testPatternIdx = -1;
        if (this.nativeVideoSupport == null) {
            throw new RuntimeException("Native video support not found.");
        }
        this.nativeVideoSupport.connect(sourceDesc);
    }

    @Override
    public void disconnect() {
        if (this.testPatternIdx >= 0) {
            this.testPatternIdx = -1;
            this.testPatternPixels = null;
        } else if (this.nativeVideoSupport != null) {
            this.nativeVideoSupport.disconnect();
        }
    }

    @Override
    public String[] enumerate() {
        String[] sources = this.nativeVideoSupport == null ? new String[]{} : this.nativeVideoSupport.enumerate();
        if (VideoDebug.TEST_PATTERN.isEnabled()) {
            int i;
            String[] oldSources = sources;
            sources = new String[oldSources.length + TestPatternNames.length];
            for (i = 0; i < TestPatternNames.length; ++i) {
                sources[i] = TestPatternNames[i];
            }
            for (i = 0; i < oldSources.length; ++i) {
                sources[i + VideoSupportExt.TestPatternNames.length] = oldSources[i];
            }
        }
        return sources;
    }

    @Override
    public String getDisplayName(String sourceDesc) {
        for (int i = 0; i < TestPatternNames.length; ++i) {
            if (!TestPatternNames[i].equals(sourceDesc)) continue;
            return sourceDesc;
        }
        if (this.nativeVideoSupport != null) {
            return this.nativeVideoSupport.getDisplayName(sourceDesc);
        }
        return sourceDesc;
    }

    @Override
    public boolean havePropsDialog() {
        if (this.testPatternIdx >= 0) {
            return false;
        }
        if (this.nativeVideoSupport == null) {
            throw new IllegalStateException("No video source is connected");
        }
        return this.nativeVideoSupport.havePropsDialog();
    }

    @Override
    public void open(int frameWidth, int frameHeight, int maxFrameRate) {
        if (this.testPatternIdx >= 0) {
            this.testPatternWidth = frameWidth;
            this.testPatternHeight = frameHeight;
            this.testPatternPixels = new int[frameWidth * frameHeight];
        } else {
            if (this.nativeVideoSupport == null) {
                throw new IllegalStateException("No video source is connected");
            }
            this.nativeVideoSupport.open(frameWidth, frameHeight, maxFrameRate);
        }
    }

    @Override
    public void read(int[] pixels) {
        if (this.testPatternIdx >= 0) {
            int order = this.testPatternIdx / 2 + 4;
            boolean isStar = this.testPatternIdx % 2 != 0;
            double angle = 1.5707963267948966 * Math.random();
            int radius = 10 + (int)(0.33 * (double)this.testPatternHeight * Math.random());
            int xCenter = (int)((double)this.testPatternWidth * Math.random());
            int xMax = 0;
            int xMin = this.testPatternWidth;
            int yCenter = (int)((double)this.testPatternHeight * Math.random());
            int yMax = 0;
            int yMin = this.testPatternHeight;
            this.testPatternPolygon.reset();
            for (int i = 0; i < order; ++i) {
                int x = xCenter + (int)((double)radius * Math.cos(angle));
                int y = yCenter - (int)((double)radius * Math.sin(angle));
                if (xMin > x) {
                    xMin = x;
                }
                if (xMax < x) {
                    xMax = x;
                }
                if (yMin > y) {
                    yMin = y;
                }
                if (yMax < y) {
                    yMax = y;
                }
                this.testPatternPolygon.addPoint(x, y);
                if (isStar) {
                    x = xCenter + (int)(0.5 * (double)radius * Math.cos(angle += Math.PI / (double)order));
                    y = yCenter - (int)(0.5 * (double)radius * Math.sin(angle));
                    this.testPatternPolygon.addPoint(x, y);
                    angle += Math.PI / (double)order;
                    continue;
                }
                angle += Math.PI * 2 / (double)order;
            }
            if (xMin < 0) {
                xMin = 0;
            }
            if (xMax >= this.testPatternWidth) {
                xMax = this.testPatternWidth - 1;
            }
            if (yMin < 0) {
                yMin = 0;
            }
            if (yMax >= this.testPatternHeight) {
                yMax = this.testPatternHeight - 1;
            }
            int red = (int)(256.0 * Math.random());
            int blu = (int)(256.0 * Math.random());
            int grn = (int)(256.0 * Math.random());
            int color = -16777216 + (red << 16) + (grn << 8) + blu;
            for (int y = yMin; y <= yMax; ++y) {
                for (int x = xMin; x <= xMax; ++x) {
                    if (!this.testPatternPolygon.contains(x, y)) continue;
                    this.testPatternPixels[y * this.testPatternWidth + x] = color;
                }
            }
            System.arraycopy(this.testPatternPixels, 0, pixels, 0, this.testPatternPixels.length);
        } else {
            if (this.nativeVideoSupport == null) {
                throw new IllegalStateException("No video source is open");
            }
            this.nativeVideoSupport.read(pixels);
        }
    }

    @Override
    public void loadPreferences(String prefix, Preferences preferences) {
        if (this.nativeVideoSupport != null) {
            this.nativeVideoSupport.loadPreferences(prefix, preferences);
        }
    }

    @Override
    public void savePreferences(String prefix, Preferences preferences) {
        if (this.nativeVideoSupport != null) {
            this.nativeVideoSupport.savePreferences(prefix, preferences);
        }
    }

    @Override
    public void setBean(VideoBean bean) {
        if (this.nativeVideoSupport != null) {
            this.nativeVideoSupport.setBean(bean);
        }
    }

    @Override
    public void setDebug(boolean enable) {
        if (this.nativeVideoSupport != null) {
            this.nativeVideoSupport.setDebug(enable);
        }
    }

    @Override
    public void showPropsDialog(Component videoPane) {
        if (this.testPatternIdx >= 0) {
            return;
        }
        if (this.nativeVideoSupport == null) {
            throw new IllegalStateException("No video source is connected");
        }
        this.nativeVideoSupport.showPropsDialog(videoPane);
    }
}

