/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.video.module;

import com.elluminate.contentcapture.ContentCapture;
import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAvailableListener;
import com.elluminate.framework.session.CRAnnotation;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermissionDelegate;
import com.elluminate.framework.session.CRPermissionFactory;
import com.elluminate.framework.session.CRPermissionScope;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRAnnotationChangeListener;
import com.elluminate.framework.session.listener.event.CRAnnotationChangeEvent;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.GroupwareDebug;
import com.elluminate.groupware.imps.FollowTheSpeakerAPI;
import com.elluminate.groupware.imps.FollowTheSpeakerListener;
import com.elluminate.groupware.imps.ImageAcceptAPI;
import com.elluminate.groupware.imps.ImageAcceptAccessibleListener;
import com.elluminate.groupware.imps.ImageAcceptData;
import com.elluminate.groupware.video.VideoDebug;
import com.elluminate.groupware.video.VideoFrame;
import com.elluminate.groupware.video.VideoProtocol;
import com.elluminate.groupware.video.module.ApplicationBean_Video;
import com.elluminate.groupware.video.module.ReceiveListener;
import com.elluminate.groupware.video.module.ReceiveQueue;
import com.elluminate.groupware.video.module.StringsProperties;
import com.elluminate.groupware.video.module.VideoDisplayPanel;
import com.elluminate.groupware.video.module.VideoModule;
import com.elluminate.groupware.video.module.VideoPermissionDelegate;
import com.elluminate.groupware.video.module.VideoPublisher;
import com.elluminate.groupware.video.module.VideoSupport;
import com.elluminate.groupware.video.module.VideoSupportExt;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.AccessibleTextSlider;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.swing.CList;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SerializerThread;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@Singleton
public class VideoBean
extends ApplicationBean_Video
implements ChannelDataListener,
ChannelListener,
ImageAcceptAccessibleListener,
PropertyChangeListener,
ReceiveListener {
    private static final long serialVersionUID = 1L;
    private String prefix;
    private Preferences preferences;
    private DialogParentProvider dialogParentProvider;
    private ChairProtocol chairProtocol;
    private static ContentCapture contentCapture;
    private ImageAcceptAPI snapshotAPI;
    private FollowTheSpeakerAPI followTheSpeakerAPI;
    private VideoPublisher videoPublisher;
    private boolean followModeratorFromNetwork;
    private static final int MAX_QUEUED_EVENTS = 4096;
    private static final int MAX_QUEUE_HYSTERESIS = 0;
    private static final boolean PRINT_QUEUE_STATS = false;
    private static final int EV_INVALID = 0;
    private static final int EV_CHANNEL_DOWN = 1;
    private static final int EV_CHANNEL_UP = 2;
    private static final int EV_FILMING_ALLOWED = 3;
    private static final int EV_FILMING_BANNED = 4;
    private static final int EV_FLOOR_GRANTED_ME = 5;
    private static final int EV_FLOOR_GRANTED_OTHER = 6;
    private static final int EV_FLOOR_REVOKED_ME = 7;
    private static final int EV_FLOOR_REVOKED_OTHER = 8;
    private static final int EV_PREVIEW_BUTTON_PRESSED = 9;
    private static final int EV_PREVIEW_BUTTON_RELEASED = 10;
    private static final int EV_RESUME = 11;
    private static final int EV_SUSPEND = 12;
    private static final int EV_TIMEOUT = 13;
    private static final int EV_TRANSMIT_BUTTON_PRESSED = 14;
    private static final int EV_TRANSMIT_BUTTON_RELEASED = 15;
    private static final int EV_VIDEO_BEGIN = 16;
    private static final int EV_VIDEO_END = 17;
    private static final int EV_VIDEO_FRAME = 18;
    private static final String[] decodeEvent;
    private static final int ST_INVALID = 0;
    private static final int ST_AWAITING_CAMERA = 1;
    private static final int ST_AWAITING_FLOOR = 2;
    private static final int ST_CONNECTED = 3;
    private static final int ST_DISCONNECTED = 4;
    private static final int ST_EXCHANGING = 5;
    private static final int ST_FILMING = 6;
    private static final int ST_PREVIEW_AWAITING_CAMERA = 7;
    private static final int ST_PREVIEW_AWAITING_FLOOR = 8;
    private static final int ST_PREVIEW_RELEASING_CAMERA = 9;
    private static final int ST_PREVIEW_RELEASING_FLOOR = 10;
    private static final int ST_PREVIEWING = 11;
    private static final int ST_RELEASING_CAMERA = 12;
    private static final int ST_RELEASING_FLOOR = 13;
    private static final int ST_SUSPENDED = 14;
    private static final int ST_WATCHING = 15;
    private static final String[] decodeState;
    static final boolean CLOSE_AUTOMATICALLY_DEFAULT = false;
    private static final String CLOSE_AUTOMATICALLY_PREF = ".autoHide";
    private static final int DEFAULT_WATCHDOG_PERIOD = 5000;
    private static final boolean ENABLED = true;
    private static final boolean EXCLUDE_RESERVED = true;
    private static final boolean EXCLUDE_SELF = true;
    private static final int EVENT_HIST_LEN = 100;
    private static final int FINE_FRAME_HEIGHT = 240;
    private static final int FINE_FRAME_WIDTH = 320;
    public static final int HIGHEST_FRAME_RATE = 30;
    public static final int HQ_FRAME_RATE = 15;
    private static final boolean INCLUDE_SELF = false;
    private static final long LOAD_TIME;
    private static final int MAX_FILMERS_LIMIT_ABSOLUTE = 9;
    private static final int MAX_MSG_LEN = 500;
    private static final int MAX_VIDEO_MODES = 8;
    static final int MVS_LARGE = 3;
    static final int MVS_MEDIUM = 2;
    static final int MVS_SMALL = 1;
    private static final short NULL_ADDRESS = -32767;
    private static final int NUM_QUALITY_LEVELS = 6;
    static final boolean OPEN_AUTOMATICALLY_DEFAULT = true;
    private static final String OPEN_AUTOMATICALLY_PREF = ".autoShow";
    private static final boolean PRESSED = true;
    private static final int SEND_BURST_MILLIS = 750;
    private static final int SEND_BURST_FRAME_LIM = 4;
    private static final boolean SMALL_CHANGES_SIGNIFICANT = true;
    private static final int THUMBS_PER_ROW = 5;
    private static final boolean VISIBLE = true;
    private CRSession session;
    private VideoPermissionDelegate videoPermissionDelegate;
    private final String DeviceLabel;
    private final I18n i18n;
    private volatile boolean awaitingFloorRelease;
    private volatile boolean awaitingVideoDataAck;
    private volatile int buttonUpdatesPending;
    private volatile boolean cameraIsConnected;
    private volatile boolean cameraIsOpen;
    private volatile int captureHeight;
    private volatile int captureWidth;
    private volatile int captureRes;
    private volatile int transmitWidth;
    private volatile int transmitHeight;
    private volatile boolean connected;
    private volatile boolean ignoreTransmitHotkey;
    private volatile boolean isMuted;
    private volatile boolean isMutedForPreview;
    private volatile boolean isSeeking;
    private volatile int msgNumber;
    private volatile boolean reservingMainView;
    private volatile boolean suspended;
    private volatile boolean suspending;
    private boolean advancedEnabled;
    private Object awaitingVideoDataAckLock;
    private ArrayList<ChangeListener> changeListeners;
    private boolean contentVisible;
    private byte[] crcRecvMsgBuf;
    private byte[] crcSendMsgBuf;
    private boolean deviceEnabled;
    private int displayHeight;
    private int displayWidth;
    private boolean displaySizeValid;
    private byte[] encodingOutBuf;
    private int encodingOutLen;
    private int eventDropCount;
    private int eventHistCnt;
    private int[] eventHistEvents;
    private int[] eventHistStates;
    private long[] eventHistTimes;
    private FilmerInf[] filmersInf;
    private boolean filmingAllowed;
    private boolean followModeratorSelected;
    private boolean followSpeakerSelected;
    private int[] frameIn;
    private int frameInCnt;
    private long[] frameInTime;
    private long[] frameInSize;
    private int frameOutCnt;
    private long[] frameOutTime;
    private long[] frameOutSize;
    private long[] nextBandWidthDisplayTime;
    private boolean haveTheFloor;
    private ViewInf mainView;
    private int mainViewSize;
    private boolean mayHavePropsDialog;
    private VideoModule module;
    private short myAddr;
    private VideoSupport nativeVideoSupport;
    private boolean playingRecording;
    private PropertyChangeListener preferenceChangeListener;
    private boolean previewEnabled;
    private boolean previewSelected;
    private boolean previewVisible;
    private boolean previewForPropertiesDialog;
    private boolean qualityVisible;
    private boolean qualityEnabled;
    private Thread readerThread;
    private Object receiveVideoDataLock;
    private ReceiveQueue recvQ;
    private int sendBurstByteCnt;
    private int sendBurstFrameCnt;
    private byte seqNum;
    private SerializerThread serialThread;
    private boolean snapshotEnabled;
    private ImageAcceptData snapshotData;
    private int state;
    private Object stateLock;
    private boolean transmitEnabled;
    private boolean transmitSelected;
    private int videoQuality;
    private VideoSupport videoSupport;
    private ViewInf[] viewsInf;
    private Object viewsInfLock;
    private GridBagLayout viewsLayout;
    private JPanel viewsPanel;
    private boolean wasAutoShown;
    private boolean childWindowShowing;
    private int watchdogPeriod;
    private LightweightTimer watchdogTimer;
    private short lastSpeaker;
    private boolean neverOpened;
    static final String CAMERA_DEFAULT;
    private static final String CAMERA_PREF = ".defaultCamera";
    static final boolean DISPLAY_USERNAME_DEFAULT = true;
    private static final String DISPLAY_USERNAME_PREF = ".displayUserName";
    static final boolean DISCONNECT_ON_CLOSE_DEFAULT = false;
    private static final String DISCONNECT_ON_CLOSE_PREF = ".disconnectOnClose";
    private static final int MAXFILMERS_DEFAULT = 1;
    private static final int MAXFILMERSLIMIT_DEFAULT = 6;
    static final int TRANSMITSIZE_MENUITEM_SMALL = 0;
    static final int TRANSMITSIZE_MENUITEM_MEDIUM = 1;
    static final int TRANSMITSIZE_MENUITEM_LARGE = 2;
    private static final int TRANSMITSIZE_DEFAULT = 2;
    private static final String TRANSMITSIZE_PREF = ".transmitSize";
    static final boolean DISPLAY_TRANSMITSIZE_DEFAULT = false;
    private static final String DISPLAY_TRANSMITSIZE_PREF = ".displayTransmitSize";
    static final int MAXIMUMFRAMERATE_DEFAULT = 10;
    private static final String MAXIMUMFRAMERATE_PREF = ".defaultMaxFrameRate";
    static final boolean DISPLAY_FRAMERATE_DEFAULT = false;
    private static final String DISPLAY_FRAMERATE_PREF = ".defaultDisplayFrameRate";
    static final int ENCODINGMODE_MENUITEM_CLASSIC = 0;
    static final int ENCODINGMODE_MENUITEM_HQSMALL = 1;
    static final int ENCODINGMODE_MENUITEM_HQMEDIUM = 2;
    static final int ENCODINGMODE_MENUITEM_HQLARGE = 3;
    private static final int ENCODINGMODE_DEFAULT = 1;
    private String[] cameraHandleList;
    private String[] cameraNameList;
    private String currentCameraHandle;
    private String currentCameraName;
    private boolean displayUserName;
    private boolean disconnectOnClose;
    private int maxFilmers;
    private int maxFilmersLimit;
    private String[] transmitSizeList;
    private int transmitSize;
    private boolean displayTransmitSize;
    private int maximumFrameRate;
    private boolean displayFrameRate;
    private String[] encodingModeList;
    private int encodingMode;
    private long[] recvDeltaCumEncodingLen;
    private long[] recvDeltaEncodingCnt;
    private long[] recvFullCumEncodingLen;
    private long[] recvFullEncodingCnt;
    private long[] sendDeltaCumEncodingLen;
    private long[] sendDeltaEncodingCnt;
    private long[] sendFullCumEncodingLen;
    private long[] sendFullEncodingCnt;
    private String QualityDesc0Text;
    private String QualityDesc1Text;
    private String QualityDesc2Text;
    private String QualityDesc3Text;
    private String QualityDesc4Text;
    private String QualityDesc5Text;
    private String[] QualityList;
    private String QualityDefault;
    ActionListener pageUpAction;
    ActionListener pageDownAction;

    @Inject
    public void initPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Inject
    protected void initDialogParentProvider(DialogParentProvider dialogParentProvider) {
        this.dialogParentProvider = dialogParentProvider;
    }

    @Inject
    public void initChairProtocol(ChairProtocol chairProtocol) {
        this.chairProtocol = chairProtocol;
    }

    @Inject
    public void initContentCaptureProvider(ContentCaptureProvider contentCaptureProvider) {
        contentCapture = contentCaptureProvider.get();
    }

    @Inject
    public void initVideoPublisher(VideoPublisher videoPublisher) {
        this.videoPublisher = videoPublisher;
    }

    @Inject
    protected void initImps(Imps imps) {
        final VideoBean bean = this;
        imps.addImpsAvailableListener((ImpsAvailableListener)new ImpsAvailableListener<ImageAcceptAPI>(){

            public void available(ImageAcceptAPI instance) {
                VideoBean.this.snapshotAPI = instance;
                if (VideoBean.this.snapshotAPI != null) {
                    VideoBean.this.snapshotAPI.addAccessibleListener((ImageAcceptAccessibleListener)bean);
                }
            }

            public void removed(ImageAcceptAPI instance) {
                if (VideoBean.this.snapshotAPI != null) {
                    VideoBean.this.snapshotAPI.removeAccessibleListener((ImageAcceptAccessibleListener)bean);
                }
                VideoBean.this.snapshotAPI = null;
            }
        }, ImageAcceptAPI.class);
        imps.addImpsAvailableListener((ImpsAvailableListener)new ImpsAvailableListener<FollowTheSpeakerAPI>(){

            public void available(FollowTheSpeakerAPI instance) {
                VideoBean.this.followTheSpeakerAPI = instance;
                VideoBean.this.followTheSpeakerAPI.addFollowTheSpeakerListener(VideoBean.this.createFollowTheSpeakerListener());
            }

            public void removed(FollowTheSpeakerAPI instance) {
            }
        }, FollowTheSpeakerAPI.class);
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
    }

    @Inject
    protected void initVideoPermissionDelegate(VideoPermissionDelegate videoPermissionDelegate) {
        this.videoPermissionDelegate = videoPermissionDelegate;
    }

    @Inject
    public VideoBean() {
        block15: {
            this.prefix = null;
            this.snapshotAPI = null;
            this.followTheSpeakerAPI = null;
            this.i18n = I18n.create((Object)this);
            this.awaitingFloorRelease = false;
            this.awaitingVideoDataAck = false;
            this.buttonUpdatesPending = 0;
            this.cameraIsConnected = false;
            this.cameraIsOpen = false;
            this.connected = false;
            this.ignoreTransmitHotkey = false;
            this.isMuted = false;
            this.isMutedForPreview = false;
            this.isSeeking = false;
            this.msgNumber = 1;
            this.reservingMainView = false;
            this.suspended = false;
            this.suspending = false;
            this.advancedEnabled = true;
            this.awaitingVideoDataAckLock = new Object();
            this.changeListeners = new ArrayList();
            this.contentVisible = false;
            this.crcRecvMsgBuf = new byte[500];
            this.crcSendMsgBuf = new byte[500];
            this.deviceEnabled = true;
            this.displayHeight = 120;
            this.displayWidth = 160;
            this.displaySizeValid = false;
            this.encodingOutBuf = new byte[0];
            this.encodingOutLen = 0;
            this.eventDropCount = 0;
            this.eventHistCnt = 0;
            this.eventHistEvents = new int[100];
            this.eventHistStates = new int[100];
            this.eventHistTimes = new long[100];
            this.filmersInf = new FilmerInf[9];
            this.filmingAllowed = false;
            this.followModeratorSelected = false;
            this.followSpeakerSelected = true;
            this.frameIn = new int[0];
            this.frameInCnt = 0;
            this.frameInTime = new long[30];
            this.frameInSize = new long[30];
            this.frameOutCnt = 0;
            this.frameOutTime = new long[30];
            this.frameOutSize = new long[30];
            this.nextBandWidthDisplayTime = new long[2];
            this.haveTheFloor = false;
            this.mainView = null;
            this.mainViewSize = -1;
            this.mayHavePropsDialog = true;
            this.module = null;
            this.myAddr = (short)-32767;
            this.nativeVideoSupport = null;
            this.playingRecording = false;
            this.previewEnabled = true;
            this.previewSelected = false;
            this.previewVisible = true;
            this.previewForPropertiesDialog = false;
            this.qualityVisible = true;
            this.qualityEnabled = true;
            this.readerThread = null;
            this.receiveVideoDataLock = new Object();
            this.recvQ = null;
            this.sendBurstByteCnt = 0;
            this.sendBurstFrameCnt = 0;
            this.seqNum = 0;
            this.serialThread = new SerializerThread("Video Access Thread");
            this.snapshotEnabled = true;
            this.snapshotData = null;
            this.state = 4;
            this.stateLock = new Object();
            this.transmitEnabled = true;
            this.transmitSelected = false;
            this.videoQuality = -1;
            this.videoSupport = null;
            this.viewsInf = new ViewInf[10];
            this.viewsInfLock = new Object();
            this.viewsLayout = new GridBagLayout();
            this.viewsPanel = new JPanel(this.viewsLayout);
            this.wasAutoShown = false;
            this.childWindowShowing = false;
            this.watchdogPeriod = 5000;
            this.watchdogTimer = null;
            this.lastSpeaker = (short)-32767;
            this.neverOpened = true;
            this.currentCameraHandle = null;
            this.currentCameraName = null;
            this.displayUserName = true;
            this.disconnectOnClose = false;
            this.maxFilmers = 1;
            this.maxFilmersLimit = 6;
            this.displayTransmitSize = false;
            this.maximumFrameRate = 10;
            this.displayFrameRate = false;
            this.encodingMode = 1;
            this.recvDeltaCumEncodingLen = new long[8];
            this.recvDeltaEncodingCnt = new long[8];
            this.recvFullCumEncodingLen = new long[8];
            this.recvFullEncodingCnt = new long[8];
            this.sendDeltaCumEncodingLen = new long[8];
            this.sendDeltaEncodingCnt = new long[8];
            this.sendFullCumEncodingLen = new long[8];
            this.sendFullEncodingCnt = new long[8];
            this.QualityDesc0Text = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_QUALITYDESC0);
            this.QualityDesc1Text = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_QUALITYDESC1);
            this.QualityDesc2Text = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_QUALITYDESC2);
            this.QualityDesc3Text = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_QUALITYDESC3);
            this.QualityDesc4Text = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_QUALITYDESC4);
            this.QualityDesc5Text = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_QUALITYDESC5);
            this.QualityList = new String[]{this.QualityDesc0Text, this.QualityDesc1Text, this.QualityDesc2Text, this.QualityDesc3Text, this.QualityDesc4Text, this.QualityDesc5Text};
            this.QualityDefault = this.QualityDesc0Text;
            this.pageDownAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoBean.this.rotateActiveViews('R', true);
                }
            };
            for (int i = 0; i < this.filmersInf.length; ++i) {
                this.filmersInf[i] = new FilmerInf();
            }
            this.DeviceLabel = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_DEVICE);
            this.watchdogTimer = new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    VideoBean.this.updateState(13, null);
                }
            });
            try {
                Class<?> cls = null;
                if (Platform.getPlatform() == 1) {
                    cls = Class.forName("com.elluminate.groupware.video.module.windows.WinVideo");
                } else if (Platform.getOS() == 300) {
                    cls = Class.forName("com.elluminate.groupware.video.module.linux.LinuxVideo");
                } else if (Platform.getPlatform() == 2) {
                    if (Platform.checkOSVersion((int)202, (String)"10.5+")) {
                        this.mayHavePropsDialog = false;
                        cls = Class.forName("com.elluminate.groupware.video.module.qtkit.QTKitVideo");
                    } else {
                        cls = Class.forName("com.elluminate.groupware.video.module.macos.MacVideo");
                    }
                }
                if (cls == null) break block15;
                try {
                    this.nativeVideoSupport = (VideoSupport)cls.newInstance();
                    if (VideoDebug.GENERAL.show()) {
                        LogSupport.message((Object)this, (String)"<init>", (String)("Loaded video: " + this.nativeVideoSupport.getClass().getName()));
                    }
                }
                catch (Throwable t) {
                    LogSupport.message((Object)this, (String)"<init>", (String)("Cannot instantiate class " + cls + ": " + t));
                }
            }
            catch (Throwable t) {
                if (!VideoDebug.GENERAL.show()) break block15;
                LogSupport.message((Object)this, (String)"<init>", (String)("Cannot create class: " + t));
            }
        }
        this.videoSupport = new VideoSupportExt(this.nativeVideoSupport);
        this.videoSupport.setDebug(VideoDebug.NATIVE.isEnabled());
        VideoDebug.NATIVE.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                VideoBean.this.videoSupport.setDebug(VideoDebug.NATIVE.isEnabled());
            }
        });
        VideoDebug.TEST_PATTERN.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                Boolean debugPatternIsOn = (Boolean)e.getNewValue();
                Boolean debugPatternWasOn = (Boolean)e.getOldValue();
                if (prop.equals("debugEnabled") && !debugPatternIsOn.booleanValue() && debugPatternWasOn.booleanValue()) {
                    VideoBean.this.currentCameraHandle = null;
                    VideoBean.this.currentCameraName = null;
                    VideoBean.this.selectCameraPrivate(VideoBean.this.dialogParentProvider.getDialogParent(), true);
                }
                VideoBean.this.refreshButtonState();
            }
        });
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"VideoBean", (Throwable)ex, (boolean)true);
        }
    }

    private FollowTheSpeakerListener createFollowTheSpeakerListener() {
        return new FollowTheSpeakerListener(){

            public void speakerChanged(short newSpeaker) {
                VideoBean.this.speakerChanged(newSpeaker);
            }
        };
    }

    private void speakerChanged(final short newSpeaker) {
        SwingRunnerSupport.invokeOnEventThread((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Debug.lockEnter((Object)this, (String)"speakerChanged", (String)"stateLock", (Object)VideoBean.this.stateLock);
                Object object = VideoBean.this.stateLock;
                synchronized (object) {
                    short saveLastSpeaker = VideoBean.this.lastSpeaker;
                    if (newSpeaker != -32767) {
                        VideoBean.this.addSpeaker(newSpeaker);
                        VideoBean.this.lastSpeaker = newSpeaker;
                    }
                    if (!VideoBean.this.followModeratorSelected && VideoBean.this.followSpeakerSelected && !VideoBean.this.isMutedForPreview() && newSpeaker != -32767) {
                        VideoBean.this.moveFilmerToMainView(newSpeaker, true);
                    }
                    if (saveLastSpeaker != newSpeaker && saveLastSpeaker != -32767 && newSpeaker != -32767) {
                        VideoBean.this.removeSpeaker(saveLastSpeaker);
                    }
                }
                Debug.lockLeave((Object)this, (String)"speakerChanged", (String)"stateLock", (Object)VideoBean.this.stateLock);
            }
        });
    }

    private void updateProfileData(int index) {
        short filmerAddr = this.viewsInf[index].filmerAddr;
        if (filmerAddr == 1) {
            return;
        }
        ClientInfo ci = this.clients.get(filmerAddr);
        String filmerName = ci == null ? null : ci.getDisplayName();
        this.viewsInf[index].viewPane.setNameText(filmerName);
        this.viewsInf[index].viewPane.setDisplayName(this.displayUserName);
        CRParticipant participant = this.session.getParticipantById(filmerAddr);
        Image filmerImage = participant == null ? null : (Image)participant.getAnnotationValue("ProfilePictureAnnotation");
        this.viewsInf[index].viewPane.setAvatarPicture(filmerImage);
        this.session.addAnnotationChangeListener("ProfilePictureAnnotation", new CRAnnotationChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onAnnotationValueChange(CRAnnotationChangeEvent event) {
                CRAnnotation annotation = event.getNewAnnotation();
                Object value = annotation.getValue();
                if (value instanceof Image) {
                    Image picture = (Image)value;
                    short filmerAddr = annotation.getID();
                    if (filmerAddr == 1) {
                        return;
                    }
                    Debug.lockEnter((Object)this, (String)"onAnnotationValueChange", (String)"stateLock", (Object)VideoBean.this.stateLock);
                    Object object = VideoBean.this.stateLock;
                    synchronized (object) {
                        int index = VideoBean.this.getViewIndex(filmerAddr);
                        if (index >= 0) {
                            ((VideoBean)VideoBean.this).viewsInf[index].viewPane.setAvatarPicture(picture);
                        }
                    }
                    Debug.lockLeave((Object)this, (String)"onAnnotationValueChange", (String)"stateLock", (Object)VideoBean.this.stateLock);
                }
            }
        });
    }

    private void updateTooltips(int index) {
        if (index == 0 && this.mainView.viewPane.getDisplayName() != this.displayUserName) {
            this.mainView.viewPane.setDisplayName(this.displayUserName);
        }
        String filmerName = this.viewsInf[index].viewPane.getNameText();
        if (index == 0) {
            if (this.state == 11) {
                this.viewsInf[index].viewPane.setToolTipText(null);
            } else {
                this.viewsInf[index].viewPane.setToolTipText(this.displayUserName ? null : filmerName);
            }
        } else {
            this.viewsInf[index].viewPane.setToolTipText(filmerName);
        }
    }

    private void clearTooltips(int index) {
        this.viewsInf[index].viewPane.setToolTipText(null);
    }

    @Override
    public void addNotify() {
        JRootPane rootPane;
        super.addNotify();
        if (this.videoSupport != null) {
            this.videoSupport.setBean(this);
        }
        if ((rootPane = this.viewsPanel.getRootPane()) != null) {
            rootPane.getLayeredPane().registerKeyboardAction(this.pageDownAction, KeyStroke.getKeyStroke(34, 0), 1);
        }
        if (rootPane != null) {
            rootPane.getLayeredPane().registerKeyboardAction(this.pageUpAction, KeyStroke.getKeyStroke(33, 0), 1);
        }
    }

    private void awaitFloorRelease() {
        if (!this.awaitingFloorRelease) {
            this.awaitingFloorRelease = true;
            ModalDialog.showMessageDialogAsync((int)-1, (Component)this.dialogParentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_SERVICENOTRESPONDING), (String)this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_VIDEOWARNINGTITLE), (int)2);
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.buildViewsPanel();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                VideoBean component = (VideoBean)e.getSource();
                Dimension videoSize = component.getSize();
                VideoBean.this.setVideoDisplaySize(videoSize);
            }
        });
        this.snapshotEnabled = false;
        this.previewEnabled = false;
        this.transmitEnabled = false;
        this.deviceEnabled = false;
        this.advancedEnabled = false;
    }

    private void buildViewsPanel() {
        for (int i = 0; i < this.viewsInf.length; ++i) {
            ViewInf viewInf = this.viewsInf[i] = new ViewInf();
            if (i == 0) {
                viewInf.viewPane = new VideoDisplayPanel(1280, 960);
                this.mainView = viewInf;
            } else {
                viewInf.viewPane = new VideoDisplayPanel(320, 240);
            }
            viewInf.viewPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    Component source = me.getComponent();
                    for (int i = 0; i < VideoBean.this.viewsInf.length; ++i) {
                        if (source != ((VideoBean)VideoBean.this).viewsInf[i].viewPane) continue;
                        short filmerAddr = ((VideoBean)VideoBean.this).viewsInf[i].filmerAddr;
                        if (filmerAddr == -32767) break;
                        if (i == 0) {
                            if (VideoBean.this.reservingMainView || !VideoBean.this.followModeratorSelected) break;
                            VideoBean.this.fireChannelData((byte)21, filmerAddr);
                            break;
                        }
                        if (!VideoBean.this.canMoveFilmer()) break;
                        VideoBean.this.moveFilmerToMainView(filmerAddr, true);
                        break;
                    }
                }
            });
            JPanel viewPanelCore = new JPanel(new BorderLayout());
            viewPanelCore.setOpaque(false);
            viewPanelCore.add((Component)viewInf.viewPane, "Center");
            viewInf.viewPanel = new JPanel(new BorderLayout());
            viewInf.viewPanel.setOpaque(false);
            viewInf.viewPanel.add((Component)viewPanelCore, "Center");
        }
    }

    protected boolean canMoveFilmer() {
        return !this.followSpeakerSelected && (!this.followModeratorSelected || this.chairProtocol.fetchChair(this.clients).isMe());
    }

    private boolean canAcquireVideo() {
        if (this.videoSupport == null) {
            return false;
        }
        return this.nativeVideoSupport != null || VideoDebug.TEST_PATTERN.isEnabled();
    }

    public void channelStateChanged(ChannelEvent event) {
        switch (event.getState()) {
            case 1: {
                this.updateState(2, null);
                break;
            }
            case 2: {
                this.updateState(1, null);
                break;
            }
            default: {
                String msg = "Invalid channel state: " + event.getState();
                LogSupport.exception((Object)this, (String)"channelStateChanged", (Throwable)new RuntimeException(msg), (boolean)false);
            }
        }
    }

    private void clearAllFilmers() {
        for (int i = 0; i < this.filmersInf.length; ++i) {
            short filmerAddr = this.filmersInf[i].filmerAddr;
            if (filmerAddr == -32767) continue;
            this.removeFilmer(filmerAddr, false);
        }
        this.updateFilmerDesc();
    }

    private void clearStatusIndicators() {
        for (ClientInfo ci : this.clients) {
            ci.setProperty("videoStatus", 0);
        }
    }

    public void close() {
        this.printQueStats();
        WorkerThread closerThread = new WorkerThread(new Runnable(){

            @Override
            public void run() {
                if (!VideoBean.this.suspended && !VideoBean.this.suspending) {
                    VideoBean.this.updateState(12, null);
                }
                long start = Platform.currentTimeMillis();
                while (!VideoBean.this.suspended && Platform.currentTimeMillis() - start < 2000L) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Throwable t) {}
                }
                if (VideoBean.this.cameraIsOpen) {
                    try {
                        VideoBean.this.videoSupport.close();
                    }
                    catch (Throwable t) {
                        LogSupport.exception((Object)this, (String)"close", (Throwable)t, (boolean)false);
                    }
                }
                if (VideoBean.this.cameraIsConnected) {
                    try {
                        VideoBean.this.videoSupport.disconnect();
                    }
                    catch (Throwable t) {
                        LogSupport.exception((Object)this, (String)"close", (Throwable)t, (boolean)false);
                    }
                }
            }
        }, "VideoCloser");
        closerThread.setDaemon(false);
        closerThread.start();
    }

    private int countActiveViews() {
        int viewCnt = 0;
        for (int i = 0; i < this.viewsInf.length; ++i) {
            if (this.viewsInf[i].filmerAddr == -32767) continue;
            ++viewCnt;
        }
        return viewCnt;
    }

    private int countFilmers(boolean excludeSelf) {
        int filmerCnt = 0;
        for (int i = 0; i < this.filmersInf.length; ++i) {
            if (this.filmersInf[i].filmerAddr == this.myAddr && this.myAddr != -32767) {
                if (excludeSelf) continue;
                ++filmerCnt;
                continue;
            }
            if (this.filmersInf[i].filmerAddr == -32767) continue;
            ++filmerCnt;
        }
        return filmerCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangeEvent() {
        Debug.lockEnter((Object)this, (String)"fireChangeEvent", (String)"changeListeners", this.changeListeners);
        ArrayList<ChangeListener> arrayList = this.changeListeners;
        synchronized (arrayList) {
            Iterator<ChangeListener> i = this.changeListeners.iterator();
            ChangeEvent e = new ChangeEvent(this);
            while (i.hasNext()) {
                ChangeListener cl = i.next();
                try {
                    cl.stateChanged(e);
                }
                catch (Exception ex) {
                    LogSupport.exception((Object)this, (String)"fireChangeEvent", (Throwable)ex, (boolean)true);
                }
            }
        }
        Debug.lockLeave((Object)this, (String)"fireChangeEvent", (String)"changeListeners", this.changeListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fireChannelData(byte[] data, int dataLen, int encodingMode, boolean isKeyframe) {
        int msgLen;
        int xmitBytesPerMilli = this.getClient().getMaxXmitSpeed() / 8000;
        int sendBurstByteLim = xmitBytesPerMilli * 750;
        for (int dataOff = 0; dataOff < dataLen; dataOff += msgLen) {
            int maxMsgLen;
            if (this.sendBurstByteCnt >= sendBurstByteLim || this.sendBurstFrameCnt >= 4) {
                Debug.lockEnter((Object)this, (String)"fireChannelData", (String)"awaitingVideoDataAckLock", (Object)this.awaitingVideoDataAckLock);
                Object object = this.awaitingVideoDataAckLock;
                synchronized (object) {
                    int status = 0;
                    long waitStart = Platform.currentTimeMillis();
                    while (this.awaitingVideoDataAck && this.haveTheFloor) {
                        long waited = Platform.currentTimeMillis() - waitStart;
                        int newStatus = waited <= 5000L ? 2 : (waited <= 15000L ? 3 : 1);
                        if (newStatus != status) {
                            try {
                                this.clients.getMyClient().setProperty("videoStatus", newStatus);
                                status = newStatus;
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        try {
                            this.awaitingVideoDataAckLock.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            return false;
                        }
                    }
                    if (status != 0) {
                        try {
                            this.clients.getMyClient().setProperty("videoStatus", 0);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    this.awaitingVideoDataAck = false;
                    this.sendBurstByteCnt = 0;
                    this.sendBurstFrameCnt = 0;
                }
                Debug.lockLeave((Object)this, (String)"fireChannelData", (String)"awaitingVideoDataAckLock", (Object)this.awaitingVideoDataAckLock);
            }
            msgLen = dataLen - dataOff;
            boolean usingCRC = VideoDebug.USE_CRC.isEnabled();
            int n = maxMsgLen = usingCRC ? 496 : 500;
            if (msgLen > maxMsgLen) {
                msgLen = maxMsgLen;
            }
            byte msgType = (byte)(encodingMode << 5);
            if (dataLen <= maxMsgLen) {
                msgType = (byte)(msgType | 3);
                ++this.sendBurstFrameCnt;
            } else if (dataOff == 0) {
                msgType = (byte)(msgType | 2);
            } else if (dataOff + msgLen < dataLen) {
                msgType = (byte)(msgType | 0);
            } else {
                msgType = (byte)(msgType | 1);
                ++this.sendBurstFrameCnt;
            }
            if (isKeyframe) {
                msgType = (byte)(msgType | 4);
            }
            if (this.sendBurstByteCnt == 0) {
                msgType = (byte)(msgType | 8);
                this.setAwaitingVideoDataAck(true);
            }
            try {
                ChannelDataEvent event;
                if (usingCRC) {
                    msgType = (byte)(msgType | 0x10);
                    System.arraycopy(data, dataOff, this.crcSendMsgBuf, 0, msgLen);
                    this.crcSendMsgBuf[msgLen] = msgType;
                    byte by = this.seqNum;
                    this.seqNum = (byte)(by + 1);
                    this.crcSendMsgBuf[msgLen + 1] = by;
                    int crc = VideoDebug.crc16((byte[])this.crcSendMsgBuf, (int)0, (int)(msgLen + 2));
                    this.crcSendMsgBuf[msgLen + 2] = (byte)(crc >> 8);
                    this.crcSendMsgBuf[msgLen + 3] = (byte)crc;
                    event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)msgType, (byte[])this.crcSendMsgBuf, (int)0, (int)(msgLen + 4));
                    this.sendBurstByteCnt += msgLen + 4;
                } else {
                    event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)msgType, (byte[])data, (int)dataOff, (int)msgLen);
                    this.sendBurstByteCnt += msgLen;
                }
                this.fireChannelData(0, event, true, (byte)1);
                continue;
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireChannelData", (Throwable)t, (boolean)false);
                return false;
            }
        }
        return true;
    }

    protected void fireChannelData(byte op) {
        if (this.connected) {
            ChannelDataEvent event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)op);
            this.fireChannelData(0, event, true, (byte)1);
        }
    }

    protected void fireChannelData(byte op, short who) {
        if (this.connected) {
            byte[] data = new byte[]{(byte)(who >> 8), (byte)who};
            ChannelDataEvent event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)op, (byte[])data);
            this.fireChannelData(0, event, true, (byte)1);
        }
    }

    protected void fireChannelData(byte op, byte b) {
        byte[] data = new byte[]{b};
        if (this.connected) {
            ChannelDataEvent event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)op, (byte[])data);
            this.fireChannelData(0, event, true, (byte)1);
        }
    }

    private boolean floorIsFull() {
        int filmerCnt = 0;
        for (int i = 0; i < this.filmersInf.length; ++i) {
            if (this.filmersInf[i].filmerAddr == -32767) continue;
            ++filmerCnt;
        }
        return filmerCnt >= this.maxFilmers;
    }

    private String formatEventHistory() {
        String msg = "Recent Event History:\n";
        int oldestIdx = 0;
        long prevTime = 0L;
        int retainedCnt = this.eventHistCnt;
        if (retainedCnt > 100) {
            oldestIdx = this.eventHistCnt % 100;
            retainedCnt = 100;
        }
        int histIdx = oldestIdx;
        for (int retainedIdx = 0; retainedIdx < retainedCnt; ++retainedIdx) {
            msg = msg + "  ";
            msg = retainedIdx == 0 ? msg + (this.eventHistTimes[histIdx] - LOAD_TIME) : msg + "+" + (this.eventHistTimes[histIdx] - prevTime);
            msg = msg + ": " + this.getEventName(this.eventHistEvents[histIdx]) + " in " + this.getStateName(this.eventHistStates[histIdx]) + "\n";
            prevTime = this.eventHistTimes[histIdx];
            histIdx = (histIdx + 1) % 100;
        }
        return msg;
    }

    private String getEventName(int event) {
        return event >= 0 && event < decodeEvent.length ? decodeEvent[event] : "Event #" + event;
    }

    private int getFilmerIndex(short filmerAddr) {
        for (int i = 0; i < this.filmersInf.length; ++i) {
            if (this.filmersInf[i].filmerAddr != filmerAddr) continue;
            return i;
        }
        return -1;
    }

    private int getFrameHeight(int encodingMode, int classicRes) {
        switch (encodingMode) {
            case 1: {
                return VideoFrame.getHeight((int)classicRes);
            }
            case 5: {
                return 480;
            }
            case 4: {
                return 240;
            }
            case 3: {
                return 120;
            }
            case 2: {
                return 60;
            }
        }
        throw new IllegalArgumentException("Invalid encodingMode: " + encodingMode);
    }

    private int getFrameWidth(int encodingMode, int classicRes) {
        switch (encodingMode) {
            case 1: {
                return VideoFrame.getWidth((int)classicRes);
            }
            case 5: {
                return 640;
            }
            case 4: {
                return 320;
            }
            case 3: {
                return 160;
            }
            case 2: {
                return 80;
            }
        }
        throw new IllegalArgumentException("Invalid encodingMode: " + encodingMode);
    }

    private String getStateName(int state) {
        return state >= 0 && state < decodeState.length ? decodeState[state] : "State #" + state;
    }

    public Long getVWHandle() {
        Frame d = this.dialogParentProvider.getDialogParent();
        if (d != null) {
            return (Long)GuiUtils.getWindowHandle((Component)d);
        }
        return null;
    }

    private int getViewIndex(short filmerAddr) {
        for (int i = 0; i < this.viewsInf.length; ++i) {
            if (this.viewsInf[i].filmerAddr != filmerAddr) continue;
            return i;
        }
        return -1;
    }

    public boolean isMuted() {
        return this.isMuted;
    }

    private String mainViewSizeString(int mainViewSize) {
        return mainViewSize == 1 ? "80 x 60" : (mainViewSize == 2 ? "160 x 120" : (mainViewSize == 3 ? "320 x 240" : "undefined"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layoutWindow() {
        boolean oldQualityVisible;
        int oldMainViewSize;
        int mainViewHeight;
        int mainViewWidth;
        int height;
        int width;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    VideoBean.this.layoutWindow();
                }
            });
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            width = this.displayWidth;
            height = this.displayHeight;
        }
        int paneCnt = this.countActiveViews();
        if (paneCnt < 1) {
            paneCnt = 1;
        }
        int thumbRows = (paneCnt - 1 + 5 - 1) / 5;
        int mainMinWidth = 80;
        int mainMinHeight = 60;
        int mainMaxWidth = 1280;
        int mainMaxHeight = 960;
        if (width < mainMinWidth) {
            width = mainMinWidth;
        }
        if (height < mainMinHeight + thumbRows * mainMinHeight / 5 + thumbRows) {
            height = mainMinHeight + thumbRows * mainMinHeight / 5 + thumbRows;
        }
        if (width > mainMaxWidth) {
            width = mainMaxWidth;
        }
        if (height > mainMaxHeight + thumbRows * mainMaxHeight / 5 + thumbRows) {
            height = mainMaxHeight + thumbRows * mainMaxHeight / 5 + thumbRows;
        }
        if ((mainViewWidth = width) * 3 / 4 > (mainViewHeight = (height - thumbRows) * 5 / (5 + thumbRows))) {
            mainViewWidth = mainViewHeight * 4 / 3;
            mainViewHeight = mainViewWidth * 3 / 4;
        } else {
            mainViewHeight = mainViewWidth * 3 / 4;
            mainViewWidth = mainViewHeight * 4 / 3;
        }
        int thumbnailInterstitialCount = paneCnt - 1;
        if (thumbnailInterstitialCount > 4) {
            thumbnailInterstitialCount = 4;
        }
        int thumbnailWidth = (mainViewWidth - thumbnailInterstitialCount) / 5;
        int thumbnailHeight = (mainViewHeight - thumbRows) / 5;
        int newMainViewSize = oldMainViewSize = this.mainViewSize;
        if (this.encodingMode == 3) {
            newMainViewSize = 1;
        } else if (this.encodingMode == 4) {
            newMainViewSize = 2;
        } else if (this.encodingMode == 5) {
            newMainViewSize = 3;
        } else if (this.encodingMode == 1) {
            int coarseWidth = 80;
            newMainViewSize = 3;
            if (mainViewWidth <= coarseWidth) {
                newMainViewSize = 2;
            }
        }
        this.mainViewSize = newMainViewSize;
        if (newMainViewSize != oldMainViewSize) {
            this.sendMaximumQuality();
        }
        boolean newQualityVisible = oldQualityVisible = this.qualityVisible;
        this.qualityVisible = newQualityVisible = this.encodingMode == 1;
        if (newQualityVisible != oldQualityVisible) {
            this.module.setMaximumQualityPublished(newQualityVisible);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        this.viewsPanel.removeAll();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        int firstStrutShim = mainViewWidth / 2 - thumbnailWidth / 2 * 5;
        for (int i = 0; i < 9; ++i) {
            Component strut = i == 0 ? Box.createHorizontalStrut(thumbnailWidth / 2 + firstStrutShim) : Box.createHorizontalStrut(thumbnailWidth / 2);
            this.viewsLayout.setConstraints(strut, gbc);
            this.viewsPanel.add(strut);
            ++gbc.gridx;
        }
        this.mainView.viewPane.setPanelSize(mainViewWidth, mainViewHeight, this.displaySizeValid);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 10;
        gbc.gridheight = 1;
        this.viewsPanel.add((Component)this.mainView.viewPanel, gbc);
        gbc.insets = new Insets(1, 0, 0, 1);
        int lastRow = (paneCnt - 1) / 5;
        int holesInLastRow = (lastRow + 1) * 5 - (paneCnt - 1);
        for (int i = 1; i < paneCnt; ++i) {
            ViewInf viewInf = this.viewsInf[i];
            viewInf.viewPane.setPanelSize(thumbnailWidth, thumbnailHeight, this.displaySizeValid);
            if (i % 5 == 1) {
                gbc.gridx = 0;
                gbc.gridy += gbc.gridheight;
                int row = (i - 1) / 5;
                if (row == lastRow) {
                    gbc.gridx += holesInLastRow;
                }
            } else {
                gbc.gridx += gbc.gridwidth;
            }
            gbc.gridwidth = 2;
            gbc.gridheight = 1;
            this.viewsLayout.setConstraints(viewInf.viewPanel, gbc);
            this.viewsPanel.add(viewInf.viewPanel);
        }
        this.viewsPanel.setBackground(Color.black);
        this.viewsPanel.revalidate();
        this.mainView.viewPane.repaint();
        this.removeAll();
        this.add((Component)this.viewsPanel, new GridBagConstraints());
    }

    public void videoInit() {
        try {
            if (this.videoSupport != null) {
                this.videoSupport.setBean(this);
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"videoInit", (Throwable)t, (boolean)false);
        }
    }

    public void videoDeinit() {
    }

    public void loadPreferences(String prefix, Preferences preferences) {
        this.loadPreferenceCamera(prefix, preferences);
        this.loadPreferenceDisplayUserName(prefix, preferences);
        this.loadPreferenceDisconnectOnClose(prefix, preferences);
        this.loadPreferenceTransmitSize(prefix, preferences);
        this.loadPreferenceDisplayTransmitSize(prefix, preferences);
        this.loadPreferenceMaximumFrameRate(prefix, preferences);
        this.loadPreferenceDisplayFrameRate(prefix, preferences);
        this.captureRes = this.transmitSize;
        if (this.captureRes < 1) {
            this.captureRes = 1;
        }
        this.captureWidth = VideoFrame.getWidth((int)this.captureRes);
        this.captureHeight = VideoFrame.getHeight((int)this.captureRes);
        if (preferences.getBooleanSetting(prefix + ".adjustDeltaFilter", false)) {
            VideoDebug.ADJUST_DELTA_FILTER.setEnabled(true);
        }
        if (preferences.getBooleanSetting(prefix + ".logStats", false)) {
            VideoDebug.LOG_STATS.setEnabled(true);
        }
        if (preferences.getBooleanSetting(prefix + ".testPattern", false)) {
            VideoDebug.TEST_PATTERN.setEnabled(true);
        }
        if (preferences.getBooleanSetting(prefix + ".useAverageFilter", false)) {
            VideoDebug.USE_AVERAGE_FILTER.setEnabled(true);
        }
        if (preferences.getBooleanSetting(prefix + ".useDeltaFilter", false)) {
            VideoDebug.USE_DELTA_FILTER.setEnabled(true);
        }
        if (this.videoSupport != null) {
            this.videoSupport.loadPreferences(prefix, preferences);
        }
    }

    public void applyPreferences(String prefix, Preferences preferences) {
        this.restartCamera(true);
        this.updateTooltips(0);
        int q = (this.transmitSize << 1) + 1;
        this.setVideoQuality(q);
        this.restartCamera(this.disconnectOnClose());
        this.sendMaximumFrameRate();
    }

    public void savePreferences(String prefix, Preferences preferences) {
        if (this.playingRecording) {
            return;
        }
        this.savePreferenceCamera(prefix, preferences);
        this.savePreferenceDisplayUserName(prefix, preferences);
        this.savePreferenceDisconnectOnClose(prefix, preferences);
        this.savePreferenceTransmitSize(prefix, preferences);
        this.savePreferenceDisplayTransmitSize(prefix, preferences);
        this.savePreferenceMaximumFrameRate(prefix, preferences);
        this.savePreferenceDisplayFrameRate(prefix, preferences);
        preferences.setSetting(prefix + ".adjustDeltaFilter", VideoDebug.ADJUST_DELTA_FILTER.isEnabled());
        preferences.setSetting(prefix + ".logStats", VideoDebug.LOG_STATS.isEnabled());
        preferences.setSetting(prefix + ".testPattern", VideoDebug.TEST_PATTERN.isEnabled());
        preferences.setSetting(prefix + ".useAverageFilter", VideoDebug.USE_AVERAGE_FILTER.isEnabled());
        preferences.setSetting(prefix + ".useDeltaFilter", VideoDebug.USE_DELTA_FILTER.isEnabled());
        if (this.videoSupport != null) {
            this.videoSupport.savePreferences(prefix, preferences);
        }
    }

    public void installPreferenceListeners() {
        if (this.preferences == null) {
            return;
        }
        this.preferenceChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                VideoBean.this.preferenceChange(e);
            }
        };
        this.preferences.addSettingChangeListener(this.prefix + CAMERA_PREF, this.preferenceChangeListener);
        this.preferences.addSettingChangeListener(this.prefix + DISPLAY_USERNAME_PREF, this.preferenceChangeListener);
        this.preferences.addSettingChangeListener(this.prefix + DISCONNECT_ON_CLOSE_PREF, this.preferenceChangeListener);
        this.preferences.addSettingChangeListener(this.prefix + TRANSMITSIZE_PREF, this.preferenceChangeListener);
        this.preferences.addSettingChangeListener(this.prefix + DISPLAY_TRANSMITSIZE_PREF, this.preferenceChangeListener);
        this.preferences.addSettingChangeListener(this.prefix + MAXIMUMFRAMERATE_PREF, this.preferenceChangeListener);
        this.preferences.addSettingChangeListener(this.prefix + DISPLAY_FRAMERATE_PREF, this.preferenceChangeListener);
    }

    public void removePreferenceListeners() {
        if (this.preferences == null) {
            return;
        }
        this.preferences.removeSettingChangeListener(this.prefix + CAMERA_PREF, this.preferenceChangeListener);
        this.preferences.removeSettingChangeListener(this.prefix + DISPLAY_USERNAME_PREF, this.preferenceChangeListener);
        this.preferences.removeSettingChangeListener(this.prefix + DISCONNECT_ON_CLOSE_PREF, this.preferenceChangeListener);
        this.preferences.removeSettingChangeListener(this.prefix + TRANSMITSIZE_PREF, this.preferenceChangeListener);
        this.preferences.removeSettingChangeListener(this.prefix + DISPLAY_TRANSMITSIZE_PREF, this.preferenceChangeListener);
        this.preferences.removeSettingChangeListener(this.prefix + MAXIMUMFRAMERATE_PREF, this.preferenceChangeListener);
        this.preferences.removeSettingChangeListener(this.prefix + DISPLAY_FRAMERATE_PREF, this.preferenceChangeListener);
    }

    private void preferenceChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.endsWith(CAMERA_PREF)) {
            this.loadPreferenceCamera(this.prefix, this.preferences);
            this.restartCamera(true);
        } else if (prop.endsWith(DISPLAY_USERNAME_PREF)) {
            this.loadPreferenceDisplayUserName(this.prefix, this.preferences);
            this.updateTooltips(0);
        } else if (prop.endsWith(DISCONNECT_ON_CLOSE_PREF)) {
            this.loadPreferenceDisconnectOnClose(this.prefix, this.preferences);
        } else if (prop.endsWith(TRANSMITSIZE_PREF)) {
            this.loadPreferenceTransmitSize(this.prefix, this.preferences);
            int q = (this.transmitSize << 1) + 1;
            this.setVideoQuality(q);
        } else if (prop.endsWith(DISPLAY_TRANSMITSIZE_PREF)) {
            this.loadPreferenceDisplayTransmitSize(this.prefix, this.preferences);
        } else if (prop.endsWith(MAXIMUMFRAMERATE_PREF)) {
            this.loadPreferenceMaximumFrameRate(this.prefix, this.preferences);
            this.restartCamera(this.disconnectOnClose());
            this.sendMaximumFrameRate();
        } else if (prop.endsWith(DISPLAY_FRAMERATE_PREF)) {
            this.loadPreferenceDisplayFrameRate(this.prefix, this.preferences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveFilmerToMainView(short filmerAddr, boolean tellService) {
        Debug.lockEnter((Object)this, (String)"moveFilmerToMainView", (String)"stateLock", (Object)this.stateLock);
        Object object = this.stateLock;
        synchronized (object) {
            int oldViewIdx = this.getViewIndex(filmerAddr);
            if (oldViewIdx < 1) {
                Debug.lockLeave((Object)this, (String)"moveFilmerToMainView", (String)"stateLock", (Object)this.stateLock);
                return false;
            }
            ViewInf oldViewInf = this.viewsInf[oldViewIdx];
            int newViewIdx = this.reservingMainView ? 1 : 0;
            ViewInf newViewInf = this.viewsInf[newViewIdx];
            this.swapViewInfs(oldViewInf, newViewInf, oldViewIdx, newViewIdx);
            newViewInf.clearViewPane();
            oldViewInf.clearViewPane();
            this.updateTooltips(newViewIdx);
            this.updateTooltips(oldViewIdx);
            if (tellService) {
                byte cmd = this.followModeratorSelected ? (byte)21 : 20;
                this.fireChannelData(cmd, filmerAddr);
            }
        }
        Debug.lockLeave((Object)this, (String)"moveFilmerToMainView", (String)"stateLock", (Object)this.stateLock);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAccessChange() {
        boolean oldSnapshotEnabled;
        boolean newSnapshotEnabled = oldSnapshotEnabled = this.snapshotEnabled;
        try {
            if (this.snapshotAPI != null && this.snapshotAPI.isAccessible(8) && (this.state == 11 || this.state == 15 || this.state == 6 || this.state == 5)) {
                newSnapshotEnabled = true;
            }
        }
        catch (Exception ex) {
            newSnapshotEnabled = false;
        }
        finally {
            this.snapshotEnabled = newSnapshotEnabled;
            if (oldSnapshotEnabled != newSnapshotEnabled) {
                this.module.setPublishToWhiteboardEnabled(newSnapshotEnabled);
            }
        }
    }

    private int countVisibleParticipants() {
        int visibleParticipants = 0;
        Iterator itr = this.session.getParticipantIterator();
        while (itr.hasNext()) {
            CRParticipant p = (CRParticipant)itr.next();
            if (!p.isVisible()) continue;
            ++visibleParticipants;
        }
        return visibleParticipants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAddClient(ClientEvent event) {
        if (!event.isMe()) {
            int visibleParticipants = this.countVisibleParticipants();
            switch (visibleParticipants) {
                case 3: {
                    Debug.lockEnter((Object)this, (String)"onAddClient", (String)"stateLock", (Object)this.stateLock);
                    Object object = this.stateLock;
                    synchronized (object) {
                        for (int i = 0; i < this.viewsInf.length; ++i) {
                            ViewInf viewInf = this.viewsInf[i];
                            if (viewInf.viewPane.getDisplayMode() != VideoDisplayPanel.DisplayMode.AVATAR) continue;
                            this.removeSpeaker(viewInf.filmerAddr);
                        }
                        this.lastSpeaker = (short)-32767;
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void onRemoveClient(ClientEvent event) {
    }

    public void onChannelData(ChannelDataEvent event) {
        if (this.recvQ == null) {
            LogSupport.error((Object)this, (String)"onChannelData", (String)"No receive queue");
        } else {
            this.recvQ.queueEvent(event);
        }
    }

    @Override
    public void onReceive(ChannelDataEvent event) {
        block16: {
            block15: {
                int command = event.getCommand() & 0xFF;
                byte[] contents = null;
                if (command >= 32) break block15;
                switch (command) {
                    case 23: {
                        for (int i = 0; i < this.filmersInf.length; ++i) {
                            this.filmersInf[i].awaitingFrameSync = false;
                        }
                        break block16;
                    }
                    case 3: 
                    case 4: {
                        contents = event.getContents();
                        short who = (short)(256 * contents[0] + (contents[1] & 0xFF));
                        if (who == this.myAddr) {
                            if (command == 3) {
                                this.updateState(5, contents);
                                break;
                            }
                            this.updateState(7, contents);
                            break;
                        }
                        if (command == 3) {
                            this.updateState(6, contents);
                            break;
                        }
                        this.updateState(8, contents);
                        break;
                    }
                    case 20: {
                        contents = event.getContents();
                        short who = (short)(256 * contents[0] + (contents[1] & 0xFF));
                        this.moveFilmerToMainView(who, false);
                        break;
                    }
                    case 11: {
                        this.sendMaximumFrameRate();
                        this.sendMaximumQuality();
                        if (this.suspended) {
                            this.stateMessage("Firing VideoProtocol.SUSPEND");
                            this.fireChannelData((byte)13);
                            break;
                        }
                        break block16;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        if (VideoDebug.IGNORE_STATUS_MSGS.isEnabled()) break;
                        int status = command == 17 ? 0 : (command == 14 ? 0 : (command == 15 ? 2 : 3));
                        contents = event.getContents();
                        short who = (short)(256 * contents[0] + (contents[1] & 0xFF));
                        ClientInfo ci = this.clients.get(who);
                        if (ci != null) {
                            ci.setProperty("videoStatus", status);
                            break;
                        }
                        break block16;
                    }
                    case 22: {
                        contents = event.getContents();
                        this.followModeratorFromNetwork = contents[0] == 1;
                        this.module.setVideoFollowsModeratorFocus(this.followModeratorFromNetwork);
                        break;
                    }
                    case 18: {
                        this.setAwaitingVideoDataAck(false);
                        break;
                    }
                    default: {
                        String diagnostic = "command = " + VideoProtocol.commandName((byte)((byte)command));
                        LogSupport.exception((Object)this, (String)"onReceive", (Throwable)new IllegalArgumentException(diagnostic), (boolean)false);
                    }
                }
                break block16;
            }
            this.receiveVideoData(event);
        }
    }

    public boolean setMaximumCamerasCmd(int maxCamerasParameter) {
        boolean isModerator;
        if (maxCamerasParameter < 1 || maxCamerasParameter > 6) {
            return false;
        }
        Chair chair = this.chairProtocol.fetchChair(this.clients);
        boolean bl = isModerator = chair != null && chair.isMe();
        if (!isModerator) {
            return false;
        }
        if (maxCamerasParameter != this.maxFilmers) {
            this.clients.setProperty("videoMaxTalkers", new Integer(maxCamerasParameter).intValue());
        }
        return true;
    }

    private void printQueStats() {
        if (this.recvQ != null) {
            // empty if block
        }
        this.eventHistCnt = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent event) {
        short addr = this.clients.getPropertyOwner(event.getSource());
        String pName = event.getPropertyName();
        if (GroupwareDebug.EVENTS.show()) {
            LogSupport.message((Object)this, (String)"propertyChange", (String)(event.toString() + ": " + pName + "(" + event.getOldValue() + "->" + event.getNewValue() + ")"));
        }
        if (pName.equals("chair")) {
            this.module.setVideoFollowsModeratorFocusEnabled(this.chairProtocol.fetchChair(this.clients).isMe());
        } else if (pName.equals("videoStateMachine")) {
            VideoDebug.STATE.setEnabled(this.clients.getProperty("videoStateMachine", false));
        } else if (pName.equals("videoFloor")) {
            if (addr == this.clients.getMyAddress()) {
                ClientInfo me = this.clients.getMyClient();
                if (me.getProperty("videoFloor", false)) {
                    this.updateState(3, null);
                } else {
                    this.updateState(4, null);
                }
            }
        } else if (pName.equals("videoMaxTalkers")) {
            this.maxFilmers = this.clients.getProperty("videoMaxTalkers", 1);
            this.layoutWindow();
            this.refreshButtonState();
        } else if (pName.equals("videoMaxFilmersLimit")) {
            this.maxFilmersLimit = this.clients.getProperty("videoMaxFilmersLimit", 6);
            if (this.maxFilmers > this.maxFilmersLimit) {
                this.maxFilmers = this.maxFilmersLimit;
            }
            this.layoutWindow();
            this.refreshButtonState();
        } else if (pName.equals("encodingMode")) {
            int newMode = this.clients.getProperty("encodingMode", 1);
            Object object = this.stateLock;
            synchronized (object) {
                Object object2 = this.receiveVideoDataLock;
                synchronized (object2) {
                    if (this.cameraIsOpen) {
                        this.releaseCamera();
                        long maxWaitTime = Platform.currentTimeMillis() + 5000L;
                        while (this.cameraIsOpen && Platform.currentTimeMillis() < maxWaitTime) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        }
                    }
                    this.encodingMode = newMode;
                    this.captureWidth = this.getFrameWidth(this.encodingMode, this.captureRes);
                    this.captureHeight = this.getFrameHeight(this.encodingMode, this.captureRes);
                    this.maxFilmers = this.encodingMode != 1 ? 1 : this.clients.getProperty("videoMaxTalkers", 1);
                }
            }
            this.layoutWindow();
            this.refreshButtonState();
        } else if (pName.equals("videoWatchdogDelay")) {
            this.watchdogPeriod = this.clients.getProperty("videoWatchdogDelay", 5000);
        }
    }

    private void quenchWatchdog() {
        if (this.watchdogTimer.cancel()) {
            this.stateMessage("Watchdog timer quenched");
        } else {
            this.stateMessage("Unable to quench watchdog timer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveVideoData(ChannelDataEvent event) {
        int command = event.getCommand() & 0xFF;
        if ((command & 8) != 0) {
            this.stateMessage("Firing VideoProtocol.VIDEO_DATA_ACK");
            this.fireChannelData((byte)18);
        }
        Debug.lockEnter((Object)this, (String)"receiveVideoData", (String)"receiveVideoDataLock", (Object)this.receiveVideoDataLock);
        Object object = this.receiveVideoDataLock;
        synchronized (object) {
            boolean usingCRC;
            short filmerAddr = event.getSourceAddress();
            if (filmerAddr == -32767) {
                RuntimeException re = new RuntimeException("Received video data message with null sender address");
                LogSupport.exception((Object)this, (String)"receiveVideoData", (Throwable)re, (boolean)false);
                Debug.lockLeave((Object)this, (String)"receiveVideoData", (String)"receiveVideoDataLock", (Object)this.receiveVideoDataLock);
                return;
            }
            FilmerInf filmerInf = null;
            for (int i = 0; i < this.filmersInf.length; ++i) {
                if (this.filmersInf[i].filmerAddr != filmerAddr) continue;
                filmerInf = this.filmersInf[i];
                break;
            }
            if (filmerInf == null) {
                Debug.lockLeave((Object)this, (String)"receiveVideoData", (String)"receiveVideoDataLock", (Object)this.receiveVideoDataLock);
                return;
            }
            boolean bl = usingCRC = (command & 0x10) != 0;
            if (usingCRC != filmerInf.usingCRC) {
                filmerInf.usingCRC = usingCRC;
                ClientInfo ci = this.clients.get(filmerAddr);
                String filmerName = ci == null ? "Unknown" : ci.getDisplayName();
                LogSupport.message((String)("Integrity checking " + (usingCRC ? "enabled" : "disabled") + " for " + filmerName));
            }
            int contentsLen = event.size();
            if (usingCRC) {
                if (contentsLen < 4) {
                    LogSupport.message((Object)this, (String)"receiveVideoData", (String)"Message integrity check info incomplete");
                } else {
                    event.getBuffer().writeTo(this.crcRecvMsgBuf, 0, contentsLen);
                    int crc1 = (this.crcRecvMsgBuf[contentsLen -= 2] & 0xFF) << 8 | this.crcRecvMsgBuf[contentsLen + 1] & 0xFF;
                    int crc2 = VideoDebug.crc16((byte[])this.crcRecvMsgBuf, (int)0, (int)contentsLen);
                    byte seqNum1 = this.crcRecvMsgBuf[--contentsLen];
                    byte seqNum2 = filmerInf.seqNum;
                    byte cmd1 = this.crcRecvMsgBuf[--contentsLen];
                    byte cmd2 = event.getCommand();
                    if (crc1 != crc2) {
                        LogSupport.message((Object)this, (String)"receiveVideoData", (String)("Message integrity check failed: CRC bad, cmd  = " + (cmd1 & 0xFF) + " (expected " + (cmd2 & 0xFF) + "), seqNum = " + (seqNum1 & 0xFF) + " (expected " + (seqNum2 & 0xFF) + ")"));
                        filmerInf.encodingStarted = true;
                        filmerInf.encodingInLen = 0;
                    }
                }
            }
            if (VideoProtocol.LOGGING_RECEIVE_TRACE.isEnabled()) {
                LogSupport.log((Object)this, (String)"receiveVideoData()", (String)("From: " + filmerAddr + " - Size: " + contentsLen));
            }
            filmerInf.seqNum = (byte)(filmerInf.seqNum + 1);
            int senderMode = command >> 5;
            if (senderMode != filmerInf.encodingMode) {
                return;
            }
            if (filmerInf.encodingMode != 1 && (command & 2) != 0 && (command & 4) != 0) {
                filmerInf.awaitingFrameSync = false;
            }
            if (filmerInf.awaitingFrameSync || this.isSeeking || this.recvQ.getQueueLength() > 4096) {
                if (this.recvQ.getQueueLength() > 4096 || this.isSeeking) {
                    filmerInf.awaitingFrameSync = true;
                }
                ++this.eventDropCount;
                return;
            }
            int minBufLen = filmerInf.encodingInLen + contentsLen;
            if (filmerInf.encodingInBuf.length < minBufLen) {
                byte[] biggerBuf = new byte[minBufLen];
                System.arraycopy(filmerInf.encodingInBuf, 0, biggerBuf, 0, filmerInf.encodingInBuf.length);
                filmerInf.encodingInBuf = biggerBuf;
            }
            switch (command & 3) {
                case 2: {
                    filmerInf.encodingInLen = 0;
                    filmerInf.encodingStarted = true;
                }
                case 0: {
                    if (!filmerInf.encodingStarted) break;
                    event.getBuffer().writeTo(filmerInf.encodingInBuf, filmerInf.encodingInLen, contentsLen);
                    filmerInf.encodingInLen += contentsLen;
                    break;
                }
                case 3: {
                    filmerInf.encodingStarted = true;
                    filmerInf.encodingInLen = 0;
                }
                case 1: {
                    if (!filmerInf.encodingStarted) break;
                    filmerInf.encodingStarted = false;
                    event.getBuffer().writeTo(filmerInf.encodingInBuf, filmerInf.encodingInLen, contentsLen);
                    filmerInf.encodingInLen += contentsLen;
                    int viewIdx = this.getViewIndex(filmerAddr);
                    if (viewIdx < 0) break;
                    ViewInf viewInf = this.viewsInf[viewIdx];
                    try {
                        int newQuality;
                        int oldQuality = filmerInf.videoFrame.getTrueQuality();
                        filmerInf.videoFrame.putEncoding(filmerInf.encodingInBuf, filmerInf.encodingInLen);
                        if (VideoDebug.QUALITY.show() && (newQuality = filmerInf.videoFrame.getTrueQuality()) != oldQuality) {
                            ClientInfo ci = this.clients.get(filmerAddr);
                            String filmerName = ci == null ? "Unknown" : ci.getDisplayName();
                            LogSupport.message((String)("Received quality changed to " + VideoFrame.getQualityName((int)newQuality) + " for " + filmerName));
                        }
                    }
                    catch (Throwable t) {
                        LogSupport.exception((Object)this, (String)"receiveVideoData", (Throwable)t, (boolean)true);
                    }
                    int frameHeight = this.getFrameHeight(filmerInf.encodingMode, this.captureRes);
                    int frameWidth = this.getFrameWidth(filmerInf.encodingMode, this.captureRes);
                    if (viewInf == this.mainView) {
                        long now = Platform.currentTimeMillis();
                        long readDelay = filmerInf.earliestShowTime - now;
                        if (readDelay > 0L) {
                            try {
                                Thread.sleep(readDelay);
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        int minDisplayMillis = 33;
                        filmerInf.earliestShowTime = Platform.currentTimeMillis() + (long)minDisplayMillis;
                        ++this.frameInCnt;
                        int index = this.frameInCnt % this.frameInTime.length;
                        this.frameInTime[index] = Platform.currentTimeMillis();
                        this.frameInSize[index] = filmerInf.encodingInLen;
                        if (!this.isMutedForPreview()) {
                            if (filmerInf.encodingMode == 1) {
                                int maxPixelCnt = 76800;
                                if (this.frameIn.length < maxPixelCnt) {
                                    this.frameIn = new int[maxPixelCnt];
                                }
                                int frameRes = filmerInf.videoFrame.getPixels(this.frameIn);
                                frameWidth = VideoFrame.getWidth((int)frameRes);
                                frameHeight = VideoFrame.getHeight((int)frameRes);
                            }
                            viewInf.viewPane.newFrame(frameWidth, frameHeight, this.frameIn);
                            this.showStats(viewInf, this.frameInCnt, this.frameInTime, this.frameInSize, 0);
                        }
                    } else {
                        if (filmerInf.encodingMode == 1) {
                            int maxPixelCnt = 76800;
                            if (this.frameIn.length < maxPixelCnt) {
                                this.frameIn = new int[maxPixelCnt];
                            }
                            int frameRes = filmerInf.videoFrame.getPixels(this.frameIn);
                            frameWidth = VideoFrame.getWidth((int)frameRes);
                            frameHeight = VideoFrame.getHeight((int)frameRes);
                        }
                        viewInf.viewPane.newFrame(frameWidth, frameHeight, this.frameIn);
                    }
                    filmerInf.awaitingFrameSync = this.isMuted || this.recvQ != null && this.recvQ.getQueueLength() > 4096 || this.isSeeking;
                    break;
                }
                default: {
                    String diagnostic = "command = " + VideoProtocol.commandName((byte)((byte)command));
                    LogSupport.exception((Object)this, (String)"assembleFrameEncoding", (Throwable)new IllegalArgumentException(diagnostic), (boolean)false);
                }
            }
        }
        Debug.lockLeave((Object)this, (String)"receiveVideoData", (String)"receiveVideoDataLock", (Object)this.receiveVideoDataLock);
    }

    private void showStats(ViewInf viewInf, int frameCount, long[] frameTime, long[] frameSize, int direction) {
        if (frameCount >= 3) {
            boolean showFrameSize = VideoBean.getPreferredShowTransmitSize(this.prefix, this.preferences) && this.mainView.filmerAddr == this.myAddr && this.myAddr != -32767;
            boolean showFrameRate = VideoBean.getPreferredShowFrameRate(this.prefix, this.preferences);
            if (showFrameSize || showFrameRate) {
                String statString = "";
                if (showFrameSize) {
                    statString = statString + this.transmitWidth + " x " + this.transmitHeight;
                }
                if (showFrameRate) {
                    if (showFrameSize) {
                        statString = statString + ", ";
                    }
                    int sampSize = frameTime.length;
                    int newest = frameCount % sampSize;
                    int oldest = 1;
                    if (frameCount >= sampSize) {
                        oldest = (frameCount + 1) % sampSize;
                    } else {
                        sampSize = frameCount;
                    }
                    float fps = 1000.0f * (float)(sampSize - 1) / (float)(frameTime[newest] - frameTime[oldest]);
                    statString = statString + (double)((int)((double)(10.0f * fps) + 0.5)) / 10.0 + " fps";
                }
                viewInf.viewPane.setFrameText(statString);
            } else {
                viewInf.viewPane.setFrameText(null);
            }
            long now = Platform.currentTimeMillis();
            boolean showDataRate = false;
            if (showDataRate) {
                int i;
                int sampSize = frameTime.length;
                int newest = frameCount % sampSize;
                int oldest = 1;
                if (frameCount >= sampSize) {
                    oldest = (frameCount + 1) % sampSize;
                } else {
                    sampSize = frameCount;
                }
                long bytes = 0L;
                if (oldest < newest) {
                    for (i = oldest; i < newest; ++i) {
                        bytes += frameSize[i];
                    }
                } else {
                    for (i = oldest; i < frameSize.length; ++i) {
                        bytes += frameSize[i];
                    }
                    for (i = 1; i < oldest; ++i) {
                        bytes += frameSize[i];
                    }
                }
                float bps = bytes / (frameTime[newest] - frameTime[oldest]);
                String statString = "bandwidth " + (direction == 0 ? "in" : "out") + ": " + (double)((int)((double)(10.0f * bps) + 0.5)) / 10.0 + " bps";
                LogSupport.message((Object)this, (String)"showStats", (String)statString);
                this.nextBandWidthDisplayTime[direction] = now + 5000L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshButtonState() {
        Debug.lockEnter((Object)this, (String)"refreshButtonState", (String)"stateLock", (Object)this.stateLock);
        Object object = this.stateLock;
        synchronized (object) {
            this.setState(this.state);
        }
        Debug.lockLeave((Object)this, (String)"refreshButtonState", (String)"stateLock", (Object)this.stateLock);
    }

    private void releaseCamera() {
        this.stateMessage("releasing camera");
        if (this.readerThread != null && this.readerThread.isAlive()) {
            this.setAwaitingVideoDataAck(false);
            this.readerThread.interrupt();
        } else {
            this.updateState(17, null);
        }
    }

    private void releaseFloor() {
        if (VideoDebug.SUPPRESS_FLOOR_RELEASE.isEnabled()) {
            this.startWatchdog(this.watchdogPeriod);
            this.stateMessage("Suppressing VideoProtocol.FLOOR_RELEASE");
        } else if (VideoDebug.STALL_FLOOR_RELEASE.isEnabled()) {
            this.startWatchdog(this.watchdogPeriod);
            new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    VideoBean.this.stateMessage("Firing VideoProtocol.FLOOR_RELEASE");
                    VideoBean.this.fireChannelData((byte)2);
                }
            }).scheduleIn((long)(3 * this.watchdogPeriod));
        } else if (VideoDebug.DELAY_FLOOR_RELEASE.isEnabled()) {
            this.startWatchdog(2 * this.watchdogPeriod);
            new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    VideoBean.this.stateMessage("Firing VideoProtocol.FLOOR_RELEASE");
                    VideoBean.this.fireChannelData((byte)2);
                }
            }).scheduleIn((long)this.watchdogPeriod);
        } else {
            this.startWatchdog(this.watchdogPeriod);
            this.stateMessage("Firing VideoProtocol.FLOOR_RELEASE");
            this.fireChannelData((byte)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener lst) {
        Debug.lockEnter((Object)this, (String)"removeChangeListener", (String)"changeListeners", this.changeListeners);
        ArrayList<ChangeListener> arrayList = this.changeListeners;
        synchronized (arrayList) {
            this.changeListeners.remove(lst);
        }
        Debug.lockLeave((Object)this, (String)"removeChangeListener", (String)"changeListeners", this.changeListeners);
    }

    private void addFilmer(short filmerAddr, int filmerIdx) {
        boolean layoutChanged;
        ClientInfo ci;
        if (filmerAddr == -32767) {
            throw new IllegalArgumentException("filmerAddr = NULL_ADDRESS");
        }
        if (filmerIdx < 0 || filmerIdx >= this.filmersInf.length) {
            throw new IllegalArgumentException("filmerIdx = " + filmerIdx);
        }
        int oldFilmerIdx = this.getFilmerIndex(filmerAddr);
        if (oldFilmerIdx >= 0) {
            ci = this.clients.get(filmerAddr);
            LogSupport.message((Object)this, (String)"addFilmer", (String)("Duplicate filmerAddr: " + (ci == null ? "Unknown" : ci.getDisplayName())));
            this.removeFilmer(filmerAddr, false);
        }
        if (this.filmersInf[filmerIdx].filmerAddr != -32767) {
            ci = this.clients.get(filmerAddr);
            LogSupport.message((Object)this, (String)"addFilmer", (String)("Duplicate filmerIdx: " + (ci == null ? "Unknown" : ci.getDisplayName())));
            this.removeFilmer(this.filmersInf[filmerIdx].filmerAddr, false);
        }
        this.filmersInf[filmerIdx].filmerAddr = filmerAddr;
        this.filmersInf[filmerIdx].seqNum = 0;
        int viewIdx = this.getViewIndex(filmerAddr);
        if (viewIdx < 0) {
            viewIdx = this.getViewIndex((short)-32767);
            if (viewIdx < 0) {
                ClientInfo ci2 = this.clients.get(filmerAddr);
                throw new RuntimeException("Cannot assign a view to the filmer: " + (ci2 == null ? "Unknown" : ci2.getDisplayName()));
            }
            this.viewsInf[viewIdx].filmerAddr = filmerAddr;
            this.viewsInf[viewIdx].viewPane.setFrameText(null);
            this.updateProfileData(viewIdx);
            this.viewsInf[viewIdx].viewPane.setDisplayIndex(viewIdx);
        }
        this.viewsInf[viewIdx].viewPane.setDisplayMode(VideoDisplayPanel.DisplayMode.FILMING);
        this.updateTooltips(viewIdx);
        if (viewIdx == 0) {
            this.reservingMainView = false;
            byte cmd = this.followModeratorSelected ? (byte)21 : 20;
            this.fireChannelData(cmd, this.mainView.filmerAddr);
        }
        boolean bl = layoutChanged = viewIdx > 0;
        if (layoutChanged) {
            this.layoutWindow();
        }
        this.updateFilmerDesc();
        if (this.neverOpened) {
            this.neverOpened = (this.reservingMainView ? 1 + this.countActiveViews() : this.countActiveViews()) == 0;
            this.module.setActiveViewCount(this.reservingMainView ? 1 + this.countActiveViews() : this.countActiveViews());
        }
    }

    private void addSpeaker(short speakerAddr) {
        if (speakerAddr == -32767) {
            throw new IllegalArgumentException("speakerAddr = NULL_ADDRESS");
        }
        int viewIdx = this.getViewIndex(speakerAddr);
        if (this.reservingMainView && viewIdx == 0) {
            viewIdx = -1;
            for (int i = 1; i < this.viewsInf.length; ++i) {
                if (this.viewsInf[i].filmerAddr != speakerAddr) continue;
                viewIdx = i;
            }
        }
        if (viewIdx < 0) {
            boolean layoutChanged;
            viewIdx = this.getViewIndex((short)-32767);
            if (viewIdx < 0) {
                ClientInfo ci = this.clients.get(speakerAddr);
                throw new RuntimeException("Cannot assign a view to the filmer: " + (ci == null ? "Unknown" : ci.getDisplayName()));
            }
            this.viewsInf[viewIdx].filmerAddr = speakerAddr;
            this.viewsInf[viewIdx].viewPane.setFrameText(null);
            this.updateProfileData(viewIdx);
            this.viewsInf[viewIdx].viewPane.setDisplayIndex(viewIdx);
            this.viewsInf[viewIdx].viewPane.setDisplayMode(VideoDisplayPanel.DisplayMode.AVATAR);
            this.updateTooltips(viewIdx);
            if (viewIdx == 0) {
                this.reservingMainView = false;
                byte cmd = this.followModeratorSelected ? (byte)21 : 20;
                this.fireChannelData(cmd, this.mainView.filmerAddr);
            }
            boolean bl = layoutChanged = viewIdx > 0;
            if (layoutChanged) {
                this.layoutWindow();
            }
            this.updateFilmerDesc();
        }
    }

    private void removeFilmer(short filmerAddr, boolean restoreProfilePicture) {
        if (filmerAddr == -32767) {
            throw new IllegalArgumentException("filmerAddr = NULL_ADDRESS");
        }
        int filmerIdx = this.getFilmerIndex(filmerAddr);
        if (filmerIdx < 0) {
            ClientInfo ci = this.clients.get(filmerAddr);
            LogSupport.message((Object)this, (String)"removeFilmer", (String)("Filmer not found in filmersInf: " + (ci == null ? "Unknown" : ci.getDisplayName())));
        } else {
            this.filmersInf[filmerIdx].reset();
        }
        boolean layoutChanged = false;
        int viewIdx = this.getViewIndex(filmerAddr);
        if (viewIdx < 0) {
            ClientInfo ci = this.clients.get(filmerAddr);
            LogSupport.message((Object)this, (String)"removeFilmer", (String)("Filmer not found in viewsInf: " + (ci == null ? "Unknown" : ci.getDisplayName())));
        } else if (restoreProfilePicture && filmerAddr == this.lastSpeaker || this.countActiveViews() == 1) {
            this.lastSpeaker = filmerAddr;
            this.viewsInf[viewIdx].viewPane.setDisplayMode(VideoDisplayPanel.DisplayMode.AVATAR);
        } else {
            layoutChanged = this.countActiveViews() > 1;
            for (int i = viewIdx; i < this.viewsInf.length; ++i) {
                ViewInf viewInf = this.viewsInf[i];
                if (i + 1 < this.viewsInf.length) {
                    this.copyViewInf(viewInf, this.viewsInf[i + 1], i);
                    this.updateTooltips(i);
                } else {
                    this.clearViewInf(viewInf);
                    this.clearTooltips(i);
                }
                viewInf.clearViewPane();
            }
            if (viewIdx == 0 && this.mainView.filmerAddr != -32767) {
                byte cmd = this.followModeratorSelected ? (byte)21 : 20;
                this.fireChannelData(cmd, this.mainView.filmerAddr);
            }
        }
        if (layoutChanged) {
            this.layoutWindow();
        }
        this.updateFilmerDesc();
        if (this.neverOpened) {
            this.neverOpened = (this.reservingMainView ? 1 + this.countActiveViews() : this.countActiveViews()) == 0;
            this.module.setActiveViewCount(this.reservingMainView ? 1 + this.countActiveViews() : this.countActiveViews());
        }
    }

    private void removeSpeaker(short speakerAddr) {
        if (speakerAddr == -32767) {
            throw new IllegalArgumentException("filmerAddr = NULL_ADDRESS");
        }
        int viewIdx = this.getViewIndex(speakerAddr);
        if (this.reservingMainView) {
            for (int i = 1; i < this.viewsInf.length; ++i) {
                if (this.viewsInf[i].filmerAddr != speakerAddr) continue;
                viewIdx = i;
            }
        }
        if (viewIdx >= 0) {
            boolean isPreviewer;
            boolean isFilmer = this.getFilmerIndex(speakerAddr) >= 0;
            boolean bl = isPreviewer = viewIdx == 0 && this.reservingMainView;
            if (!isFilmer && !isPreviewer) {
                boolean layoutChanged = this.countActiveViews() > 1;
                for (int i = viewIdx; i < this.viewsInf.length; ++i) {
                    ViewInf viewInf = this.viewsInf[i];
                    if (i + 1 < this.viewsInf.length) {
                        this.copyViewInf(viewInf, this.viewsInf[i + 1], i);
                        this.updateTooltips(i);
                    } else {
                        this.clearViewInf(viewInf);
                        this.clearTooltips(i);
                    }
                    viewInf.clearViewPane();
                }
                if (viewIdx == 0 && this.mainView.filmerAddr != -32767) {
                    byte cmd = this.followModeratorSelected ? (byte)21 : 20;
                    this.fireChannelData(cmd, this.mainView.filmerAddr);
                }
                if (layoutChanged) {
                    this.layoutWindow();
                }
                this.updateFilmerDesc();
            }
        }
    }

    private void requestCamera() {
        this.stateMessage("requesting camera");
        if (!this.cameraIsConnected && this.selectCameraPrivate(this.dialogParentProvider.getDialogParent(), true)) {
            try {
                this.videoSupport.connect(this.currentCameraHandle);
                this.cameraIsConnected = true;
            }
            catch (Throwable t) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        VideoBean.this.ignoreTransmitHotkey = true;
                        ModalDialog.showMessageDialog((Component)VideoBean.this.dialogParentProvider.getDialogParent(), (Object)VideoBean.this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_CANNOTCONNECTMSG, new Object[]{VideoBean.this.currentCameraName, t.toString()}), (String)VideoBean.this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_VIDEOERRORTITLE), (int)0);
                        VideoBean.this.ignoreTransmitHotkey = false;
                    }
                });
            }
        }
        if (this.cameraIsConnected && !this.cameraIsOpen) {
            try {
                this.maximumFrameRate = this.getPreferredMaximumFrameRate(this.prefix, this.preferences);
                this.videoSupport.open(this.captureWidth, this.captureHeight, this.encodingMode == 1 ? this.maximumFrameRate : 15);
                this.cameraIsOpen = true;
            }
            catch (Throwable t) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        VideoBean.this.ignoreTransmitHotkey = true;
                        ModalDialog.showMessageDialog((Component)VideoBean.this.dialogParentProvider.getDialogParent(), (Object)VideoBean.this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_CANNOTCONNECTMSG, new Object[]{VideoBean.this.currentCameraName, t.toString()}), (String)VideoBean.this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_VIDEOERRORTITLE), (int)0);
                        VideoBean.this.ignoreTransmitHotkey = false;
                        if (VideoBean.this.cameraIsConnected) {
                            try {
                                VideoBean.this.videoSupport.disconnect();
                                VideoBean.this.cameraIsConnected = false;
                            }
                            catch (Throwable t2) {
                                LogSupport.exception((Object)this, (String)"requestCamera", (Throwable)t2, (boolean)false);
                            }
                        }
                    }
                });
            }
        }
        if (this.cameraIsOpen) {
            this.readerThread = new WorkerThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int[] pixels = new int[]{};
                    VideoBean.this.encodingOutLen = 0;
                    VideoBean.this.updateState(16, null);
                    long earliestReadTime = 0L;
                    while (!VideoBean.this.readerThread.isInterrupted()) {
                        long lastFrameGetTime;
                        long now;
                        int minMillisPerFrame = Integer.MAX_VALUE;
                        if (VideoBean.this.maximumFrameRate > 0) {
                            minMillisPerFrame = 1000 / (VideoBean.this.encodingMode == 1 ? VideoBean.this.maximumFrameRate : 15);
                        }
                        if ((now = Platform.currentTimeMillis()) < earliestReadTime) {
                            try {
                                Thread.sleep(earliestReadTime - now);
                            }
                            catch (InterruptedException ie) {
                                break;
                            }
                            earliestReadTime += (long)minMillisPerFrame;
                        } else {
                            earliestReadTime = now + (long)minMillisPerFrame;
                        }
                        Object ie = VideoBean.this.stateLock;
                        synchronized (ie) {
                            try {
                                int pixelCnt = VideoBean.this.captureWidth * VideoBean.this.captureHeight;
                                if (pixels.length < pixelCnt) {
                                    pixels = new int[pixelCnt];
                                }
                                VideoBean.this.videoSupport.read(pixels);
                                lastFrameGetTime = Platform.currentTimeMillis();
                            }
                            catch (IllegalStateException x) {
                                if (VideoDebug.GENERAL.show()) {
                                    LogSupport.message((Object)this, (String)"run", (String)Debug.getStackTrace((Throwable)x));
                                }
                                VideoBean.this.cameraIsOpen = false;
                                break;
                            }
                            catch (Throwable t) {
                                if (VideoDebug.GENERAL.show()) {
                                    LogSupport.message((Object)this, (String)"run", (String)Debug.getStackTrace((Throwable)t));
                                }
                                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        ModalDialog.showMessageDialogAsync((int)-1, (Component)VideoBean.this.dialogParentProvider.getDialogParent(), (Object)VideoBean.this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_CANNOTREADMSG, new Object[]{t.toString()}), (String)VideoBean.this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_VIDEOERRORTITLE), (int)0);
                                    }
                                });
                                break;
                            }
                            try {
                                VideoBean.this.updateState(18, pixels);
                            }
                            catch (Throwable t) {
                                LogSupport.exception((Object)this, (String)"run", (Throwable)t, (boolean)true);
                                break;
                            }
                        }
                        int filmerIdx = VideoBean.this.getFilmerIndex(VideoBean.this.myAddr);
                        if (VideoBean.this.encodingOutLen > 0 && filmerIdx >= 0) {
                            FilmerInf filmerInf = VideoBean.this.filmersInf[filmerIdx];
                            if (filmerInf.encodingMode == 1) {
                                int maxBytesPerSec = (int)(0.7097791798107256 * (double)VideoBean.this.getClient().getMaxXmitSpeed() / 8.0 + 0.5);
                                long sendDoneTime = lastFrameGetTime + 1000L * (long)VideoBean.this.encodingOutLen / (long)maxBytesPerSec;
                                if (earliestReadTime < sendDoneTime) {
                                    earliestReadTime = sendDoneTime;
                                }
                            }
                            boolean isKeyframe = false;
                            if (!VideoBean.this.fireChannelData(VideoBean.this.encodingOutBuf, VideoBean.this.encodingOutLen, filmerInf.encodingMode, isKeyframe)) break;
                            VideoBean.this.encodingOutLen = 0;
                        }
                        Thread.yield();
                    }
                    if (VideoBean.this.cameraIsOpen) {
                        try {
                            VideoBean.this.videoSupport.close();
                            VideoBean.this.cameraIsOpen = false;
                            if (VideoBean.this.disconnectOnClose()) {
                                VideoBean.this.videoSupport.disconnect();
                                VideoBean.this.cameraIsConnected = false;
                            }
                        }
                        catch (Throwable t) {
                            LogSupport.exception((Object)this, (String)"run", (Throwable)t, (boolean)false);
                        }
                    }
                    VideoBean.this.updateState(17, null);
                }
            }, "VideoFrameReader");
            this.readerThread.setDaemon(true);
            this.readerThread.start();
        } else {
            this.updateState(17, null);
        }
    }

    private void requestFloor() {
        if (VideoDebug.SUPPRESS_FLOOR_REQUEST.isEnabled()) {
            this.startWatchdog(this.watchdogPeriod);
            this.stateMessage("Suppressing VideoProtocol.FLOOR_REQUEST");
        } else if (VideoDebug.DENY_FLOOR_REQUEST.isEnabled()) {
            this.startWatchdog(this.watchdogPeriod);
            new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    VideoBean.this.stateMessage("Faking floor request denial");
                    VideoBean.this.updateState(7, null);
                }
            }).scheduleIn((long)(this.watchdogPeriod / 2));
        } else if (VideoDebug.STALL_FLOOR_REQUEST.isEnabled()) {
            this.startWatchdog(this.watchdogPeriod);
        } else if (VideoDebug.DELAY_FLOOR_REQUEST.isEnabled()) {
            this.startWatchdog(2 * this.watchdogPeriod);
            new LightweightTimer(new Runnable(){

                @Override
                public void run() {
                    VideoBean.this.stateMessage("Firing VideoProtocol.FLOOR_REQUEST");
                    VideoBean.this.fireChannelData((byte)1);
                }
            }).scheduleIn((long)this.watchdogPeriod);
        } else {
            this.startWatchdog(this.watchdogPeriod);
            this.stateMessage("Firing VideoProtocol.FLOOR_REQUEST");
            this.fireChannelData((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reserveMainView(boolean reserve) {
        boolean layoutChanged = false;
        Debug.lockEnter((Object)this, (String)"reserveMainView", (String)"stateLock", (Object)this.stateLock);
        Object object = this.stateLock;
        synchronized (object) {
            if (reserve == this.reservingMainView) {
                Debug.lockLeave((Object)this, (String)"reserveMainView", (String)"stateLock", (Object)this.stateLock);
                return;
            }
            if (reserve) {
                int viewIdx = this.getViewIndex((short)-32767);
                this.viewsInf[viewIdx].filmerAddr = this.myAddr;
                this.viewsInf[viewIdx].viewPane.setFrameText(null);
                this.viewsInf[viewIdx].viewPane.setNameText(null);
                this.viewsInf[viewIdx].viewPane.setAvatarPicture(null);
                this.viewsInf[viewIdx].viewPane.setDisplayIndex(viewIdx);
                this.viewsInf[viewIdx].viewPane.setDisplayMode(VideoDisplayPanel.DisplayMode.PREVIEWING);
                this.viewsInf[viewIdx].viewPane.setDisplayName(true);
                layoutChanged = this.rotateActiveViews('R', false);
            } else if (this.mainView.filmerAddr == this.myAddr) {
                layoutChanged = this.rotateActiveViews('L', false);
                int viewIdx = this.countActiveViews() - 1;
                if (this.viewsInf[viewIdx].filmerAddr == this.myAddr) {
                    this.clearViewInf(this.viewsInf[viewIdx]);
                } else {
                    for (int i = 0; i < this.viewsInf.length; ++i) {
                        if (this.viewsInf[i].viewPane.getDisplayMode() != VideoDisplayPanel.DisplayMode.PREVIEWING) continue;
                        this.clearViewInf(this.viewsInf[i]);
                    }
                }
            }
            this.reservingMainView = reserve;
            if (this.neverOpened) {
                this.neverOpened = (this.reservingMainView ? 1 + this.countActiveViews() : this.countActiveViews()) == 0;
                this.module.setActiveViewCount(this.reservingMainView ? 1 + this.countActiveViews() : this.countActiveViews());
            }
        }
        Debug.lockLeave((Object)this, (String)"reserveMainView", (String)"stateLock", (Object)this.stateLock);
        if (layoutChanged) {
            this.layoutWindow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rotateActiveViews(char direction, boolean excludeReserved) {
        Debug.lockEnter((Object)this, (String)"rotateActiveViews", (String)"stateLock", (Object)this.stateLock);
        Object object = this.stateLock;
        synchronized (object) {
            int i;
            int firstViewIdx = this.reservingMainView && excludeReserved ? 1 : 0;
            int viewCnt = this.countActiveViews();
            if (viewCnt - firstViewIdx < 2) {
                return false;
            }
            VideoDisplayPanel.VideoDisplayPanelInfo videoDisplayPanelInfo = new VideoDisplayPanel.VideoDisplayPanelInfo();
            if (direction == 'L') {
                videoDisplayPanelInfo.getViewDisplayPanelInfo(this.viewsInf[firstViewIdx].viewPane, this.viewsInf[firstViewIdx].filmerAddr);
                for (i = firstViewIdx + 1; i < viewCnt; ++i) {
                    this.copyViewInf(this.viewsInf[i - 1], this.viewsInf[i], i - 1);
                    this.viewsInf[i - 1].clearViewPane();
                }
                this.viewsInf[viewCnt - 1].filmerAddr = videoDisplayPanelInfo.setViewDisplayPanelInfo(this.viewsInf[viewCnt - 1].viewPane);
                this.viewsInf[viewCnt - 1].viewPane.setDisplayIndex(viewCnt - 1);
                this.viewsInf[viewCnt - 1].clearViewPane();
            } else {
                videoDisplayPanelInfo.getViewDisplayPanelInfo(this.viewsInf[viewCnt - 1].viewPane, this.viewsInf[viewCnt - 1].filmerAddr);
                for (i = viewCnt - 1; i > firstViewIdx; --i) {
                    this.copyViewInf(this.viewsInf[i], this.viewsInf[i - 1], i);
                    this.viewsInf[i].clearViewPane();
                }
                this.viewsInf[firstViewIdx].filmerAddr = videoDisplayPanelInfo.setViewDisplayPanelInfo(this.viewsInf[firstViewIdx].viewPane);
                this.viewsInf[firstViewIdx].viewPane.setDisplayIndex(firstViewIdx);
                this.viewsInf[firstViewIdx].clearViewPane();
            }
            for (i = firstViewIdx; i < viewCnt; ++i) {
                this.updateTooltips(i);
            }
            byte cmd = this.followModeratorSelected ? (byte)21 : 20;
            this.fireChannelData(cmd, this.mainView.filmerAddr);
        }
        Debug.lockLeave((Object)this, (String)"rotateActiveViews", (String)"stateLock", (Object)this.stateLock);
        return true;
    }

    private void sendMaximumFrameRate() {
        this.maximumFrameRate = this.getPreferredMaximumFrameRate(this.prefix, this.preferences);
        this.stateMessage("Firing VideoProtocol.FRAME_RATE(" + this.maximumFrameRate + ")");
        byte[] data = new byte[]{(byte)this.maximumFrameRate};
        ChannelDataEvent event = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)19, (byte[])data, (int)0, (int)data.length);
        this.fireChannelData(0, event, true, (byte)1);
    }

    private void sendMaximumQuality() {
        if (this.mainViewSize < 1) {
            return;
        }
        int maxQuality = 3;
        switch (this.mainViewSize) {
            case 1: {
                maxQuality = 1;
                break;
            }
            case 3: {
                maxQuality = 5;
            }
        }
        switch (maxQuality) {
            case 1: {
                this.stateMessage("Firing VideoProtocol.QUALITY_CC");
                this.fireChannelData((byte)5);
                break;
            }
            case 5: {
                this.stateMessage("Firing VideoProtocol.QUALITY_FC");
                this.fireChannelData((byte)7);
                break;
            }
            case 4: {
                this.stateMessage("Firing VideoProtocol.QUALITY_FG");
                this.fireChannelData((byte)8);
                break;
            }
            case 3: {
                this.stateMessage("Firing VideoProtocol.QUALITY_MC");
                this.fireChannelData((byte)9);
                break;
            }
            case 2: {
                this.stateMessage("Firing VideoProtocol.QUALITY_MG");
                this.fireChannelData((byte)10);
                break;
            }
            default: {
                this.stateMessage("Firing VideoProtocol.QUALITY_CG");
                this.fireChannelData((byte)6);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAwaitingVideoDataAck(boolean value) {
        Debug.lockEnter((Object)this, (String)"setAwaitingVideoDataAck", (String)"awaitingVideoDataAckLock", (Object)this.awaitingVideoDataAckLock);
        Object object = this.awaitingVideoDataAckLock;
        synchronized (object) {
            this.awaitingVideoDataAck = value;
            this.awaitingVideoDataAckLock.notifyAll();
        }
        Debug.lockLeave((Object)this, (String)"setAwaitingVideoDataAck", (String)"awaitingVideoDataAckLock", (Object)this.awaitingVideoDataAckLock);
    }

    public void setClient(Client theClient) {
        this.setClient(theClient, (JinxProtocol)new VideoProtocol(false), this, this, this);
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        if (contentCapture.isCapturingData()) {
            contentCapture = contentCapture.registerImageModule("Video", "Video", (Container)this.mainView.viewPane, this.i18n.getIcon("VideoBean.thinClientIcon"), (byte)3, (byte)70);
            contentCapture.setFeedVisible(false);
            contentCapture.setConditionData(new byte[]{0, 1});
        }
        this.clients.addPropertyChangeListener((byte)0, (PropertyChangeListener)new VideoAnnotationProvider());
        if (this.videoPermissionDelegate != null) {
            this.videoPermissionDelegate.setClientProvider(this.clientProvider);
            this.videoPermissionDelegate.setSession(this.session);
            CRPermissionFactory permissionFactory = new CRPermissionFactory("VideoPermission", "VideoPermission", CRPermissionScope.PARTICIPANT, (CRPermissionDelegate)this.videoPermissionDelegate);
            this.session.registerPermission(permissionFactory);
            this.clients.addPropertyChangeListener(this.videoPermissionDelegate.getPropertyName(), (byte)0, (PropertyChangeListener)((Object)this.videoPermissionDelegate));
            this.clients.addDefaultPropertyChangeListener(this.videoPermissionDelegate.getPropertyName(), (byte)0, (PropertyChangeListener)((Object)this.videoPermissionDelegate));
        }
    }

    public void setContentVisible(boolean isVisible) {
        if (this.contentVisible == isVisible) {
            return;
        }
        this.contentVisible = isVisible;
        if (isVisible) {
            this.layoutWindow();
            if (this.suspended || this.suspending) {
                try {
                    this.serialThread.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            VideoBean.this.updateState(11, null);
                        }
                    });
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"setContentVisible", (Throwable)t, (boolean)false);
                }
            }
        } else if (!this.suspended && !this.suspending) {
            try {
                this.serialThread.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VideoBean.this.updateState(12, null);
                    }
                });
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"setContentVisible", (Throwable)t, (boolean)false);
            }
        }
        if (contentCapture.isCapturingData()) {
            contentCapture.setFeedVisible(isVisible);
        }
    }

    public void setModule(VideoModule module) {
        this.module = module;
        if (module != null) {
            this.prefix = module.getPrefix();
        }
    }

    public void setMuted(boolean muted) {
        if (muted == this.isMuted) {
            return;
        }
        if (muted) {
            this.waitSync();
        }
        this.isMuted = muted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitSync() {
        Object object = this.stateLock;
        synchronized (object) {
            int i;
            for (i = 0; i < this.filmersInf.length; ++i) {
                FilmerInf filmerInf = this.filmersInf[i];
                filmerInf.awaitingFrameSync = true;
                filmerInf.encodingInLen = 0;
                filmerInf.encodingStarted = true;
            }
            for (i = 0; i < this.viewsInf.length; ++i) {
                ViewInf viewInf = this.viewsInf[i];
                if (viewInf == null) continue;
                viewInf.clearViewPane();
            }
        }
    }

    public void setSeeking(boolean seeking) {
        if (seeking == this.isSeeking) {
            return;
        }
        if (seeking) {
            this.waitSync();
        }
        this.isSeeking = seeking;
    }

    static void setPreferredCloseAutomatically(String prefix, Preferences preferences, boolean automatic) {
        preferences.setSetting(prefix + CLOSE_AUTOMATICALLY_PREF, automatic);
    }

    static void setPreferredMaxFrameRate(String prefix, Preferences preferences, int rate) {
        preferences.setSetting(prefix + MAXIMUMFRAMERATE_PREF, rate);
    }

    static void setPreferredOpenAutomatically(String prefix, Preferences preferences, boolean automatic) {
        preferences.setSetting(prefix + OPEN_AUTOMATICALLY_PREF, automatic);
    }

    static void setPreferredShowFrameRate(String prefix, Preferences preferences, boolean show) {
        preferences.setSetting(prefix + DISPLAY_FRAMERATE_PREF, show);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int newState) {
        Debug.lockEnter((Object)this, (String)"setState", (String)"stateLock", (Object)this.stateLock);
        Object object = this.stateLock;
        synchronized (object) {
            this.stateMessage(this.getStateName(this.state) + " -> " + this.getStateName(newState));
            this.state = newState;
            this.updateTooltips(0);
            boolean oldAdvancedEnabled = this.advancedEnabled;
            boolean oldDeviceEnabled = this.deviceEnabled;
            boolean oldSnapshotEnabled = this.snapshotEnabled;
            boolean oldTransmitEnabled = this.transmitEnabled;
            boolean oldTransmitSelected = this.transmitSelected;
            boolean oldPreviewEnabled = this.previewEnabled;
            boolean oldPreviewSelected = this.previewSelected;
            boolean oldPreviewVisible = this.previewVisible;
            boolean newAdvancedEnabled = oldAdvancedEnabled;
            boolean newDeviceEnabled = oldDeviceEnabled;
            boolean newSnapshotEnabled = oldSnapshotEnabled;
            boolean newTransmitEnabled = oldTransmitEnabled;
            boolean newTransmitSelected = oldTransmitSelected;
            boolean newPreviewEnabled = oldPreviewEnabled;
            boolean newPreviewSelected = oldPreviewSelected;
            boolean newPreviewVisible = oldPreviewVisible;
            switch (this.state) {
                case 4: {
                    newAdvancedEnabled = false;
                    newDeviceEnabled = false;
                    newSnapshotEnabled = false;
                    newTransmitEnabled = false;
                    newTransmitSelected = false;
                    newPreviewEnabled = false;
                    newPreviewSelected = false;
                    newPreviewVisible = true;
                    break;
                }
                case 3: {
                    newAdvancedEnabled = this.canAcquireVideo() && !this.playingRecording && this.mayHavePropsDialog;
                    newDeviceEnabled = this.canAcquireVideo() && !this.playingRecording;
                    newSnapshotEnabled = false;
                    newTransmitEnabled = this.filmingAllowed && this.canAcquireVideo() && !this.awaitingFloorRelease && !this.playingRecording;
                    newTransmitSelected = false;
                    newPreviewEnabled = !this.playingRecording && this.canAcquireVideo();
                    newPreviewSelected = false;
                    newPreviewVisible = true;
                    break;
                }
                case 7: {
                    newAdvancedEnabled = false;
                    newDeviceEnabled = false;
                    newSnapshotEnabled = false;
                    newTransmitEnabled = false;
                    newTransmitSelected = false;
                    newPreviewEnabled = false;
                    newPreviewSelected = !this.previewForPropertiesDialog;
                    newPreviewVisible = true;
                    break;
                }
                case 11: {
                    newAdvancedEnabled = false;
                    newDeviceEnabled = false;
                    newSnapshotEnabled = this.snapshotAPI == null ? false : this.snapshotAPI.isAccessible(8);
                    newTransmitEnabled = !this.previewForPropertiesDialog && this.filmingAllowed && this.canAcquireVideo() && !this.awaitingFloorRelease && !this.playingRecording && !this.floorIsFull();
                    newTransmitSelected = false;
                    newPreviewEnabled = !this.playingRecording && this.canAcquireVideo() && !this.previewForPropertiesDialog;
                    newPreviewSelected = !this.previewForPropertiesDialog;
                    newPreviewVisible = true;
                    break;
                }
                case 9: {
                    newAdvancedEnabled = false;
                    newDeviceEnabled = false;
                    newSnapshotEnabled = false;
                    newTransmitEnabled = false;
                    newTransmitSelected = false;
                    newPreviewEnabled = false;
                    newPreviewSelected = false;
                    newPreviewVisible = true;
                    break;
                }
                case 15: {
                    newAdvancedEnabled = this.canAcquireVideo() && !this.playingRecording && this.mayHavePropsDialog;
                    newDeviceEnabled = this.canAcquireVideo() && !this.playingRecording;
                    newSnapshotEnabled = this.snapshotAPI == null ? false : this.snapshotAPI.isAccessible(8);
                    newTransmitEnabled = this.filmingAllowed && !this.playingRecording && this.canAcquireVideo() && !this.floorIsFull();
                    newTransmitSelected = false;
                    newPreviewEnabled = !this.playingRecording && this.canAcquireVideo();
                    newPreviewSelected = false;
                    newPreviewVisible = true;
                    break;
                }
                case 2: {
                    newAdvancedEnabled = false;
                    newDeviceEnabled = false;
                    newSnapshotEnabled = false;
                    newTransmitEnabled = false;
                    newTransmitSelected = true;
                    newPreviewEnabled = false;
                    newPreviewSelected = false;
                    newPreviewVisible = true;
                    break;
                }
                case 1: {
                    newAdvancedEnabled = false;
                    newDeviceEnabled = false;
                    newSnapshotEnabled = false;
                    newTransmitEnabled = false;
                    newTransmitSelected = true;
                    newPreviewEnabled = false;
                    newPreviewSelected = false;
                    newPreviewVisible = true;
                    break;
                }
                case 5: {
                    newAdvancedEnabled = false;
                    newDeviceEnabled = false;
                    newSnapshotEnabled = this.snapshotAPI == null ? false : this.snapshotAPI.isAccessible(8);
                    newTransmitEnabled = !this.playingRecording && this.canAcquireVideo();
                    newTransmitSelected = true;
                    newPreviewEnabled = !this.playingRecording && this.canAcquireVideo() && !this.previewForPropertiesDialog;
                    newPreviewSelected = false;
                    newPreviewVisible = false;
                    break;
                }
                case 6: {
                    newAdvancedEnabled = false;
                    newDeviceEnabled = false;
                    newSnapshotEnabled = this.snapshotAPI == null ? false : this.snapshotAPI.isAccessible(8);
                    newTransmitEnabled = !this.playingRecording && this.canAcquireVideo();
                    newTransmitSelected = true;
                    newPreviewEnabled = !this.playingRecording && this.canAcquireVideo() && !this.previewForPropertiesDialog;
                    newPreviewSelected = false;
                    newPreviewVisible = false;
                    break;
                }
                case 12: {
                    newAdvancedEnabled = false;
                    newDeviceEnabled = false;
                    newSnapshotEnabled = false;
                    newTransmitEnabled = false;
                    newTransmitSelected = false;
                    newPreviewEnabled = false;
                    newPreviewSelected = false;
                    newPreviewVisible = true;
                    break;
                }
                case 13: {
                    newAdvancedEnabled = false;
                    newDeviceEnabled = false;
                    newSnapshotEnabled = false;
                    newTransmitEnabled = false;
                    newTransmitSelected = false;
                    newPreviewEnabled = false;
                    newPreviewSelected = false;
                    newPreviewVisible = true;
                    break;
                }
                case 14: {
                    newAdvancedEnabled = false;
                    newDeviceEnabled = false;
                    newSnapshotEnabled = false;
                    newTransmitEnabled = false;
                    newTransmitSelected = false;
                    newPreviewEnabled = false;
                    newPreviewSelected = false;
                    newPreviewVisible = true;
                    break;
                }
                case 8: {
                    newAdvancedEnabled = false;
                    newDeviceEnabled = false;
                    newSnapshotEnabled = false;
                    newTransmitEnabled = false;
                    newTransmitSelected = true;
                    newPreviewEnabled = false;
                    newPreviewSelected = false;
                    newPreviewVisible = true;
                    break;
                }
                case 10: {
                    newAdvancedEnabled = false;
                    newDeviceEnabled = false;
                    newSnapshotEnabled = false;
                    newTransmitEnabled = false;
                    newTransmitSelected = false;
                    newPreviewEnabled = false;
                    newPreviewSelected = false;
                    newPreviewVisible = true;
                    break;
                }
                default: {
                    String msg = "No code for state " + this.state;
                    LogSupport.exception((Object)this, (String)"setState", (Throwable)new RuntimeException(msg), (boolean)false);
                }
            }
            this.advancedEnabled = newAdvancedEnabled;
            this.deviceEnabled = newDeviceEnabled;
            this.snapshotEnabled = newSnapshotEnabled;
            this.transmitEnabled = newTransmitEnabled;
            this.transmitSelected = newTransmitSelected;
            this.previewEnabled = newPreviewEnabled;
            this.previewSelected = newPreviewSelected;
            this.previewVisible = newPreviewVisible;
            if (newAdvancedEnabled != oldAdvancedEnabled) {
                this.module.setAdvancedEnabled(newAdvancedEnabled);
            }
            if (newDeviceEnabled != oldDeviceEnabled) {
                this.module.setSelectCameraEnabled(newDeviceEnabled);
            }
            if (newSnapshotEnabled != oldSnapshotEnabled) {
                this.module.setPublishToWhiteboardEnabled(newSnapshotEnabled);
            }
            if (newTransmitEnabled != oldTransmitEnabled) {
                this.module.setTransmitEnabled(newTransmitEnabled);
            }
            if (newTransmitSelected != oldTransmitSelected) {
                this.module.setTransmit(newTransmitSelected);
            }
            if (newPreviewEnabled != oldPreviewEnabled) {
                this.module.setPreviewEnabled(newPreviewEnabled);
            }
            if (newPreviewSelected != oldPreviewSelected) {
                this.module.setPreview(newPreviewSelected);
            }
            if (newPreviewVisible != oldPreviewVisible) {
                this.module.setPreviewVisible(newPreviewVisible);
            }
        }
        Debug.lockLeave((Object)this, (String)"setState", (String)"stateLock", (Object)this.stateLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVideoDisplaySize(Dimension videoSize) {
        Object object = this.stateLock;
        synchronized (object) {
            this.displayWidth = (int)(videoSize.getWidth() + 0.5);
            this.displayHeight = (int)(videoSize.getHeight() + 0.5);
        }
        if (this.displayWidth > 0 && this.displayHeight > 0) {
            this.displaySizeValid = true;
            this.layoutWindow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVideoQuality(final int q) {
        int newCaptureRes;
        if (q < 0 || q >= 6) {
            LogSupport.exception((Object)this, (String)"setVideoQuality", (Throwable)new IllegalArgumentException("Invalid quality: " + q), (boolean)true);
            return;
        }
        if (q == this.videoQuality) {
            return;
        }
        this.videoQuality = q;
        if (this.module != null) {
            this.module.setMaximumQuality(this.maximumQualityIndexToString(q));
        }
        this.frameInCnt = 0;
        this.frameOutCnt = 0;
        int n = newCaptureRes = q < 4 ? 1 : 2;
        if (newCaptureRes != this.captureRes) {
            if (!this.cameraIsOpen || this.encodingMode != 1) {
                Object object = this.stateLock;
                synchronized (object) {
                    this.captureRes = newCaptureRes;
                    this.captureWidth = VideoFrame.getWidth((int)this.captureRes);
                    this.captureHeight = VideoFrame.getHeight((int)this.captureRes);
                }
            } else {
                boolean oldQualityEnabled;
                boolean newQualityEnabled = oldQualityEnabled = this.qualityEnabled;
                this.qualityEnabled = newQualityEnabled = false;
                if (newQualityEnabled != oldQualityEnabled) {
                    this.module.setMaximumQualityEnabled(newQualityEnabled);
                }
                this.serialThread.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Debug.lockEnter((Object)this, (String)"setVideoQuality", (String)"stateLock", (Object)VideoBean.this.stateLock);
                        Object object = VideoBean.this.stateLock;
                        synchronized (object) {
                            boolean oldQualityEnabled;
                            try {
                                VideoBean.this.videoSupport.close();
                                VideoBean.this.cameraIsOpen = false;
                                if (VideoBean.this.disconnectOnClose()) {
                                    VideoBean.this.videoSupport.disconnect();
                                    VideoBean.this.cameraIsConnected = false;
                                    VideoBean.this.videoSupport.connect(VideoBean.this.currentCameraHandle);
                                    VideoBean.this.cameraIsConnected = true;
                                }
                                VideoBean.this.maximumFrameRate = VideoBean.this.getPreferredMaximumFrameRate(VideoBean.this.prefix, VideoBean.this.preferences);
                                VideoBean.this.captureRes = newCaptureRes;
                                VideoBean.this.captureWidth = VideoFrame.getWidth((int)VideoBean.this.captureRes);
                                VideoBean.this.captureHeight = VideoFrame.getHeight((int)VideoBean.this.captureRes);
                                VideoBean.this.videoSupport.open(VideoBean.this.captureWidth, VideoBean.this.captureHeight, VideoBean.this.maximumFrameRate);
                                VideoBean.this.cameraIsOpen = true;
                            }
                            catch (Throwable t) {
                                VideoBean.this.updateState(17, null);
                                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        VideoBean.this.ignoreTransmitHotkey = true;
                                        ModalDialog.showMessageDialog((Component)VideoBean.this.dialogParentProvider.getDialogParent(), (Object)VideoBean.this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_CANNOTCONNECTMSG, new Object[]{VideoBean.this.currentCameraName, t.toString()}), (String)VideoBean.this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_VIDEOERRORTITLE), (int)0);
                                        VideoBean.this.ignoreTransmitHotkey = false;
                                        if (VideoBean.this.cameraIsConnected) {
                                            try {
                                                VideoBean.this.videoSupport.disconnect();
                                                VideoBean.this.cameraIsConnected = false;
                                            }
                                            catch (Throwable tc) {
                                                LogSupport.exception((Object)this, (String)"run", (Throwable)tc, (boolean)false);
                                            }
                                        }
                                    }
                                });
                            }
                            for (int i = 0; i < VideoBean.this.filmersInf.length; ++i) {
                                ((VideoBean)VideoBean.this).filmersInf[i].videoFrame.setQuality(q);
                            }
                            boolean newQualityEnabled = oldQualityEnabled = VideoBean.this.qualityEnabled;
                            newQualityEnabled = true;
                            VideoBean.this.qualityEnabled = newQualityEnabled;
                            if (newQualityEnabled != oldQualityEnabled) {
                                VideoBean.this.module.setMaximumQualityEnabled(newQualityEnabled);
                            }
                        }
                        Debug.lockLeave((Object)this, (String)"setVideoQuality", (String)"stateLock", (Object)VideoBean.this.stateLock);
                    }
                });
                return;
            }
        }
        for (int i = 0; i < this.filmersInf.length; ++i) {
            this.filmersInf[i].videoFrame.setQuality(q);
        }
    }

    public void showEncodingModeDialog() {
        int newMode;
        MultilineLabel blurb = new MultilineLabel("Warning:  The ability of a moderator to set the encoding\nmode is temporary.  Eventually the server will set it\nwhen launching a room, and it will be immutable for the\nlife of the room.\n");
        JRadioButton classicBtn = new JRadioButton("Classic Video", this.encodingMode == 1);
        JRadioButton hqSmallBtn = new JRadioButton("High-quality small video", this.encodingMode == 3);
        JRadioButton hqMediumBtn = new JRadioButton("High-quality medium video", this.encodingMode == 4);
        JRadioButton hqLargeBtn = new JRadioButton("High-quality large video", this.encodingMode == 5);
        ButtonGroup buttonGrp = new ButtonGroup();
        buttonGrp.add(classicBtn);
        buttonGrp.add(hqSmallBtn);
        buttonGrp.add(hqMediumBtn);
        buttonGrp.add(hqLargeBtn);
        Box buttonBox = Box.createVerticalBox();
        buttonBox.add(classicBtn);
        buttonBox.add(hqSmallBtn);
        buttonBox.add(hqMediumBtn);
        buttonBox.add(hqLargeBtn);
        Component parent = this.getAppFrame();
        String title = "Encoding Mode";
        JPanel content = new JPanel(new BorderLayout(0, 6));
        content.add((Component)blurb, "North");
        content.add((Component)buttonBox, "Center");
        EasyDialog d = new EasyDialog(parent, title);
        d.setContent((Component)content);
        d.addActionButton(d.makeButton(1), true);
        d.addCancelButton(d.makeButton(0));
        d.setInitialFocus((Component)buttonBox);
        d.show();
        if (!d.wasCanceled() && this.encodingMode != (newMode = hqSmallBtn.isSelected() ? 3 : (hqMediumBtn.isSelected() ? 4 : (hqLargeBtn.isSelected() ? 5 : 1)))) {
            this.encodingMode = newMode;
            this.clients.setProperty("encodingMode", new Integer(newMode).intValue());
        }
    }

    public void showMaxFilmersDialog() {
        int newMaxFilmers;
        MultilineLabel blurb = new MultilineLabel(this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_MAXFILMERSMSG));
        AccessibleTextSlider slider = new AccessibleTextSlider(1, this.maxFilmersLimit, this.maxFilmers);
        slider.setMajorTickSpacing((this.maxFilmersLimit - 1) / 8 + 1);
        slider.setMinorTickSpacing(1);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        slider.setPaintTrack(true);
        slider.setSnapToTicks(true);
        slider.getAccessibleContext().setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_MAXCAMERA_ACCESSIBLE_DESC));
        Component parent = this.getAppFrame();
        String title = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_MAXFILMERSTITLE);
        JPanel content = new JPanel(new BorderLayout(0, 6));
        content.add((Component)blurb, "North");
        content.add((Component)slider, "Center");
        EasyDialog d = new EasyDialog(parent, title);
        d.setContent((Component)content);
        d.addActionButton(d.makeButton(1), true);
        d.addCancelButton(d.makeButton(0));
        d.setInitialFocus((Component)slider);
        d.show();
        if (!d.wasCanceled() && this.maxFilmers != (newMaxFilmers = slider.getValue())) {
            this.maxFilmers = newMaxFilmers;
            this.clients.setProperty("videoMaxTalkers", new Integer(this.maxFilmers).intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startTransmitVideoCmd() {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case 15: {
                    if (this.floorIsFull()) {
                        return false;
                    }
                }
                case 3: 
                case 11: 
                case 14: {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            VideoBean.this.cmdVideoWindowControl(true);
                            VideoBean.this.updateState(14, null);
                        }
                    });
                    return true;
                }
                case 2: {
                    if (this.floorIsFull()) {
                        return false;
                    }
                }
                case 1: 
                case 5: 
                case 6: {
                    return true;
                }
                case 7: 
                case 8: {
                    if (this.floorIsFull()) {
                        return false;
                    }
                    this.setMutedForPreview(false);
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startVideoPreviewCmd() {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case 3: 
                case 5: 
                case 6: 
                case 14: 
                case 15: {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            VideoBean.this.cmdVideoWindowControl(true);
                            VideoBean.this.updateState(9, null);
                        }
                    });
                    return true;
                }
                case 1: {
                    this.setState(7);
                    this.setMutedForPreview(true);
                    return true;
                }
                case 2: {
                    this.setState(8);
                    this.setMutedForPreview(true);
                    return true;
                }
                case 7: 
                case 8: 
                case 11: {
                    this.setMutedForPreview(true);
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopVideoCmd() {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case 11: {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            VideoBean.this.updateState(10, null);
                            VideoBean.this.cmdVideoWindowControl(false);
                        }
                    });
                    return true;
                }
                case 5: 
                case 6: {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            VideoBean.this.updateState(15, null);
                            VideoBean.this.cmdVideoWindowControl(false);
                        }
                    });
                    return true;
                }
                case 1: {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            VideoBean.this.setState(12);
                            VideoBean.this.releaseCamera();
                            VideoBean.this.cmdVideoWindowControl(false);
                        }
                    });
                    return true;
                }
                case 2: {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            VideoBean.this.setState(13);
                            VideoBean.this.releaseFloor();
                            VideoBean.this.cmdVideoWindowControl(false);
                        }
                    });
                    return true;
                }
                case 7: {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            VideoBean.this.setState(9);
                            VideoBean.this.releaseCamera();
                            VideoBean.this.cmdVideoWindowControl(false);
                        }
                    });
                    return true;
                }
                case 8: {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            VideoBean.this.setState(10);
                            VideoBean.this.releaseFloor();
                            VideoBean.this.cmdVideoWindowControl(false);
                        }
                    });
                    return true;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            VideoBean.this.cmdVideoWindowControl(false);
                        }
                    });
                    return true;
                }
                case 3: 
                case 4: 
                case 14: 
                case 15: {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            VideoBean.this.cmdVideoWindowControl(false);
                        }
                    });
                    return true;
                }
            }
            return false;
        }
    }

    private void startWatchdog(int delay) {
        if (delay <= 0 || this.watchdogTimer.isScheduled()) {
            return;
        }
        this.watchdogTimer.scheduleIn((long)delay);
        this.stateMessage("Watchdog timer set at " + delay);
    }

    private int stateMessage(String msg) {
        int msgNum = 0;
        if (VideoDebug.STATE.show()) {
            msgNum = this.msgNumber++;
            LogSupport.message((String)(msgNum + ": " + msg));
        }
        return msgNum;
    }

    private void cmdVideoWindowControl(boolean open) {
        if (!SwingUtilities.isEventDispatchThread()) {
            LogSupport.exception((Object)this, (String)"cmdVideoWindowControl", (Throwable)new IllegalThreadStateException("Must be called from Swing Thread"), (boolean)true);
        }
        if (open) {
            if (this.neverOpened) {
                this.neverOpened = false;
                this.module.setActiveViewCount(1);
            }
        } else if (this.isHideAutomatic() && this.countFilmers(true) == 0 && this.countFilmers(false) <= 1) {
            if (this.neverOpened) {
                this.neverOpened = (this.reservingMainView ? 1 + this.countActiveViews() : this.countActiveViews()) == 0;
                this.module.setActiveViewCount(this.reservingMainView ? 1 + this.countActiveViews() : this.countActiveViews());
            }
            if (this.state == 14) {
                this.updateState(11, null);
            }
        }
    }

    void toggleTransmit() {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!VideoBean.this.ignoreTransmitHotkey && VideoBean.this.transmitEnabled) {
                    VideoBean.this.transmitSelected = !VideoBean.this.transmitSelected;
                    VideoBean.this.setTransmitting(VideoBean.this.transmitSelected);
                }
            }
        });
    }

    private void updateFilmerDesc() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    VideoBean.this.updateFilmerDesc();
                }
            });
            return;
        }
        int filmerCnt = 0;
        String firstFilmerName = null;
        for (int i = 0; i < this.filmersInf.length; ++i) {
            ClientInfo ci;
            if (this.filmersInf[i].filmerAddr == -32767 || this.filmersInf[i].filmerAddr == this.myAddr || (ci = this.clients.get(this.filmersInf[i].filmerAddr)) == null) continue;
            if (filmerCnt < 1) {
                firstFilmerName = ci.getDisplayName();
            }
            ++filmerCnt;
        }
        String filmerDesc = filmerCnt < 1 ? null : (filmerCnt == 1 ? firstFilmerName : this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_MULTIPLEFILMERSDESC));
        if (contentCapture != null) {
            if (filmerDesc != null && filmerDesc.length() > 0) {
                contentCapture.setTitle("Video - " + filmerDesc);
            } else {
                contentCapture.setTitle("Video");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState(int eventCode, Object eventData) {
        Debug.lockEnter((Object)this, (String)"updateState", (String)"stateLock", (Object)this.stateLock);
        Object object = this.stateLock;
        synchronized (object) {
            String operation = "Got " + this.getEventName(eventCode) + " in " + this.getStateName(this.state);
            this.stateMessage(operation);
            int histIdx = this.eventHistCnt++ % 100;
            this.eventHistEvents[histIdx] = eventCode;
            this.eventHistStates[histIdx] = this.state;
            this.eventHistTimes[histIdx] = Platform.currentTimeMillis();
            block4 : switch (eventCode) {
                case 1: {
                    if (!this.connected) break;
                    this.recvQ.abort();
                    this.printQueStats();
                    this.recvQ = null;
                    this.myAddr = (short)-32767;
                    this.connected = false;
                    this.awaitingFloorRelease = false;
                    this.filmingAllowed = false;
                    this.haveTheFloor = false;
                    this.clearAllFilmers();
                    switch (this.state) {
                        case 1: 
                        case 7: 
                        case 9: 
                        case 12: 
                        case 14: {
                            break block4;
                        }
                        case 2: 
                        case 13: {
                            this.quenchWatchdog();
                            this.setState(4);
                            break block4;
                        }
                        case 3: 
                        case 15: {
                            this.setState(4);
                            break block4;
                        }
                        case 4: {
                            String diagnostic = "Channel already disconnected in state " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break block4;
                        }
                        case 5: 
                        case 6: {
                            this.setState(12);
                            this.releaseCamera();
                            break block4;
                        }
                        case 8: 
                        case 10: {
                            this.quenchWatchdog();
                            this.setState(9);
                            this.releaseCamera();
                            break block4;
                        }
                        case 11: {
                            this.setState(9);
                            this.releaseCamera();
                            break block4;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 2: {
                    if (this.connected) break;
                    try {
                        this.printQueStats();
                        this.recvQ = new ReceiveQueue();
                        this.recvQ.addReceiveListener(this);
                    }
                    catch (Throwable t) {
                        LogSupport.exception((Object)this, (String)"updateState", (Throwable)t, (boolean)false);
                        this.printQueStats();
                        this.recvQ = null;
                        break;
                    }
                    this.myAddr = this.clients.getMyAddress();
                    this.connected = true;
                    boolean bl = this.playingRecording = this.getClient() != null && this.getClient().toString().indexOf(".PlaybackClient") >= 0;
                    if (this.playingRecording) {
                        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                VideoBean.this.setVideoQuality(5);
                            }
                        });
                    }
                    switch (this.state) {
                        case 4: {
                            this.setState(3);
                            if (!this.suspending) break block4;
                            this.updateState(12, null);
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 12: {
                            break;
                        }
                        case 14: {
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 13: 
                        case 15: {
                            String diagnostic = "Channel already connected in state " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break;
                        }
                        default: {
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                            break;
                        }
                    }
                    break;
                }
                case 3: {
                    this.filmingAllowed = true;
                    switch (this.state) {
                        case 3: 
                        case 11: 
                        case 15: {
                            this.refreshButtonState();
                            break block4;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: 
                        case 14: {
                            break block4;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 4: {
                    this.filmingAllowed = false;
                    switch (this.state) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: 
                        case 14: {
                            break block4;
                        }
                        case 3: 
                        case 11: 
                        case 15: {
                            this.refreshButtonState();
                            break block4;
                        }
                        case 5: 
                        case 6: {
                            this.setState(12);
                            this.releaseCamera();
                            break block4;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 5: {
                    if (VideoDebug.IGNORE_FLOOR_GRANT.isEnabled()) {
                        this.stateMessage("Ignoring EV_FLOOR_GRANTED_ME");
                        break;
                    }
                    if (this.awaitingFloorRelease) break;
                    this.reserveMainView(false);
                    byte[] floorData = (byte[])eventData;
                    int filmerIdx = floorData.length < 3 ? 0 : floorData[2] & 0xFF;
                    this.addFilmer(this.myAddr, filmerIdx);
                    this.seqNum = 0;
                    FilmerInf filmerInf = this.filmersInf[filmerIdx];
                    filmerInf.encodingMode = this.encodingMode;
                    this.haveTheFloor = true;
                    switch (this.state) {
                        case 2: {
                            this.quenchWatchdog();
                            this.setState(1);
                            this.sendBurstByteCnt = 0;
                            this.sendBurstFrameCnt = 0;
                            this.setAwaitingVideoDataAck(false);
                            this.serialThread.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    VideoBean.this.requestCamera();
                                }
                            });
                            break block4;
                        }
                        case 8: {
                            this.quenchWatchdog();
                            this.setState(this.countFilmers(true) > 0 ? 5 : 6);
                            this.sendBurstByteCnt = 0;
                            this.sendBurstFrameCnt = 0;
                            this.setAwaitingVideoDataAck(false);
                            break block4;
                        }
                        case 14: {
                            break block4;
                        }
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 15: {
                            String diagnostic = "Floor granted in state " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break block4;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 6: {
                    if ((this.playingRecording || this.isShowAutomatic()) && !this.wasAutoShown) {
                        this.wasAutoShown = !this.contentVisible;
                    }
                    byte[] floorData = (byte[])eventData;
                    short filmerAddr = (short)(256 * floorData[0] + (floorData[1] & 0xFF));
                    int filmerIdx = floorData.length < 3 ? 0 : floorData[2] & 0xFF;
                    this.addFilmer(filmerAddr, filmerIdx);
                    FilmerInf filmerInf = this.filmersInf[filmerIdx];
                    filmerInf.encodingMode = this.encodingMode;
                    switch (this.state) {
                        case 4: 
                        case 14: {
                            break block4;
                        }
                        case 1: 
                        case 2: 
                        case 5: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: {
                            this.refreshButtonState();
                            break block4;
                        }
                        case 3: 
                        case 15: {
                            this.setState(15);
                            break block4;
                        }
                        case 6: {
                            this.setState(5);
                            break block4;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 7: {
                    if (VideoDebug.IGNORE_FLOOR_REVOKE.isEnabled()) {
                        this.stateMessage("Ignoring EV_FLOOR_REVOKED_ME");
                        break;
                    }
                    if (this.haveTheFloor) {
                        this.haveTheFloor = false;
                        this.removeFilmer(this.myAddr, true);
                        this.clearStatusIndicators();
                    }
                    if (this.awaitingFloorRelease) {
                        this.awaitingFloorRelease = false;
                        this.refreshButtonState();
                    }
                    switch (this.state) {
                        case 1: 
                        case 12: {
                            break;
                        }
                        case 2: 
                        case 13: {
                            this.quenchWatchdog();
                            this.setState(!this.connected ? 4 : (this.countFilmers(true) < 1 ? 3 : 15));
                            if (!this.suspending) break block4;
                            this.updateState(12, null);
                            break;
                        }
                        case 3: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 15: {
                            break;
                        }
                        case 5: 
                        case 6: {
                            this.setState(12);
                            this.releaseCamera();
                            break;
                        }
                        case 8: {
                            this.quenchWatchdog();
                            this.setState(9);
                            this.releaseCamera();
                            break;
                        }
                        case 10: {
                            this.quenchWatchdog();
                            this.setState(11);
                            this.reserveMainView(true);
                            break;
                        }
                        case 14: {
                            break;
                        }
                        case 4: {
                            String diagnostic = "Floor revoked in state " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break;
                        }
                        default: {
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                            break;
                        }
                    }
                    break;
                }
                case 8: {
                    byte[] floorData = (byte[])eventData;
                    short filmerAddr = (short)(256 * floorData[0] + (floorData[1] & 0xFF));
                    this.removeFilmer(filmerAddr, true);
                    ClientInfo ci = this.clients.get(filmerAddr);
                    if (ci != null) {
                        ci.setProperty("videoStatus", 0);
                    }
                    if ((this.playingRecording || this.wasAutoShown && this.isHideAutomatic()) && this.state != 11 && this.state != 7 && this.countFilmers(false) < 1 && !this.childWindowShowing) {
                        this.wasAutoShown = false;
                    }
                    switch (this.state) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 10: 
                        case 12: 
                        case 13: 
                        case 14: {
                            break;
                        }
                        case 3: 
                        case 15: {
                            this.setState(this.countFilmers(true) > 0 ? 15 : 3);
                            if (!this.suspending) break block4;
                            this.updateState(12, null);
                            break;
                        }
                        case 7: 
                        case 9: 
                        case 11: {
                            this.refreshButtonState();
                            break;
                        }
                        default: {
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                            break;
                        }
                    }
                    break;
                }
                case 9: {
                    switch (this.state) {
                        case 3: 
                        case 15: {
                            this.setState(7);
                            this.setMutedForPreview(true);
                            if (SwingUtilities.isEventDispatchThread()) {
                                this.serialThread.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        VideoBean.this.requestCamera();
                                    }
                                });
                                break block4;
                            }
                            this.requestCamera();
                            break block4;
                        }
                        case 5: 
                        case 6: {
                            this.setMutedForPreview(true);
                            this.setState(10);
                            this.releaseFloor();
                            break block4;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: {
                            String diagnostic = "Preview button pressed in state " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break block4;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 10: {
                    switch (this.state) {
                        case 11: {
                            this.setState(9);
                            this.releaseCamera();
                            break block4;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: {
                            String diagnostic = "Preview button released in state " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break block4;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 11: {
                    this.suspended = false;
                    this.suspending = false;
                    if (this.connected) {
                        this.stateMessage("Firing VideoProtocol.RESUME");
                        this.fireChannelData((byte)12);
                        break;
                    }
                    this.setState(4);
                    break;
                }
                case 12: {
                    int currState = this.state;
                    switch (currState) {
                        case 14: {
                            String diagnostic = "Got SUSPEND in " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break block4;
                        }
                    }
                    this.suspended = true;
                    this.suspending = true;
                    this.stateMessage("Firing VideoProtocol.SUSPEND");
                    this.fireChannelData((byte)13);
                    break;
                }
                case 13: {
                    switch (this.state) {
                        case 1: {
                            this.setState(12);
                            this.releaseCamera();
                            break;
                        }
                        case 2: {
                            this.setState(13);
                            if (VideoDebug.STALL_FLOOR_REQUEST.isEnabled()) {
                                new LightweightTimer(new Runnable(){

                                    @Override
                                    public void run() {
                                        VideoBean.this.stateMessage("Firing stalled VideoProtocol.FLOOR_REQUEST");
                                        VideoBean.this.fireChannelData((byte)1);
                                        VideoBean.this.stateMessage("Firing VideoProtocol.FLOOR_RELEASE");
                                        VideoBean.this.fireChannelData((byte)2);
                                    }
                                }).scheduleIn((long)(2 * this.watchdogPeriod));
                            } else {
                                this.stateMessage("Firing VideoProtocol.FLOOR_RELEASE");
                                this.fireChannelData((byte)2);
                            }
                            this.awaitFloorRelease();
                            this.setState(!this.connected ? 4 : (this.countFilmers(true) < 1 ? 3 : 15));
                            break;
                        }
                        case 7: {
                            this.setState(9);
                            this.releaseCamera();
                            break;
                        }
                        case 8: {
                            this.setState(13);
                            if (VideoDebug.STALL_FLOOR_REQUEST.isEnabled()) {
                                new LightweightTimer(new Runnable(){

                                    @Override
                                    public void run() {
                                        VideoBean.this.stateMessage("Firing stalled VideoProtocol.FLOOR_REQUEST");
                                        VideoBean.this.fireChannelData((byte)1);
                                        VideoBean.this.stateMessage("Firing VideoProtocol.FLOOR_RELEASE");
                                        VideoBean.this.fireChannelData((byte)2);
                                    }
                                }).scheduleIn((long)(2 * this.watchdogPeriod));
                            } else {
                                this.stateMessage("Firing VideoProtocol.FLOOR_RELEASE");
                                this.fireChannelData((byte)2);
                            }
                        }
                        case 10: {
                            this.awaitFloorRelease();
                            this.setState(9);
                            this.releaseCamera();
                            if (!this.haveTheFloor) break block4;
                            this.haveTheFloor = false;
                            this.removeFilmer(this.myAddr, true);
                            this.clearStatusIndicators();
                            break;
                        }
                        case 9: {
                            this.setState(!this.connected ? 4 : (this.countFilmers(true) < 1 ? 3 : 15));
                            this.setMutedForPreview(false);
                            if (!this.suspending) break block4;
                            this.updateState(12, null);
                            break;
                        }
                        case 12: {
                            this.setState(13);
                            this.awaitFloorRelease();
                            this.releaseFloor();
                            break;
                        }
                        case 13: {
                            this.awaitFloorRelease();
                            this.setState(!this.connected ? 4 : (this.countFilmers(true) < 1 ? 3 : 15));
                            if (this.haveTheFloor) {
                                this.haveTheFloor = false;
                                this.removeFilmer(this.myAddr, true);
                                this.clearStatusIndicators();
                            }
                            if (!this.suspending) break block4;
                            this.updateState(12, null);
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 11: 
                        case 14: 
                        case 15: {
                            String diagnostic = "Watchdog timeout in state " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break;
                        }
                        default: {
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                            break;
                        }
                    }
                    break;
                }
                case 14: {
                    switch (this.state) {
                        case 3: 
                        case 15: {
                            this.setState(2);
                            this.requestFloor();
                            break block4;
                        }
                        case 11: {
                            this.setMutedForPreview(false);
                            this.setState(8);
                            this.requestFloor();
                            break block4;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: 
                        case 14: {
                            String diagnostic = "Transmit button pressed in state " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break block4;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 15: {
                    switch (this.state) {
                        case 5: 
                        case 6: {
                            this.setState(12);
                            this.releaseCamera();
                            break block4;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: {
                            String diagnostic = "Transmit button released in state " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break block4;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 16: {
                    this.frameOutCnt = 0;
                    switch (this.state) {
                        case 1: {
                            if (this.haveTheFloor) {
                                this.setState(this.countFilmers(true) > 0 ? 5 : 6);
                                break block4;
                            }
                            this.setState(12);
                            this.releaseCamera();
                            break block4;
                        }
                        case 7: {
                            this.setState(11);
                            this.reserveMainView(true);
                            break block4;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: {
                            String diagnostic = "Got VIDEO_BEGIN in " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break block4;
                        }
                    }
                    LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                    break;
                }
                case 17: {
                    this.previewForPropertiesDialog = false;
                    this.reserveMainView(false);
                    switch (this.state) {
                        case 1: 
                        case 5: 
                        case 6: 
                        case 10: 
                        case 12: {
                            this.mainView.clearViewPane();
                            if (this.haveTheFloor) {
                                this.setState(13);
                                this.releaseFloor();
                                break;
                            }
                            this.setState(!this.connected ? 4 : (this.countFilmers(true) < 1 ? 3 : 15));
                            if (!this.suspending) break block4;
                            this.updateState(12, null);
                            break;
                        }
                        case 7: 
                        case 9: 
                        case 11: {
                            this.mainView.clearViewPane();
                            this.setState(!this.connected ? 4 : (this.countFilmers(true) < 1 ? 3 : 15));
                            this.setMutedForPreview(false);
                            if (!this.suspending) break block4;
                            this.updateState(12, null);
                            break;
                        }
                        case 8: {
                            this.mainView.clearViewPane();
                            this.setState(10);
                            this.releaseFloor();
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 13: 
                        case 14: 
                        case 15: {
                            String diagnostic = "Got VIDEO_END in " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break;
                        }
                        default: {
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                            break;
                        }
                    }
                    break;
                }
                case 18: {
                    switch (this.state) {
                        case 5: 
                        case 6: 
                        case 11: {
                            int displayHeight;
                            int displayWidth;
                            int filmerIdx;
                            ViewInf viewInf;
                            if (this.state == 11) {
                                viewInf = this.mainView;
                            } else {
                                int viewIdx = this.getViewIndex(this.myAddr);
                                if (viewIdx < 0) break;
                                viewInf = this.viewsInf[viewIdx];
                            }
                            int[] frameOut = (int[])eventData;
                            if (viewInf == this.mainView) {
                                ++this.frameOutCnt;
                                int index = this.frameOutCnt % this.frameOutTime.length;
                                this.frameOutTime[index] = Platform.currentTimeMillis();
                                this.frameOutSize[index] = frameOut.length;
                            }
                            if ((filmerIdx = this.getFilmerIndex(this.myAddr)) >= 0 && (this.state == 6 || this.state == 5)) {
                                FilmerInf filmerInf = this.filmersInf[filmerIdx];
                                filmerInf.videoFrame.putPixels(this.captureRes, frameOut);
                                try {
                                    int maxEncodingLen = VideoFrame.getMaxEncodingLength();
                                    if (this.encodingOutBuf.length < maxEncodingLen) {
                                        this.encodingOutBuf = new byte[maxEncodingLen];
                                    }
                                    this.encodingOutLen = filmerInf.videoFrame.getEncoding(false, this.encodingOutBuf);
                                }
                                catch (Throwable t) {
                                    this.encodingOutLen = 0;
                                    LogSupport.exception((Object)this, (String)"updateState", (Throwable)t, (boolean)true);
                                }
                                int displayRes = filmerInf.videoFrame.getPixels(frameOut);
                                displayWidth = VideoFrame.getWidth((int)displayRes);
                                displayHeight = VideoFrame.getHeight((int)displayRes);
                            } else {
                                this.encodingOutLen = 0;
                                if (this.encodingMode == 1) {
                                    int displayRes = this.captureRes;
                                    if (!this.previewForPropertiesDialog) {
                                        displayRes = this.filmersInf[0].videoFrame.previewPixels(this.captureRes, frameOut);
                                    }
                                    displayWidth = VideoFrame.getWidth((int)displayRes);
                                    displayHeight = VideoFrame.getHeight((int)displayRes);
                                } else {
                                    displayWidth = this.captureWidth;
                                    displayHeight = this.captureHeight;
                                }
                            }
                            viewInf.viewPane.newFrame(displayWidth, displayHeight, frameOut);
                            if (viewInf != this.mainView || this.previewForPropertiesDialog) break block4;
                            this.showStats(viewInf, this.frameOutCnt, this.frameOutTime, this.frameOutSize, 1);
                            break;
                        }
                        case 8: 
                        case 10: {
                            break;
                        }
                        case 9: 
                        case 12: {
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 13: 
                        case 14: 
                        case 15: {
                            String diagnostic = "Got VIDEO_FRAME in " + this.getStateName(this.state);
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(diagnostic) + "\n" + this.formatEventHistory()));
                            break;
                        }
                        default: {
                            LogSupport.message((Object)this, (String)"updateState", (String)(new IllegalStateException(operation) + "\n" + this.formatEventHistory()));
                            break;
                        }
                    }
                    break;
                }
                default: {
                    String diagnostic = "Invalid event index: " + eventCode;
                    LogSupport.exception((Object)this, (String)"updateState", (Throwable)new IllegalArgumentException(diagnostic), (boolean)false, (String)this.formatEventHistory());
                }
            }
        }
        Debug.lockLeave((Object)this, (String)"updateState", (String)"stateLock", (Object)this.stateLock);
    }

    public void publishToWhiteboard() {
        if (this.snapshotAPI == null) {
            return;
        }
        this.snapshotData = new ImageAcceptData(8, 0, 0);
        this.mainView.viewPane.setFrameText(null);
        String nameText = this.mainView.viewPane.getNameText();
        this.mainView.viewPane.setNameText(null);
        boolean displayName = this.mainView.viewPane.getDisplayName();
        this.mainView.viewPane.setDisplayName(false);
        this.snapshotData = this.snapshotAPI.setImage((Component)this.mainView.viewPane, this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_SNAPSHOTTITLE), this.snapshotData);
        this.mainView.viewPane.setNameText(nameText);
        this.mainView.viewPane.setDisplayName(displayName);
        if (this.snapshotData.getException() != null) {
            ModalDialog.showMessageDialogAsync((int)-1, (Component)this.dialogParentProvider.getDialogParent(), (Object)this.snapshotData.getException().getMessage(), (String)this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_VIDEOERRORTITLE), (int)0);
        }
    }

    public void setFollowModerator(boolean follow) {
        this.followModeratorSelected = follow;
        if (this.followModeratorSelected == this.followModeratorFromNetwork) {
            return;
        }
        this.fireChannelData((byte)22, follow ? (byte)1 : 0);
        if (follow && this.mainView.filmerAddr != -32767 && !this.reservingMainView) {
            this.fireChannelData((byte)21, this.mainView.filmerAddr);
        }
    }

    public void setFollowSpeaker(boolean followSpeaker) {
        if (followSpeaker == this.followSpeakerSelected) {
            return;
        }
        this.followSpeakerSelected = followSpeaker;
        if (this.followTheSpeakerAPI != null) {
            this.speakerChanged(this.followTheSpeakerAPI.getSpeaker());
        }
    }

    public boolean setTransmitting(boolean transmitting) {
        boolean status = false;
        if (transmitting) {
            status = this.startTransmitVideoCmd();
            if (status) {
                this.videoPublisher.sendVideoOnMessage(this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOPUBLISHER_VIDEO_ON), true);
            }
        } else {
            status = this.stopVideoCmd();
            if (status) {
                this.videoPublisher.sendVideoOffMessage(this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOPUBLISHER_VIDEO_OFF), true);
            }
        }
        return status;
    }

    public void setPreviewing(boolean previewing) {
        if (previewing) {
            this.previewForPropertiesDialog = false;
            this.startVideoPreviewCmd();
        } else {
            this.stopVideoCmd();
        }
    }

    public void startPreview() {
        this.previewForPropertiesDialog = true;
        this.updateState(9, null);
    }

    public void stopPreview() {
        this.updateState(10, null);
    }

    private void restartCamera(final boolean disconnect) {
        this.serialThread.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Debug.lockEnter((Object)this, (String)"restartCamera", (String)"stateLock", (Object)VideoBean.this.stateLock);
                Object object = VideoBean.this.stateLock;
                synchronized (object) {
                    try {
                        if (VideoBean.this.cameraIsOpen) {
                            VideoBean.this.videoSupport.close();
                            VideoBean.this.cameraIsOpen = false;
                            if (disconnect) {
                                VideoBean.this.videoSupport.disconnect();
                                VideoBean.this.cameraIsConnected = false;
                                VideoBean.this.videoSupport.connect(VideoBean.this.currentCameraHandle);
                                VideoBean.this.cameraIsConnected = true;
                            }
                            VideoBean.this.captureWidth = VideoFrame.getWidth((int)VideoBean.this.captureRes);
                            VideoBean.this.captureHeight = VideoFrame.getHeight((int)VideoBean.this.captureRes);
                            VideoBean.this.videoSupport.open(VideoBean.this.captureWidth, VideoBean.this.captureHeight, VideoBean.this.maximumFrameRate);
                            VideoBean.this.cameraIsOpen = true;
                        }
                    }
                    catch (Throwable t) {
                        VideoBean.this.updateState(17, null);
                        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                VideoBean.this.ignoreTransmitHotkey = true;
                                ModalDialog.showMessageDialog((Component)VideoBean.this.dialogParentProvider.getDialogParent(), (Object)VideoBean.this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_CANNOTCONNECTMSG, new Object[]{VideoBean.this.currentCameraName, t.toString()}), (String)VideoBean.this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_VIDEOERRORTITLE), (int)0);
                                VideoBean.this.ignoreTransmitHotkey = false;
                                if (VideoBean.this.cameraIsConnected) {
                                    try {
                                        VideoBean.this.videoSupport.disconnect();
                                        VideoBean.this.cameraIsConnected = false;
                                    }
                                    catch (Throwable tc) {
                                        LogSupport.exception((Object)this, (String)"run", (Throwable)tc, (boolean)false);
                                    }
                                }
                            }
                        });
                    }
                }
                Debug.lockLeave((Object)this, (String)"restartCamera", (String)"stateLock", (Object)VideoBean.this.stateLock);
            }
        });
    }

    public boolean isChair() {
        Chair chair = this.chairProtocol.fetchChair(this.clients);
        return chair != null && chair.isMe();
    }

    public boolean isHideAutomatic() {
        return VideoBean.getPreferredCloseAutomatically(this.prefix, this.preferences);
    }

    public boolean isShowAutomatic() {
        return VideoBean.getPreferredOpenAutomatically(this.prefix, this.preferences);
    }

    static boolean getPreferredCloseAutomatically(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + CLOSE_AUTOMATICALLY_PREF, false);
    }

    static boolean getPreferredOpenAutomatically(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + OPEN_AUTOMATICALLY_PREF, true);
    }

    static boolean getPreferredShowFrameRate(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + DISPLAY_FRAMERATE_PREF, false) && (contentCapture.isEchoingData() || !contentCapture.isCapturingData());
    }

    static boolean getPreferredShowTransmitSize(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + DISPLAY_TRANSMITSIZE_PREF, false) && (contentCapture.isEchoingData() || !contentCapture.isCapturingData());
    }

    private void loadPreferenceCamera(String prefix, Preferences preferences) {
        try {
            this.currentCameraHandle = preferences.getSetting(prefix + CAMERA_PREF, null);
            this.currentCameraName = null;
            if (this.videoSupport != null) {
                this.currentCameraName = this.videoSupport.getDisplayName(this.currentCameraHandle);
            }
        }
        catch (Throwable t) {
            this.currentCameraHandle = null;
            this.currentCameraName = null;
            LogSupport.exception((Object)this, (String)"loadPreferenceCamera", (Throwable)t, (boolean)true);
        }
        if (VideoDebug.GENERAL.show()) {
            LogSupport.message((Object)this, (String)"loadPreferenceCamera", (String)("default camera: " + this.currentCameraName + (this.currentCameraHandle != this.currentCameraName ? " (" + this.currentCameraHandle + ")" : "")));
        }
    }

    private void savePreferenceCamera(String prefix, Preferences preferences) {
        if (this.currentCameraHandle != null) {
            preferences.setSetting(prefix + CAMERA_PREF, this.currentCameraHandle);
        }
    }

    public String[] getCameraList() {
        try {
            this.serialThread.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (VideoBean.this.videoSupport == null) {
                        return;
                    }
                    VideoBean.access$6002(VideoBean.this, new String[0]);
                    try {
                        VideoBean.access$6002(VideoBean.this, VideoBean.this.videoSupport.enumerate());
                    }
                    catch (Throwable t) {
                        LogSupport.exception((Object)this, (String)"selectCameraPrivate", (Throwable)t, (boolean)false);
                    }
                    VideoBean.access$6102(VideoBean.this, new String[VideoBean.this.cameraHandleList.length]);
                    for (int ix = 0; ix < VideoBean.this.cameraHandleList.length; ++ix) {
                        ((VideoBean)VideoBean.this).cameraNameList[ix] = VideoBean.this.videoSupport.getDisplayName(VideoBean.this.cameraHandleList[ix]);
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return this.cameraNameList;
    }

    public int getDefaultCameraIndex() {
        return 0;
    }

    public int getPreferredCameraIndex(String prefix, Preferences preferences) {
        String cameraHandle = preferences.getSetting(prefix + CAMERA_PREF, null);
        if (this.cameraHandleList.length == 0) {
            return -1;
        }
        for (int ix = 0; ix < this.cameraHandleList.length; ++ix) {
            if (!this.cameraHandleList[ix].equals(cameraHandle)) continue;
            return ix;
        }
        return 0;
    }

    public void setPreferredCameraIndex(String prefix, Preferences preferences, int preferredCamera) {
        if (this.cameraHandleList != null && this.cameraHandleList.length > 0) {
            preferences.setSetting(prefix + CAMERA_PREF, this.cameraHandleList[preferredCamera]);
        }
    }

    private void loadPreferenceDisplayUserName(String prefix, Preferences preferences) {
        this.displayUserName = this.getPreferredDisplayUserName(prefix, preferences);
    }

    private void savePreferenceDisplayUserName(String prefix, Preferences preferences) {
        this.setPreferredDisplayUserName(prefix, preferences, this.displayUserName);
    }

    private boolean displayUserName() {
        return this.getPreferredDisplayUserName(this.prefix, this.preferences);
    }

    public boolean getDefaultDisplayUserName() {
        return true;
    }

    public boolean getPreferredDisplayUserName(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + DISPLAY_USERNAME_PREF, true);
    }

    public void setPreferredDisplayUserName(String prefix, Preferences preferences, boolean preferredDisplayUserName) {
        preferences.setSetting(prefix + DISPLAY_USERNAME_PREF, preferredDisplayUserName);
    }

    private void loadPreferenceDisconnectOnClose(String prefix, Preferences preferences) {
        this.disconnectOnClose = this.getPreferredDisconnectOnClose(prefix, preferences);
    }

    private void savePreferenceDisconnectOnClose(String prefix, Preferences preferences) {
        this.setPreferredDisconnectOnClose(prefix, preferences, this.disconnectOnClose);
    }

    private boolean disconnectOnClose() {
        return this.getPreferredDisconnectOnClose(this.prefix, this.preferences);
    }

    public boolean getDefaultDisconnectOnClose() {
        return false;
    }

    public boolean getPreferredDisconnectOnClose(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + DISCONNECT_ON_CLOSE_PREF, false);
    }

    public void setPreferredDisconnectOnClose(String prefix, Preferences preferences, boolean disconnect) {
        preferences.setSetting(prefix + DISCONNECT_ON_CLOSE_PREF, disconnect);
    }

    public int getMaxFilmersLimit() {
        return this.maxFilmersLimit;
    }

    public int getDefaultMaxFilmers() {
        return this.maxFilmers;
    }

    public int getPreferredMaxFilmers(String prefix, Preferences preferences) {
        return this.maxFilmers > this.maxFilmersLimit ? this.maxFilmersLimit : (this.maxFilmers < 1 ? 1 : this.maxFilmers);
    }

    public void setPreferredMaxFilmers(String prefix, Preferences preferences, int preferredMaxFilmers) {
        int n = preferredMaxFilmers > this.maxFilmersLimit ? this.maxFilmersLimit : (preferredMaxFilmers = preferredMaxFilmers < 1 ? 1 : preferredMaxFilmers);
        if (preferredMaxFilmers != this.maxFilmers) {
            if (!this.isChair()) {
                return;
            }
            this.maxFilmers = preferredMaxFilmers;
            this.clients.setProperty("videoMaxTalkers", new Integer(this.maxFilmers).intValue());
        }
    }

    private void loadPreferenceTransmitSize(String prefix, Preferences preferences) {
        this.transmitSize = this.getPreferredTransmitSize(prefix, preferences);
        this.transmitWidth = VideoFrame.getWidth((int)this.transmitSize);
        this.transmitHeight = VideoFrame.getHeight((int)this.transmitSize);
    }

    private void savePreferenceTransmitSize(String prefix, Preferences preferences) {
        this.setPreferredTransmitSize(prefix, preferences, this.transmitSize);
    }

    public String[] getTransmitSizeList() {
        this.transmitSizeList = new String[3];
        this.transmitSizeList[0] = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOCAMERASETTINGSPREFS_TRANSMITSIZE_MENUITEM0);
        this.transmitSizeList[1] = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOCAMERASETTINGSPREFS_TRANSMITSIZE_MENUITEM1);
        this.transmitSizeList[2] = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOCAMERASETTINGSPREFS_TRANSMITSIZE_MENUITEM2);
        return this.transmitSizeList;
    }

    public int getDefaultTransmitSize() {
        return 2;
    }

    public int getPreferredTransmitSize(String prefix, Preferences preferences) {
        return 2;
    }

    public void setPreferredTransmitSize(String prefix, Preferences preferences, int preferredTransmitSize) {
        preferences.setSetting(prefix + TRANSMITSIZE_PREF, preferredTransmitSize == 0 ? "s" : (preferredTransmitSize == 1 ? "m" : "l"));
    }

    private void loadPreferenceDisplayTransmitSize(String prefix, Preferences preferences) {
        this.displayTransmitSize = this.getPreferredDisplayTransmitSize(prefix, preferences);
    }

    private void savePreferenceDisplayTransmitSize(String prefix, Preferences preferences) {
        this.setPreferredDisplayTransmitSize(prefix, preferences, this.displayTransmitSize);
    }

    public boolean getDefaultDisplayTransmitSize() {
        return false;
    }

    public boolean getPreferredDisplayTransmitSize(String prefix, Preferences preferences) {
        return false;
    }

    public void setPreferredDisplayTransmitSize(String prefix, Preferences preferences, boolean preferredDisplayTransmitSize) {
        preferences.setSetting(prefix + DISPLAY_TRANSMITSIZE_PREF, preferredDisplayTransmitSize);
    }

    private void loadPreferenceMaximumFrameRate(String prefix, Preferences preferences) {
        this.maximumFrameRate = this.getPreferredMaximumFrameRate(prefix, preferences);
    }

    private void savePreferenceMaximumFrameRate(String prefix, Preferences preferences) {
        this.setPreferredMaximumFrameRate(prefix, preferences, this.maximumFrameRate);
    }

    public int getMaximumFrameRateLimit() {
        return 30;
    }

    public int getDefaultMaximumFrameRate() {
        return 10;
    }

    public int getPreferredMaximumFrameRate(String prefix, Preferences preferences) {
        return preferences.getIntegerSetting(prefix + MAXIMUMFRAMERATE_PREF, 10);
    }

    public void setPreferredMaximumFrameRate(String prefix, Preferences preferences, int preferredMaximumFrameRate) {
        preferences.setSetting(prefix + MAXIMUMFRAMERATE_PREF, preferredMaximumFrameRate);
    }

    private void loadPreferenceDisplayFrameRate(String prefix, Preferences preferences) {
        this.displayFrameRate = this.getPreferredDisplayFrameRate(prefix, preferences);
    }

    private void savePreferenceDisplayFrameRate(String prefix, Preferences preferences) {
        this.setPreferredDisplayFrameRate(prefix, preferences, this.displayFrameRate);
    }

    public boolean getDefaultDisplayFrameRate() {
        return false;
    }

    public boolean getPreferredDisplayFrameRate(String prefix, Preferences preferences) {
        return preferences.getBooleanSetting(prefix + DISPLAY_FRAMERATE_PREF, false);
    }

    public void setPreferredDisplayFrameRate(String prefix, Preferences preferences, boolean preferredDisplayFrameRate) {
        preferences.setSetting(prefix + DISPLAY_FRAMERATE_PREF, preferredDisplayFrameRate);
    }

    public String[] getEncodingModeList() {
        this.encodingModeList = new String[4];
        this.encodingModeList[0] = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOCAMERASETTINGSPREFS_ENCODINGMODE_MENUITEM_CLASSIC);
        this.encodingModeList[1] = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOCAMERASETTINGSPREFS_ENCODINGMODE_MENUITEM_HQSMALL);
        this.encodingModeList[2] = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOCAMERASETTINGSPREFS_ENCODINGMODE_MENUITEM_HQMEDIUM);
        this.encodingModeList[3] = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOCAMERASETTINGSPREFS_ENCODINGMODE_MENUITEM_HQLARGE);
        return this.encodingModeList;
    }

    public int getDefaultEncodingMode() {
        return 1;
    }

    public int getPreferredEncodingMode(String prefix, Preferences preferences) {
        switch (this.encodingMode) {
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
        }
        return 0;
    }

    public void setPreferredEncodingMode(String prefix, Preferences preferences, int preferredEncodingMode) {
        if (this.encodingMode != this.getPreferredEncodingMode(prefix, preferences)) {
            if (!this.isChair()) {
                return;
            }
            this.encodingMode = 1;
            switch (preferredEncodingMode) {
                case 1: {
                    this.encodingMode = 3;
                    break;
                }
                case 2: {
                    this.encodingMode = 4;
                    break;
                }
                case 3: {
                    this.encodingMode = 5;
                }
            }
            this.clients.setProperty("encodingMode", new Integer(this.encodingMode).intValue());
        }
    }

    public String[] getQualityList() {
        return this.QualityList;
    }

    public String getDefaultQuality() {
        return this.QualityDefault;
    }

    public String maximumQualityIndexToString(int q) {
        String maximumQuality = this.QualityDesc0Text;
        switch (q) {
            case 0: {
                maximumQuality = this.QualityDesc0Text;
                break;
            }
            case 1: {
                maximumQuality = this.QualityDesc1Text;
                break;
            }
            case 2: {
                maximumQuality = this.QualityDesc2Text;
                break;
            }
            case 3: {
                maximumQuality = this.QualityDesc3Text;
                break;
            }
            case 4: {
                maximumQuality = this.QualityDesc4Text;
                break;
            }
            case 5: {
                maximumQuality = this.QualityDesc5Text;
            }
        }
        return maximumQuality;
    }

    public String getPreferredQuality() {
        String qualityStr = this.preferences.getSetting(this.prefix + ".defaultQuality", "cg");
        String maximumQuality = this.QualityDesc0Text;
        if (qualityStr.equals("cg")) {
            maximumQuality = this.QualityDesc0Text;
        } else if (qualityStr.equals("cc")) {
            maximumQuality = this.QualityDesc1Text;
        } else if (qualityStr.equals("mg")) {
            maximumQuality = this.QualityDesc2Text;
        } else if (qualityStr.equals("mc")) {
            maximumQuality = this.QualityDesc3Text;
        } else if (qualityStr.equals("fg")) {
            maximumQuality = this.QualityDesc4Text;
        } else if (qualityStr.equals("fc")) {
            maximumQuality = this.QualityDesc5Text;
        }
        return maximumQuality;
    }

    public void setMaximumQuality(String maximumQuality) {
        int q = 0;
        String qualityStr = "cg";
        if (maximumQuality.equals(this.QualityDesc0Text)) {
            q = 0;
            qualityStr = "cg";
        } else if (maximumQuality.equals(this.QualityDesc1Text)) {
            q = 1;
            qualityStr = "cc";
        } else if (maximumQuality.equals(this.QualityDesc2Text)) {
            q = 2;
            qualityStr = "mg";
        } else if (maximumQuality.equals(this.QualityDesc3Text)) {
            q = 3;
            qualityStr = "mc";
        } else if (maximumQuality.equals(this.QualityDesc4Text)) {
            q = 4;
            qualityStr = "fg";
        } else if (maximumQuality.equals(this.QualityDesc5Text)) {
            q = 5;
            qualityStr = "fc";
        }
        this.setVideoQuality(q);
        this.preferences.setSetting(this.prefix + ".defaultQuality", qualityStr);
    }

    public void selectCamera() {
        this.childWindowShowing = true;
        this.stateMessage("disabling buttons before device dialog");
        this.advancedEnabled = false;
        this.deviceEnabled = false;
        this.previewEnabled = false;
        this.transmitEnabled = false;
        this.serialThread.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (VideoBean.this.selectCameraPrivate(VideoBean.this.dialogParentProvider.getDialogParent(), false)) {
                    Debug.lockEnter((Object)this, (String)"actionPerformed", (String)"stateLock", (Object)VideoBean.this.stateLock);
                    Object object = VideoBean.this.stateLock;
                    synchronized (object) {
                        if (VideoBean.this.cameraIsOpen) {
                            String diagnostic = "Camera is open";
                            LogSupport.exception((Object)this, (String)"actionPerformed", (Throwable)new IllegalStateException(diagnostic), (boolean)false);
                        } else if (VideoBean.this.cameraIsConnected) {
                            try {
                                VideoBean.this.videoSupport.disconnect();
                                VideoBean.this.cameraIsConnected = false;
                            }
                            catch (Throwable t) {
                                LogSupport.exception((Object)this, (String)"actionPerformed", (Throwable)t, (boolean)false);
                            }
                        }
                    }
                    Debug.lockLeave((Object)this, (String)"actionPerformed", (String)"stateLock", (Object)VideoBean.this.stateLock);
                }
                VideoBean.this.childWindowShowing = false;
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        VideoBean.this.stateMessage("restoring buttons after device dialog");
                        VideoBean.this.refreshButtonState();
                    }
                });
            }
        });
    }

    private boolean selectCameraPrivate(Component parent, boolean implicit) {
        if (this.videoSupport == null) {
            return false;
        }
        String[] cameras = new String[]{};
        try {
            cameras = this.videoSupport.enumerate();
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"selectCameraPrivate", (Throwable)t, (boolean)false);
        }
        if (cameras.length < 1) {
            ModalDialog.showMessageDialog((Component)parent, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_NOVIDEOSOURCESMSG), (String)this.DeviceLabel, (int)0);
            return false;
        }
        if (implicit) {
            for (int i = 0; i < cameras.length; ++i) {
                if (!cameras[i].equals(this.currentCameraHandle)) continue;
                return true;
            }
            if (cameras.length == 1) {
                this.currentCameraHandle = cameras[0];
                this.currentCameraName = this.videoSupport.getDisplayName(cameras[0]);
                return true;
            }
        }
        Object[] cameraNames = new String[cameras.length];
        for (int ix = 0; ix < cameras.length; ++ix) {
            cameraNames[ix] = this.videoSupport.getDisplayName(cameras[ix]);
        }
        final CList list = new CList(cameraNames);
        list.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_DEVICELISTTIP));
        list.clearSelection();
        list.setSelectionMode(0);
        list.setSelectedValue(cameraNames[0], true);
        if (this.currentCameraName != null) {
            list.setSelectedValue((Object)this.currentCameraName, true);
        }
        list.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                JButton defaultBtn;
                JRootPane rootPane;
                if (e.getClickCount() == 2 && (rootPane = list.getRootPane()) != null && (defaultBtn = rootPane.getDefaultButton()) != null) {
                    defaultBtn.doClick();
                }
            }
        });
        Object[] message = new Object[]{new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_DEVICELIST)), new JScrollPane((Component)list)};
        int optionType = 2;
        int messageType = -1;
        Icon icon = null;
        Object[] options = null;
        Object initialValue = null;
        do {
            int action;
            if ((action = ModalDialog.showOptionDialog((Component)parent, (Object)message, (String)this.DeviceLabel, (int)optionType, (int)messageType, icon, options, initialValue)) != 2 && action != -1) continue;
            return false;
        } while (list.isSelectionEmpty());
        this.currentCameraHandle = cameras[list.getSelectedIndex()];
        this.currentCameraName = cameraNames[list.getSelectedIndex()];
        return true;
    }

    public void advancedProperties() {
        if (this.buttonUpdatesPending > 0) {
            return;
        }
        this.childWindowShowing = true;
        this.stateMessage("disabling buttons before properties dialog");
        this.advancedEnabled = false;
        this.deviceEnabled = false;
        this.previewEnabled = false;
        this.transmitEnabled = false;
        this.reserveMainView(true);
        this.serialThread.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!VideoBean.this.cameraIsConnected && VideoBean.this.selectCameraPrivate(VideoBean.this.dialogParentProvider.getDialogParent(), true)) {
                        try {
                            VideoBean.this.videoSupport.connect(VideoBean.this.currentCameraHandle);
                            VideoBean.this.cameraIsConnected = true;
                        }
                        catch (Throwable t) {
                            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    VideoBean.this.ignoreTransmitHotkey = true;
                                    ModalDialog.showMessageDialog((Component)VideoBean.this.dialogParentProvider.getDialogParent(), (Object)VideoBean.this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_CANNOTCONNECTMSG, new Object[]{VideoBean.this.currentCameraName, t.toString()}), (String)VideoBean.this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_VIDEOERRORTITLE), (int)0);
                                    VideoBean.this.ignoreTransmitHotkey = false;
                                }
                            });
                        }
                    }
                    if (VideoBean.this.cameraIsConnected) {
                        if (VideoBean.this.videoSupport.havePropsDialog()) {
                            try {
                                VideoBean.this.videoSupport.showPropsDialog(((VideoBean)VideoBean.this).mainView.viewPane);
                            }
                            catch (Throwable t) {
                                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        ModalDialog.showMessageDialog((Component)VideoBean.this.dialogParentProvider.getDialogParent(), (Object)VideoBean.this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_DIALOGFAILEDMSG, new Object[]{VideoBean.this.currentCameraName, t.toString()}), (String)VideoBean.this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_VIDEOERRORTITLE), (int)0);
                                    }
                                });
                            }
                        } else {
                            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    ModalDialog.showMessageDialog((Component)VideoBean.this.dialogParentProvider.getDialogParent(), (Object)VideoBean.this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_DIALOGMISSINGMSG, new Object[]{VideoBean.this.currentCameraName}), (String)VideoBean.this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_ADVANCED), (int)1);
                                    if (VideoBean.this.cameraIsConnected) {
                                        try {
                                            VideoBean.this.videoSupport.disconnect();
                                            VideoBean.this.cameraIsConnected = false;
                                        }
                                        catch (Throwable t) {
                                            LogSupport.exception((Object)this, (String)"run", (Throwable)t, (boolean)false);
                                        }
                                    }
                                }
                            });
                        }
                    }
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"actionPerformed", (Throwable)t, (boolean)false);
                }
                VideoBean.this.childWindowShowing = false;
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        VideoBean.this.stateMessage("restoring buttons after properties dialog");
                        VideoBean.this.refreshButtonState();
                        VideoBean.this.reserveMainView(false);
                    }
                });
            }
        });
    }

    public boolean maximumQualityPublished() {
        return this.qualityVisible;
    }

    public boolean advancedEnabled() {
        return this.advancedEnabled;
    }

    public boolean maximumQualityEnabled() {
        return this.qualityEnabled;
    }

    public boolean selectCameraEnabled() {
        return this.deviceEnabled;
    }

    public boolean publishToWhiteboardEnabled() {
        return this.snapshotEnabled;
    }

    public boolean previewStartStopEnabled() {
        return this.previewEnabled;
    }

    public boolean transmitStartStopEnabled() {
        return this.transmitEnabled;
    }

    public boolean isTransmitting() {
        return this.transmitSelected;
    }

    public boolean isPreviewing() {
        return this.previewSelected;
    }

    public boolean isVideoFollowingModerator() {
        return this.followModeratorSelected;
    }

    public boolean isVideoFollowingSpeaker() {
        return this.followSpeakerSelected;
    }

    public String getMaximumQuality() {
        return this.maximumQualityIndexToString(this.videoQuality);
    }

    private void setMutedForPreview(boolean isMutedForPreview) {
        this.isMutedForPreview = isMutedForPreview;
        this.speakerChanged(this.followTheSpeakerAPI.getSpeaker());
    }

    private boolean isMutedForPreview() {
        return this.isMutedForPreview;
    }

    CRSession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyViewInf(ViewInf dstView, ViewInf srcView, int index) {
        Object object = this.viewsInfLock;
        synchronized (object) {
            if (srcView.filmerAddr == 1) {
                return;
            }
            dstView.filmerAddr = srcView.filmerAddr;
            dstView.viewPane.setFrameText(srcView.viewPane.getFrameText());
            dstView.viewPane.setNameText(srcView.viewPane.getNameText());
            dstView.viewPane.setAvatarPicture(srcView.viewPane.getAvatarPicture());
            dstView.viewPane.setDisplayIndex(index);
            dstView.viewPane.setDisplayMode(srcView.viewPane.getDisplayMode());
            dstView.viewPane.setDisplayName(srcView.viewPane.getDisplayName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearViewInf(ViewInf view) {
        Object object = this.viewsInfLock;
        synchronized (object) {
            view.filmerAddr = (short)-32767;
            view.viewPane.setFrameText(null);
            view.viewPane.setNameText(null);
            view.viewPane.setAvatarPicture(null);
            view.viewPane.setDisplayIndex(-1);
            view.viewPane.setDisplayMode(VideoDisplayPanel.DisplayMode.NONE);
            view.viewPane.setDisplayName(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapViewInfs(ViewInf view1, ViewInf view2, int index1, int index2) {
        Object object = this.viewsInfLock;
        synchronized (object) {
            VideoDisplayPanel.VideoDisplayPanelInfo videoDisplayPanelInfo = new VideoDisplayPanel.VideoDisplayPanelInfo();
            videoDisplayPanelInfo.getViewDisplayPanelInfo(view1.viewPane, view1.filmerAddr);
            this.copyViewInf(view1, view2, index1);
            view2.filmerAddr = videoDisplayPanelInfo.setViewDisplayPanelInfo(view2.viewPane);
            view2.viewPane.setDisplayIndex(index2);
        }
    }

    static /* synthetic */ String[] access$6002(VideoBean x0, String[] x1) {
        x0.cameraHandleList = x1;
        return x1;
    }

    static /* synthetic */ String[] access$6102(VideoBean x0, String[] x1) {
        x0.cameraNameList = x1;
        return x1;
    }

    static {
        decodeEvent = new String[]{"EV_INVALID", "EV_CHANNEL_DOWN", "EV_CHANNEL_UP", "EV_FILMING_ALLOWED", "EV_FILMING_BANNED", "EV_FLOOR_GRANTED_ME", "EV_FLOOR_GRANTED_OTHER", "EV_FLOOR_REVOKED_ME", "EV_FLOOR_REVOKED_OTHER", "EV_PREVIEW_BUTTON_PRESSED", "EV_PREVIEW_BUTTON_RELEASED", "EV_RESUME", "EV_SUSPEND", "EV_TIMEOUT", "EV_TRANSMIT_BUTTON_PRESSED", "EV_TRANSMIT_BUTTON_RELEASED", "EV_VIDEO_BEGIN", "EV_VIDEO_END", "EV_VIDEO_FRAME"};
        decodeState = new String[]{"ST_INVALID", "ST_AWAITING_CAMERA", "ST_AWAITING_FLOOR", "ST_CONNECTED", "ST_DISCONNECTED", "ST_EXCHANGING", "ST_FILMING", "ST_PREVIEW_AWAITING_CAMERA", "ST_PREVIEW_AWAITING_FLOOR", "ST_PREVIEW_RELEASING_CAMERA", "ST_PREVIEW_RELEASING_FLOOR", "ST_PREVIEWING", "ST_RELEASING_CAMERA", "ST_RELEASING_FLOOR", "ST_SUSPENDED", "ST_WATCHING"};
        LOAD_TIME = Platform.currentTimeMillis();
        CAMERA_DEFAULT = null;
    }

    class FilmerInf {
        volatile boolean awaitingFrameSync;
        long earliestShowTime;
        byte[] encodingInBuf;
        int encodingInLen;
        int encodingMode;
        boolean encodingStarted;
        short filmerAddr;
        byte seqNum;
        boolean usingCRC;
        VideoFrame videoFrame = new VideoFrame();

        FilmerInf() {
            this.reset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            Object object = VideoBean.this.receiveVideoDataLock;
            synchronized (object) {
                this.awaitingFrameSync = false;
                this.earliestShowTime = 0L;
                this.encodingInBuf = new byte[0];
                this.encodingInLen = 0;
                this.encodingMode = 0;
                this.encodingStarted = false;
                this.filmerAddr = (short)-32767;
                this.seqNum = 0;
                this.usingCRC = false;
                this.videoFrame.clear();
            }
        }
    }

    private class VideoAnnotationProvider
    implements PropertyChangeListener {
        private VideoAnnotationProvider() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (VideoBean.this.clients == null) {
                return;
            }
            String propertyName = evt.getPropertyName();
            short ownerId = VideoBean.this.clients.getPropertyOwner(evt.getSource());
            ClientInfo ci = VideoBean.this.clients.get(ownerId);
            if (ci == null) {
                return;
            }
            if (propertyName.equals("videoActive")) {
                boolean active = ci.getProperty("videoActive", false);
                if (active) {
                    VideoBean.this.session.setAnnotationValue(ownerId, "VideoActivityAnnotation", (Object)1);
                } else {
                    VideoBean.this.session.setAnnotationValue(ownerId, "VideoActivityAnnotation", (Object)0);
                }
            } else if (propertyName.equals("videoStatus")) {
                int status = ci.getProperty("videoStatus", 0);
                switch (status) {
                    case 2: {
                        VideoBean.this.session.setAnnotationValue(ownerId, "VideoLagAnnotation", (Object)1);
                        break;
                    }
                    case 1: 
                    case 3: {
                        VideoBean.this.session.setAnnotationValue(ownerId, "VideoLagAnnotation", (Object)2);
                        break;
                    }
                    default: {
                        VideoBean.this.session.setAnnotationValue(ownerId, "VideoLagAnnotation", (Object)0);
                    }
                }
            }
        }
    }

    class ViewInf {
        short filmerAddr = (short)-32767;
        VideoDisplayPanel viewPane = null;
        JPanel viewPanel = null;

        ViewInf() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clearViewPane() {
            Object object = VideoBean.this.receiveVideoDataLock;
            synchronized (object) {
                this.viewPane.clear();
            }
        }
    }
}

