/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.video.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandNoPermissionException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.StopVideoCommand;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.video.module.StringsProperties;
import com.elluminate.groupware.video.module.VideoBean;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class StopVideoCmd
extends AbstractCommand
implements StopVideoCommand {
    private I18n i18n = I18n.create((Object)((Object)this));
    private Provider<VideoBean> beanProvider;

    @Inject
    public void initVideoBeanProvider(Provider<VideoBean> bp) {
        this.beanProvider = bp;
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnline();
        VideoBean bean = (VideoBean)this.beanProvider.get();
        CRSession session = bean.getSession();
        CRParticipant me = session.getMe();
        if (me != null) {
            if (!session.getPermissionValue("VideoPermission", me.getID())) {
                throw new CommandNoPermissionException("You have no Video permission.");
            }
        } else {
            throw new CommandNoPermissionException("No Me Participant.");
        }
        if (!bean.isTransmitting() || !bean.setTransmitting(false)) {
            throw new CommandContextException("Video cannot be stopped right now", this.i18n.getString((PropertiesEnum)StringsProperties.STOPVIDEOCMD_BADCONTEXTCANNOTSTOP));
        }
    }
}

