/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.profile;

import com.elluminate.groupware.profile.ProfileItem;
import com.elluminate.groupware.profile.ProfileItemID;
import java.awt.Image;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jdom.Element;

public class ProxyProfileItem
extends ProfileItem {
    public static final String MIME = "image/proxy";
    public static final byte ITEM_TYPE = 3;
    private int len;
    private int height;
    private int width;

    protected ProxyProfileItem(ProfileItemID id, DataInputStream istr) throws IOException {
        super(id, (byte)3, MIME);
        this.height = istr.readByte();
        this.width = istr.readByte();
        this.len = istr.readInt();
    }

    @Override
    public byte[] getRaw() {
        return null;
    }

    @Override
    public void send(DataOutputStream ostr) throws IOException {
        ostr.writeByte(this.kind);
        this.id.send(ostr);
        ostr.writeByte(this.height);
        ostr.writeByte(this.width);
        ostr.writeInt(this.len);
    }

    @Override
    public void sendDeferred(DataOutputStream ostr) throws IOException {
        this.send(ostr);
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void write(Element parent) throws IOException {
        throw new IOException("Proxy profile items may not be saved.");
    }

    public boolean equals(Object o) {
        try {
            ProxyProfileItem p = (ProxyProfileItem)o;
            if (this.id != p.id) {
                return false;
            }
            return this.len == p.len;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.len;
    }

    public String toString() {
        return this.id + "(" + MIME + ")=[" + this.width + "x" + this.height + "," + this.len + " bytes]";
    }
}

