/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.chat;

import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.LabelProps;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.PropertyAccessAPI;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Address {
    private byte type;
    private String name;
    private String role;
    private boolean chair;
    private boolean me;
    private short jinxAddress;

    public Address(byte type, String name, short addr) {
        this(type, name, "", false, false, addr);
    }

    public Address(byte type, String name) {
        this(type, name, "", false, false, -32767);
    }

    public Address(byte type, String name, String role, boolean chair, boolean me) {
        this(type, name, "", false, false, -32767);
    }

    public Address(byte type, String name, String role, boolean chair, boolean me, short addr) {
        this.name = name;
        this.role = role;
        this.type = type;
        this.chair = chair;
        this.me = me;
        this.jinxAddress = addr;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getRole() {
        return this.role;
    }

    public byte getType() {
        return this.type;
    }

    public boolean isChair() {
        return this.chair;
    }

    public boolean isMe() {
        return this.me;
    }

    public void encode(ClientList clients, DataOutputStream str) throws IOException {
        str.writeByte(this.type);
        if (this.type == 4 || this.type == 5) {
            return;
        }
        ClientInfo ci = clients.getVisible(this.name);
        if (ci == null) {
            str.writeShort(-1);
            str.writeUTF(this.name);
        } else {
            str.writeShort(ci.getAddress());
        }
    }

    public static Address decode(ClientList clients, DataInputStream str) throws IOException {
        String name;
        Chair chair = ChairProtocol.getChair((ClientList)clients);
        byte type = str.readByte();
        String role = "";
        boolean isChair = false;
        boolean isMe = false;
        switch (type) {
            case 1: {
                return null;
            }
            case 4: 
            case 5: {
                return new Address(type, "", -32767);
            }
        }
        short addr = str.readShort();
        if (addr < 0) {
            name = str.readUTF();
        } else if (clients != null) {
            ClientInfo ci = clients.get(addr);
            if (ci == null) {
                name = Short.toString(addr);
            } else {
                name = ci.getDisplayName();
                isChair = chair.contains(ci.getAddress());
                isMe = ci.isMe();
                if (isChair) {
                    role = LabelProps.get((PropertyAccessAPI)clients, (String)"Label.Moderator");
                }
            }
        } else {
            name = Short.toString(addr);
        }
        if (type == 2 && !isChair) {
            return new Address(type, name, role, isChair, isMe, addr);
        }
        return new Address(type, name, role, isChair, isMe, -32767);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        switch (this.type) {
            case 5: {
                return "ALL ROOMS";
            }
            case 4: {
                return "ALL";
            }
            case 3: {
                buf.append("TO:");
                break;
            }
            case 6: {
                buf.append("BCC:");
                break;
            }
            case 2: {
                buf.append("FROM:");
            }
        }
        buf.append(this.name);
        return buf.toString();
    }

    public short getJinxAddress() {
        return this.jinxAddress;
    }

    public void setJinxAddress(short jinxAddress) {
        this.jinxAddress = jinxAddress;
    }
}

