/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.breakout.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.AbstractFeature;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.ActionParameterDescriptor;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.StringFeature;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.breakout.BreakoutProtocol;
import com.elluminate.groupware.breakout.module.BreakoutBean;
import com.elluminate.groupware.breakout.module.CloseAllRoomsCmd;
import com.elluminate.groupware.breakout.module.CloseRoomCmd;
import com.elluminate.groupware.breakout.module.CreateRoomCmd;
import com.elluminate.groupware.breakout.module.CreateRoomsAndDistributeCmd;
import com.elluminate.groupware.breakout.module.CreateRoomsAndSplitCmd;
import com.elluminate.groupware.breakout.module.Distributor;
import com.elluminate.groupware.breakout.module.ReturnAllToMainRoomCmd;
import com.elluminate.groupware.breakout.module.ReturnAllToPreviousRoomsCmd;
import com.elluminate.groupware.breakout.module.StringsProperties;
import com.elluminate.groupware.imps.ParticipantSelectionListener;
import com.elluminate.groupware.imps.ParticipantSelectorAPI;
import com.elluminate.groupware.imps.TelephonyAPI;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.swing.CMenu;
import com.elluminate.gui.swing.CMenuItem;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientGroupEvent;
import com.elluminate.jinx.ClientGroupListener;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class BreakoutModule
extends AbstractClientModule
implements ParticipantSelectionListener,
ModulePublisherInfo,
PropertyChangeListener,
ClientGroupListener {
    private final I18n i18n = I18n.create((Object)this);
    private static final String MODULE_NAME = "Breakout";
    private DialogParentProvider parentProvider;
    private ClientProvider clientProvider;
    static final int MAX_NAME_LENGTH = 128;
    private static final String MOVE_TO_ROOM = "/breakout/notice/moveToRoom";
    private FeatureBroker broker;
    private BooleanFeature allowSelfMoveFeature;
    private ActionFeature distributeFeature;
    private ActionFeature returnFromBORFeature;
    private ActionFeature returnAllFromBORFeature;
    private ActionFeature redistributeFeature;
    private ActionFeature closeBORFeature;
    private ActionFeature closeAllBORFeature;
    private ActionFeature renameBORFeature;
    private EnumeratedFeature<String> sendSelfToBORFeature;
    private EnumeratedFeature<String> sendToBORFeature;
    private ActionFeature moveParameterizedFeature;
    private ActionFeature enterFeature;
    private StringFeature currentRoomFeature;
    private ParticipantSelectorAPI selector = null;
    private JMenu joinPopup;
    private JMenuItem joinMainPopup;
    private JMenuItem joinPrivPopup;
    private JMenuItem openPopup;
    private JMenuItem closePopup;
    private JMenuItem renamePopup;
    private JMenuItem rejoinPopup;
    private JMenuItem distPopup;
    private ClientList clients = null;
    private BreakoutBean breakout = null;
    private Provider<BreakoutBean> beanProvider;
    private boolean includeMods = false;
    private Imps imps = null;
    private boolean doNotify = false;
    private Object rebuildLock = new Object();
    private List<String> breakoutRooms = new ArrayList<String>();
    private Object breakoutRoomsLock = new Object();
    private static final int MAX_MENU_COUNT_DEFAULT = 10;
    private boolean maxMenuOverride = false;
    private ConferencingEngine confEngine;
    private Provider<CloseAllRoomsCmd> closeAllRoomsCmd;
    private Provider<CloseRoomCmd> closeRoomCmd;
    private Provider<CreateRoomCmd> createRoomCmd;
    private Provider<CreateRoomsAndDistributeCmd> createRoomsAndDistributeCmd;
    private Provider<CreateRoomsAndSplitCmd> createRoomsAndSplitCmd;
    private Provider<ReturnAllToMainRoomCmd> returnAllToMainRoomCmd;
    private Provider<ReturnAllToPreviousRoomsCmd> returnAllToPreviousRoomsCmd;
    private Comparator ignoreCaseComparator = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            int com = ((String)obj1).compareToIgnoreCase((String)obj2);
            return com;
        }
    };

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Inject
    public void initComponentRegistrar(ComponentRegistrar cr) {
        cr.registerComponent((Object)this);
    }

    @Inject
    public void initBreakoutBeanProvider(Provider<BreakoutBean> bp) {
        this.beanProvider = bp;
    }

    @Inject
    public void initParentProvider(DialogParentProvider parentProvider) {
        this.parentProvider = parentProvider;
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initConferencingEngine(ConferencingEngine ce) {
        this.confEngine = ce;
    }

    @Inject
    public void initCloseAllRoomsCmd(Provider<CloseAllRoomsCmd> cp) {
        this.closeAllRoomsCmd = cp;
    }

    @Inject
    public void initCloseRoomCmd(Provider<CloseRoomCmd> cp) {
        this.closeRoomCmd = cp;
    }

    @Inject
    public void initCreateRoomCmd(Provider<CreateRoomCmd> cp) {
        this.createRoomCmd = cp;
    }

    @Inject
    public void initCreateRoomsAndDistributeCmd(Provider<CreateRoomsAndDistributeCmd> cp) {
        this.createRoomsAndDistributeCmd = cp;
    }

    @Inject
    public void initCreateRoomsAndSplitCmd(Provider<CreateRoomsAndSplitCmd> cp) {
        this.createRoomsAndSplitCmd = cp;
    }

    @Inject
    public void initReturnAllToMainRoomCmd(Provider<ReturnAllToMainRoomCmd> cp) {
        this.returnAllToMainRoomCmd = cp;
    }

    @Inject
    public void initReturnAllToPreviousRoomsCmd(Provider<ReturnAllToPreviousRoomsCmd> cp) {
        this.returnAllToPreviousRoomsCmd = cp;
    }

    @Inject
    public BreakoutModule() {
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getDisplayNameOfModule() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_TITLE);
    }

    public Icon getModuleIcon() {
        return this.i18n.getIcon("Breakout.icon");
    }

    public void setupUI() {
        this.setupMenus();
        this.updateLabels();
        this.updateRejoinMenus();
        this.selector = (ParticipantSelectorAPI)this.imps.findBest(ParticipantSelectorAPI.class);
        if (this.selector != null) {
            this.selector.addSelectionListener((ParticipantSelectionListener)this);
        }
        this.broker.announceNotification((Object)this, MOVE_TO_ROOM);
    }

    public void cleanupUI() {
    }

    public void attach() {
        Client theClient = this.clientProvider.get();
        this.breakout = (BreakoutBean)this.beanProvider.get();
        this.breakout.setClient(theClient);
        this.clients = theClient.getClientList();
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("breakout.autoMobile", (PropertyChangeListener)this);
        theClient.addClientGroupListener((ClientGroupListener)this);
        this.clients.addPropertyChangeListener("Label.group", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.groups", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.Groups", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.participants", (PropertyChangeListener)this);
        this.clients.addClientListener(new ClientListener(){

            public void onAddClient(ClientEvent e) {
                if (e.isMe()) {
                    BreakoutModule.this.doNotify = true;
                }
            }

            public void onRemoveClient(ClientEvent e) {
                if (e.isMe()) {
                    BreakoutModule.this.doNotify = false;
                }
            }
        });
        theClient.addClientGroupListener(new ClientGroupListener(){

            public void clientGroupCreated(ClientGroupEvent event) {
            }

            public void clientGroupDeleted(ClientGroupEvent event) {
            }

            public void clientGroupRenamed(ClientGroupEvent event) {
            }

            public void clientGroupChanged(ClientGroupEvent event) {
                ClientInfo who = event.getClient();
                Connection client = who.getClientList().getConnection();
                if (who.isMe() && BreakoutModule.this.doNotify) {
                    String roomName = event.getGroupName();
                    if (event.getGroupID() == 0) {
                        roomName = BreakoutModule.this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_DEFAULTGROUPNAME);
                    } else if (roomName == null || roomName.length() == 0) {
                        roomName = LabelProps.get((PropertyAccessAPI)BreakoutModule.this.clients, (String)"Label.session");
                    }
                    String msg1 = BreakoutModule.this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_MOVETOROOM, new Object[]{roomName});
                    BreakoutModule.this.broker.sendNotification((Object)this, BreakoutModule.MOVE_TO_ROOM, msg1, client.getSessionTime());
                }
            }
        });
    }

    protected BreakoutBean getBean() {
        return this.breakout;
    }

    private void buildSendSelf(List menuItems) {
        ClientGroup grp;
        String rm = LabelProps.get(null, (String)"Label.Group");
        String TXT_MAIN_ROOM = this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_MAINROOM);
        String VAL_MAIN_ROOM = "_main";
        String initialValue = "_main";
        ClientInfo info = this.clients.getMyClient();
        if (info != null && (grp = info.getGroup()) != null && grp.getGroupID() != 0) {
            initialValue = grp.getName();
        }
        ArrayList<String> allMenuItems = new ArrayList<String>(menuItems);
        Collections.sort(allMenuItems, this.ignoreCaseComparator);
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: buildSendSelf (" + allMenuItems.size() + " items + main)");
        }
        allMenuItems.add(0, "_main");
        this.sendSelfToBORFeature = this.broker.createEnumeratedFeature((Object)this, "/breakout/sendSelfTo", String.class, true, (Object)initialValue, allMenuItems, this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_SELFMENU, new Object[]{rm}), this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_SELFMENU, new Object[]{rm}));
        this.sendSelfToBORFeature.setValueText((Object)"_main", TXT_MAIN_ROOM);
        this.sendSelfToBORFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                if (BreakoutProtocol.DEBUG.show()) {
                    System.out.println("breakout: sendSelfToBOR clicked.  id = '" + event.getID() + "'  new sendSelf value = '" + event.getNewValue() + "'");
                }
                if (event.getNewValue().equals("_main")) {
                    BreakoutModule.this.doJoinMainSelf();
                } else {
                    BreakoutModule.this.doFeatureJoin(true, (String)event.getNewValue());
                }
            }
        });
        this.sendSelfToBORFeature.setEnabled(true);
    }

    private void buildSendTo(List<?> menuItems) {
        String rm = LabelProps.get(null, (String)"Label.Group");
        String TXT_SNDTO_MAIN_ROOM = this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_MAINROOM);
        String TXT_SNDTO_PRIV_ROOM = this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_PRIVROOM, new Object[]{rm});
        String VAL_SNDTO_MAIN_ROOM = "_main";
        String VAL_SNDTO_PRIV_ROOM = "_priv";
        Chair chair = ChairProtocol.getChair((ClientList)this.clients);
        boolean isChair = chair.isMe();
        ArrayList<String> rooms = new ArrayList<String>();
        for (ClientInfo info : this.getSelectedParticipants()) {
            String name;
            ClientGroup grp = info.getGroup();
            if (grp == null || rooms.contains(name = grp.getGroupID() == 0 ? "_main" : grp.getName())) continue;
            rooms.add(name);
        }
        String initialValue = !rooms.isEmpty() ? (String)rooms.get(0) : "_main";
        ArrayList allMenuItems = new ArrayList(menuItems);
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: buildSendTo (" + allMenuItems.size() + " items + main + priv)");
        }
        Collections.sort(allMenuItems, this.ignoreCaseComparator);
        allMenuItems.add(0, "_main");
        if (isChair) {
            allMenuItems.add(allMenuItems.size(), "_priv");
        }
        this.sendToBORFeature = this.broker.createEnumeratedFeature((Object)this, "/breakout/sendTo", String.class, true, (Object)initialValue, allMenuItems, this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_JOINMENU, new Object[]{rm}), this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_JOINMENU, new Object[]{rm}));
        this.sendToBORFeature.setValueText((Object)"_main", TXT_SNDTO_MAIN_ROOM);
        if (isChair) {
            this.sendToBORFeature.setValueText((Object)"_priv", TXT_SNDTO_PRIV_ROOM);
        }
        this.sendToBORFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                if (BreakoutProtocol.DEBUG.show()) {
                    System.out.println("breakout: sendToBOR clicked.  id = '" + event.getID() + "'  new sendTo value = '" + event.getNewValue() + "'");
                }
                if (event.getNewValue().equals("_main")) {
                    BreakoutModule.this.doJoinMain();
                } else if (event.getNewValue().equals("_priv")) {
                    BreakoutModule.this.doJoinPriv();
                } else {
                    BreakoutModule.this.doFeatureJoin(false, (String)event.getNewValue());
                }
            }
        });
        this.sendToBORFeature.setEnabled(true);
    }

    private void setupMenus() {
        String rm = LabelProps.get(null, (String)"Label.Group");
        String rms = LabelProps.get(null, (String)"Label.Groups");
        String parts = LabelProps.get(null, (String)"Label.Participants");
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: setupMenus");
        }
        this.allowSelfMoveFeature = this.broker.createBooleanFeature((Object)this, "/breakout/allowSelfMove", true, true, this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_SELFMOVEMODE, new Object[]{parts, rms}), this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_SELFMOVEMODE, new Object[]{parts, rms}));
        this.allowSelfMoveFeature.setValue((Object)false);
        this.allowSelfMoveFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_SELFMOVEMODE, new Object[]{parts, rms}));
        this.allowSelfMoveFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_SELFMOVEMODE, new Object[]{parts, rms}));
        this.allowSelfMoveFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                if (BreakoutProtocol.DEBUG.show()) {
                    System.out.println("breakout: allowSelfMoveFeature clicked <==== [ HANDLING THIS ]");
                }
                BreakoutModule.this.doToggleSelfMoveMode();
            }
        });
        this.distributeFeature = this.broker.createActionFeature((Object)this, "/breakout/distribute", this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_DISTRIBUTE, new Object[]{rms}), this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_DISTRIBUTE, new Object[]{rms}));
        this.distributeFeature.setInteractive(true);
        this.distributeFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (BreakoutProtocol.DEBUG.show()) {
                    System.out.println("breakout: distributeFeature clicked <==== [ HANDLING THIS ]");
                }
                BreakoutModule.this.doDistribute();
            }
        });
        this.returnFromBORFeature = this.broker.createActionFeature((Object)this, "/breakout/return", this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_REJOIN), this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_REJOIN));
        this.returnFromBORFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (BreakoutProtocol.DEBUG.show()) {
                    System.out.println("breakout: returnFromBORFeature clicked <==== [ HANDLING THIS ]");
                }
                BreakoutModule.this.doJoinMainFromRooms();
            }
        });
        this.returnAllFromBORFeature = this.broker.createActionFeature((Object)this, "/breakout/returnAll", this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_REJOINALL), this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_REJOINALL));
        this.returnAllFromBORFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (BreakoutProtocol.DEBUG.show()) {
                    System.out.println("breakout: returnAllFromBORFeature clicked <==== [ HANDLING THIS ]");
                }
                BreakoutModule.this.breakout.rejoin();
            }
        });
        this.redistributeFeature = this.broker.createActionFeature((Object)this, "/breakout/redistribute", this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_REDISTRIBUTE, new Object[]{rms}), this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_REDISTRIBUTE, new Object[]{rms}));
        this.redistributeFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (BreakoutProtocol.DEBUG.show()) {
                    System.out.println("breakout: redistributeFeature clicked <==== [ HANDLING THIS ]");
                }
                BreakoutModule.this.doRedistribute();
            }
        });
        this.closeBORFeature = this.broker.createActionFeature((Object)this, "/breakout/close", this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_CLOSE, new Object[]{rm}), this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_CLOSE, new Object[]{rm}));
        this.closeBORFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (BreakoutProtocol.DEBUG.show()) {
                    System.out.println("breakout: closeBORFeature clicked <==== [ ALMOST HANDLING THIS (can't select room) ]");
                }
                BreakoutModule.this.doDeleteRooms(false);
            }
        });
        this.closeAllBORFeature = this.broker.createActionFeature((Object)this, "/breakout/closeAll", this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_CLOSEALL, new Object[]{rm}), this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_CLOSEALL, new Object[]{rm}));
        this.closeAllBORFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (BreakoutProtocol.DEBUG.show()) {
                    System.out.println("breakout: closeAllBORFeature clicked <==== [ HANDLING THIS ]");
                }
                BreakoutModule.this.doDeleteRooms(true);
            }
        });
        this.renameBORFeature = this.broker.createActionFeature((Object)this, "/breakout/rename", this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_RENAMEROOM, new Object[]{rm}), this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_RENAMEROOM, new Object[]{rm}));
        this.renameBORFeature.setInteractive(true);
        this.renameBORFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (BreakoutProtocol.DEBUG.show()) {
                    System.out.println("breakout: renameBORFeature clicked <==== [ ALMOST HANDLING THIS (can't select room) ]");
                }
                BreakoutModule.this.doRenameRoom();
            }
        });
        ArrayList<ActionParameterDescriptor> paramDescs = new ArrayList<ActionParameterDescriptor>();
        paramDescs.add(new ActionParameterDescriptor("participants", ActionParameterDescriptor.Type.PARTICIPANT, 1, Integer.MAX_VALUE));
        paramDescs.add(new ActionParameterDescriptor("room", ActionParameterDescriptor.Type.ROOM, 1, 1));
        this.moveParameterizedFeature = this.broker.createActionFeature((Object)this, "/breakout/moveParameterized", paramDescs, null, null);
        this.moveParameterizedFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent e) {
                if (BreakoutProtocol.DEBUG.show()) {
                    System.out.println("breakout: moveFeature invoked <==== [ HANDLING THIS ]");
                }
                Collection ps = e.getParameterAsCollectionOf(CRParticipant.class, "participants");
                CRRoom r = (CRRoom)e.getParameterAs(CRRoom.class, "room");
                boolean success = BreakoutModule.this.doJoinParameterized(ps, r);
                e.setComplete(success);
            }
        });
        this.enterFeature = this.broker.createActionFeature((Object)this, "/breakout/enter", this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_ENTERROOM, new Object[]{rm}), this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_ENTERROOM, new Object[]{rm}));
        this.enterFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (BreakoutProtocol.DEBUG.show()) {
                    System.out.println("breakout: enterFeature clicked <==== [ HANDLING THIS ]");
                }
                BreakoutModule.this.doJoinRoomSelf();
            }
        });
        this.currentRoomFeature = this.broker.createStringFeature((Object)this, "/breakout/currentRoom", false, null, this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_MAINROOMNAME), null);
        this.buildSendSelf(new ArrayList());
        this.buildSendTo(new ArrayList());
        this.allowSelfMoveFeature.setEnabled(false);
        this.distributeFeature.setEnabled(true);
        this.returnFromBORFeature.setEnabled(true);
        this.returnAllFromBORFeature.setEnabled(true);
        this.redistributeFeature.setEnabled(true);
        this.closeBORFeature.setEnabled(true);
        this.closeAllBORFeature.setEnabled(true);
        this.renameBORFeature.setEnabled(true);
        this.moveParameterizedFeature.setEnabled(true);
        this.enterFeature.setEnabled(true);
        this.currentRoomFeature.setEnabled(true);
        this.joinPopup = new CMenu(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_JOINMENU, new Object[]{rm}));
        this.joinMainPopup = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_MAINROOM));
        this.joinMainPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakoutModule.this.doJoinMain();
            }
        });
        this.joinPrivPopup = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_PRIVROOM, new Object[]{rm}));
        this.joinPrivPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakoutModule.this.doJoinPriv();
            }
        });
        this.joinPopup.add(this.joinMainPopup);
        this.joinPopup.add(this.joinPrivPopup);
        this.openPopup = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_CREATEROOM, new Object[]{rm}));
        this.openPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakoutModule.this.doCreateRoom();
            }
        });
        this.closePopup = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_CLOSE, new Object[]{rm}));
        this.closePopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakoutModule.this.doDeleteRooms(true);
            }
        });
        this.renamePopup = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_RENAMEROOM, new Object[]{rm}));
        this.renamePopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakoutModule.this.doRenameRoom();
            }
        });
        this.rejoinPopup = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_REJOIN));
        this.rejoinPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakoutModule.this.breakout.rejoin();
            }
        });
        this.distPopup = new CMenuItem(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_DISTRIBUTE, new Object[]{parts}));
        this.distPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakoutModule.this.doDistribute();
            }
        });
    }

    public void detach() {
        this.clients.removePropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("breakout.autoMobile", (PropertyChangeListener)this);
        this.clientProvider.get().removeClientGroupListener((ClientGroupListener)this);
        this.clients.removePropertyChangeListener("Label.group", (PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("Label.groups", (PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("Label.Groups", (PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("Label.participants", (PropertyChangeListener)this);
    }

    public void start() {
        this.confEngine.registerCommand(this.closeAllRoomsCmd);
        this.confEngine.registerCommand(this.closeRoomCmd);
        this.confEngine.registerCommand(this.createRoomCmd);
        this.confEngine.registerCommand(this.createRoomsAndDistributeCmd);
        this.confEngine.registerCommand(this.createRoomsAndSplitCmd);
        this.confEngine.registerCommand(this.returnAllToMainRoomCmd);
        this.confEngine.registerCommand(this.returnAllToPreviousRoomsCmd);
    }

    public void stop() {
    }

    public void participantSelectionChanged() {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: participantSelectionChanged");
        }
        this.updateUI();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: propertyChange");
        }
        if (e.getPropertyName().equals("chair") || e.getPropertyName().equals("breakout.autoMobile")) {
            this.updateUI();
        } else {
            this.updateLabels();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUI() {
        boolean showRename;
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: updateUI");
        }
        if (this.clients == null) {
            return;
        }
        Chair chair = ChairProtocol.getChair((ClientList)this.clients);
        int nUsers = 0;
        int nGroups = 0;
        boolean isTransient = false;
        boolean moveSelf = this.clients.getProperty("breakout.autoMobile", false);
        boolean selfSelected = false;
        if (this.selector != null) {
            List users = this.selector.getSelectedParticipants();
            nUsers = users.size();
            List groups = this.selector.getSelectedGroups();
            nGroups = groups.size();
            if (nGroups > 0) {
                isTransient = ((ClientGroup)groups.get(0)).isTransient();
            }
            selfSelected = nUsers == 1 && nGroups == 0 && ((CRParticipant)users.get(0)).isMe();
        }
        boolean showChair = chair.isMe();
        boolean showMenu = chair.isMe() && this.selector != null;
        boolean showJoin = chair.isMe() && nUsers > 0 && nGroups == 0;
        boolean showClose = chair.isMe() && nUsers == 0 && nGroups > 0;
        boolean bl = showRename = chair.isMe() && nUsers == 0 && nGroups == 1 && !isTransient;
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: showChair = " + showChair);
            System.out.println("breakout: showMenu = " + showMenu);
            System.out.println("breakout: showJoin = " + showJoin);
            System.out.println("breakout: moveSelf = " + moveSelf);
            System.out.println("breakout: chair.isMe() = " + chair.isMe());
            System.out.println("breakout: nUsers = " + nUsers);
            System.out.println("breakout: nGroups = " + nGroups);
            System.out.println("breakout: selfSelected = " + selfSelected);
            System.out.println("breakout: isTransient = " + isTransient);
            System.out.println("breakout: selector!=null = " + (this.selector != null));
        }
        this.allowSelfMoveFeature.setEnabled(showChair);
        this.allowSelfMoveFeature.setValue((Object)moveSelf);
        ArrayList<String> rooms = new ArrayList<String>(this.breakoutRooms);
        this.broker.setFeaturePublished((Feature)this.allowSelfMoveFeature, showChair);
        this.broker.setFeaturePublished((Feature)this.distributeFeature, showChair);
        this.broker.setFeaturePublished((Feature)this.returnFromBORFeature, showChair && nGroups > 0);
        this.broker.setFeaturePublished((Feature)this.returnAllFromBORFeature, showChair && !rooms.isEmpty());
        this.broker.setFeaturePublished((Feature)this.redistributeFeature, showChair && !rooms.isEmpty());
        this.broker.setFeaturePublished((Feature)this.closeBORFeature, showClose);
        this.broker.setFeaturePublished((Feature)this.closeAllBORFeature, showChair && !rooms.isEmpty());
        Object object = this.rebuildLock;
        synchronized (object) {
            this.rebuildRoomMenus();
            this.broker.setFeaturePublished(this.sendToBORFeature, showJoin);
            this.broker.setFeaturePublished(this.sendSelfToBORFeature, !rooms.isEmpty() && (showChair || moveSelf));
        }
        this.broker.setFeaturePublished((Feature)this.currentRoomFeature, !rooms.isEmpty());
        this.broker.setFeaturePublished((Feature)this.renameBORFeature, showRename);
        this.broker.setFeaturePublished((Feature)this.moveParameterizedFeature, (showChair || moveSelf) && !rooms.isEmpty());
        this.broker.setFeaturePublished((Feature)this.enterFeature, (showChair || moveSelf) && nGroups == 1);
        String desc = nGroups > 1 ? LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Groups") : LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Group");
        String rms = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Groups");
        String parts = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Participants");
        this.closePopup.setText(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_CLOSE, new Object[]{desc}));
        this.closeBORFeature.setName(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_CLOSE, new Object[]{desc}));
        this.closeAllBORFeature.setName(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_CLOSEALL, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Groups")}));
        this.distPopup.setText(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_DISTRIBUTE, new Object[]{parts}));
        this.distributeFeature.setName(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_DISTRIBUTE, new Object[]{rms}));
        this.redistributeFeature.setName(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_REDISTRIBUTE, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Groups")}));
        this.updateRejoinMenus();
    }

    private void updateLabels() {
        int nGroups = 1;
        String rm = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Group");
        String rms = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Groups");
        String parts = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Participants");
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: updateLabels <===== FIXME: SUBSEQUENT setName()s NOT YET HANDLED BY APP SHELL");
        }
        if (this.selector != null) {
            nGroups = this.selector.getSelectedRoomCount();
        }
        this.rebuildFeatureMenu((AbstractFeature)this.sendToBORFeature, this.breakoutRooms);
        this.sendSelfToBORFeature.setName(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_SELFMENU, new Object[]{rm}));
        this.distributeFeature.setName(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_DISTRIBUTE, new Object[]{rms}));
        this.renameBORFeature.setName(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_RENAMEROOM, new Object[]{rm}));
        this.enterFeature.setName(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_ENTERROOM, new Object[]{rm}));
        this.allowSelfMoveFeature.setName(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_SELFMOVEMODE, new Object[]{parts, rms}));
        this.joinPopup.setText(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_JOINMENU, new Object[]{rm}));
        this.joinPrivPopup.setText(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_PRIVROOM, new Object[]{rm}));
        this.openPopup.setText(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_CREATEROOM, new Object[]{rm}));
        this.distPopup.setText(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_DISTRIBUTE, new Object[]{parts}));
        this.renamePopup.setText(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_RENAMEROOM, new Object[]{rm}));
        if (nGroups > 1) {
            this.closePopup.setText(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_CLOSE, new Object[]{rms}));
            this.closeBORFeature.setName(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_CLOSE, new Object[]{rms}));
        } else {
            this.closePopup.setText(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_CLOSE, new Object[]{rm}));
            this.closeBORFeature.setName(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_CLOSE, new Object[]{rm}));
        }
    }

    private void doJoinMain() {
        ClientInfo[] who;
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: doJoinMain");
        }
        if ((who = this.getSelectedParticipants()).length == 0) {
            return;
        }
        this.breakout.join(this.clients.getClientGroup((short)0), who);
    }

    private void doJoinMainSelf() {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: doJoinMainSelf");
        }
        if (this.clients == null) {
            return;
        }
        ClientInfo[] who = new ClientInfo[]{this.clients.getMyClient()};
        this.breakout.join(this.clients.getClientGroup((short)0), who);
    }

    private void doJoinRoomSelf() {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: doJoinMainSelf");
        }
        if (this.clients == null) {
            return;
        }
        ClientGroup[] grps = this.getSelectedGroups();
        if (grps.length != 1) {
            return;
        }
        ClientInfo[] who = new ClientInfo[]{this.clients.getMyClient()};
        this.breakout.join(grps[0], who);
    }

    private void doJoinMainFromRooms() {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: doJoinMain");
        }
        ArrayList who = new ArrayList();
        for (ClientGroup grp : this.getSelectedGroups()) {
            Collections.addAll(who, grp.getMembers());
        }
        if (who.isEmpty()) {
            return;
        }
        this.breakout.join(this.clients.getClientGroup((short)0), who.toArray(new ClientInfo[0]));
    }

    private void doJoinPriv() {
        ClientInfo[] who;
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: doJoinPriv");
        }
        if ((who = this.getSelectedParticipants()).length == 0) {
            return;
        }
        this.breakout.create(null, who, true);
    }

    private void doFeatureJoin(boolean self, String groupName) {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: doFeatureJoin( " + groupName + " )");
        }
        ClientInfo[] who = null;
        if (self) {
            if (this.clients == null) {
                return;
            }
            who = new ClientInfo[]{this.clients.getMyClient()};
        } else {
            who = this.getSelectedParticipants();
            if (who.length == 0) {
                System.out.println("breakout: doFeatureJoin: bailing");
                return;
            }
        }
        try {
            ClientGroup grp = this.clients.getClientGroup(groupName);
            this.warnOnTelephonyError(grp, who);
            this.breakout.join(grp, who);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"doJoin", (Throwable)ex, (boolean)true);
        }
    }

    private boolean doJoinParameterized(Collection<CRParticipant> participants, CRRoom room) {
        Chair chair = ChairProtocol.getChair((ClientList)this.clients);
        boolean canMoveSelf = this.clients.getProperty("breakout.autoMobile", false);
        ArrayList<ClientInfo> infos = new ArrayList<ClientInfo>();
        for (CRParticipant p : participants) {
            ClientInfo info = this.clients.get(p.getID());
            if (info == null || !chair.isMe() && (!canMoveSelf || !info.isMe())) continue;
            infos.add(info);
        }
        if (infos.isEmpty()) {
            return false;
        }
        ClientInfo[] who = infos.toArray(new ClientInfo[0]);
        try {
            ClientGroup grp = this.clients.getClientGroup(room.getID());
            if (grp == null) {
                return false;
            }
            this.warnOnTelephonyError(grp, who);
            this.breakout.join(grp, who);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"doJoinParameterized", (Throwable)ex, (boolean)true);
            return false;
        }
        return true;
    }

    private void doJoin(ActionEvent e) {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: doJoin(AE)");
        }
        JMenuItem src = (JMenuItem)e.getSource();
        Container parent = src.getParent();
        ClientInfo[] who = null;
        who = this.getSelectedParticipants();
        if (who.length == 0) {
            return;
        }
        try {
            ClientGroup grp = this.clients.getClientGroup(e.getActionCommand());
            this.warnOnTelephonyError(grp, who);
            this.breakout.join(grp, who);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"doJoin", (Throwable)ex, (boolean)true);
        }
    }

    private void doJoin(ClientInfo[] who, ClientGroup grp) {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: doJoin(CI, CG)");
        }
        if (who.length == 0) {
            return;
        }
        try {
            this.warnOnTelephonyError(grp, who);
            this.breakout.join(grp, who);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"doJoin", (Throwable)ex, (boolean)true);
        }
    }

    protected void warnOnTelephonyError(ClientGroup grp, ClientInfo[] who) {
        if (who.length == 0) {
            return;
        }
        TelephonyAPI api = this.breakout.getTelephonyAPI();
        if (api == null || !api.isEnabled()) {
            return;
        }
        int clientBridge = 0;
        int clientTelephony = 0;
        ClientInfo bridgeCI = null;
        for (int i = 0; i < who.length; ++i) {
            int mode = api.getAudioMode(who[i].getAddress());
            if (mode == 3) {
                ++clientBridge;
                bridgeCI = who[i];
                continue;
            }
            if (mode != 2) continue;
            ++clientTelephony;
        }
        if (clientBridge == 0 && clientTelephony == 0) {
            return;
        }
        int grpBridges = 0;
        int grpTelephonyClients = 0;
        if (grp != null) {
            Iterator i = grp.visibleIterator();
            while (i.hasNext()) {
                Object infoObj = i.next();
                ClientInfo info = (ClientInfo)infoObj;
                int mode = api.getAudioMode(info.getAddress());
                if (mode == 3) {
                    ++grpBridges;
                    continue;
                }
                if (mode != 2) continue;
                ++grpTelephonyClients;
            }
        }
        if (clientTelephony > 0 && clientBridge == 0 && grpBridges == 0) {
            ModalDialog.showMessageDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_MOVINGTELEPHONYCLIENTINTOGRPWITHNOBRDGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_DISTRIBUTIONTELEPHONYWARNTITLE), (int)2);
            return;
        }
        if (clientTelephony == 0 && clientBridge > 0 && grpTelephonyClients == 0) {
            ModalDialog.showMessageDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_MOVINGTELEPHONYBRIDGEINTOGRPWITHNOTELEPHONYCLIENTS), (String)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_DISTRIBUTIONTELEPHONYWARNTITLE), (int)2);
            return;
        }
        if (bridgeCI != null) {
            short grpID = bridgeCI.getGroupID();
            ClientGroup srcGrp = this.clients.getClientGroup(grpID);
            Iterator i = srcGrp.visibleIterator();
            while (i.hasNext()) {
                Object infoObj = i.next();
                ClientInfo info = (ClientInfo)infoObj;
                int mode = api.getAudioMode(info.getAddress());
                if (mode != 2) continue;
                boolean foundInMoveList = false;
                for (int count = 0; count < who.length; ++count) {
                    if (!info.equals(who[count])) continue;
                    foundInMoveList = true;
                }
                if (foundInMoveList) continue;
                ModalDialog.showMessageDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_MOVINGTELEPHONYBRIDGEOUTOFGRPWITHTELEPHONYCLIENTS), (String)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_DISTRIBUTIONTELEPHONYWARNTITLE), (int)2);
                return;
            }
        }
    }

    private void doCreateRoom() {
        String name;
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: doCreateRoom");
        }
        if ((name = ModalDialog.showInputDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_CREATEPROMPT, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.group")}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_CREATETITLE, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Group")}), (int)-1)) == null) {
            return;
        }
        if ((name = name.trim()).equals("")) {
            return;
        }
        if (name.length() > 128) {
            ModalDialog.showMessageDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_TOOLONGMSG), (String)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_TOOLONGTITLE), (int)0);
            return;
        }
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: doCreateRoom: name '" + name + "'");
        }
        ClientInfo[] who = new ClientInfo[]{};
        this.breakout.create(name, who, false);
    }

    private void doDeleteRooms(boolean all) {
        ClientGroup[] which;
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: doDeleteRoom");
        }
        if ((which = all ? this.getAllGroups() : this.getSelectedGroups()).length == 0) {
            return;
        }
        this.breakout.delete(which);
    }

    private void doRenameRoom() {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: doRenameRoom");
        }
        ClientGroup[] which = this.getSelectedGroups();
        String oldName = which[0].getName();
        String name = ModalDialog.showInputDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_RENAMEPROMPT, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.group")}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_RENAMETITLE, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Group")}), (int)-1, (String)oldName);
        if (name == null) {
            return;
        }
        if ((name = name.trim()).equals("")) {
            return;
        }
        if (name.length() > 128) {
            ModalDialog.showMessageDialog((Component)this.parentProvider.getDialogParent(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_TOOLONGMSG), (String)this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_TOOLONGTITLE), (int)0);
            return;
        }
        this.breakout.rename(which[0], name);
    }

    private void doDistribute() {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: doDistribute");
        }
        Distributor d = new Distributor(this.parentProvider.getDialogParent(), this.clients);
        d.show();
        if (!d.wasCanceled()) {
            String roomName = d.getRoomName();
            int roomCount = d.getRoomCount();
            this.includeMods = d.isIncludingModerators();
            switch (d.getDistributeOption()) {
                case 0: {
                    if (roomCount == 1) {
                        this.breakout.create(roomName, new ClientInfo[0], false);
                        break;
                    }
                    if (roomCount <= 1) break;
                    for (int i = 0; i < roomCount; ++i) {
                        StringBuilder b = new StringBuilder();
                        b.append(roomName);
                        b.append(' ');
                        b.append(String.valueOf(i + 1));
                        this.breakout.create(b.toString(), new ClientInfo[0], false);
                    }
                    break;
                }
                case 1: {
                    this.breakout.distNGroups(roomCount, roomName, this.includeMods);
                    break;
                }
                case 2: {
                    int roomSize = d.getRoomSize();
                    this.breakout.distNPeople(roomSize, roomName, this.includeMods);
                }
            }
        }
    }

    private void doRedistribute() {
        this.breakout.redist(this.includeMods);
    }

    public void doToggleSelfMoveMode() {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: doToggleSelfMoveMode");
        }
        boolean selected = (Boolean)this.allowSelfMoveFeature.getValue();
        boolean current = this.clients.getProperty("breakout.autoMobile", false);
        Chair chair = ChairProtocol.getChair((ClientList)this.clients);
        if (!chair.isMe()) {
            if (BreakoutProtocol.DEBUG.show()) {
                System.out.println("breakout: doToggleSelfMoveMode: NOT chair, so not updating setting");
            }
            return;
        }
        if (current == selected) {
            if (BreakoutProtocol.DEBUG.show()) {
                System.out.println("breakout: doToggleSelfMoveMode: current == selected, so not updating setting");
            }
            return;
        }
        this.clients.setProperty("breakout.autoMobile", selected);
    }

    public void clientGroupCreated(ClientGroupEvent e) {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: clientGroupCreated");
        }
        String name = e.getGroupName();
        if (e.getGroupID() == 0) {
            return;
        }
        this.addItem(name);
        this.updateUI();
    }

    public void clientGroupDeleted(ClientGroupEvent e) {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: clientGroupDeleted");
        }
        String name = e.getGroupName();
        if (e.getGroupID() == 0) {
            return;
        }
        this.removeItem(name);
        this.updateUI();
    }

    public void clientGroupRenamed(ClientGroupEvent e) {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: clientGroupRenamed");
        }
        String oldName = e.getPreviousGroupName();
        String newName = e.getGroupName();
        if (e.getGroupID() == 0) {
            return;
        }
        this.removeItem(oldName);
        this.addItem(newName);
        this.rebuildRoomMenus();
    }

    public void clientGroupChanged(ClientGroupEvent e) {
        if (BreakoutProtocol.DEBUG.show()) {
            System.out.println("breakout: clientGroupChanged");
        }
        if (e.getClient().isMe()) {
            this.updateRejoinMenus();
            String roomName = e.getGroupID() == 0 ? this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_MAINROOMNAME) : e.getGroupName();
            this.currentRoomFeature.setName(roomName);
        }
    }

    private void updateRejoinMenus() {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean clientsToMove = !BreakoutModule.this.breakout.areAllClientsInMainRoom();
                BreakoutModule.this.returnAllFromBORFeature.setEnabled(clientsToMove);
                BreakoutModule.this.rejoinPopup.setVisible(clientsToMove);
            }
        });
    }

    private int getMaxMenuItems(JMenu menu) {
        if (menu == null || this.maxMenuOverride) {
            return 10;
        }
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int fontHeight = menu.getFont().getSize() * 2;
        return (int)((double)screenHeight * 0.5) / fontHeight;
    }

    private void buildMenu(JMenu parent, List menuItemsParam, int maxCount) {
        ArrayList menuItems = new ArrayList(menuItemsParam);
        if (parent == null || menuItems == null || maxCount < 1) {
            return;
        }
        Collections.sort(menuItems, this.ignoreCaseComparator);
        if (menuItems.size() <= maxCount) {
            for (String name : menuItems) {
                this.addItemToMenu(parent, name);
            }
            return;
        }
        List subset = menuItems.subList(0, maxCount);
        List remaining = menuItems.subList(maxCount, menuItems.size());
        for (String name : subset) {
            this.addItemToMenu(parent, name);
        }
        CMenu submenu = new CMenu(this.i18n.getString((PropertiesEnum)StringsProperties.BREAKOUTMODULE_MORESUBMENU));
        parent.add((JMenuItem)submenu);
        this.buildMenu((JMenu)submenu, remaining, maxCount);
    }

    private void addItemToMenu(JMenu menu, String name) {
        CMenuItem item = new CMenuItem(name);
        item.setActionCommand(name);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakoutModule.this.doJoin(e);
            }
        });
        menu.add((JMenuItem)item);
    }

    private void rebuildRoomMenus() {
        ArrayList<String> rooms = new ArrayList<String>(this.breakoutRooms);
        this.rebuildFeatureMenu((AbstractFeature)this.sendToBORFeature, rooms);
        this.rebuildFeatureMenu((AbstractFeature)this.sendSelfToBORFeature, rooms);
        this.rebuildMenu(this.joinPopup, rooms);
    }

    private void rebuildFeatureMenu(AbstractFeature feature, List menuItems) {
        if (feature == this.sendToBORFeature) {
            this.sendToBORFeature.setEnabled(false);
            this.broker.removeFeature(this.sendToBORFeature);
            this.buildSendTo(menuItems);
        } else if (feature == this.sendSelfToBORFeature) {
            this.sendSelfToBORFeature.setEnabled(false);
            this.broker.removeFeature(this.sendSelfToBORFeature);
            this.buildSendSelf(menuItems);
        }
    }

    private void rebuildMenu(JMenu menu, List menuItems) {
        int maxCount = this.getMaxMenuItems(menu);
        Chair chair = ChairProtocol.getChair((ClientList)this.clients);
        boolean isChair = chair.isMe();
        menu.removeAll();
        if (menu == this.joinPopup) {
            menu.add(this.joinMainPopup);
            if (isChair) {
                menu.add(this.joinPrivPopup);
            }
        }
        if (menu.getItemCount() != 0 && menuItems != null && menuItems.size() != 0) {
            menu.addSeparator();
        }
        this.buildMenu(menu, menuItems, maxCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addItem(String name) {
        Object object = this.breakoutRoomsLock;
        synchronized (object) {
            if (name != null && !"".equals(name) && !this.breakoutRooms.contains(name)) {
                ArrayList<String> rooms = new ArrayList<String>(this.breakoutRooms);
                rooms.add(name);
                Collections.sort(rooms);
                this.breakoutRooms = rooms;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeItem(String name) {
        Object object = this.breakoutRoomsLock;
        synchronized (object) {
            if (name != null && !"".equals(name) && this.breakoutRooms.contains(name)) {
                ArrayList<String> rooms = new ArrayList<String>(this.breakoutRooms);
                rooms.remove(name);
                Collections.sort(rooms);
                this.breakoutRooms = rooms;
            }
        }
    }

    private ClientInfo[] getSelectedParticipants() {
        if (this.selector == null) {
            return new ClientInfo[0];
        }
        List list = this.selector.getSelectedClients();
        ClientInfo[] array = new ClientInfo[list.size()];
        return list.toArray(array);
    }

    private ClientGroup[] getAllGroups() {
        ArrayList<ClientGroup> list = new ArrayList<ClientGroup>();
        Iterator itr = this.clients.groupIterator();
        while (itr.hasNext()) {
            ClientGroup grp = (ClientGroup)itr.next();
            if (grp.getGroupID() == 0) continue;
            list.add(grp);
        }
        ClientGroup[] array = new ClientGroup[list.size()];
        return list.toArray(array);
    }

    private ClientGroup[] getSelectedGroups() {
        if (this.selector == null) {
            return new ClientGroup[0];
        }
        List list = this.selector.getSelectedGroups();
        ClientGroup[] array = new ClientGroup[list.size()];
        return list.toArray(array);
    }
}

