/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.chat;

import com.elluminate.groupware.chat.Address;
import com.elluminate.groupware.chat.Chat;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.DefaultProtocolResponder;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.jinx.ProtocolResponder;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.log.LogSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;

public class ChatProtocol
extends JinxProtocolAdapter {
    public static final byte DIRECT_MESSAGE = 1;
    public static final byte WELCOME = 2;
    public static final byte ANNOUNCEMENT = 0;
    public static final byte BODY = 1;
    public static final byte HDR_FROM = 2;
    public static final byte HDR_TO = 3;
    public static final byte HDR_TO_ALL = 4;
    public static final byte HDR_TO_ALL_ROOMS = 5;
    public static final byte HDR_BCC = 6;
    public static final byte HDR_TO_ALL_MODERATORS = 7;
    public static final String CHANNEL = "directMessaging";
    public static final byte PRIORITY = 2;
    public static final String ACCESS_PROPERTY = "directMessagingFloor";
    public static final String ACTIVE_PROPERTY = "directMessagingActive";
    public static final String MONITORED_PROPERTY = "directMessagingMonitored";
    public static final String TRANSCRIPT_PROPERTY = "directMessagingTranscript";
    public static final String CHAT_ACTIVE_PROPERTY = "directMessagingChatActive";
    public static final String EMOTICONS_ENABLED_PROPERTY = "directMessagingEmoticonsEnabled";
    public static final String EMOTICONS_LOCK_STATE_PROPERTY = "directMessagingEmoticonsLockState";
    public static final String PRIVATE_CHAT_RESTRICTED_PROPERTY = "directMessagingPrivateChatRestricted";
    public static final String CHAT_RESPONDER_GENERATOR = "chatTesters";
    private ClientList clients = null;
    private Short responderChatDelay = 0;
    private boolean isRecorder = true;

    public ChatProtocol() {
        this(false, true);
    }

    public ChatProtocol(boolean dftAccess, boolean monitored) {
        this.defineChannel(CHANNEL, (byte)2);
        this.defineProperty(ACCESS_PROPERTY, (byte)0, new Boolean(dftAccess));
        this.defineProperty(ACTIVE_PROPERTY, (byte)0, Boolean.FALSE);
        this.defineProperty(MONITORED_PROPERTY, (byte)1, monitored ? Boolean.TRUE : Boolean.FALSE);
        this.defineProperty(TRANSCRIPT_PROPERTY, (byte)1, Boolean.FALSE);
        this.defineProperty(CHAT_ACTIVE_PROPERTY, (byte)0, Boolean.FALSE);
        this.defineProperty(CHAT_RESPONDER_GENERATOR, (byte)1, this.responderChatDelay);
        this.defineProperty(EMOTICONS_ENABLED_PROPERTY, (byte)1, Boolean.TRUE);
        this.defineProperty(EMOTICONS_LOCK_STATE_PROPERTY, (byte)1, Boolean.FALSE);
        this.defineProperty(PRIVATE_CHAT_RESTRICTED_PROPERTY, (byte)1, Boolean.FALSE);
    }

    public void setClientList(ClientList list) {
        this.clients = list;
    }

    public String commandToString(byte cmd) {
        switch (cmd) {
            case 1: {
                return "Chat";
            }
            case 2: {
                return "Welcome";
            }
        }
        return "Invalid direct messaging protocol command - " + cmd;
    }

    public String messageToString(byte cmd, DataInputStream str) {
        String command = this.commandToString(cmd);
        try {
            switch (cmd) {
                case 1: {
                    Chat msg = this.decode(str, this.clients);
                    return command + " - " + msg;
                }
                case 2: {
                    long gmt = str.readLong();
                    Date dt = new Date(gmt);
                    SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    return command + " - " + fmt.format(dt);
                }
            }
            return command;
        }
        catch (IOException ex) {
            return command + " - [ IO Exception decoding message ]";
        }
    }

    public void encode(DataOutputStream str, ClientList clients, Chat msg) throws IOException {
        Address from = msg.getOriginator();
        Collection<Address> addrs = msg.getRecipients();
        Iterator<Address> i = addrs.iterator();
        str.writeByte(0);
        str.writeByte(msg.isAnnouncement() ? 1 : 0);
        from.encode(clients, str);
        while (i.hasNext()) {
            Address addr = i.next();
            addr.encode(clients, str);
        }
        str.writeByte(1);
        str.writeUTF(msg.getText());
    }

    public Chat decode(DataInputStream str, ClientList clients) throws IOException {
        Address addr;
        Chat msg = new Chat();
        str.skipBytes(1);
        msg.setAnnouncement(str.readByte() != 0);
        while ((addr = Address.decode(clients, str)) != null) {
            msg.addAddress(addr);
        }
        msg.setText(str.readUTF());
        return msg;
    }

    public ProtocolResponder getResponder() {
        return new ChatResponder((JinxProtocol)this);
    }

    class ChatResponder
    extends DefaultProtocolResponder
    implements PropertyChangeListener,
    ChannelListener,
    Runnable {
        String[] MSGS;
        LightweightTimer timer;
        Random rnd;
        boolean sendChat;

        public ChatResponder(JinxProtocol p) {
            super(p);
            this.MSGS = new String[]{"natter", "gromish", "applesauce", "nonsense", "gemini will win in the end"};
            this.rnd = new Random();
            this.sendChat = false;
            this.setChannelListener(this);
        }

        public void channelStateChanged(ChannelEvent e) {
            switch (e.getState()) {
                case 1: {
                    this.timer = new LightweightTimer((Runnable)this);
                    ChatProtocol.this.clients = this.getClientList();
                    ChatProtocol.this.clients.addClientPropertyChangeListener(ChatProtocol.ACCESS_PROPERTY, (PropertyChangeListener)this);
                    ChatProtocol.this.clients.addPropertyChangeListener(ChatProtocol.CHAT_RESPONDER_GENERATOR, (PropertyChangeListener)this);
                    ChatProtocol.this.isRecorder = ChatProtocol.this.clients.getMyClient().getAddress() == 1;
                    break;
                }
                case 2: {
                    ChatProtocol.this.clients.removeClientPropertyChangeListener(ChatProtocol.ACCESS_PROPERTY, (PropertyChangeListener)this);
                    ChatProtocol.this.clients.removePropertyChangeListener(ChatProtocol.CHAT_RESPONDER_GENERATOR, (PropertyChangeListener)this);
                    ChatProtocol.this.clients = null;
                    if (!this.timer.isScheduled()) break;
                    this.timer.cancel();
                }
            }
        }

        @Override
        public synchronized void propertyChange(PropertyChangeEvent e) {
            String nm = e.getPropertyName();
            if (nm.equals(ChatProtocol.ACCESS_PROPERTY)) {
                if (ChatProtocol.this.clients.getPropertyOwner(e.getSource()) == ChatProtocol.this.clients.getMyAddress()) {
                    this.sendChat = !ChatProtocol.this.isRecorder;
                }
            } else if (nm.equals(ChatProtocol.CHAT_RESPONDER_GENERATOR)) {
                ChatProtocol.this.responderChatDelay = (Short)e.getNewValue();
                this.sendChat = ChatProtocol.this.responderChatDelay != null ? ChatProtocol.this.responderChatDelay > 0 : false;
            }
            if (this.sendChat) {
                this.reschedule();
            } else if (this.timer.isScheduled()) {
                this.timer.cancel();
            }
        }

        @Override
        public synchronized void run() {
            Chat msg = new Chat();
            ClientInfo me = ChatProtocol.this.clients.getMyClient();
            if (me == null) {
                return;
            }
            String text = this.MSGS[this.rnd.nextInt(this.MSGS.length)];
            msg.setFrom(me);
            msg.setText(text);
            msg.setAnnouncement(false);
            msg.addAll();
            this.fireChannelDataEvent(msg);
            this.reschedule();
        }

        private void fireChannelDataEvent(Chat msg) {
            ChannelDataEvent e = null;
            e = ChannelDataEvent.getInstance((Object)this, (short)-4, (byte)1);
            try {
                DataOutputStream str = e.write();
                ChatProtocol.this.encode(str, ChatProtocol.this.clients, msg);
                str.close();
            }
            catch (IOException ex) {
                e.dispose();
                LogSupport.exception((Object)this, (String)"fireChannelDataEvent", (Throwable)ex, (boolean)true);
                return;
            }
            this.sendDataOnChannel(ChatProtocol.CHANNEL, e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reschedule() {
            LightweightTimer lightweightTimer = this.timer;
            synchronized (lightweightTimer) {
                if (this.sendChat) {
                    int base = 40;
                    int range = Math.max(0, ChatProtocol.this.responderChatDelay.intValue() * 2000 - 40);
                    int random = this.rnd.nextInt(range);
                    this.timer.scheduleIn((long)(40 + random));
                } else if (this.timer.isScheduled()) {
                    this.timer.cancel();
                }
            }
        }
    }
}

