/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.cluster;

import com.hazelcast.core.HazelcastInstance;

public abstract class HazelcastWrappedObject<T> {
    private static final long LOCK_SLEEP_MILLIS = 500L;
    private volatile boolean isBusy = false;
    private volatile boolean pausingForReload = false;
    private volatile Object stateChangeLock = new Object();
    private volatile HazelcastInstance instance = null;

    public HazelcastWrappedObject(HazelcastInstance _instance) {
        this.instance = _instance;
        this.isBusy = false;
    }

    protected HazelcastInstance getInstance() {
        return this.instance;
    }

    protected abstract void refresh();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseForReload() {
        this.pausingForReload = true;
        while (this.isBusy) {
            Object object = this.stateChangeLock;
            synchronized (object) {
                if (!this.isBusy) {
                    this.instance = null;
                    break;
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeAfterReload(HazelcastInstance _instance) {
        Object object = this.stateChangeLock;
        synchronized (object) {
            this.instance = _instance;
            this.refresh();
            this.pausingForReload = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getLock() {
        while (this.pausingForReload || !this.isBusy) {
            Object object = this.stateChangeLock;
            synchronized (object) {
                if (!this.pausingForReload) {
                    this.isBusy = true;
                    break;
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseLock() {
        Object object = this.stateChangeLock;
        synchronized (object) {
            this.isBusy = false;
        }
    }
}

