/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.cluster;

import com.elluminate.cluster.HazelcastWrappedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MessageListener;
import java.util.HashSet;
import java.util.Set;

public class CTopic<T>
extends HazelcastWrappedObject<T> {
    private ITopic<T> itopic;
    private Set<MessageListener<T>> mListeners = new HashSet<MessageListener<T>>();

    public CTopic(String name, HazelcastInstance instance) {
        super(instance);
        this.itopic = instance.getTopic(name);
    }

    public String getName() {
        return this.itopic.getName();
    }

    @Override
    protected void refresh() {
        this.itopic = this.getInstance().getTopic(this.getName());
        for (MessageListener<T> listener : this.mListeners) {
            this.itopic.addMessageListener(listener);
        }
    }

    public void addMessageListener(MessageListener<T> listener) {
        this.getLock();
        this.itopic.addMessageListener(listener);
        this.mListeners.add(listener);
        this.releaseLock();
    }

    public void removeMessageListener(MessageListener<T> listener) {
        this.getLock();
        this.itopic.removeMessageListener(listener);
        this.mListeners.remove(listener);
        this.releaseLock();
    }

    public void publish(T message) {
        this.getLock();
        this.itopic.publish(message);
        this.releaseLock();
    }
}

