/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.cluster;

import com.elluminate.cluster.ClusterMsg;

public class AsteriskServer
extends ClusterMsg {
    private static final long serialVersionUID = 1L;
    private static final short VERSION = 1;
    private static final short F_NAME = 1;
    private static final short F_HOST = 2;
    private static final short F_STATE = 3;
    private static final short F_SIP_PORT = 4;
    private static final short F_IAX_PORT = 5;
    private static final short F_AMI_PORT = 6;
    private static final short F_BRIDGE_EXT = 7;
    private static final short F_CONF_LIMIT = 8;
    private static final short F_CONF_COUNT = 9;
    private static final short F_CALL_COUNT = 10;
    public static final byte ST_OFFLINE = 0;
    public static final byte ST_QUIESCING = 1;
    public static final byte ST_ONLINE = 2;
    public static final byte ST_TIMEDOUT = 3;
    public static final int NONE = -1;

    public AsteriskServer() {
    }

    public AsteriskServer(String name, String host) {
        this(name, host, 0);
    }

    public AsteriskServer(String name, String host, byte state) {
        this(name, host, state, -1, -1, -1, -1, -1, -1, -1);
    }

    public AsteriskServer(String name, String host, byte state, int sip, int iax, int ami, int ext, int maxConf, int currConf, int currCall) {
        super((short)1, (short)1, name, (short)2, host, (short)3, state);
        if (state < 0 || state > 3) {
            throw new IllegalArgumentException("state out of range.");
        }
        if (sip > 0) {
            this.setField((short)4, sip);
        }
        if (iax > 0) {
            this.setField((short)5, iax);
        }
        if (ami > 0) {
            this.setField((short)6, ami);
        }
        if (ext > 0) {
            this.setField((short)7, ext);
        }
        if (maxConf > 0) {
            this.setField((short)8, maxConf);
        }
        if (currConf > 0) {
            this.setField((short)9, currConf);
        }
        if (currCall > 0) {
            this.setField((short)10, currCall);
        }
    }

    public String getName() {
        return this.getFieldAsString((short)1);
    }

    public String getHost() {
        return this.getFieldAsString((short)2);
    }

    public byte getState() {
        return (byte)this.getFieldAsLong((short)3);
    }

    public int getSipPort() {
        return (int)this.getFieldAsLong((short)4, -1L);
    }

    public int getIaxPort() {
        return (int)this.getFieldAsLong((short)5, -1L);
    }

    public int getAmiPort() {
        return (int)this.getFieldAsLong((short)6, -1L);
    }

    public int getBridgeExtension() {
        return (int)this.getFieldAsLong((short)7, -1L);
    }

    public int getConferenceLimit() {
        return (int)this.getFieldAsLong((short)8, -1L);
    }

    public int getConferenceCount() {
        return (int)this.getFieldAsLong((short)9, -1L);
    }

    public int getCallCount() {
        return (int)this.getFieldAsLong((short)10, -1L);
    }

    public static String getStateName(byte state) {
        switch (state) {
            case 0: {
                return "offline";
            }
            case 1: {
                return "quiescing";
            }
            case 2: {
                return "online";
            }
            case 3: {
                return "timed out";
            }
        }
        return "*INVALID*";
    }

    @Override
    public String toString() {
        StringBuilder bld = new StringBuilder("AsteriskServer(v");
        bld.append(this.getVersion());
        bld.append(",name=");
        bld.append(this.getName());
        bld.append(",host=");
        bld.append(this.getHost());
        if (this.hasField((short)3)) {
            bld.append(",State=");
            bld.append(AsteriskServer.getStateName(this.getState()));
        }
        if (this.hasField((short)4)) {
            bld.append(",SIP-port=");
            bld.append(this.getSipPort());
        }
        if (this.hasField((short)5)) {
            bld.append(",IAX-port=");
            bld.append(this.getIaxPort());
        }
        if (this.hasField((short)6)) {
            bld.append(",AMI-port=");
            bld.append(this.getAmiPort());
        }
        if (this.hasField((short)7)) {
            bld.append(",bridgeExt=");
            bld.append(this.getBridgeExtension());
        }
        if (this.hasField((short)8)) {
            bld.append(",confLimit=");
            bld.append(this.getConferenceLimit());
        }
        if (this.hasField((short)9)) {
            bld.append(",confCount=");
            bld.append(this.getConferenceCount());
        }
        if (this.hasField((short)10)) {
            bld.append(", callCount=");
            bld.append(this.getCallCount());
        }
        bld.append(")");
        return bld.toString();
    }
}

