/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.chair;

import com.elluminate.groupware.chair.ChairDebug;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.PropertyValue;
import com.elluminate.util.log.LogSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class LegacyChairSupport
implements PropertyChangeListener {
    ClientList clients;
    short[] chairs = new short[0];

    public LegacyChairSupport(ClientList clist) {
        this.clients = clist;
        this.clients.addClientPropertyChangeListener("chair.role", (PropertyChangeListener)this);
    }

    public void dispose() {
        this.clients.removeClientPropertyChangeListener("chair.role", (PropertyChangeListener)this);
        this.clients = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("chair.role".equals(evt.getPropertyName())) {
            short[] newChairs;
            Boolean oldValue = (Boolean)evt.getOldValue();
            Boolean newValue = (Boolean)evt.getNewValue();
            boolean wasChair = oldValue == null ? false : oldValue;
            boolean isChair = newValue == null ? false : newValue;
            short addr = this.clients.getPropertyOwner(evt.getSource());
            if (ChairDebug.LEGACY.show()) {
                LogSupport.message((String)("chair.role(" + addr + ") changing from " + wasChair + " to " + isChair));
            }
            if (isChair == wasChair) {
                return;
            }
            if (isChair) {
                newChairs = new short[this.chairs.length + 1];
                System.arraycopy(this.chairs, 0, newChairs, 0, this.chairs.length);
                newChairs[this.chairs.length] = addr;
                this.chairs = newChairs;
            } else {
                newChairs = new short[this.chairs.length - 1];
                int j = 0;
                for (int i = 0; i < this.chairs.length; ++i) {
                    if (this.chairs[i] == addr) continue;
                    newChairs[j++] = this.chairs[i];
                }
                if (j != newChairs.length) {
                    LogSupport.error((Object)this, (String)"propertyChange", (String)("Inconsistent chair list - expected " + newChairs.length + " elements, got " + j));
                }
                this.chairs = newChairs;
            }
            if (ChairDebug.LEGACY.show()) {
                StringBuffer msg = new StringBuffer("chair = short[" + this.chairs.length + "] {");
                boolean first = true;
                for (short c : this.chairs) {
                    if (first) {
                        first = false;
                    } else {
                        msg.append(',');
                    }
                    msg.append(c);
                }
                msg.append("}");
                LogSupport.message((String)msg.toString());
            }
            this.clients.setProperty("chair", new PropertyValue(this.chairs));
        }
    }
}

