/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda;

import com.elluminate.groupware.agenda.event.TransferEvent;
import com.elluminate.groupware.agenda.event.TransferListener;
import com.elluminate.jinx.XmitWindow;
import com.elluminate.util.WorkerThread;
import java.io.IOException;
import java.util.zip.CRC32;
import javax.swing.event.EventListenerList;

public abstract class Transfer
implements Runnable {
    public static final int TYPE_UPLOAD = 1;
    public static final int TYPE_DOWNLOAD = 2;
    private Object object;
    private int type;
    private int bufferSize = 1024;
    private long transferSize = -1L;
    private long bytesTransfered = 0L;
    private XmitWindow window = new XmitWindow(3000L, 1024, 32768);
    private boolean running = false;
    private boolean canceled = false;
    private EventListenerList listenerList = new EventListenerList();

    public Transfer(Object object, int type) {
        this.object = object;
        this.type = type;
    }

    public Object getObject() {
        return this.object;
    }

    public int getType() {
        return this.type;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setTransferSize(long transferSize) {
        this.transferSize = transferSize;
    }

    public long getTransferSize() {
        return this.transferSize;
    }

    public long getBytesTransfered() {
        return this.bytesTransfered;
    }

    public synchronized void start() {
        if (this.running) {
            throw new IllegalStateException("Transfer is already in progress");
        }
        this.bytesTransfered = 0L;
        this.canceled = false;
        this.running = true;
        WorkerThread th = new WorkerThread((Runnable)this, "Transfer");
        th.start();
    }

    public void cancel() {
        this.canceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int bytesRead;
            this.fireTransferEvent(1);
            CRC32 crc32 = new CRC32();
            byte[] buf = new byte[this.bufferSize];
            while (!this.canceled && (bytesRead = this.read(buf)) != -1) {
                this.write(buf, 0, bytesRead);
                crc32.update(buf, 0, bytesRead);
                this.bytesTransfered += (long)bytesRead;
                this.fireTransferEvent(2);
                if (this.window.xmit(bytesRead)) continue;
                long size = this.waitFor();
                while (!this.window.ack((int)size)) {
                    size = this.waitFor();
                }
            }
            try {
                this.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (this.canceled) {
                this.canceled();
                this.fireTransferEvent(4);
            } else {
                this.completed(crc32.getValue());
                this.fireTransferEvent(3);
            }
        }
        catch (IOException ex) {
            this.error(ex);
            this.fireTransferEvent(5);
        }
        finally {
            this.running = false;
            this.cleanup();
        }
    }

    public abstract int read(byte[] var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public abstract long waitFor();

    public abstract void close() throws IOException;

    public abstract void completed(long var1) throws IOException;

    public abstract void canceled() throws IOException;

    public abstract void error(IOException var1);

    public abstract void cleanup();

    public void addTransferListener(TransferListener l) {
        this.listenerList.add(TransferListener.class, l);
    }

    public void removeTransferListener(TransferListener l) {
        this.listenerList.remove(TransferListener.class, l);
    }

    protected void fireTransferEvent(int eventID) {
        TransferEvent e = new TransferEvent(this, eventID);
        Object[] ls = this.listenerList.getListenerList();
        block6: for (int i = ls.length - 2; i >= 0; i -= 2) {
            if (ls[i] != TransferListener.class) continue;
            TransferListener l = (TransferListener)ls[i + 1];
            switch (eventID) {
                case 1: {
                    l.transferStarted(e);
                    continue block6;
                }
                case 2: {
                    l.transferData(e);
                    continue block6;
                }
                case 3: {
                    l.transferFinished(e);
                    continue block6;
                }
                case 4: {
                    l.transferCanceled(e);
                }
            }
        }
    }
}

