/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda;

import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaExecutable;
import com.elluminate.groupware.agenda.AgendaItem;
import com.elluminate.groupware.agenda.AgendaNode;
import com.elluminate.groupware.agenda.AgendaObject;
import com.elluminate.groupware.agenda.AgendaProtocol;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class AgendaAction
extends AgendaNode
implements AgendaExecutable {
    private String description;
    private String commandName = Agenda.ACTION_COMMAND_DEFAULT;
    private HashMap commandParameters = new HashMap();
    private String note = Agenda.ACTION_NOTE_DEFAULT;
    private ArrayList actions = new ArrayList();
    private boolean isCommandAvailable = true;

    @Override
    public boolean isCovered() {
        return this.covered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCovered(boolean covered) {
        if (this.covered != covered) {
            ArrayList arrayList = this.actions;
            synchronized (arrayList) {
                for (AgendaAction act : this.actions) {
                    if (act.isCovered() == covered) continue;
                    act.setCovered(covered);
                }
            }
            this.setCoveredInternal(covered);
        }
    }

    private void setCoveredInternal(boolean covered) {
        this.covered = covered;
        this.changeItemNotify(this, "covered");
    }

    public boolean isCompounded() {
        AgendaNode p = this.getParent();
        return p instanceof AgendaAction && ((AgendaAction)p).isCompoundAction();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (this.description == null && this.description != description || !this.description.equals(description)) {
            this.description = description;
            this.changeItemNotify(this, "description");
        }
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public void setCommandName(String commandName) {
        if (this.commandName == null && this.commandName != commandName || this.commandName != null && !this.commandName.equals(commandName)) {
            this.commandName = commandName;
            this.clearCommandParameters();
            this.changeItemNotify(this, "command");
        }
    }

    @Override
    public String[] getCommandParameterNames() {
        return this.commandParameters.keySet().toArray(new String[0]);
    }

    @Override
    public String getCommandParameter(String name) {
        return (String)this.commandParameters.get(name);
    }

    @Override
    public void setCommandParameter(String name, String value) {
        if (value != null) {
            this.commandParameters.put(name, value);
        } else {
            this.commandParameters.remove(name);
        }
        this.changeItemNotify(this, AgendaProtocol.formatParameterName("parameter", name));
    }

    @Override
    public void clearCommandParameters() {
        this.commandParameters.clear();
    }

    @Override
    public String getStringParameter(String name) {
        return this.getCommandParameter(name);
    }

    @Override
    public Integer getIntegerParameter(String name) {
        Integer i = null;
        String value = this.getCommandParameter(name);
        if (value != null) {
            try {
                i = new Integer(Integer.parseInt(value));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return i;
    }

    @Override
    public Boolean getBooleanParameter(String name) {
        Boolean b = null;
        String value = this.getCommandParameter(name);
        if (value != null) {
            b = new Boolean(value.equalsIgnoreCase("true"));
        }
        return b;
    }

    @Override
    public Rectangle getRectangleParameter(String name) {
        StringTokenizer st;
        Rectangle r = null;
        String value = this.getCommandParameter(name);
        if (value != null && (st = new StringTokenizer(value, ",")).countTokens() == 4) {
            try {
                int x = Integer.parseInt(st.nextToken());
                int y = Integer.parseInt(st.nextToken());
                int w = Integer.parseInt(st.nextToken());
                int h = Integer.parseInt(st.nextToken());
                r = new Rectangle(x, y, w, h);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return r;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        if (this.note == null && this.note != note || !this.note.equals(note)) {
            this.note = note;
            this.changeItemNotify(this, "note");
        }
    }

    public void addAction(AgendaAction action) {
        this.addAction(action, -1);
    }

    public void addAction(AgendaAction action, int index) {
        if (action.parent != null) {
            action.removeFromParent();
        }
        action.parent = this;
        if (index >= 0) {
            this.actions.add(index, action);
        } else {
            this.actions.add(action);
        }
        this.setCommandName(Agenda.ACTION_COMMAND_DEFAULT);
        this.addItemNotify(action, index);
    }

    public void removeAction(AgendaAction action) {
        if (this.actions.remove(action)) {
            this.removeItemNotify(action);
        }
    }

    @Override
    void removeFromParent() {
        AgendaObject p = this.parent;
        if (p instanceof AgendaAction) {
            ((AgendaAction)p).removeAction(this);
        } else {
            super.removeFromParent();
        }
    }

    public int getActionCount() {
        return this.actions.size();
    }

    public AgendaAction getAction(int index) {
        return (AgendaAction)this.actions.get(index);
    }

    public int getActionIndex(AgendaAction action) {
        return this.actions.indexOf(action);
    }

    public synchronized AgendaAction[] getActions() {
        ArrayList<AgendaAction> list = new ArrayList<AgendaAction>();
        for (AgendaAction act : this.actions) {
            list.add(act);
        }
        return list.toArray(new AgendaAction[0]);
    }

    public boolean isCompoundAction() {
        return this.getActionCount() != 0 || this.commandName == null || this.commandName.length() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void changeItemNotify(AgendaItem item, String property) {
        super.changeItemNotify(item, property);
        if (item != this && property.equals("covered")) {
            boolean covered = true;
            ArrayList arrayList = this.actions;
            synchronized (arrayList) {
                for (AgendaAction act : this.actions) {
                    if (act.isCovered()) continue;
                    covered = false;
                    break;
                }
            }
            if (this.covered != covered) {
                this.setCoveredInternal(covered);
            }
        }
    }

    @Override
    public boolean canMoveUp() {
        Agenda ag = this.getParentAgenda();
        if (ag != null) {
            return ag.getNodeBefore(this, true) != null;
        }
        return false;
    }

    @Override
    public boolean canMoveDown() {
        Agenda ag = this.getParentAgenda();
        if (ag != null) {
            AgendaNode n = this;
            while ((n = ag.getNodeAfter(n, true)) != null) {
                if (this.isAncestorOf(n)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canMoveLeft() {
        if (super.canMoveLeft()) {
            return true;
        }
        if (!(this.parent instanceof AgendaAction)) {
            return false;
        }
        AgendaAction act = (AgendaAction)this.parent;
        return act.getActionIndex(this) == act.getActionCount() - 1;
    }

    @Override
    public boolean canMoveRight() {
        if (super.canMoveRight()) {
            return true;
        }
        Agenda ag = this.getParentAgenda();
        if (ag != null) {
            AgendaNode prev = ag.getSiblingNodeBefore(this);
            return prev instanceof AgendaAction && ((AgendaAction)prev).isCompoundAction();
        }
        return false;
    }

    @Override
    protected String paramString() {
        StringBuffer b = new StringBuffer();
        b.append(super.paramString());
        b.append(",description=");
        b.append(this.description);
        b.append(",commandName=");
        b.append(this.commandName);
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() throws CloneNotSupportedException {
        AgendaAction cl = (AgendaAction)super.clone();
        cl.commandParameters = (HashMap)this.commandParameters.clone();
        cl.actions = new ArrayList();
        ArrayList arrayList = this.actions;
        synchronized (arrayList) {
            for (AgendaAction act : this.actions) {
                cl.addAction((AgendaAction)act.clone());
            }
        }
        return cl;
    }

    public boolean isCommandAvailable() {
        return this.isCommandAvailable;
    }

    public void setCommandAvailable(boolean commandAvailable) {
        this.isCommandAvailable = commandAvailable;
    }
}

