/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia.module;

import com.elluminate.classroom.client.messaging.MessagePublisher;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageRouter;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.groupware.multimedia.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

@Singleton
public class MultimediaPublisher {
    private final String UNIQUE_NAME = "MultimediaPublisher";
    private final String DISPLAY_NAME;
    private final Icon icon;
    public static final String MULTIMEDIA_PLAYING = "multimedia-playing";
    public static final String MULTIMEDIA_STOPPED = "multimedia-stopped";
    private final MessagePublisher publisher;
    private final MessagePublisherMetadata metadata;
    private final I18n i18n;
    private final MessageRouter router;
    private String modName;
    private String modDisplayName;
    private Map<String, MessageType> msgTypes = new HashMap<String, MessageType>();

    @Inject
    public MultimediaPublisher(MessagePublisher pub, MessagePublisherMetadata meta, MessageRouter rtr, I18n localization, ModulePublisherInfo mod) {
        this.publisher = pub;
        this.metadata = meta;
        this.router = rtr;
        this.i18n = localization;
        this.DISPLAY_NAME = this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIAPUBLISHER_DISPLAYNAME);
        this.icon = mod.getModuleIcon();
        this.modName = mod.getNameOfModule();
        this.modDisplayName = mod.getDisplayNameOfModule();
        this.initializePublisher();
    }

    public void sendMultimediaPlayingMessage(String mediaName, boolean isMe) {
        String message = this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIAPUBLISHER_PLAYING_MESSAGE, new Object[]{mediaName});
        this.sendRouterMsg(message, this.msgTypes.get(MULTIMEDIA_PLAYING), isMe);
    }

    public void sendMultimediaStoppedMessage(String mediaName, boolean isMe) {
        String message = this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIAPUBLISHER_STOPPED_MESSAGE, new Object[]{mediaName});
        this.sendRouterMsg(message, this.msgTypes.get(MULTIMEDIA_STOPPED), isMe);
    }

    private void sendRouterMsg(String message, MessageType type, boolean isMe) {
        this.publisher.sendTextMessage(message, type, isMe);
    }

    private void initializePublisher() {
        this.initMessageTypes();
        this.setMetadata();
        this.publisher.setPublisherMetadata(this.metadata);
        this.router.registerPublisher(this.publisher);
    }

    private void setMetadata() {
        this.metadata.setPublisherDisplayName(this.DISPLAY_NAME);
        this.metadata.setPublisherUniqueName("MultimediaPublisher");
        this.metadata.setPublisherIcon(this.icon);
        this.metadata.setModuleName(this.modName);
        this.metadata.setModuleDisplayName(this.modDisplayName);
        this.metadata.setPublisherSupportedMessageTypes(new ArrayList<MessageType>(this.msgTypes.values()));
    }

    private void initMessageTypes() {
        this.msgTypes.put(MULTIMEDIA_PLAYING, new MessageType(MULTIMEDIA_PLAYING, this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIAPUBLISHER_TYPE_PLAYING), 5));
        this.msgTypes.put(MULTIMEDIA_STOPPED, new MessageType(MULTIMEDIA_STOPPED, this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIAPUBLISHER_TYPE_STOPPED), 5));
    }
}

