/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia.module;

import com.elluminate.groupware.multimedia.module.ClientMediaLibrary;
import com.elluminate.groupware.multimedia.module.MediaRequestProcessor;
import com.elluminate.net.Endpoint;
import com.elluminate.net.EndpointListener;
import com.elluminate.util.WorkerThread;
import java.awt.Component;
import java.io.IOException;
import java.net.InetAddress;

public class MediaServer
implements Runnable {
    private ClientMediaLibrary lib = null;
    private EndpointListener listener = null;
    private Thread thread = null;
    private Component comp = null;
    private boolean starting = false;

    public MediaServer(ClientMediaLibrary mLib) {
        this.lib = mLib;
    }

    public void setComponent(Component c) {
        this.comp = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start() throws IOException {
        int port = 0;
        MediaServer mediaServer = this;
        synchronized (mediaServer) {
            if (this.thread == null) {
                InetAddress loopback;
                try {
                    loopback = InetAddress.getByName("localhost");
                }
                catch (Throwable t) {
                    loopback = InetAddress.getByName("127.0.0.1");
                }
                this.listener = new EndpointListener("direct", 0, 50, loopback);
                this.thread = new WorkerThread((Runnable)this, "Media Server");
                this.thread.setDaemon(true);
                this.thread.start();
                port = this.listener.getLocalPort();
                this.starting = true;
                while (this.starting) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ix) {}
                }
            }
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        MediaServer mediaServer = this;
        synchronized (mediaServer) {
            while (this.starting) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
                this.listener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        boolean running;
        MediaServer mediaServer = this;
        synchronized (mediaServer) {
            running = this.listener != null;
        }
        return running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPort() {
        int port = 0;
        MediaServer mediaServer = this;
        synchronized (mediaServer) {
            if (this.listener != null) {
                port = this.listener.getLocalPort();
            }
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        EndpointListener localListener;
        MediaServer mediaServer = this;
        synchronized (mediaServer) {
            localListener = this.listener;
            this.starting = false;
            this.notifyAll();
        }
        while (!Thread.interrupted()) {
            try {
                Endpoint ep = localListener.accept();
                new MediaRequestProcessor(this.lib, this.comp, ep);
            }
            catch (IOException ex) {
                // empty catch block
                break;
            }
        }
        mediaServer = this;
        synchronized (mediaServer) {
            if (this.listener == localListener) {
                this.stop();
            }
        }
        localListener.closeForce();
    }
}

