/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia.module;

import com.elluminate.groupware.multimedia.MediaLibrary;
import com.elluminate.groupware.multimedia.MediaLibraryEntry;
import com.elluminate.groupware.multimedia.MultimediaDebug;
import com.elluminate.groupware.multimedia.module.LengthCellRenderer;
import com.elluminate.groupware.multimedia.module.MultimediaBean;
import com.elluminate.groupware.multimedia.module.Progress;
import com.elluminate.groupware.multimedia.module.ProgressCellRenderer;
import com.elluminate.groupware.multimedia.module.ServerCellRenderer;
import com.elluminate.groupware.multimedia.module.StringsProperties;
import com.elluminate.gui.component.AccessibleToolBar;
import com.elluminate.gui.component.CToolBarButton;
import com.elluminate.gui.swing.CTable;
import com.elluminate.gui.swing.CTableHeader;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.StringComparator;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class LibraryPanel
extends JPanel {
    private static I18n i18n = I18n.create(LibraryPanel.class);
    private static final int DFT_WIDTH = 500;
    private static final int DFT_HEIGHT = 320;
    private MediaLibrary lib = null;
    private ArrayList<MediaLibraryEntry> selectionMap = null;
    private int[] selections = null;
    private BorderLayout contentLayout = new BorderLayout();
    private JScrollPane libScroller = new JScrollPane();
    private CTable libTable = null;
    private JToolBar toolbar = new AccessibleToolBar();
    private CToolBarButton loadFileButton = new CToolBarButton();
    private CToolBarButton loadURLButton = new CToolBarButton();
    private CToolBarButton removeMediaButton = new CToolBarButton();
    private CToolBarButton stopMediaButton = new CToolBarButton();
    private CToolBarButton playMediaButton = new CToolBarButton();
    private JLabel nowPlaying = new JLabel();
    private String[] cNames = new String[4];
    private TableColumnModel cModel = null;
    private DefaultTableModel model = null;
    private JTableHeader header = null;
    private Dimension dialogSize = new Dimension(500, 320);
    private boolean deferredPlay = false;
    private boolean updatingSelection = false;
    private LightweightTimer refreshTimer = new LightweightTimer(new Runnable(){

        @Override
        public void run() {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    LibraryPanel.this.mergeData(LibraryPanel.this.getDataVector());
                }
            });
        }
    });
    private ListSelectionModel selectionModel = null;
    private boolean playing = false;
    private boolean blankTitle = true;
    private MultimediaBean mediaBean = null;

    public LibraryPanel(MediaLibrary lib) {
        super(false);
        this.lib = lib;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setPlayingTitle(null);
    }

    private void jbInit() throws Exception {
        this.cNames[0] = i18n.getString((PropertiesEnum)StringsProperties.LIBRARYDIALOG_NAMETITLE);
        this.cNames[1] = i18n.getString((PropertiesEnum)StringsProperties.LIBRARYDIALOG_SIZETITLE);
        this.cNames[2] = i18n.getString((PropertiesEnum)StringsProperties.LIBRARYDIALOG_SERVERTITLE);
        this.cNames[3] = i18n.getString((PropertiesEnum)StringsProperties.LIBRARYDIALOG_PROGRESSTITLE);
        this.setLayout(this.contentLayout);
        this.header = new CTableHeader();
        this.model = new DefaultTableModel(this.getDataVector(), this.cNames){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.libTable = new CTable();
        this.libTable.setAutoCreateColumnsFromModel(false);
        this.libTable.setTableHeader(this.header);
        this.libTable.setModel((TableModel)this.model);
        this.libTable.setPreferredScrollableViewportSize(new Dimension(480, 260));
        this.libTable.setIntercellSpacing(new Dimension(0, 1));
        this.libTable.setShowHorizontalLines(false);
        this.libTable.setShowVerticalLines(true);
        this.libTable.setRowHeight(20);
        this.libTable.setGridColor(new Color(224, 224, 224));
        this.libTable.setIntercellSpacing(new Dimension(1, 1));
        this.libTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int r = LibraryPanel.this.libTable.rowAtPoint(e.getPoint());
                if (r < 0) {
                    LibraryPanel.this.libTable.clearSelection();
                    LibraryPanel.this.enableButtons();
                } else if (!(e.getClickCount() != 2 || (e.getModifiers() & 0x10) == 0 || e.isAltDown() || e.isControlDown() || e.isMetaDown() || e.isShiftDown() || !LibraryPanel.this.hasSelectedMedia())) {
                    LibraryPanel.this.playMediaButton.setEnabled(true);
                    LibraryPanel.this.playMediaButton.doClick(100);
                }
            }
        });
        this.libTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (LibraryPanel.this.libTable.getSelectedRowCount() > 0 && e.getModifiers() == 0 && (e.getKeyCode() == 127 || e.getKeyCode() == 8)) {
                    LibraryPanel.this.removeMediaButton.doClick(100);
                }
            }
        });
        this.selectionModel = this.libTable.getSelectionModel();
        this.libTable.setSelectionMode(2);
        this.model.addTableModelListener((TableModelListener)this.libTable);
        this.cModel = this.libTable.getColumnModel();
        this.header.setColumnModel(this.cModel);
        this.header.setReorderingAllowed(false);
        this.cModel.addColumnModelListener(this.header);
        TableColumn col = new TableColumn(0, 320);
        col.setHeaderValue(this.cNames[0]);
        this.cModel.addColumn(col);
        col = new TableColumn(1, 120);
        col.setHeaderValue(this.cNames[1]);
        col.setCellRenderer(new LengthCellRenderer());
        this.cModel.addColumn(col);
        col = new TableColumn(2, 135);
        col.setHeaderValue(this.cNames[2]);
        col.setCellRenderer(new ServerCellRenderer());
        this.cModel.addColumn(col);
        col = new TableColumn(3, 125);
        col.setHeaderValue(this.cNames[3]);
        col.setCellRenderer(new ProgressCellRenderer());
        this.cModel.addColumn(col);
        this.loadFileButton.setIcon((Icon)i18n.getIcon("LibraryDialog.loadFileIcon"));
        this.loadFileButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.LIBRARYDIALOG_LOADFILETIP));
        this.loadURLButton.setIcon((Icon)i18n.getIcon("LibraryDialog.loadURLIcon"));
        this.loadURLButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.LIBRARYDIALOG_LOADURLTIP));
        this.removeMediaButton.setIcon((Icon)i18n.getIcon("LibraryDialog.removeMediaIcon"));
        this.removeMediaButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.LIBRARYDIALOG_REMOVEMEDIATIP));
        this.removeMediaButton.setEnabled(false);
        this.stopMediaButton.setIcon((Icon)i18n.getIcon("LibraryDialog.stopMediaIcon"));
        this.stopMediaButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.LIBRARYDIALOG_STOPMEDIATIP));
        this.stopMediaButton.setEnabled(false);
        this.playMediaButton.setIcon((Icon)i18n.getIcon("LibraryDialog.playMediaIcon"));
        this.playMediaButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.LIBRARYDIALOG_PLAYMEDIATIP));
        this.playMediaButton.setEnabled(false);
        this.playMediaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryPanel.this.deferredPlay = LibraryPanel.this.playing;
            }
        });
        this.toolbar.setFloatable(false);
        this.toolbar.add((Component)this.loadFileButton);
        this.toolbar.add((Component)this.loadURLButton);
        this.toolbar.addSeparator();
        this.toolbar.add((Component)this.removeMediaButton);
        this.toolbar.addSeparator();
        this.toolbar.add((Component)this.playMediaButton);
        this.toolbar.add((Component)this.stopMediaButton);
        this.add((Component)this.toolbar, "North");
        this.add((Component)this.libScroller, "Center");
        FullSizeViewport vp = new FullSizeViewport();
        vp.setView((Component)this.libTable);
        this.libScroller.setViewport(vp);
        this.libScroller.setViewportView((Component)this.libTable);
        this.libScroller.getViewport().setBackground(this.libTable.getBackground());
        this.libScroller.setVerticalScrollBarPolicy(22);
        this.libScroller.setHorizontalScrollBarPolicy(30);
        this.libScroller.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LibraryPanel.this.libTable.requestFocus();
                LibraryPanel.this.libTable.clearSelection();
                LibraryPanel.this.enableButtons();
            }
        });
        this.libScroller.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.LIGHT_GRAY));
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                LibraryPanel.this.enableButtons();
            }
        });
        this.selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!LibraryPanel.this.updatingSelection) {
                    LibraryPanel.this.enableButtons();
                }
            }
        });
        this.add((Component)this.nowPlaying, "South");
        this.setPreferredSize(this.dialogSize);
        this.setSize(this.dialogSize);
    }

    public void setBean(MultimediaBean mediaBean) {
        this.mediaBean = mediaBean;
    }

    public void onStop() {
        this.enableButtons();
    }

    public boolean requestPlay() {
        if (this.isPlaying()) {
            this.deferredPlay = true;
        }
        return !this.isPlaying();
    }

    public void clearDeferredPlay() {
        this.deferredPlay = false;
    }

    public void setPlaying(boolean playing, int id) {
        this.playing = playing;
        if (playing) {
            this.deferredPlay = false;
        }
        if (playing && id != 0 && this.lib.get(id) != null) {
            this.setPlayingTitle(this.lib.get(id).getName());
        } else {
            this.setPlayingTitle("");
        }
        this.enableButtons();
    }

    private void setPlayingTitle(final String playing) {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String txt = playing != null && playing.length() > 0 ? i18n.getString((PropertiesEnum)StringsProperties.LIBRARYDIALOG_PLAYINGLABEL, new Object[]{playing}) : " ";
                LibraryPanel.this.nowPlaying.setText(txt);
            }
        });
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void deselectMedia() {
        this.libTable.clearSelection();
        this.enableButtons();
    }

    public boolean hasSelectedMedia() {
        return this.libTable.getSelectedRowCount() > 0;
    }

    private void enableButtons() {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean playMedia;
                boolean enableRemove;
                if (MultimediaDebug.UI.show()) {
                    LogSupport.message((Object)this, (String)"enableButtons", (String)("rows=" + LibraryPanel.this.model.getRowCount() + ",selected=" + LibraryPanel.this.libTable.getSelectedRowCount() + ",playing=" + LibraryPanel.this.playing));
                }
                boolean bl = enableRemove = LibraryPanel.this.model.getRowCount() > 0 && LibraryPanel.this.libTable.getSelectedRowCount() > 0;
                if (enableRemove != LibraryPanel.this.removeMediaButton.isEnabled()) {
                    LibraryPanel.this.removeMediaButton.setEnabled(enableRemove);
                }
                if (LibraryPanel.this.playing != LibraryPanel.this.stopMediaButton.isEnabled()) {
                    LibraryPanel.this.stopMediaButton.setEnabled(LibraryPanel.this.playing);
                }
                boolean bl2 = playMedia = !LibraryPanel.this.playing && LibraryPanel.this.libTable.getSelectedRowCount() == 1 && LibraryPanel.this.blankTitle;
                if (playMedia && LibraryPanel.this.deferredPlay) {
                    LibraryPanel.this.deferredPlay = false;
                    if (LibraryPanel.this.mediaBean != null) {
                        LibraryPanel.this.mediaBean.playSelectedMedia();
                    }
                }
                if (LibraryPanel.this.playMediaButton.isEnabled() != (LibraryPanel.this.libTable.getSelectedRowCount() == 1)) {
                    LibraryPanel.this.playMediaButton.setEnabled(LibraryPanel.this.libTable.getSelectedRowCount() == 1);
                }
                if (MultimediaDebug.UI.show()) {
                    LogSupport.message((Object)this, (String)"enableButtons", (String)("remove: " + LibraryPanel.this.removeMediaButton.isEnabled() + ", stop: " + LibraryPanel.this.stopMediaButton.isEnabled() + ", play: " + LibraryPanel.this.playMediaButton.isEnabled()));
                }
            }
        });
    }

    public void setLoadFileAction(ActionListener loadFileAction) {
        this.loadFileButton.addActionListener(loadFileAction);
    }

    public void setLoadURLAction(ActionListener loadFileAction) {
        this.loadURLButton.addActionListener(loadFileAction);
    }

    public void setRemoveMediaAction(ActionListener removeMediaAction) {
        this.removeMediaButton.addActionListener(removeMediaAction);
    }

    public void setPlayMediaAction(ActionListener playMediaAction) {
        this.playMediaButton.addActionListener(playMediaAction);
    }

    public void setStopMediaAction(ActionListener stopMediaAction) {
        this.stopMediaButton.addActionListener(stopMediaAction);
    }

    public int[] getIDSelection() {
        if (this.libTable.getSelectedRowCount() == 0) {
            Toolkit.getDefaultToolkit().beep();
            return new int[0];
        }
        this.selections = new int[this.libTable.getSelectedRowCount()];
        int[] indices = this.libTable.getSelectedRows();
        for (int i = 0; i < indices.length; ++i) {
            try {
                MediaLibraryEntry ent = this.selectionMap.get(indices[i]);
                this.selections[i] = ent.getID();
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return this.selections;
    }

    int findMultimediaIdByName(String name) {
        if (name == null || name.length() < 1) {
            return -1;
        }
        for (MediaLibraryEntry ent : this.selectionMap) {
            if (!name.equals(ent.getName())) continue;
            return ent.getID();
        }
        return -1;
    }

    Object[][] getDataVector() {
        Object[][] tmpl = new Object[][]{};
        TreeMap<Object[], MediaLibraryEntry> data = new TreeMap<Object[], MediaLibraryEntry>(new Comparator<Object[]>(){
            StringComparator sc = new StringComparator(false, 1);

            @Override
            public int compare(Object[] a1, Object[] a2) {
                int cmp = this.sc.compare((String)a1[0], (String)a2[0]);
                if (cmp != 0) {
                    return cmp;
                }
                MediaLibraryEntry e1 = (MediaLibraryEntry)a1[4];
                MediaLibraryEntry e2 = (MediaLibraryEntry)a2[4];
                return e1.getID() - e2.getID();
            }

            @Override
            public boolean equals(Object o) {
                return false;
            }
        });
        if (this.lib != null) {
            for (MediaLibraryEntry ent : this.lib) {
                Progress prog = new Progress(ent);
                Object[] row = new Object[]{ent.getName(), new long[]{ent.getLength(), ent.getPosition()}, prog, prog, ent};
                data.put(row, ent);
            }
        }
        this.selectionMap = new ArrayList(data.values());
        return (Object[][])data.keySet().toArray((T[])tmpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeData(Object[][] data) {
        int i;
        int i2;
        int tableRow = 0;
        int dataRow = 0;
        int selectedRowIndex = 0;
        boolean selectionChanged = false;
        int[] rows = this.libTable.getSelectedRows();
        boolean[] selectedTableRows = new boolean[this.libTable.getRowCount()];
        for (i2 = 0; i2 < selectedTableRows.length; ++i2) {
            selectedTableRows[i2] = false;
        }
        for (i2 = 0; i2 < rows.length; ++i2) {
            selectedTableRows[rows[i2]] = true;
        }
        int selectedOffset = 0;
        try {
            while (this.model.getRowCount() > 0 || data.length > 0) {
                if (tableRow >= this.model.getRowCount()) {
                    while (dataRow < data.length) {
                        this.model.addRow(data[dataRow]);
                        ++dataRow;
                    }
                    break;
                }
                if (dataRow >= data.length) {
                    while (tableRow < this.model.getRowCount()) {
                        this.model.removeRow(tableRow);
                    }
                    break;
                }
                String tableKey = (String)this.model.getValueAt(tableRow, 0);
                String dataKey = (String)data[dataRow][0];
                int compare = tableKey.toLowerCase().compareTo(dataKey.toLowerCase(Locale.ENGLISH));
                if (tableKey == null || dataKey == null) {
                    return;
                }
                if (compare > 0) {
                    this.model.insertRow(tableRow++, data[dataRow++]);
                    --selectedOffset;
                    selectionChanged = true;
                    continue;
                }
                if (compare < 0) {
                    this.model.removeRow(tableRow);
                    ++selectedOffset;
                    selectionChanged = true;
                    continue;
                }
                for (i = 0; i < data[dataRow].length && i < this.model.getColumnCount(); ++i) {
                    if (data[dataRow][i] != null && i < this.model.getColumnCount() && data[dataRow][i].equals(this.model.getValueAt(tableRow, i))) continue;
                    this.model.setValueAt(data[dataRow][i], tableRow, i);
                }
                if (rows.length > 0 && selectedTableRows[tableRow + selectedOffset]) {
                    rows[selectedRowIndex++] = tableRow;
                }
                ++tableRow;
                ++dataRow;
            }
        }
        finally {
            if (rows.length > 0 && selectionChanged) {
                this.updatingSelection = true;
                this.selectionModel.clearSelection();
                for (i = 0; i < selectedRowIndex; ++i) {
                    this.libTable.addRowSelectionInterval(rows[i], rows[i]);
                }
                this.updatingSelection = false;
            }
        }
    }

    public void setUpdating(boolean updating) {
        if (updating) {
            this.refreshTimer.scheduleEvery(2000L);
            this.mergeData(this.getDataVector());
            if (this.mediaBean != null) {
                this.mediaBean.firePropertyChange("libraryVisible", false, true);
            }
        } else {
            this.refreshTimer.cancel();
            if (this.mediaBean != null) {
                this.mediaBean.firePropertyChange("libraryVisible", true, false);
            }
        }
    }

    void refreshBtn_actionPerformed(ActionEvent e) {
        Object[][] data = this.getDataVector();
        this.model.setDataVector(data, this.cNames);
    }

    private class FullSizeViewport
    extends JViewport {
        private FullSizeViewport() {
        }

        @Override
        public void setViewSize(Dimension newSize) {
            Dimension s = this.getSize();
            if (newSize != null && newSize.height < s.height) {
                newSize = new Dimension(newSize.width, s.height);
            }
            super.setViewSize(newSize);
        }
    }
}

