/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia.module;

import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.multimedia.AbstractLoader;
import com.elluminate.groupware.multimedia.FileLoader;
import com.elluminate.groupware.multimedia.LoaderListener;
import com.elluminate.groupware.multimedia.MediaLibrary;
import com.elluminate.groupware.multimedia.MediaLibraryEntry;
import com.elluminate.groupware.multimedia.MultimediaProtocol;
import com.elluminate.groupware.multimedia.StreamCache;
import com.elluminate.groupware.multimedia.StreamEvent;
import com.elluminate.groupware.multimedia.StreamProxy;
import com.elluminate.groupware.multimedia.module.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.jinx.TransmitStatusEvent;
import com.elluminate.jinx.TransmitStatusListener;
import com.elluminate.platform.Platform;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.util.Iterator;
import java.util.TooManyListenersException;

public class ClientMediaLibrary
extends MediaLibrary {
    private Component parent;
    private StreamProxy svrProxy = null;
    private LoaderListener loadListener = null;

    private void reportError(String msg, String context, String details) {
        ModalDialog.showMessageDialogAsync((int)-1, (Component)this.parent, (Object)this.i18n.getStringLegacy(msg, new Object[]{context, details}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.CLIENTMEDIALIBRARY_ERRORTITLE), (int)0);
    }

    public ClientMediaLibrary(Channel chnl, Component parent) {
        super(chnl);
        this.parent = parent;
        this.loadListener = new LoaderListener(){

            public boolean startingLoad(AbstractLoader loader) {
                return ClientMediaLibrary.this.startLoad(loader);
            }
        };
        try {
            chnl.addTransmitStatusListener((TransmitStatusListener)this);
        }
        catch (TooManyListenersException tmlx) {
            LogSupport.exception((Object)((Object)this), (String)"<init>", (Throwable)tmlx, (boolean)true);
        }
    }

    public void add(File file, int id, BigInteger auth) throws IOException {
        if (this.svrProxy == null) {
            throw new IllegalStateException("Not connected.");
        }
        String name = file.getName();
        String type = Platform.getMimeType((String)name);
        FileLoader loader = new FileLoader(file, id, this.getLock(), this.loadListener, this.parent);
        loader.setAuth(auth);
        loader.start();
    }

    private boolean startLoad(AbstractLoader loader) {
        String name = loader.getName();
        String type = loader.getMimeType();
        BigInteger auth = loader.getAuth();
        StreamCache cache = loader.getCache();
        int id = cache.getStreamID();
        MediaLibraryEntry entry = null;
        entry = new MediaLibraryEntry(cache, auth, name, type);
        entry.setSource(this.channel.getConnection().getAddress());
        this.insert(id, entry);
        cache.setLock(this.getLock());
        this.svrProxy.connect(entry);
        return true;
    }

    public void add(URL url) {
        ChannelDataEvent e = this.serverMsg((byte)17);
        try {
            DataOutputStream ostr = e.write();
            ostr.writeUTF(url.toExternalForm());
            ostr.close();
            this.channel.onChannelData(e);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)((Object)this), (String)"add", (Throwable)ex, (boolean)true);
        }
    }

    public void remove(int id) {
        ChannelDataEvent e = this.serverMsg((byte)20);
        try {
            DataOutputStream ostr = e.write();
            ostr.writeInt(id);
            ostr.close();
            this.channel.onChannelData(e);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)((Object)this), (String)"remove", (Throwable)ex, (boolean)true);
        }
    }

    public void onChannelData(ChannelDataEvent event) {
        if (this.svrProxy == null) {
            return;
        }
        if (event.getSourceAddress() != 0) {
            return;
        }
        try {
            DataInputStream istr = event.read();
            switch (event.getCommand()) {
                case 23: {
                    int id = istr.readInt();
                    int nBytes = istr.readInt();
                    this.svrProxy.ack(id, nBytes);
                    break;
                }
                case 22: {
                    ProtocolBuffer buf = event.getBuffer();
                    istr.close();
                    istr = buf.readHeader(4);
                    int id = istr.readInt();
                    istr.close();
                    istr = null;
                    MediaLibraryEntry entry = this.get(id);
                    if (entry == null) {
                        return;
                    }
                    StreamCache cache = entry.getCache();
                    cache.streamingData(StreamEvent.getInstance((Object)((Object)this), (int)id, (ProtocolBuffer)((ProtocolBuffer)buf.clone())));
                    long unacked = entry.getPosition() - entry.getAcknowledged();
                    if (unacked < 16000L) break;
                    ChannelDataEvent resp = ChannelDataEvent.getInstance((Object)((Object)this), (short)0, (byte)23);
                    DataOutputStream ostr = resp.write();
                    ostr.writeInt(entry.getID());
                    ostr.writeInt((int)unacked);
                    ostr.close();
                    this.channel.onChannelData(resp, entry.isPlaying() ? (byte)0 : -2);
                    entry.setAcknowledged(entry.getPosition());
                    break;
                }
                case 20: {
                    int id = istr.readInt();
                    MediaLibraryEntry entry = this.get(id);
                    if (entry == null) {
                        return;
                    }
                    if (this.svrProxy.isConnected(entry)) {
                        this.svrProxy.disconnect(entry);
                    }
                    this.delete(id);
                    entry.dispose();
                    break;
                }
                case 25: {
                    String msg = istr.readUTF();
                    String context = istr.readUTF();
                    String details = istr.readUTF();
                    this.reportError(msg, context, details);
                    break;
                }
                case 18: {
                    StreamCache cache;
                    int id = istr.readInt();
                    String name = istr.readUTF();
                    String type = istr.readUTF();
                    long len = istr.readLong();
                    long posn = istr.readLong();
                    String auth = istr.readUTF();
                    MediaLibraryEntry entry = this.get(id);
                    if (entry == null) {
                        cache = new StreamCache(id, len);
                        entry = new MediaLibraryEntry(cache, null, name, type);
                        this.insert(id, entry);
                    } else {
                        cache = entry.getCache();
                        cache.setLocation(posn);
                    }
                    cache.setLock(this.getLock());
                    break;
                }
                case 19: {
                    int id = istr.readInt();
                    long posn = istr.readLong();
                    MediaLibraryEntry entry = this.get(id);
                    if (entry == null) break;
                    this.svrProxy.reconnect(entry, posn);
                    break;
                }
                case 26: {
                    int id = istr.readInt();
                    while (id > 0) {
                        MediaLibraryEntry entry = this.get(id);
                        if (entry != null) {
                            entry.decodeProgress(istr);
                        } else {
                            istr.skipBytes(1 + MultimediaProtocol.STATUS_PCT.length * 2);
                        }
                        id = istr.readInt();
                    }
                    break;
                }
                case 24: {
                    int id = istr.readInt();
                    istr.close();
                    istr = null;
                    if (this.svrProxy == null) {
                        return;
                    }
                    this.svrProxy.setUrgent(id, true);
                    break;
                }
                default: {
                    this.reportError("ClientMediaLibrary.unexpectedMessage", "", Byte.toString(event.getCommand()));
                }
            }
            if (istr != null) {
                istr.close();
            }
        }
        catch (IOException ex) {
            LogSupport.exception((Object)((Object)this), (String)"onChannelData", (Throwable)ex, (boolean)true);
        }
    }

    public void transmitStatusChange(TransmitStatusEvent e) {
        if (e.getSourceAddress() != 0) {
            return;
        }
        if (this.svrProxy == null) {
            return;
        }
        this.svrProxy.onTransmitStatusChanged(e);
    }

    protected void startHook(int id) {
        MediaLibraryEntry ent = this.get(id);
        if (ent == null) {
            return;
        }
        if (ent.isComplete()) {
            return;
        }
        if (ent.getSource() == this.channel.getConnection().getAddress()) {
            return;
        }
        ChannelDataEvent evt = ChannelDataEvent.getInstance((Object)((Object)this), (short)0, (byte)24);
        try {
            DataOutputStream ostr = evt.write();
            ostr.writeInt(id);
            ostr.close();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)((Object)this), (String)"startHook", (Throwable)ex, (boolean)true);
            evt.dispose();
            return;
        }
        this.channel.onChannelData(evt);
    }

    public void addProxy(short addr) {
        if (addr != 0) {
            throw new IllegalArgumentException("Only the server may be a client proxy.");
        }
        if (this.channel == null) {
            throw new IllegalStateException("Cannot add procy when not connected.");
        }
        if (this.svrProxy != null) {
            return;
        }
        this.svrProxy = new StreamProxy(this.channel, addr, 32000);
        ChannelDataEvent e = this.serverMsg((byte)21);
        try {
            DataOutputStream ostr = e.write();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                MediaLibraryEntry ent = (MediaLibraryEntry)i.next();
                ent.encodeStatus(ostr, this.getConnection().getAddress());
                ent.setAcknowledged(ent.getPosition());
            }
            ostr.writeInt(0);
            ostr.close();
            this.channel.onChannelData(e);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)((Object)this), (String)"addProxy", (Throwable)ex, (boolean)true);
        }
    }

    public void removeProxy(short addr) {
        if (addr == 0 && this.svrProxy != null) {
            this.disconnectProxy(this.svrProxy);
            this.svrProxy = null;
        }
    }

    private ChannelDataEvent serverMsg(byte cmd) {
        if (cmd != 21) {
            this.chairCheck();
        }
        return ChannelDataEvent.getInstance((Object)((Object)this), (short)0, (byte)cmd);
    }

    private void chairCheck() {
        Chair chair = ChairProtocol.getChair((Connection)this.getConnection());
        if (!chair.isMe()) {
            throw new IllegalStateException("Not Chair.");
        }
    }
}

