/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module.action;

import com.elluminate.groupware.agenda.module.action.ActionParameterValue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;

public class ActionParameter {
    public static final int TYPE_BOOLEAN = 1;
    public static final int TYPE_INTEGER = 2;
    public static final int TYPE_TEXT = 3;
    public static final int TYPE_FILE = 4;
    public static final int TYPE_APPLICATION = 5;
    public static final int TYPE_EMBEDDED_FILE_OR_URL = 6;
    public static final int TYPE_BOUNDS = 7;
    public static final int TYPE_LIST = 8;
    public static final int TYPE_DURATION_SECONDS = 9;
    public static final int TYPE_DURATION_MINUTES = 10;
    public static final int TYPE_EMBEDDED_FILE = 11;
    public static final int TYPE_EMBEDDED_QUIZ = 12;
    public static final int TYPE_EMBEDDED_SCREEN = 13;
    public static final int TYPE_EDITABLE_LIST = 14;
    public static final int TYPE_URL = 15;
    public static final int TYPE_PHONE_NUMBER = 16;
    public static final int TYPE_PHONE_NUMBER_OR_SIP = 17;
    public static final int TYPE_PHONE_PIN = 18;
    public static final String PROP_MINIMUM_VALUE = "minimumValue";
    public static final String PROP_MAXIMUM_VALUE = "maximumValue";
    private String name;
    private String displayName;
    private int type;
    private String helpText;
    private int minimumValue = -1;
    private int maximumValue = -1;
    private ArrayList possibleValues;
    private String defaultValue;
    private boolean required = false;
    private HashMap problemSuggestions;
    private PropertyChangeSupport changeSupport;

    public ActionParameter(String name, String displayName, int type, String helpText) {
        this.name = name;
        this.displayName = displayName;
        this.type = type;
        this.helpText = helpText;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getType() {
        return this.type;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setMinimumValue(int minimumValue) {
        int oldVal = this.minimumValue;
        this.minimumValue = minimumValue;
        PropertyChangeSupport ch = this.changeSupport;
        if (ch != null) {
            ch.firePropertyChange(PROP_MINIMUM_VALUE, oldVal, minimumValue);
        }
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public void setMaximumValue(int maximumValue) {
        int oldVal = this.maximumValue;
        this.maximumValue = maximumValue;
        PropertyChangeSupport ch = this.changeSupport;
        if (ch != null) {
            ch.firePropertyChange(PROP_MAXIMUM_VALUE, oldVal, maximumValue);
        }
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPossibleValue(ActionParameterValue value) {
        ActionParameter actionParameter = this;
        synchronized (actionParameter) {
            if (this.possibleValues == null) {
                this.possibleValues = new ArrayList();
            }
        }
        this.possibleValues.add(value);
    }

    public synchronized ActionParameterValue[] getPossibleValues() {
        if (this.possibleValues != null) {
            return this.possibleValues.toArray(new ActionParameterValue[0]);
        }
        return new ActionParameterValue[0];
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setProblemSuggestion(int problemType, String suggestion) {
        if (this.problemSuggestions == null) {
            this.problemSuggestions = new HashMap();
        }
        this.problemSuggestions.put(new Integer(problemType), suggestion);
    }

    public String getProblemSuggestion(int problemType) {
        if (this.problemSuggestions != null) {
            return (String)this.problemSuggestions.get(new Integer(problemType));
        }
        return null;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(l);
        }
    }
}

