/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaFile;
import com.elluminate.groupware.agenda.AgendaItem;
import com.elluminate.groupware.agenda.AgendaUtils;
import com.elluminate.groupware.agenda.event.AgendaEvent;
import com.elluminate.groupware.agenda.event.AgendaListener;
import com.elluminate.groupware.agenda.module.AgendaValidator;
import com.elluminate.groupware.agenda.module.StringsProperties;
import com.elluminate.groupware.agenda.module.event.AgendaValidatorEvent;
import com.elluminate.groupware.agenda.module.event.AgendaValidatorListener;
import com.elluminate.gui.swing.CTable;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.File;
import java.text.NumberFormat;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

class FilesEditor
extends CTable
implements AgendaListener {
    public static final int MODE_VIEWING = 1;
    public static final int MODE_PRESENTING = 2;
    public static final int MODE_EDITING = 3;
    private static final Color ALTERNATE_ROW_COLOR = new Color(237, 243, 254);
    private I18n i18n;
    private FileListModel fileListModel;
    private Agenda agenda;
    private AgendaValidator validator;
    private AgendaValidatorListener validatorListener = new AgendaValidatorListener(){

        @Override
        public void problemFound(AgendaValidatorEvent e) {
            this.problemChanged(e);
        }

        @Override
        public void problemResolved(AgendaValidatorEvent e) {
            this.problemChanged(e);
        }

        private void problemChanged(AgendaValidatorEvent e) {
            AgendaItem it = e.getItem();
            if (it instanceof AgendaFile) {
                FilesEditor.this.repaintFile((AgendaFile)it);
            }
        }
    };
    private Color problemColor;
    private Color transparentProblemColor;
    private int mode = 1;
    private Font f;

    public FilesEditor(I18n i18n) {
        this.i18n = i18n;
        this.setOpaque(false);
        this.setRowHeight(18);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setProblemColor(Color.RED, 64);
        int shortcutMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        InputMap imap = this.getInputMap();
        imap.put(KeyStroke.getKeyStroke(38, shortcutMask), "none");
        imap.put(KeyStroke.getKeyStroke(40, shortcutMask), "none");
        imap.put(KeyStroke.getKeyStroke(37, shortcutMask), "none");
        imap.put(KeyStroke.getKeyStroke(39, shortcutMask), "none");
        this.f = this.getFont();
        if (Platform.getLAF() == 502) {
            this.f = this.f.deriveFont((float)this.f.getSize() - 1.0f);
            this.setFont(this.f);
        }
        this.fileListModel = new FileListModel();
        this.fileListModel.addColumn(i18n.getString((PropertiesEnum)StringsProperties.FILESEDITOR_FILELISTNAME));
        this.fileListModel.addColumn("");
        this.fileListModel.addColumn("");
        this.setModel(this.fileListModel);
        JTableHeader hdr = this.getTableHeader();
        if (hdr != null) {
            hdr.setResizingAllowed(false);
            hdr.setReorderingAllowed(false);
        }
        TableColumn col = this.getColumnModel().getColumn(1);
        col.setMinWidth(75);
        col.setPreferredWidth(75);
        col.setMaxWidth(75);
        col = this.getColumnModel().getColumn(2);
        col.setMinWidth(20);
        col.setPreferredWidth(20);
        col.setMaxWidth(20);
        this.setDefaultRenderer(Object.class, new FileRenderer());
    }

    public void setProblemColor(Color problemColor, int alpha) {
        if (problemColor != null) {
            this.problemColor = problemColor;
            this.transparentProblemColor = new Color(problemColor.getRed(), problemColor.getGreen(), problemColor.getBlue(), alpha);
            this.repaint();
        }
    }

    public Color getProblemColor() {
        return this.problemColor;
    }

    public synchronized void setValidator(AgendaValidator validator) {
        if (this.validator != null && this.agenda != null) {
            this.validator.removeAgendaValidatorListener(this.agenda, this.validatorListener);
        }
        this.validator = validator;
        if (validator != null && this.agenda != null) {
            validator.addAgendaValidatorListener(this.agenda, this.validatorListener);
        }
    }

    public Agenda getAgenda() {
        return this.agenda;
    }

    public synchronized void setAgenda(Agenda agenda) {
        if (this.agenda != null) {
            this.agenda.removeAgendaListener((AgendaListener)this);
            if (this.validator != null) {
                this.validator.removeAgendaValidatorListener(this.agenda, this.validatorListener);
            }
        }
        this.fileListModel.setRowCount(0);
        this.agenda = agenda;
        if (agenda != null) {
            this.populate();
            agenda.addAgendaListener((AgendaListener)this);
            if (this.validator != null) {
                this.validator.addAgendaValidatorListener(agenda, this.validatorListener);
            }
        }
    }

    public AgendaFile[] getSelectedFiles() {
        int[] rows = this.getSelectedRows();
        AgendaFile[] a = new AgendaFile[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            a[i] = (AgendaFile)this.fileListModel.getValueAt(rows[i], 0);
        }
        return a;
    }

    private void populate() {
        for (int i = 0; i < this.agenda.getFileCount(); ++i) {
            AgendaFile file = this.agenda.getFile(i);
            Object[] cells = new Object[]{file, file, file};
            this.fileListModel.addRow(cells);
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        Point pt;
        int row;
        switch (e.getID()) {
            case 501: {
                if (this.rowAtPoint(e.getPoint()) != -1) break;
                this.clearSelection();
                this.requestFocus();
            }
        }
        if (e.isPopupTrigger() && (row = this.rowAtPoint(pt = e.getPoint())) != -1) {
            Rectangle b = this.getCellRect(row, 0, false);
            if (b.y <= pt.y && pt.y <= b.y + b.height && !this.isRowSelected(row)) {
                this.setRowSelectionInterval(row, row);
            }
        }
        super.processMouseEvent(e);
    }

    protected void paintComponent(Graphics g) {
        g.setColor(ALTERNATE_ROW_COLOR);
        Dimension s = this.getSize();
        int rh = this.getRowHeight();
        for (int y = 0; y < s.height; y += 2 * rh) {
            g.fillRect(0, y, s.width, rh);
        }
        super.paintComponent(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintFile(AgendaFile file) {
        FileListModel fileListModel = this.fileListModel;
        synchronized (fileListModel) {
            for (int i = 0; i < this.fileListModel.getRowCount(); ++i) {
                if (this.fileListModel.getValueAt(i, 0) != file) continue;
                this.fileListModel.updateRow(i);
                break;
            }
        }
    }

    public void editorChanged(AgendaEvent e) {
    }

    public void agendaPropertyChanged(AgendaEvent e) {
    }

    public void itemAdded(AgendaEvent e) {
        AgendaItem it = e.getItem();
        if (it instanceof AgendaFile) {
            int row = e.getIndex();
            if (row == -1) {
                row = this.fileListModel.getRowCount();
            }
            Object[] cells = new Object[]{it, it, it};
            this.fileListModel.insertRow(row, cells);
            this.getSelectionModel().addSelectionInterval(row, row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemRemoved(AgendaEvent e) {
        AgendaItem it = e.getItem();
        if (it instanceof AgendaFile) {
            FileListModel fileListModel = this.fileListModel;
            synchronized (fileListModel) {
                for (int i = 0; i < this.fileListModel.getRowCount(); ++i) {
                    if (this.fileListModel.getValueAt(i, 0) != it) continue;
                    this.fileListModel.removeRow(i);
                    break;
                }
            }
        }
    }

    public void itemPropertyChanged(AgendaEvent e) {
        AgendaItem it = e.getItem();
        if (it instanceof AgendaFile) {
            AgendaFile file = (AgendaFile)it;
            String prop = e.getProperty();
            if (prop.equals("name") || prop.equals("autoload") || prop.equals("size")) {
                this.repaintFile(file);
            }
        }
    }

    public void timerStarted(AgendaEvent e) {
    }

    public void timerStopped(AgendaEvent e) {
    }

    public void transferAdded(AgendaEvent e) {
    }

    public void transferRemoved(AgendaEvent e) {
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public String getStrikeThroughText(String text, boolean isSelected) {
        if (!Platform.checkJavaVersion((String)"1.6+")) {
            if (isSelected) {
                return "<html><span style='color:white'><strike>" + text + "</strike></span></html>";
            }
            return "<html><span style='color:gray'><strike>" + text + "</strike></span></html>";
        }
        HashMap<TextAttribute, Boolean> attrs = new HashMap<TextAttribute, Boolean>();
        attrs.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        this.setFont(this.f.deriveFont(attrs));
        return text;
    }

    private static class AutoloadIcon
    implements Icon {
        private static final int SIZE = 6;
        private static final Color COLOR = new Color(116, 191, 113);

        private AutoloadIcon() {
        }

        @Override
        public int getIconWidth() {
            return 6;
        }

        @Override
        public int getIconHeight() {
            return 6;
        }

        @Override
        public void paintIcon(Component component, Graphics g, int x, int y) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(COLOR);
            g.fillOval(x, y, 6, 6);
        }
    }

    private static class FileListModel
    extends DefaultTableModel {
        private FileListModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void updateRow(int row) {
            this.fireTableRowsUpdated(row, row);
        }
    }

    private class FileRenderer
    extends DefaultTableCellRenderer {
        private static final double KB = 1024.0;
        private static final double MB = 1048576.0;
        private static final double GB = 1.073741824E9;
        private NumberFormat format = NumberFormat.getNumberInstance();
        private Icon autoloadIcon = new AutoloadIcon();
        private AgendaValidatorEvent[] problems;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            this.problems = null;
            super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            if (!selected) {
                if (row % 2 == 0) {
                    this.setBackground(ALTERNATE_ROW_COLOR);
                } else {
                    this.setBackground(table.getBackground());
                }
            }
            this.setBorder(noFocusBorder);
            if (value instanceof AgendaFile) {
                AgendaFile file = (AgendaFile)value;
                if (FilesEditor.this.validator != null) {
                    this.problems = FilesEditor.this.validator.getProblems((AgendaItem)file);
                }
                switch (column) {
                    case 0: {
                        if (this.problems != null && FilesEditor.this.mode != 3) {
                            if (!selected) {
                                this.setForeground(Color.gray);
                            }
                            this.setText(FilesEditor.this.getStrikeThroughText(file.getName(), selected));
                        } else {
                            if (!selected) {
                                this.setForeground(Color.black);
                            }
                            this.setFont(FilesEditor.this.f);
                            this.setText(file.getName());
                        }
                        this.setIcon(AgendaUtils.getFileIcon((File)new File(file.getPath())));
                        break;
                    }
                    case 1: {
                        this.setFont(FilesEditor.this.f);
                        this.setText(this.formatSize(file.getSize()));
                        this.setIcon(null);
                        break;
                    }
                    case 2: {
                        this.setText(null);
                        this.setIcon(file.isAutoload() ? this.autoloadIcon : null);
                    }
                }
            }
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.problems != null && FilesEditor.this.mode == 3) {
                Dimension s = this.getSize();
                g.setColor(FilesEditor.this.transparentProblemColor);
                g.fillRect(0, 0, s.width, s.height);
                g.setColor(FilesEditor.this.problemColor);
                g.drawLine(0, 0, s.width - 1, 0);
                g.drawLine(0, s.height - 1, s.width - 1, s.height - 1);
            }
        }

        private String formatSize(long size) {
            if ((double)size >= 1.073741824E9) {
                this.format.setMaximumFractionDigits(1);
                return FilesEditor.this.i18n.getString((PropertiesEnum)StringsProperties.FILESEDITOR_FILESIZEGIGABYTES, new Object[]{this.format.format((double)size / 1.073741824E9)});
            }
            if ((double)size >= 1048576.0) {
                this.format.setMaximumFractionDigits(1);
                return FilesEditor.this.i18n.getString((PropertiesEnum)StringsProperties.FILESEDITOR_FILESIZEMEGABYTES, new Object[]{this.format.format((double)size / 1048576.0)});
            }
            if ((double)size >= 1024.0) {
                this.format.setMaximumFractionDigits(0);
                return FilesEditor.this.i18n.getString((PropertiesEnum)StringsProperties.FILESEDITOR_FILESIZEKILOBYTES, new Object[]{this.format.format((double)size / 1024.0)});
            }
            this.format.setMaximumFractionDigits(0);
            return FilesEditor.this.i18n.getString((PropertiesEnum)StringsProperties.FILESEDITOR_FILESIZEBYTES, new Object[]{this.format.format(size)});
        }
    }
}

