/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandInstantiationException;
import com.elluminate.engine.CommandNotChairException;
import com.elluminate.engine.CommandNotFoundException;
import com.elluminate.engine.CommandNotOnlineException;
import com.elluminate.engine.CommandNotPlaybackException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.Command;
import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaAction;
import com.elluminate.groupware.agenda.AgendaExecutable;
import com.elluminate.groupware.agenda.AgendaUtils;
import com.elluminate.groupware.agenda.module.Actions;
import com.elluminate.groupware.agenda.module.AgendaModule;
import com.elluminate.groupware.agenda.module.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Component;

class ExecutableTask
implements Runnable {
    private AgendaModule module;
    private I18n i18n;
    private Agenda agenda;
    private AgendaExecutable executable;
    private boolean suppressErrors;

    public ExecutableTask(AgendaModule module, I18n i18n, Agenda agenda, AgendaExecutable executable, boolean suppressErrors) {
        this.module = module;
        this.i18n = i18n;
        this.agenda = agenda;
        this.executable = executable;
        this.suppressErrors = suppressErrors;
    }

    @Override
    public void run() {
        this.execute(this.executable);
    }

    private void execute(AgendaExecutable executable) {
        block18: {
            try {
                if (executable instanceof AgendaAction && ((AgendaAction)executable).isCompoundAction()) {
                    AgendaAction act = (AgendaAction)executable;
                    for (int i = 0; i < act.getActionCount(); ++i) {
                        this.execute((AgendaExecutable)act.getAction(i));
                    }
                } else {
                    Class<?> intf = Class.forName(executable.getCommandName());
                    Command cmd = this.module.getConfEngine().newCommand(intf);
                    if (Actions.setupCommand(cmd, executable, this.module.getBean(), this.i18n)) {
                        cmd.execute();
                    }
                }
            }
            catch (ClassNotFoundException ex) {
                if (!this.suppressErrors) {
                    ModalDialog.showMessageDialog((Component)this.module.getBean(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDUNKNOWNMESSAGE, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)executable)}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDUNKNOWNTITLE), (int)0);
                }
            }
            catch (CommandNotFoundException ex) {
                if (!this.suppressErrors) {
                    ModalDialog.showMessageDialog((Component)this.module.getBean(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDNOTFOUNDMESSAGE, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)executable)}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDNOTFOUNDTITLE), (int)0);
                }
            }
            catch (CommandInstantiationException ex) {
                if (!this.suppressErrors) {
                    ModalDialog.showMessageDialog((Component)this.module.getBean(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDCREATIONFAILEDMESSAGE, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)executable)}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDCREATIONFAILEDTITLE), (int)0);
                }
            }
            catch (CommandNotOnlineException ex) {
                if (!this.suppressErrors) {
                    ModalDialog.showMessageDialog((Component)this.module.getBean(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDNOTONLINEMESSAGE, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)executable)}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDNOTONLINETITLE), (int)0);
                }
            }
            catch (CommandNotChairException ex) {
                if (!this.suppressErrors) {
                    ModalDialog.showMessageDialog((Component)this.module.getBean(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDNOTCHAIRMESSAGE, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)executable)}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDNOTCHAIRTITLE), (int)0);
                }
            }
            catch (CommandNotPlaybackException ex) {
                if (!this.suppressErrors) {
                    ModalDialog.showMessageDialog((Component)this.module.getBean(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDNOTPLAYBACKMESSAGE, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)executable)}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDNOTPLAYBACKTITLE), (int)0);
                }
            }
            catch (CommandExecutionException ex) {
                if (this.suppressErrors) break block18;
                String dmsg = ex.getDisplayMessage();
                String msg = dmsg != null && dmsg.length() != 0 ? this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDFAILEDWITHREASONMESSAGE, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)executable), dmsg}) : (ex instanceof CommandParameterException ? this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDPARAMETERBADMESSAGE, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)executable)}) : (ex instanceof CommandContextException ? this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDCONTEXTBADMESSAGE, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)executable)}) : this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDFAILEDMESSAGE, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)executable)})));
                String title = ex instanceof CommandParameterException ? this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDPARAMETERBADTITLE) : (ex instanceof CommandContextException ? this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDCONTEXTBADTITLE) : this.i18n.getString((PropertiesEnum)StringsProperties.EXECUTABLETASK_COMMANDFAILEDTITLE));
                ModalDialog.showMessageDialog((Component)this.module.getBean(), (Object)msg, (String)title, (int)0);
            }
        }
    }
}

