/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import com.elluminate.engine.ConferencingEngine;
import com.elluminate.engine.command.SetMaximumCamerasCommand;
import com.elluminate.engine.command.SetMaximumTalkersCommand;
import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaAction;
import com.elluminate.groupware.agenda.AgendaExecutable;
import com.elluminate.groupware.agenda.AgendaFile;
import com.elluminate.groupware.agenda.AgendaItem;
import com.elluminate.groupware.agenda.AgendaLibrary;
import com.elluminate.groupware.agenda.AgendaNode;
import com.elluminate.groupware.agenda.AgendaText;
import com.elluminate.groupware.agenda.AgendaTopic;
import com.elluminate.groupware.agenda.AgendaUtils;
import com.elluminate.groupware.agenda.event.AgendaEvent;
import com.elluminate.groupware.agenda.event.AgendaLibraryEvent;
import com.elluminate.groupware.agenda.event.AgendaLibraryListener;
import com.elluminate.groupware.agenda.event.AgendaListener;
import com.elluminate.groupware.agenda.module.Actions;
import com.elluminate.groupware.agenda.module.AgendaBean;
import com.elluminate.groupware.agenda.module.AgendaEditor;
import com.elluminate.groupware.agenda.module.AgendaPreferences;
import com.elluminate.groupware.agenda.module.AgendaValidator;
import com.elluminate.groupware.agenda.module.FilesEditor;
import com.elluminate.groupware.agenda.module.PopupMenu;
import com.elluminate.groupware.agenda.module.PropertyEditor;
import com.elluminate.groupware.agenda.module.StringsProperties;
import com.elluminate.groupware.agenda.module.action.ActionDependency;
import com.elluminate.groupware.agenda.module.action.ActionInfo;
import com.elluminate.groupware.agenda.module.action.ActionParameter;
import com.elluminate.groupware.agenda.module.event.AgendaEditorEvent;
import com.elluminate.groupware.agenda.module.event.AgendaEditorListener;
import com.elluminate.groupware.agenda.module.event.AgendaValidatorEvent;
import com.elluminate.groupware.agenda.module.event.AgendaValidatorListener;
import com.elluminate.groupware.imps.quiz.Quiz;
import com.elluminate.groupware.imps.whiteboard.WhiteboardScreenNode;
import com.elluminate.gui.dnd.UriListDataFlavor;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientListener;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

@Singleton
public class EditorPanel
extends JPanel
implements AgendaLibraryListener,
AgendaListener,
PropertyChangeListener,
ClientListener {
    public static final String PROP_AGENDA = "agenda";
    public static final String PROP_SELECTED_ITEMS = "selectedItems";
    public static final DataFlavor commandFlavor = new DataFlavor(CommandSelection.class, "Command Selection");
    public static final DataFlavor agendaFileListFlavor = new DataFlavor(AgendaFileSelection.class, "Agenda File Selection");
    public static final DataFlavor agendaNodeListFlavor = new DataFlavor(AgendaNodeSelection.class, "Agenda Node Selection");
    public static final UriListDataFlavor uriListFlavor;
    private static final int PROBLEM_COLOR_ALPHA = 64;
    private static final Color BORDER_COLOR;
    private static final Font PROBLEM_FONT;
    private AgendaBean bean;
    private AgendaLibrary library;
    private JSplitPane propertiesSplit;
    private JSplitPane filesSplit;
    private JSplitPane notesSplit;
    private int defaultDividerSize;
    private int lastFilesDividerPosition;
    private int lastNotesDividerPosition;
    private int lastPropertiesDividerPosition;
    private Font noteFont;
    private JScrollPane filesScroller;
    private FilesEditor filesEditor;
    private JScrollPane agendaScroller;
    private AgendaEditor agendaEditor;
    private JScrollPane notesScroller;
    private JTextArea notesField;
    private PropertyEditor propertyEditor;
    private AgendaItem[] selectedItems;
    private AgendaValidator agendaValidator;
    private PopupMenu popup;
    private AgendaValidatorListener problemNoteUpdater = new AgendaValidatorListener(){

        @Override
        public void problemFound(AgendaValidatorEvent e) {
            this.problemChanged(e);
        }

        @Override
        public void problemResolved(AgendaValidatorEvent e) {
            this.problemChanged(e);
        }

        private void problemChanged(AgendaValidatorEvent e) {
            AgendaItem selectedItem = null;
            if (EditorPanel.this.selectedItems != null && EditorPanel.this.selectedItems.length == 1) {
                selectedItem = EditorPanel.this.selectedItems[0];
            }
            Agenda ag = e.getAgenda();
            AgendaItem it = e.getItem();
            if (it != null) {
                if (selectedItem != null && selectedItem == it) {
                    EditorPanel.this.updateNotes(selectedItem);
                }
            } else if (selectedItem != null) {
                EditorPanel.this.updateNotes(selectedItem);
            } else {
                EditorPanel.this.updateNotes(ag, null);
            }
        }
    };
    private ProblemNoteProvider problemNoteProvider;
    private Color notesProblemColor = EditorPanel.fakeTransparentColor(Color.RED, 64);
    private boolean clearingAgendaEditor;
    private boolean clearingFilesEditor;

    public EditorPanel(AgendaBean bean, AgendaLibrary library, I18n i18n, PropertyEditor pe) {
        super(new BorderLayout());
        this.bean = bean;
        this.library = library;
        bean.getClientList().addClientListener((ClientListener)this);
        bean.addPropertyChangeListener("moderator", this);
        library.addAgendaLibraryListener((AgendaLibraryListener)this);
        this.propertiesSplit = new JSplitPane(1, true){
            private boolean initialDividerLocationSet;
            {
                this.initialDividerLocationSet = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reshape(int x, int y, int width, int height) {
                super.reshape(x, y, width, height);
                2 var5_5 = this;
                synchronized (var5_5) {
                    if (!this.initialDividerLocationSet && width != 0) {
                        this.initialDividerLocationSet = true;
                        this.setDividerLocation(this.getWidth() - EditorPanel.this.lastPropertiesDividerPosition);
                    }
                }
            }
        };
        this.propertiesSplit.setUI(new PropertySplitterUI());
        this.propertiesSplit.setBorder(BorderFactory.createEmptyBorder());
        this.propertiesSplit.setResizeWeight(1.0);
        this.propertiesSplit.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (EditorPanel.this.propertyEditor.isShowing()) {
                    EditorPanel.this.lastPropertiesDividerPosition = EditorPanel.this.propertiesSplit.getWidth() - EditorPanel.this.propertiesSplit.getDividerLocation();
                }
            }
        });
        this.filesSplit = new JSplitPane(0, true);
        if (Platform.getLAF() != 502) {
            this.filesSplit.setUI(new SplitterUI());
        }
        this.filesSplit.setResizeWeight(0.0);
        this.filesSplit.setBorder(BorderFactory.createEmptyBorder());
        this.filesSplit.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (EditorPanel.this.filesScroller != null && EditorPanel.this.filesScroller.isShowing()) {
                    EditorPanel.this.lastFilesDividerPosition = EditorPanel.this.filesSplit.getDividerLocation();
                    if (EditorPanel.this.lastFilesDividerPosition < 5) {
                        EditorPanel.this.filesEditor.clearSelection();
                        KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                        if (fm.getFocusOwner() == EditorPanel.this.filesEditor) {
                            fm.focusNextComponent((Component)((Object)EditorPanel.this.filesEditor));
                        }
                    }
                }
            }
        });
        this.notesSplit = new JSplitPane(0, true);
        if (Platform.getLAF() != 502) {
            this.notesSplit.setUI(new SplitterUI());
        }
        this.defaultDividerSize = this.notesSplit.getDividerSize();
        this.notesSplit.setResizeWeight(1.0);
        this.notesSplit.setBorder(BorderFactory.createEmptyBorder());
        this.notesSplit.setDividerSize(0);
        this.notesSplit.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (EditorPanel.this.notesScroller.isShowing()) {
                    EditorPanel.this.lastNotesDividerPosition = EditorPanel.this.notesSplit.getHeight() - EditorPanel.this.notesSplit.getDividerLocation();
                }
            }
        });
        this.propertyEditor = pe;
        this.propertyEditor.setMinimumSize(new Dimension(0, 0));
        this.filesEditor = new FilesEditor(i18n){
            private AgendaFile lastHoveredFile;
            private String cachedTip;

            public String getToolTipText(MouseEvent e) {
                if (EditorPanel.this.agendaEditor.getMode() != 3) {
                    return null;
                }
                int row = this.rowAtPoint(e.getPoint());
                if (row != -1) {
                    AgendaFile file = (AgendaFile)this.getModel().getValueAt(row, 0);
                    if (this.lastHoveredFile != file) {
                        this.lastHoveredFile = file;
                        this.cachedTip = EditorPanel.this.problemNoteProvider.getProblemDescription(null, (AgendaItem)file, true);
                    }
                    return this.cachedTip;
                }
                this.lastHoveredFile = null;
                return null;
            }

            @Override
            protected void processMouseEvent(MouseEvent e) {
                super.processMouseEvent(e);
                if (e.getID() == 505) {
                    this.lastHoveredFile = null;
                }
            }
        };
        this.filesEditor.setDragEnabled(true);
        this.filesEditor.setTransferHandler(new FilesEditorTransferHandler());
        this.filesEditor.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (EditorPanel.this.clearingFilesEditor || e.getValueIsAdjusting()) {
                    return;
                }
                EditorPanel.this.selectedItemsChanged((AgendaItem[])EditorPanel.this.filesEditor.getSelectedFiles());
                EditorPanel.this.clearingAgendaEditor = true;
                EditorPanel.this.agendaEditor.clearSelection();
                EditorPanel.this.clearingAgendaEditor = false;
            }
        });
        this.filesEditor.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (EditorPanel.this.agendaEditor.getSelectedIndex() != -1) {
                    EditorPanel.this.selectedItemsChanged((AgendaItem[])EditorPanel.this.filesEditor.getSelectedFiles());
                    EditorPanel.this.clearingAgendaEditor = true;
                    EditorPanel.this.agendaEditor.clearSelection();
                    EditorPanel.this.clearingAgendaEditor = false;
                }
                if (e.isPopupTrigger() && EditorPanel.this.agendaEditor.getMode() == 3) {
                    this.popupTriggered(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && EditorPanel.this.agendaEditor.getMode() == 3) {
                    this.popupTriggered(e);
                }
            }

            private void popupTriggered(MouseEvent e) {
                Point pt = e.getPoint();
                EditorPanel.this.popup.show(EditorPanel.this.selectedItems, (Component)((Object)EditorPanel.this.filesEditor), pt.x, pt.y);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                FilesEditor ed = (FilesEditor)((Object)e.getSource());
                if (EditorPanel.this.agendaEditor.getMode() == 3 && e.getClickCount() == 2) {
                    EditorPanel.this.bean.doEditFiles();
                }
            }
        });
        String removeItemAction = "remove-item";
        InputMap imap = this.filesEditor.getInputMap(0);
        imap.put(KeyStroke.getKeyStroke(127, 0), "remove-item");
        imap.put(KeyStroke.getKeyStroke(8, 0), "remove-item");
        this.filesEditor.getActionMap().put("remove-item", new AbstractAction("remove-item"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditorPanel.this.agendaEditor.getMode() == 3) {
                    EditorPanel.this.bean.doRemoveItems();
                }
            }
        });
        this.filesScroller = new JScrollPane(22, 31);
        this.filesScroller.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, BORDER_COLOR));
        this.filesScroller.setViewport(new JViewport(){

            @Override
            public void setViewSize(Dimension newSize) {
                Dimension s = this.getSize();
                if (newSize != null && newSize.height < s.height) {
                    newSize = new Dimension(newSize.width, s.height);
                }
                super.setViewSize(newSize);
            }
        });
        this.filesScroller.setViewportView((Component)((Object)this.filesEditor));
        this.filesScroller.setMinimumSize(new Dimension(0, 0));
        this.agendaEditor = new AgendaEditor(this.createIconProvider()){
            private AgendaNode lastHoveredNode;
            private String cachedTip;

            @Override
            public String getToolTipText(MouseEvent e) {
                if (EditorPanel.this.agendaEditor.getMode() != 3) {
                    return null;
                }
                int row = this.locationToIndex(e.getPoint());
                if (row != -1) {
                    AgendaNode node = (AgendaNode)this.getModel().getElementAt(row);
                    if (this.lastHoveredNode != node) {
                        this.lastHoveredNode = node;
                        this.cachedTip = EditorPanel.this.problemNoteProvider.getProblemDescription(null, (AgendaItem)node, true);
                    }
                    return this.cachedTip;
                }
                this.lastHoveredNode = null;
                return null;
            }

            @Override
            protected void processMouseEvent(MouseEvent e) {
                super.processMouseEvent(e);
                if (e.getID() == 505) {
                    this.lastHoveredNode = null;
                }
            }
        };
        this.agendaEditor.setDragEnabled(true);
        this.agendaEditor.setTransferHandler(new AgendaEditorTransferHandler());
        imap = this.agendaEditor.getInputMap(0);
        imap.put(KeyStroke.getKeyStroke(127, 0), "remove-item");
        imap.put(KeyStroke.getKeyStroke(8, 0), "remove-item");
        this.agendaEditor.getActionMap().put("remove-item", new AbstractAction("remove-item"){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorPanel.this.bean.doRemoveItems();
            }
        });
        this.agendaEditor.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (EditorPanel.this.clearingAgendaEditor || e.getValueIsAdjusting() || EditorPanel.this.agendaEditor.getMode() != 3) {
                    return;
                }
                EditorPanel.this.selectedItemsChanged((AgendaItem[])EditorPanel.this.agendaEditor.getSelectedNodes());
                EditorPanel.this.clearingFilesEditor = true;
                EditorPanel.this.filesEditor.clearSelection();
                EditorPanel.this.clearingFilesEditor = false;
            }
        });
        this.agendaEditor.addAgendaEditorListener(new AgendaEditorListener(){

            @Override
            public void nodeStatusClicked(AgendaEditorEvent e) {
                Agenda ag = EditorPanel.this.agendaEditor.getAgenda();
                AgendaNode node = e.getAgendaNode();
                boolean toggleAll = (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
                EditorPanel.this.bean.doToggleCovered(ag, node, toggleAll);
            }

            @Override
            public void nodeClicked(AgendaEditorEvent e) {
                Agenda ag = EditorPanel.this.agendaEditor.getAgenda();
                AgendaNode node = e.getAgendaNode();
                EditorPanel.this.bean.doNodeClick(ag, node);
            }

            @Override
            public void nodeDurationClicked(AgendaEditorEvent e) {
                Agenda ag = EditorPanel.this.agendaEditor.getAgenda();
                AgendaNode node = e.getAgendaNode();
                EditorPanel.this.bean.doDurationClick(ag, node);
            }

            @Override
            public void currentIndicatorMoved(AgendaEditorEvent e) {
                Agenda ag = EditorPanel.this.agendaEditor.getAgenda();
                AgendaNode node = e.getAgendaNode();
                EditorPanel.this.bean.doCurrentNode(ag, node);
            }
        });
        this.agendaEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.isActionKey() || Platform.getPlatform() != 2 && e.isAltDown()) {
                    return;
                }
                char ch = e.getKeyChar();
                int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                if (Character.isLetterOrDigit(ch) && (e.getModifiers() & mask) == 0 && EditorPanel.this.agendaEditor.getMode() == 3 && EditorPanel.this.propertyEditor.getItem() != null) {
                    EditorPanel.this.propertyEditor.startEditing(String.valueOf(ch));
                }
            }
        });
        this.agendaEditor.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (EditorPanel.this.filesEditor.getSelectedRowCount() != 0) {
                    EditorPanel.this.selectedItemsChanged((AgendaItem[])EditorPanel.this.agendaEditor.getSelectedNodes());
                    EditorPanel.this.clearingFilesEditor = true;
                    EditorPanel.this.filesEditor.clearSelection();
                    EditorPanel.this.clearingFilesEditor = false;
                }
                if (e.isPopupTrigger() && EditorPanel.this.agendaEditor.getMode() == 3) {
                    this.popupTriggered(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && EditorPanel.this.agendaEditor.getMode() == 3) {
                    this.popupTriggered(e);
                }
            }

            private void popupTriggered(MouseEvent e) {
                Point pt = e.getPoint();
                EditorPanel.this.popup.show(EditorPanel.this.selectedItems, EditorPanel.this.agendaEditor, pt.x, pt.y);
            }
        });
        this.agendaScroller = new JScrollPane(this.agendaEditor, 22, 31);
        this.agendaScroller.getViewport().setBackground(this.agendaEditor.getBackground());
        this.agendaValidator = new AgendaValidator(this.createContentProvider());
        this.problemNoteProvider = new ProblemNoteProvider(this.agendaValidator, i18n);
        this.notesField = new JTextArea();
        this.notesField.setEditable(false);
        this.notesField.setLineWrap(true);
        this.notesField.setWrapStyleWord(true);
        this.notesField.setTabSize(2);
        this.notesField.setMargin(new Insets(1, 4, 1, 4));
        this.notesScroller = new JScrollPane(this.notesField, 20, 31);
        this.notesScroller.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, BORDER_COLOR));
        this.notesScroller.setMinimumSize(new Dimension(0, 0));
        this.notesScroller.getViewport().setBackground(this.notesField.getBackground());
        this.filesSplit.setTopComponent(this.filesScroller);
        this.filesSplit.setBottomComponent(this.agendaScroller);
        this.propertiesSplit.setLeftComponent(this.filesSplit);
        this.propertiesSplit.setRightComponent(this.propertyEditor);
        this.notesSplit.setTopComponent(this.propertiesSplit);
        this.notesSplit.setBottomComponent(this.notesScroller);
        this.add((Component)this.notesSplit, "Center");
        this.popup = new PopupMenu(bean, i18n);
        this.updateView();
    }

    private AgendaEditor.IconProvider createIconProvider() {
        return new AgendaEditor.IconProvider(){

            @Override
            public Icon getIcon(AgendaItem item) {
                return EditorPanel.this.bean.getIcon(item);
            }
        };
    }

    private AgendaValidator.EmbeddedContentProvider createContentProvider() {
        return new AgendaValidator.EmbeddedContentProvider(){

            @Override
            public boolean fileContainsQuiz(AgendaFile file, String quizName) {
                String path = file.getPath();
                if (path.endsWith(".vcq")) {
                    try {
                        Quiz[] qzs = EditorPanel.this.bean.getQuizzes(new File(path));
                        for (int i = 0; i < qzs.length; ++i) {
                            if (!qzs[i].getName().equals(quizName)) continue;
                            return true;
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                return false;
            }

            @Override
            public boolean fileContainsScreen(AgendaFile file, String screen) {
                String path = file.getPath();
                if (path.endsWith(".wbd") || path.endsWith(".wbp")) {
                    try {
                        WhiteboardScreenNode root = EditorPanel.this.bean.getWhiteboard(new File(path));
                        if (screen.indexOf(":") != -1) {
                            return this.findScreenByPath(root, screen);
                        }
                        return this.findScreenByName(root, screen, 0);
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                return false;
            }

            private boolean findScreenByName(WhiteboardScreenNode node, String screenName, int level) {
                WhiteboardScreenNode n;
                for (int i = 0; i < node.getChildCount(); ++i) {
                    n = node.getChild(i);
                    if (!n.getName().equals(screenName)) continue;
                    return true;
                }
                if (level == 0) {
                    try {
                        int index = Integer.parseInt(screenName);
                        if (index > 0 && index <= node.getChildCount()) {
                            return true;
                        }
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                for (int i = 0; i < node.getChildCount(); ++i) {
                    n = node.getChild(i);
                    if (!this.findScreenByName(n, screenName, level + 1)) continue;
                    return true;
                }
                return false;
            }

            private boolean findScreenByPath(WhiteboardScreenNode node, String screenPath) {
                WhiteboardScreenNode n;
                int i;
                for (i = 0; i < node.getChildCount(); ++i) {
                    n = node.getChild(i);
                    if (!screenPath.equals(n.getName())) continue;
                    return true;
                }
                for (i = 0; i < node.getChildCount(); ++i) {
                    n = node.getChild(i);
                    String name = n.getName();
                    if (!screenPath.startsWith(name + ":")) continue;
                    return this.findScreenByPath(n, screenPath.substring(name.length() + 1));
                }
                String token = screenPath;
                int pos = screenPath.indexOf(58);
                if (pos != -1) {
                    token = screenPath.substring(0, pos);
                }
                try {
                    int index = Integer.parseInt(token);
                    if (index > 0 && index <= node.getChildCount()) {
                        String leftover;
                        if (pos != -1 && (leftover = screenPath.substring(pos + 1)).length() != 0) {
                            return this.findScreenByPath(node.getChild(index - 1), leftover);
                        }
                        return true;
                    }
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                return false;
            }
        };
    }

    public void setCommandEngine(ConferencingEngine commandEngine) {
        this.agendaValidator.setCommandEngine(commandEngine);
    }

    public Agenda getAgenda() {
        if (this.agendaEditor != null) {
            return this.agendaEditor.getAgenda();
        }
        return null;
    }

    public synchronized void setAgenda(Agenda agenda) {
        Agenda oldAgenda = this.agendaEditor.getAgenda();
        if (oldAgenda != null) {
            oldAgenda.removeAgendaListener((AgendaListener)this);
            oldAgenda.removePropertyChangeListener((PropertyChangeListener)this);
            this.agendaValidator.stopMonitoring(oldAgenda);
            this.agendaValidator.removeAgendaValidatorListener(agenda, this.problemNoteUpdater);
        }
        this.filesEditor.setAgenda(agenda);
        this.agendaEditor.setAgenda(agenda);
        this.propertyEditor.setAgenda(agenda);
        if (agenda != null) {
            this.agendaValidator.monitor(agenda);
            this.agendaValidator.addAgendaValidatorListener(agenda, this.problemNoteUpdater);
        }
        if (agenda != null) {
            if (this.agendaEditor.getMode() != 3) {
                this.updateNotes((AgendaItem)agenda.getCurrentNode());
            }
            agenda.addAgendaListener((AgendaListener)this);
            agenda.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.updateView();
        if (oldAgenda != null) {
            oldAgenda.unload();
        }
        this.firePropertyChange(PROP_AGENDA, oldAgenda, agenda);
    }

    public AgendaItem[] getSelectedItems() {
        return this.selectedItems;
    }

    public void setSelectedNode(AgendaNode node) {
        this.agendaEditor.setSelectedValue(node, true);
    }

    private void selectedItemsChanged(AgendaItem[] selectedItems) {
        AgendaItem[] oldItems = this.selectedItems;
        this.selectedItems = selectedItems;
        if (selectedItems != null && selectedItems.length == 1) {
            this.propertyEditor.setItem(selectedItems[0]);
            this.updateNotes(selectedItems[0]);
        } else {
            this.propertyEditor.setItem(null);
            this.updateNotes(this.agendaEditor.getAgenda(), null);
        }
        this.firePropertyChange(PROP_SELECTED_ITEMS, oldItems, selectedItems);
    }

    public void clearFileSelection() {
        this.filesEditor.clearSelection();
    }

    public void clearNodeSelection() {
        this.agendaEditor.clearSelection();
    }

    public void requestFocusInAgenda() {
        this.agendaEditor.requestFocus();
    }

    public void requestFocusInFiles() {
        this.filesEditor.requestFocus();
    }

    public void loadPreferences(Preferences preferences, String prefix) {
        this.lastFilesDividerPosition = AgendaPreferences.getFilesDividerPosition(prefix, preferences);
        this.lastNotesDividerPosition = AgendaPreferences.getNotesDividerPosition(prefix, preferences);
        this.lastPropertiesDividerPosition = AgendaPreferences.getPropertiesDividerPosition(prefix, preferences);
        this.agendaEditor.setCoveredNodeColor(AgendaPreferences.getCoveredNodeColor(prefix, preferences));
        this.agendaEditor.setActionHyperlinkColor(AgendaPreferences.getActionHyperlinkColor(prefix, preferences));
        this.agendaEditor.setTopicFont(AgendaPreferences.getTopicFont(prefix, preferences));
        this.agendaEditor.setActionFont(AgendaPreferences.getActionFont(prefix, preferences));
        this.agendaEditor.setTextFont(AgendaPreferences.getTextFont(prefix, preferences));
        this.noteFont = AgendaPreferences.getNoteFont(prefix, preferences);
        Color c = AgendaPreferences.getProblemColor(prefix, preferences);
        this.agendaEditor.setProblemColor(c, 64);
        this.filesEditor.setProblemColor(c, 64);
        this.notesProblemColor = EditorPanel.fakeTransparentColor(c, 64);
        int MB = 0x100000;
        this.agendaValidator.setTransferQuota(AgendaPreferences.getTransferQuota(prefix, preferences) * 0x100000);
        this.agendaValidator.setMultimediaQuota(AgendaPreferences.getMultimediaQuota(prefix, preferences) * 0x100000);
        this.agendaValidator.setWhiteboardQuota(AgendaPreferences.getWhiteboardQuota(prefix, preferences) * 0x100000);
        preferences.addSettingChangeListener(prefix + ".coveredNodeColor", (PropertyChangeListener)this);
        preferences.addSettingChangeListener(prefix + ".actionHyperlinkColor", (PropertyChangeListener)this);
        preferences.addSettingChangeListener(prefix + ".problemColor", (PropertyChangeListener)this);
        preferences.addSettingChangeListener(prefix + ".topicFont", (PropertyChangeListener)this);
        preferences.addSettingChangeListener(prefix + ".actionFont", (PropertyChangeListener)this);
        preferences.addSettingChangeListener(prefix + ".textFont", (PropertyChangeListener)this);
        preferences.addSettingChangeListener(prefix + ".noteFont", (PropertyChangeListener)this);
        preferences.addSettingChangeListener(prefix + ".transferQuota", (PropertyChangeListener)this);
        preferences.addSettingChangeListener(prefix + ".multimediaQuota", (PropertyChangeListener)this);
        preferences.addSettingChangeListener(prefix + ".whiteboardQuota", (PropertyChangeListener)this);
        preferences.addSettingChangeListener(prefix + ".maxTalkerCount", (PropertyChangeListener)this);
        preferences.addSettingChangeListener(prefix + ".maxCameraCount", (PropertyChangeListener)this);
    }

    public void savePreferences(Preferences preferences, String prefix) {
        AgendaPreferences.setFilesDividerPosition(prefix, preferences, this.lastFilesDividerPosition);
        AgendaPreferences.setNotesDividerPosition(prefix, preferences, this.lastNotesDividerPosition);
        AgendaPreferences.setPropertiesDividerPosition(prefix, preferences, this.lastPropertiesDividerPosition);
    }

    public Book getPrintingView(PageFormat format) {
        Rectangle b;
        AgendaEditor ed = new AgendaEditor(this.createIconProvider());
        ed.setMode(this.agendaEditor.getMode());
        ed.setPrintedAgenda(this.agendaEditor.getAgenda());
        ed.setCoveredNodeIcon(this.agendaEditor.getCoveredNodeIcon());
        ed.setCurrentNodeIcon(this.agendaEditor.getCurrentNodeIcon());
        ed.setCoveredNodeColor(this.agendaEditor.getCoveredNodeColor());
        ed.setTopicFont(this.agendaEditor.getTopicFont());
        ed.setActionFont(this.agendaEditor.getActionFont());
        ed.setTextFont(this.agendaEditor.getTextFont());
        ed.setIndentSize(this.agendaEditor.getIndentSize());
        ed.setDurationVisible(this.agendaEditor.isDurationVisible());
        ed.setSize((int)format.getImageableWidth(), Integer.MAX_VALUE);
        ed.addNotify();
        Book bk = new Book();
        int h = (int)format.getImageableHeight();
        int startRow = 0;
        while ((b = ed.getCellBounds(startRow, startRow)) != null) {
            int endRow = ed.locationToIndex(new Point(0, b.y + h - 1));
            if (endRow != -1) {
                --endRow;
            }
            bk.append(new PrintedAgendaPage(ed, startRow, endRow), format);
            if (endRow == -1) break;
            startRow = endRow + 1;
        }
        if (bk.getNumberOfPages() == 0) {
            bk.append(new PrintedAgendaPage(ed, -1, -1), format);
        }
        return bk;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.endsWith(".coveredNodeColor")) {
            Color c = Preferences.colorValue((Object)e.getNewValue(), null);
            if (c != null) {
                this.agendaEditor.setCoveredNodeColor(c);
            }
        } else if (prop.endsWith(".actionHyperlinkColor")) {
            Color c = Preferences.colorValue((Object)e.getNewValue(), null);
            if (c != null) {
                this.agendaEditor.setActionHyperlinkColor(c);
            }
        } else if (prop.endsWith(".problemColor")) {
            Color c = Preferences.colorValue((Object)e.getNewValue(), null);
            if (c != null) {
                this.agendaEditor.setProblemColor(c, 64);
                this.filesEditor.setProblemColor(c, 64);
                this.notesProblemColor = EditorPanel.fakeTransparentColor(c, 64);
                if (this.agendaEditor.getMode() == 3) {
                    this.notesField.setBackground(this.notesProblemColor);
                }
            }
        } else if (prop.endsWith(".topicFont")) {
            Font f = null;
            Object fontID = e.getNewValue();
            if (fontID != null) {
                f = Font.decode(String.valueOf(fontID));
            }
            this.agendaEditor.setTopicFont(f);
        } else if (prop.endsWith(".actionFont")) {
            Font f = null;
            Object fontID = e.getNewValue();
            if (fontID != null) {
                f = Font.decode(String.valueOf(fontID));
            }
            this.agendaEditor.setActionFont(f);
        } else if (prop.endsWith(".textFont")) {
            Font f = null;
            Object fontID = e.getNewValue();
            if (fontID != null) {
                f = Font.decode(String.valueOf(fontID));
            }
            this.agendaEditor.setTextFont(f);
        } else if (prop.endsWith(".noteFont")) {
            this.noteFont = null;
            Object fontID = e.getNewValue();
            if (fontID != null) {
                this.noteFont = Font.decode(String.valueOf(fontID));
            }
            if (this.agendaEditor.getMode() != 3) {
                this.notesField.setFont(this.noteFont);
            }
        } else if (prop.endsWith(".transferQuota")) {
            int size = Preferences.integerValue((Object)e.getNewValue(), (int)0);
            this.agendaValidator.setTransferQuota(size * 1024 * 1024);
        } else if (prop.endsWith(".multimediaQuota")) {
            int size = Preferences.integerValue((Object)e.getNewValue(), (int)0);
            this.agendaValidator.setMultimediaQuota(size * 1024 * 1024);
        } else if (prop.endsWith(".whiteboardQuota")) {
            int size = Preferences.integerValue((Object)e.getNewValue(), (int)0);
            this.agendaValidator.setWhiteboardQuota(size * 1024 * 1024);
        } else if (prop.endsWith(".maxTalkerCount")) {
            this.agendaValidator.recheckIntegerLimits(SetMaximumTalkersCommand.class);
        } else if (prop.endsWith(".maxCameraCount")) {
            this.agendaValidator.recheckIntegerLimits(SetMaximumCamerasCommand.class);
        } else if (prop.equals("moderator")) {
            this.updateView();
            Agenda ag = this.getAgenda();
            if (ag != null && this.agendaEditor.getMode() != 3) {
                this.updateNotes((AgendaItem)ag.getCurrentNode());
            }
        } else if (prop.equals("modified")) {
            this.bean.updateWindowModified();
        }
    }

    private void updateView() {
        Agenda ag = this.getAgenda();
        if (!this.bean.isOnline() && !this.bean.getClient().isPlayback()) {
            this.showEditor();
        } else {
            if (this.bean.isOnline()) {
                // empty if block
            }
            this.showViewer(this.bean.isChair());
        }
        this.revalidate();
        this.repaint();
        if (ag == null || !this.bean.isMe(ag.getEditor()) || this.bean.isOnline() && !this.library.isActiveAgenda(ag)) {
            this.agendaEditor.setMode(1);
        } else if (this.library.isActiveAgenda(ag) || this.bean.isOnline()) {
            this.agendaEditor.setMode(2);
        } else {
            this.agendaEditor.setMode(3);
        }
        this.agendaEditor.setDurationVisible(this.bean.isChair() || !this.bean.isOnline());
        this.agendaEditor.setActionExpandable(this.bean.isChair());
        int mode = this.agendaEditor.getMode();
        this.filesEditor.setValidator(this.agendaValidator);
        this.filesEditor.setMode(mode);
        this.agendaEditor.setValidator(this.agendaValidator);
    }

    private void showViewer(boolean chair) {
        this.propertyEditor.setVisible(false);
        this.propertiesSplit.setDividerSize(0);
        if (chair) {
            if (this.filesScroller != null) {
                this.filesScroller.setVisible(true);
            }
            if (this.filesSplit != null) {
                this.filesSplit.setDividerSize(this.defaultDividerSize);
                this.filesSplit.setDividerLocation(0);
            }
        } else {
            if (this.filesScroller != null) {
                this.filesScroller.setVisible(false);
            }
            if (this.filesSplit != null) {
                this.filesSplit.setDividerSize(0);
            }
        }
        int bottom = this.notesScroller.isVisible() ? 1 : 0;
        int top = chair ? 1 : 0;
        this.agendaScroller.setBorder(BorderFactory.createMatteBorder(top, 0, bottom, 0, BORDER_COLOR));
        this.notesField.setBackground(UIManager.getColor("ToolTip.background"));
        this.notesField.setFont(this.noteFont);
        this.agendaEditor.clearSelection();
    }

    private void showEditor() {
        this.propertyEditor.setVisible(true);
        this.propertiesSplit.setDividerSize(this.defaultDividerSize);
        this.propertiesSplit.setDividerLocation(this.propertiesSplit.getWidth() - this.lastPropertiesDividerPosition);
        if (this.filesScroller != null) {
            this.filesScroller.setVisible(true);
        }
        if (this.filesSplit != null) {
            this.filesSplit.setDividerSize(this.defaultDividerSize);
            this.filesSplit.setDividerLocation(this.lastFilesDividerPosition);
        }
        int bottom = this.notesScroller.isVisible() ? 1 : 0;
        this.agendaScroller.setBorder(BorderFactory.createMatteBorder(1, 0, bottom, 0, BORDER_COLOR));
        this.notesField.setBackground(this.notesProblemColor);
        this.notesField.setFont(PROBLEM_FONT);
        this.revalidate();
        this.repaint();
    }

    private void updateNotes(AgendaItem item) {
        Agenda ag = null;
        if (item != null) {
            ag = item.getParentAgenda();
        }
        this.updateNotes(ag, item);
    }

    private void updateNotes(Agenda agenda, AgendaItem item) {
        String text = null;
        switch (this.agendaEditor.getMode()) {
            case 2: {
                if (item instanceof AgendaTopic) {
                    text = ((AgendaTopic)item).getNote();
                    break;
                }
                if (!(item instanceof AgendaAction)) break;
                text = ((AgendaAction)item).getNote();
                break;
            }
            case 3: {
                text = this.problemNoteProvider.getProblemDescription(agenda, item, false);
            }
        }
        if (text != null && text.length() != 0) {
            this.notesField.setText(text);
            if (!this.notesScroller.isVisible()) {
                this.notesScroller.setVisible(true);
                this.agendaScroller.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, BORDER_COLOR));
                this.notesSplit.setDividerSize(this.defaultDividerSize);
                this.notesSplit.setDividerLocation(this.notesSplit.getHeight() - this.lastNotesDividerPosition);
                this.revalidate();
                this.repaint();
            }
        } else {
            this.notesField.setText(null);
            if (this.notesScroller.isVisible()) {
                this.notesScroller.setVisible(false);
                this.agendaScroller.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, BORDER_COLOR));
                this.notesSplit.setDividerSize(0);
                this.notesSplit.setDividerLocation(this.notesSplit.getHeight());
                this.revalidate();
                this.repaint();
            }
        }
    }

    static Color getTransparentColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    static Color fakeTransparentColor(Color color, int alpha) {
        Color bg = Color.WHITE;
        int[] vals = new int[]{color.getRed(), color.getGreen(), color.getBlue()};
        int[] bgVals = new int[]{bg.getRed(), bg.getGreen(), bg.getBlue()};
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = 255 - (int)((1.0 - (double)vals[i] / (double)bgVals[i]) * (double)alpha);
        }
        return new Color(vals[0], vals[1], vals[2]);
    }

    public void agendaActivated(AgendaLibraryEvent e) {
        this.updateView();
    }

    public void agendaDeactivated(AgendaLibraryEvent e) {
        this.updateView();
    }

    public void agendaAdded(AgendaLibraryEvent e) {
    }

    public void agendaRemoved(AgendaLibraryEvent e) {
    }

    public void agendaAutoloaded(AgendaLibraryEvent e) {
    }

    public void editorChanged(AgendaEvent e) {
        this.updateView();
        Agenda ag = e.getAgenda();
        this.updateNotes((AgendaItem)ag.getCurrentNode());
    }

    public void agendaPropertyChanged(AgendaEvent e) {
        String prop = e.getProperty();
        if (prop.equals("currentitem")) {
            Agenda ag = e.getAgenda();
            this.updateNotes((AgendaItem)ag.getCurrentNode());
        } else if (prop.equals("filename")) {
            this.bean.updateWindowTitle();
        }
    }

    public void itemAdded(AgendaEvent e) {
    }

    public void itemRemoved(AgendaEvent e) {
    }

    public void itemPropertyChanged(AgendaEvent e) {
    }

    public void timerStarted(AgendaEvent e) {
    }

    public void timerStopped(AgendaEvent e) {
    }

    public void transferAdded(AgendaEvent e) {
    }

    public void transferRemoved(AgendaEvent e) {
    }

    public void onAddClient(ClientEvent e) {
        if (e.isMe()) {
            this.updateView();
        }
    }

    public void onRemoveClient(ClientEvent e) {
        if (e.isMe()) {
            this.updateView();
        }
    }

    static {
        UriListDataFlavor flv = null;
        try {
            flv = new UriListDataFlavor();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        uriListFlavor = flv;
        BORDER_COLOR = new Color(165, 165, 165);
        PROBLEM_FONT = UIManager.getFont("List.font");
    }

    private abstract class AbstractTransferHandler
    extends TransferHandler {
        private ArrayList flavors = new ArrayList();
        private boolean dragAction;

        private AbstractTransferHandler() {
        }

        protected void addFlavor(DataFlavor flavor) {
            this.flavors.add(flavor);
        }

        @Override
        public boolean canImport(JComponent component, DataFlavor[] flavors) {
            return this.hasKnownFlavor(flavors);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean hasKnownFlavor(DataFlavor[] flavors) {
            DataFlavor[] dataFlavorArray = flavors;
            synchronized (flavors) {
                for (int i = 0; i < flavors.length; ++i) {
                    Iterator itr = this.flavors.iterator();
                    while (itr.hasNext()) {
                        if (!flavors[i].equals((DataFlavor)itr.next())) continue;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return true;
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
        }

        @Override
        public void exportAsDrag(JComponent component, InputEvent e, int action) {
            this.dragAction = true;
            super.exportAsDrag(component, e, action);
        }

        @Override
        public void exportToClipboard(JComponent component, Clipboard clipboard, int action) throws IllegalStateException {
            this.dragAction = false;
            super.exportToClipboard(component, clipboard, action);
        }

        protected boolean isDragAction() {
            return this.dragAction;
        }
    }

    private class AgendaEditorTransferHandler
    extends AbstractTransferHandler {
        private JComponent initiator;
        private ArrayList transferedNodes;

        public AgendaEditorTransferHandler() {
            this.addFlavor(commandFlavor);
            this.addFlavor(agendaFileListFlavor);
            this.addFlavor(agendaNodeListFlavor);
            this.addFlavor(DataFlavor.javaFileListFlavor);
            if (Platform.getOS() == 300 || Platform.getOS() == 250) {
                this.addFlavor((DataFlavor)uriListFlavor);
            }
        }

        @Override
        public boolean canImport(JComponent component, DataFlavor[] flavors) {
            if (EditorPanel.this.agendaEditor.getMode() == 3) {
                return this.hasKnownFlavor(flavors);
            }
            return false;
        }

        @Override
        public boolean importData(JComponent component, Transferable transferable) {
            try {
                File[] files;
                List list;
                Serializable data;
                ArrayList<File> validFiles = new ArrayList<File>();
                if (transferable.isDataFlavorSupported(commandFlavor)) {
                    CommandSelection data2 = (CommandSelection)transferable.getTransferData(commandFlavor);
                    EditorPanel.this.bean.doAddAction(data2.getCommandInterface());
                    return true;
                }
                if (transferable.isDataFlavorSupported(agendaFileListFlavor)) {
                    data = (AgendaFileSelection)transferable.getTransferData(agendaFileListFlavor);
                    AgendaFile[] files2 = ((AgendaFileSelection)data).getFiles();
                    if (files2.length > 0) {
                        Agenda ag = EditorPanel.this.getAgenda();
                        for (int i = 0; i < files2.length; ++i) {
                            AgendaFile af = files2[i];
                            if (ag.containsItem((AgendaItem)af)) {
                                EditorPanel.this.bean.doAddFileActions(af, EditorPanel.this.agendaEditor.getDragHoveredNode());
                                continue;
                            }
                            File f = new File(af.getPath());
                            if (!f.isFile()) continue;
                            validFiles.add(f);
                        }
                        if (validFiles.size() == 0) {
                            return true;
                        }
                    }
                } else if (transferable.isDataFlavorSupported(agendaNodeListFlavor)) {
                    data = (AgendaNodeSelection)transferable.getTransferData(agendaNodeListFlavor);
                    AgendaNode[] nodes = ((AgendaNodeSelection)data).getNodes();
                    if (nodes.length > 0) {
                        AgendaNode sel = (AgendaNode)EditorPanel.this.agendaEditor.getSelectedValue();
                        AgendaNode first = null;
                        if (this.transferedNodes != null) {
                            first = (AgendaNode)this.transferedNodes.get(0);
                        }
                        if (sel == null || first == null || first != sel && !first.isAncestorOf(sel)) {
                            for (int i = 0; i < nodes.length; ++i) {
                                AgendaNode n = nodes[i];
                                if (n instanceof AgendaTopic) {
                                    EditorPanel.this.bean.doAddTopic((AgendaTopic)n);
                                    continue;
                                }
                                if (n instanceof AgendaAction) {
                                    EditorPanel.this.bean.doAddAction((AgendaAction)n);
                                    continue;
                                }
                                if (!(n instanceof AgendaText)) continue;
                                EditorPanel.this.bean.doAddText((AgendaText)n);
                            }
                            if (this.initiator == component && this.transferedNodes != null) {
                                EditorPanel.this.bean.doRemoveItems((AgendaItem[])this.transferedNodes.toArray(new AgendaNode[0]));
                            }
                            return true;
                        }
                    }
                } else if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File f : list) {
                        if (!f.isFile()) continue;
                        validFiles.add(f);
                    }
                } else if (transferable.isDataFlavorSupported((DataFlavor)uriListFlavor)) {
                    list = uriListFlavor.getTransferFiles(transferable);
                    for (File f : list) {
                        if (!f.isFile()) continue;
                        validFiles.add(f);
                    }
                }
                if ((files = validFiles.toArray(new File[0])).length > 0) {
                    EditorPanel.this.bean.doAddFiles(files, EditorPanel.this.agendaEditor.getDragHoveredNode());
                    return true;
                }
            }
            catch (UnsupportedFlavorException ex) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public int getSourceActions(JComponent component) {
            if (EditorPanel.this.agendaEditor.getMode() == 3) {
                return 3;
            }
            return 0;
        }

        @Override
        protected Transferable createTransferable(JComponent component) {
            this.initiator = component;
            this.transferedNodes = new ArrayList();
            AgendaNodeTransferable t = new AgendaNodeTransferable();
            AgendaNode[] nodes = EditorPanel.this.agendaEditor.getSelectedNodes();
            List list = AgendaBean.pruneDescendants((AgendaItem[])nodes);
            for (AgendaNode n : list) {
                this.transferedNodes.add(n);
                t.addNode(n);
            }
            return t;
        }

        @Override
        protected void exportDone(JComponent component, Transferable transferable, int action) {
            if (!this.isDragAction() && (action & 2) != 0 && this.transferedNodes != null) {
                EditorPanel.this.bean.doRemoveItems((AgendaItem[])this.transferedNodes.toArray(new AgendaNode[0]));
            }
            this.initiator = null;
            this.transferedNodes = null;
        }
    }

    static class AgendaFileSelection
    implements Serializable {
        private ArrayList files = new ArrayList();

        AgendaFileSelection() {
        }

        public void addFile(AgendaFile file) {
            this.files.add(file);
        }

        public AgendaFile[] getFiles() {
            return this.files.toArray(new AgendaFile[0]);
        }
    }

    private class AgendaFileTransferable
    implements Transferable {
        private DataFlavor[] flavors;
        private ArrayList agendaFiles = new ArrayList();

        public AgendaFileTransferable() {
            ArrayList<DataFlavor> list = new ArrayList<DataFlavor>();
            list.add(agendaFileListFlavor);
            list.add(DataFlavor.javaFileListFlavor);
            if (Platform.getOS() == 300 || Platform.getOS() == 250) {
                list.add((DataFlavor)uriListFlavor);
            }
            list.add(DataFlavor.plainTextFlavor);
            list.add(DataFlavor.stringFlavor);
            this.flavors = list.toArray(new DataFlavor[0]);
        }

        public void addFile(AgendaFile file) {
            this.agendaFiles.add(file);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return (DataFlavor[])this.flavors.clone();
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (int i = 0; i < this.flavors.length; ++i) {
                if (!this.flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(agendaFileListFlavor)) {
                AgendaFileSelection data = new AgendaFileSelection();
                Iterator itr = this.agendaFiles.iterator();
                while (itr.hasNext()) {
                    data.addFile((AgendaFile)itr.next());
                }
                return data;
            }
            if (flavor.equals(DataFlavor.javaFileListFlavor)) {
                ArrayList<File> data = new ArrayList<File>();
                for (AgendaFile file : this.agendaFiles) {
                    File f = new File(file.getPath());
                    if (!f.exists()) continue;
                    data.add(f);
                }
                return data;
            }
            if (flavor.equals((DataFlavor)uriListFlavor)) {
                ArrayList<File> list = new ArrayList<File>();
                for (AgendaFile file : this.agendaFiles) {
                    File f = new File(file.getPath());
                    if (!f.exists()) continue;
                    list.add(f);
                }
                return uriListFlavor.setTransferFiles(list);
            }
            if (flavor.equals(DataFlavor.stringFlavor) || flavor.equals(DataFlavor.plainTextFlavor)) {
                StringBuffer b = new StringBuffer();
                for (AgendaFile file : this.agendaFiles) {
                    if (b.length() != 0) {
                        b.append("\n");
                    }
                    b.append(file.getName());
                }
                if (flavor.equals(DataFlavor.stringFlavor)) {
                    return new StringSelection(b.toString());
                }
                try {
                    String charset = flavor.getParameter("charset").trim();
                    return new ByteArrayInputStream(b.toString().getBytes(charset));
                }
                catch (UnsupportedEncodingException ex) {
                    // empty catch block
                }
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    static class AgendaNodeSelection
    implements Serializable {
        private ArrayList nodes = new ArrayList();

        AgendaNodeSelection() {
        }

        public void addNode(AgendaNode node) {
            try {
                this.nodes.add((AgendaNode)node.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }

        public AgendaNode[] getNodes() {
            return this.nodes.toArray(new AgendaNode[0]);
        }
    }

    private class AgendaNodeTransferable
    implements Transferable {
        private DataFlavor[] flavors;
        private ArrayList agendaNodes = new ArrayList();

        public AgendaNodeTransferable() {
            this.flavors = new DataFlavor[]{agendaNodeListFlavor, DataFlavor.plainTextFlavor, DataFlavor.stringFlavor};
        }

        public void addNode(AgendaNode node) {
            this.agendaNodes.add(node);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return (DataFlavor[])this.flavors.clone();
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (int i = 0; i < this.flavors.length; ++i) {
                if (!this.flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(agendaNodeListFlavor)) {
                AgendaNodeSelection data = new AgendaNodeSelection();
                Iterator itr = this.agendaNodes.iterator();
                while (itr.hasNext()) {
                    data.addNode((AgendaNode)itr.next());
                }
                return data;
            }
            if (flavor.equals(DataFlavor.stringFlavor) || flavor.equals(DataFlavor.plainTextFlavor)) {
                StringBuffer b = new StringBuffer();
                for (AgendaNode node : this.agendaNodes) {
                    this.appendNode(b, node, 0);
                }
                if (flavor.equals(DataFlavor.stringFlavor)) {
                    return new StringSelection(b.toString());
                }
                try {
                    String charset = flavor.getParameter("charset").trim();
                    return new ByteArrayInputStream(b.toString().getBytes(charset));
                }
                catch (UnsupportedEncodingException ex) {
                    // empty catch block
                }
            }
            throw new UnsupportedFlavorException(flavor);
        }

        private void appendNode(StringBuffer buffer, AgendaNode node, int level) {
            block10: {
                block9: {
                    if (buffer.length() != 0) {
                        buffer.append("\n");
                    }
                    for (int i = 0; i < level; ++i) {
                        buffer.append("\t");
                    }
                    if (node instanceof AgendaTopic) {
                        buffer.append(((AgendaTopic)node).getName());
                    } else if (node instanceof AgendaAction) {
                        buffer.append(((AgendaAction)node).getDescription());
                    } else if (node instanceof AgendaText) {
                        buffer.append(((AgendaText)node).getText());
                    }
                    if (!(node instanceof AgendaTopic)) break block9;
                    AgendaTopic top = (AgendaTopic)node;
                    for (int i = 0; i < top.getNodeCount(); ++i) {
                        this.appendNode(buffer, top.getNode(i), level + 1);
                    }
                    break block10;
                }
                if (!(node instanceof AgendaAction)) break block10;
                AgendaAction act = (AgendaAction)node;
                for (int i = 0; i < act.getActionCount(); ++i) {
                    this.appendNode(buffer, (AgendaNode)act.getAction(i), level + 1);
                }
            }
        }
    }

    static class CommandSelection
    implements Serializable {
        private Class commandInterface;

        public CommandSelection(Class commandInterface) {
            this.commandInterface = commandInterface;
        }

        public Class getCommandInterface() {
            return this.commandInterface;
        }
    }

    private class FilesEditorTransferHandler
    extends AbstractTransferHandler {
        private ArrayList transferedFiles;

        public FilesEditorTransferHandler() {
            this.addFlavor(agendaFileListFlavor);
            this.addFlavor(DataFlavor.javaFileListFlavor);
            this.addFlavor((DataFlavor)uriListFlavor);
        }

        @Override
        public boolean canImport(JComponent component, DataFlavor[] flavors) {
            if (EditorPanel.this.agendaEditor.getMode() == 3) {
                return this.hasKnownFlavor(flavors);
            }
            return false;
        }

        @Override
        public boolean importData(JComponent component, Transferable transferable) {
            try {
                File[] files;
                List list;
                ArrayList<File> validFiles = new ArrayList<File>();
                if (transferable.isDataFlavorSupported(agendaFileListFlavor)) {
                    AgendaFileSelection data = (AgendaFileSelection)transferable.getTransferData(agendaFileListFlavor);
                    AgendaFile[] files2 = data.getFiles();
                    if (files2.length > 0) {
                        Agenda ag = EditorPanel.this.getAgenda();
                        for (int i = 0; i < files2.length; ++i) {
                            AgendaFile af = files2[i];
                            if (ag.containsItem((AgendaItem)af)) {
                                EditorPanel.this.bean.doAddFileActions(af, EditorPanel.this.agendaEditor.getDragHoveredNode());
                                continue;
                            }
                            File f = new File(af.getPath());
                            if (!f.isFile()) continue;
                            validFiles.add(f);
                        }
                        if (validFiles.size() == 0) {
                            return true;
                        }
                    }
                } else if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File f : list) {
                        if (!f.isFile()) continue;
                        validFiles.add(f);
                    }
                } else if (transferable.isDataFlavorSupported((DataFlavor)uriListFlavor)) {
                    list = uriListFlavor.getTransferFiles(transferable);
                    for (File f : list) {
                        if (!f.isFile()) continue;
                        validFiles.add(f);
                    }
                }
                if ((files = validFiles.toArray(new File[0])).length != 0) {
                    EditorPanel.this.bean.doAddFiles(files);
                    return true;
                }
            }
            catch (UnsupportedFlavorException ex) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public int getSourceActions(JComponent component) {
            if (EditorPanel.this.agendaEditor.getMode() == 3) {
                return 1;
            }
            return 0;
        }

        @Override
        protected Transferable createTransferable(JComponent component) {
            this.transferedFiles = new ArrayList();
            AgendaFileTransferable t = new AgendaFileTransferable();
            AgendaFile[] files = EditorPanel.this.filesEditor.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                AgendaFile f = files[i];
                this.transferedFiles.add(f);
                t.addFile(f);
            }
            return t;
        }

        @Override
        public void exportAsDrag(JComponent component, InputEvent e, int action) {
            component.getDropTarget().setActive(false);
            super.exportAsDrag(component, e, action);
        }

        @Override
        protected void exportDone(JComponent component, Transferable transferable, int action) {
            component.getDropTarget().setActive(true);
            if (!this.isDragAction() && (action & 2) != 0 && this.transferedFiles != null) {
                EditorPanel.this.bean.doRemoveItems((AgendaItem[])this.transferedFiles.toArray(new AgendaFile[0]));
            }
            this.transferedFiles = null;
        }
    }

    private static class PrintedAgendaPage
    implements Printable {
        private AgendaEditor editor;
        private int startRow;
        private int endRow;

        public PrintedAgendaPage(AgendaEditor editor, int startRow, int endRow) {
            this.editor = editor;
            this.startRow = startRow;
            this.endRow = endRow;
        }

        @Override
        public int print(Graphics g, PageFormat format, int pageIndex) throws PrinterException {
            RepaintManager mgr = RepaintManager.currentManager(this.editor);
            mgr.setDoubleBufferingEnabled(false);
            if (this.startRow >= 0) {
                g.translate((int)format.getImageableX(), (int)format.getImageableY());
                Point pt1 = this.editor.indexToLocation(this.startRow);
                g.translate(0, -pt1.y);
                Rectangle oldClip = g.getClipBounds();
                if (this.endRow != -1) {
                    Point pt2 = this.editor.indexToLocation(this.endRow + 1);
                    g.clipRect(0, pt1.y, (int)format.getImageableWidth(), pt2.y - pt1.y);
                }
                this.editor.paint(g);
                g.setClip(oldClip);
            }
            mgr.setDoubleBufferingEnabled(true);
            return 0;
        }
    }

    private static class ProblemNoteProvider {
        private AgendaValidator validator;
        private I18n i18n;

        public ProblemNoteProvider(AgendaValidator validator, I18n i18n) {
            this.validator = validator;
            this.i18n = i18n;
        }

        public String getProblemDescription(Agenda agenda, AgendaItem item, boolean asToolTip) {
            StringBuffer b = new StringBuffer();
            AgendaValidatorEvent[] probs = null;
            if (item != null) {
                probs = this.validator.getProblems(item);
            }
            if (probs == null && agenda != null) {
                probs = this.validator.getProblems(agenda);
            }
            if (probs != null) {
                for (int i = 0; i < probs.length; ++i) {
                    AgendaValidatorEvent prob = probs[i];
                    AgendaExecutable exe = (AgendaExecutable)prob.getItem();
                    Object culprit = prob.getCulprit();
                    String msg = null;
                    String sugg = null;
                    int problemType = prob.getProblem();
                    switch (problemType) {
                        case 11: {
                            ActionInfo a;
                            if (!(culprit instanceof Class) || (a = this.getActionInfo((Class)culprit)) == null) break;
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_QUOTAEXCEEDEDPROBLEM, new Object[]{a.getDisplayName()});
                            break;
                        }
                        case 12: {
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_COMMANDNOTSPECIFIEDPROBLEM, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)exe)});
                            break;
                        }
                        case 13: {
                            if (!(culprit instanceof String)) break;
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_COMMANDINVALIDPROBLEM, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)exe), (String)culprit});
                            break;
                        }
                        case 14: {
                            ActionParameter p;
                            ActionInfo a = this.getActionInfo(exe);
                            if (a == null || !(culprit instanceof String) || (p = a.getParameter((String)culprit)) == null) break;
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_PARAMETERNOTSPECIFIEDPROBLEM, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)exe), p.getDisplayName()});
                            sugg = p.getProblemSuggestion(problemType);
                            break;
                        }
                        case 15: {
                            ActionParameter p;
                            ActionInfo a = this.getActionInfo(exe);
                            if (a == null || !(culprit instanceof String) || (p = a.getParameter((String)culprit)) == null) break;
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_PARAMETERINVALIDPROBLEM, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)exe), p.getDisplayName()});
                            sugg = p.getProblemSuggestion(problemType);
                            break;
                        }
                        case 16: {
                            ActionParameter p;
                            ActionInfo a = this.getActionInfo(exe);
                            if (a == null || !(culprit instanceof String) || (p = a.getParameter((String)culprit)) == null) break;
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_PARAMETERFILEINVALIDPROBLEM, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)exe), p.getDisplayName(), exe.getCommandParameter((String)culprit)});
                            sugg = p.getProblemSuggestion(problemType);
                            break;
                        }
                        case 17: {
                            ActionParameter p;
                            ActionInfo a = this.getActionInfo(exe);
                            if (a == null || !(culprit instanceof String) || (p = a.getParameter((String)culprit)) == null) break;
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_PARAMETERURLINVALIDPROBLEM, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)exe), p.getDisplayName(), exe.getCommandParameter((String)culprit)});
                            sugg = p.getProblemSuggestion(problemType);
                            break;
                        }
                        case 18: {
                            ActionParameter p;
                            ActionInfo a = this.getActionInfo(exe);
                            if (a == null || !(culprit instanceof String) || (p = a.getParameter((String)culprit)) == null) break;
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_PARAMETERFILETYPEINVALIDPROBLEM, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)exe), p.getDisplayName(), exe.getCommandParameter((String)culprit)});
                            sugg = p.getProblemSuggestion(problemType);
                            break;
                        }
                        case 19: {
                            ActionParameter p;
                            ActionInfo a = this.getActionInfo(exe);
                            if (a == null || !(culprit instanceof String) || (p = a.getParameter((String)culprit)) == null) break;
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_PARAMETERPHONENUMBERINVALIDPROBLEM, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)exe), p.getDisplayName(), exe.getCommandParameter((String)culprit)});
                            sugg = p.getProblemSuggestion(problemType);
                            break;
                        }
                        case 20: {
                            ActionParameter p;
                            ActionInfo a = this.getActionInfo(exe);
                            if (a == null || !(culprit instanceof String) || (p = a.getParameter((String)culprit)) == null) break;
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_PARAMETERPHONESIPINVALIDPROBLEM, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)exe), p.getDisplayName(), exe.getCommandParameter((String)culprit)});
                            sugg = p.getProblemSuggestion(problemType);
                            break;
                        }
                        case 21: {
                            ActionParameter p;
                            ActionInfo a = this.getActionInfo(exe);
                            if (a == null || !(culprit instanceof String) || (p = a.getParameter((String)culprit)) == null) break;
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_PARAMETERPHONEPININVALIDPROBLEM, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)exe), p.getDisplayName(), exe.getCommandParameter((String)culprit)});
                            sugg = p.getProblemSuggestion(problemType);
                            break;
                        }
                        case 22: {
                            ActionParameter p;
                            ActionInfo a = this.getActionInfo(exe);
                            if (a == null || !(culprit instanceof String) || (p = a.getParameter((String)culprit)) == null) break;
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_PARAMETERLISTVALUEINVALIDPROBLEM, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)exe), p.getDisplayName(), exe.getCommandParameter((String)culprit)});
                            sugg = p.getProblemSuggestion(problemType);
                            break;
                        }
                        case 23: 
                        case 24: 
                        case 25: {
                            ActionParameter p;
                            ActionInfo a = this.getActionInfo(exe);
                            if (a == null || !(culprit instanceof String) || (p = a.getParameter((String)culprit)) == null) break;
                            switch (problemType) {
                                case 23: {
                                    msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_PARAMETERINTEGERINVALIDPROBLEM, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)exe), p.getDisplayName(), exe.getCommandParameter((String)culprit)});
                                    break;
                                }
                                case 24: {
                                    msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_PARAMETERINTEGERTOOSMALLPROBLEM, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)exe), p.getDisplayName(), exe.getCommandParameter((String)culprit), String.valueOf(p.getMinimumValue())});
                                    break;
                                }
                                default: {
                                    msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_PARAMETERINTEGERTOOLARGEPROBLEM, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)exe), p.getDisplayName(), exe.getCommandParameter((String)culprit), String.valueOf(p.getMaximumValue())});
                                }
                            }
                            sugg = p.getProblemSuggestion(problemType);
                            break;
                        }
                        case 41: 
                        case 42: {
                            StringBuffer list = new StringBuffer();
                            ActionInfo a = this.getActionInfo(exe);
                            if (a != null) {
                                ActionDependency[] deps = problemType == 41 ? a.getDependencies(3) : a.getDependencies(1);
                                for (int j = 0; j < deps.length; ++j) {
                                    if (list.length() != 0) {
                                        list.append("\n");
                                    }
                                    list.append("\t- ");
                                    list.append(this.getActionInfo(deps[j].getOtherCommand()).getDisplayName());
                                }
                            }
                            if (culprit == null) {
                                msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_ITEMNOTENABLEDPROBLEM, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)exe), list.toString()});
                                break;
                            }
                            if (culprit instanceof String) {
                                ActionParameter p = a.getParameter((String)culprit);
                                if (p == null) break;
                                msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_ITEMNOTRESOLVEDPROBLEM, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)exe), p.getDisplayName(), exe.getCommandParameter((String)culprit), list.toString()});
                                break;
                            }
                            if (!(culprit instanceof AgendaExecutable)) break;
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_ITEMDISABLEDPROBLEM, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)exe), AgendaUtils.getShortItemName((AgendaExecutable)((AgendaExecutable)culprit)), list.toString()});
                            break;
                        }
                        case 43: {
                            msg = this.i18n.getString((PropertiesEnum)StringsProperties.EDITORPANEL_FILENOTLOADEDPROBLEM, new Object[]{AgendaUtils.getShortItemName((AgendaExecutable)exe)});
                        }
                    }
                    if (msg == null || msg.length() == 0) continue;
                    if (b.length() != 0) {
                        b.append("\n\n");
                    }
                    b.append(msg);
                    if (sugg == null || sugg.length() == 0) continue;
                    b.append(' ');
                    b.append(sugg);
                }
            }
            String desc = b.toString();
            if (asToolTip && desc.length() != 0) {
                return this.formatToolTip(desc);
            }
            return desc;
        }

        private ActionInfo getActionInfo(AgendaExecutable executable) {
            String cmd = executable.getCommandName();
            if (cmd != null && cmd.length() != 0) {
                return Actions.getAction(cmd);
            }
            return null;
        }

        private ActionInfo getActionInfo(Class commandInterface) {
            return Actions.getAction(commandInterface.getName());
        }

        private String formatToolTip(String text) {
            int WIDTH = 400;
            StringBuffer b = new StringBuffer();
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(UIManager.getFont("ToolTip.font"));
            BreakIterator itr = BreakIterator.getWordInstance();
            itr.setText(text);
            int lineStart = 0;
            int previousBoundary = -1;
            int bnd = itr.next();
            while (bnd != -1) {
                String line = text.substring(lineStart, bnd);
                boolean hasNewLine = line.endsWith("\n");
                if (!hasNewLine && fm.stringWidth(line) <= 400) {
                    previousBoundary = bnd;
                } else {
                    if (b.length() != 0) {
                        b.append("\n");
                    }
                    if (!hasNewLine && previousBoundary != -1) {
                        b.append(text.substring(lineStart, previousBoundary).trim());
                        lineStart = previousBoundary;
                    } else {
                        b.append(text.substring(lineStart, bnd).trim());
                        lineStart = bnd;
                    }
                    previousBoundary = -1;
                }
                bnd = itr.next();
            }
            if (lineStart < text.length() - 1) {
                if (b.length() != 0) {
                    b.append("\n");
                }
                b.append(text.substring(lineStart));
            }
            return "<html>" + b.toString().replaceAll("\n", "<br>") + "</html>";
        }
    }

    private static class PropertySplitterUI
    extends BasicSplitPaneUI {
        private PropertySplitterUI() {
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new BasicSplitPaneDivider(this){

                @Override
                public void paint(Graphics g) {
                    Dimension s = this.getSize();
                    g.setColor(PropertyEditor.BACKGROUND_COLOR);
                    g.fillRect(0, 0, s.width, s.height);
                    g.setColor(Color.GRAY);
                    g.drawLine(0, 0, 0, s.height);
                }
            };
        }
    }

    private static class SplitterUI
    extends BasicSplitPaneUI {
        private SplitterUI() {
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new BasicSplitPaneDivider(this){

                @Override
                public void setBorder(Border border) {
                }

                @Override
                public void paint(Graphics g) {
                }
            };
        }
    }
}

