/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import com.elluminate.engine.command.SetMaximumCamerasCommand;
import com.elluminate.engine.command.SetMaximumTalkersCommand;
import com.elluminate.groupware.agenda.module.Actions;
import com.elluminate.groupware.agenda.module.AgendaPreferences;
import com.elluminate.groupware.agenda.module.StringsProperties;
import com.elluminate.groupware.agenda.module.action.ActionInfo;
import com.elluminate.groupware.agenda.module.action.ActionParameter;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.CColorPicker;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.gui.swing.CTable;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

@Singleton
public class EditorOptionsPrefsPanel
extends AbstractPreferencesPanel {
    private I18n i18n;
    private CColorPicker problemColorPicker;
    private JSpinner transferQuotaField;
    private JSpinner multimediaQuotaField;
    private JSpinner whiteboardQuotaField;
    private JSpinner maxPlanSizeField;
    private CTable parameterValueTable;
    private DefaultTableModel parameterValueModel;

    @Inject
    public EditorOptionsPrefsPanel(PreferencesPanelOwner owner, I18n i18n) {
        super(owner, i18n.getString((PropertiesEnum)StringsProperties.EDITOROPTIONS_TITLE));
        this.i18n = i18n;
    }

    protected void createContent() {
        this.setLayout(new BorderLayout(0, 6));
        JPanel p = new JPanel(new GridBagLayout());
        this.add(p, "North");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridy = 0;
        gbc.insets.top = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        p.add((Component)new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.EDITOROPTIONS_PROBLEMCOLORLABEL)), gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets.left = 6;
        this.problemColorPicker = new CColorPicker();
        this.problemColorPicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("color")) {
                    EditorOptionsPrefsPanel.this.setModified(true);
                }
            }
        });
        p.add((Component)this.problemColorPicker, gbc);
        p = new JPanel(new GridBagLayout());
        this.add(p, "Center");
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridy = 0;
        gbc.insets.top = 20;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        gbc.insets.left = 0;
        gbc.weightx = 1.0;
        p.add((Component)new MultilineLabel(this.i18n.getString((PropertiesEnum)StringsProperties.EDITOROPTIONS_MAXSIZEPROMPT)), gbc);
        String MB = this.i18n.getString((PropertiesEnum)StringsProperties.EDITOROPTIONS_MEGABYTEUNITS);
        ++gbc.gridy;
        gbc.insets.top = 6;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.insets.left = 0;
        gbc.weightx = 0.0;
        p.add((Component)new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.EDITOROPTIONS_TRANSFERQUOTALABEL)), gbc);
        gbc.gridx = 1;
        gbc.insets.left = 6;
        gbc.weightx = 0.0;
        this.transferQuotaField = new JSpinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        this.transferQuotaField.setEditor(new SizeEditor(this.transferQuotaField));
        p.add((Component)this.transferQuotaField, gbc);
        gbc.gridx = 2;
        gbc.insets.left = 6;
        gbc.weightx = 1.0;
        p.add((Component)new JLabel(MB), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.insets.left = 0;
        gbc.weightx = 0.0;
        p.add((Component)new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.EDITOROPTIONS_MULTIMEDIAQUOTALABEL)), gbc);
        gbc.gridx = 1;
        gbc.insets.left = 6;
        gbc.weightx = 0.0;
        this.multimediaQuotaField = new JSpinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        this.multimediaQuotaField.setEditor(new SizeEditor(this.multimediaQuotaField));
        p.add((Component)this.multimediaQuotaField, gbc);
        gbc.gridx = 2;
        gbc.insets.left = 6;
        gbc.weightx = 1.0;
        p.add((Component)new JLabel(MB), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.insets.left = 0;
        gbc.weightx = 0.0;
        p.add((Component)new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.EDITOROPTIONS_WHITEBOARDQUOTALABEL)), gbc);
        gbc.gridx = 1;
        gbc.insets.left = 6;
        gbc.weightx = 0.0;
        this.whiteboardQuotaField = new JSpinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        this.whiteboardQuotaField.setEditor(new SizeEditor(this.whiteboardQuotaField));
        p.add((Component)this.whiteboardQuotaField, gbc);
        gbc.gridx = 2;
        gbc.insets.left = 6;
        gbc.weightx = 1.0;
        p.add((Component)new JLabel(MB), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.insets.left = 0;
        gbc.weightx = 0.0;
        p.add((Component)new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.EDITOROPTIONS_MAXPLANSIZELABEL)), gbc);
        gbc.gridx = 1;
        gbc.insets.left = 6;
        gbc.weightx = 0.0;
        this.maxPlanSizeField = new JSpinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        this.maxPlanSizeField.setEditor(new SizeEditor(this.maxPlanSizeField));
        p.add((Component)this.maxPlanSizeField, gbc);
        gbc.gridx = 2;
        gbc.insets.left = 6;
        gbc.weightx = 1.0;
        p.add((Component)new JLabel(MB), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.insets.left = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets.top = 10;
        p.add((Component)new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.EDITOROPTIONS_ACTIONLISTLABEL)), gbc);
        ++gbc.gridy;
        gbc.insets.top = 2;
        this.parameterValueModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 2;
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
                if (column == 2) {
                    try {
                        int val = Integer.parseInt(String.valueOf(value));
                        super.setValueAt(String.valueOf(val), row, column);
                        EditorOptionsPrefsPanel.this.setModified(true);
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
            }
        };
        this.parameterValueModel.addColumn(this.i18n.getString((PropertiesEnum)StringsProperties.EDITOROPTIONS_ACTIONCOLUMNTITLE));
        this.parameterValueModel.addColumn(this.i18n.getString((PropertiesEnum)StringsProperties.EDITOROPTIONS_PARAMETERCOLUMNTITLE));
        this.parameterValueModel.addColumn(this.i18n.getString((PropertiesEnum)StringsProperties.EDITOROPTIONS_MAXIMUMCOLUMNTITLE));
        this.parameterValueTable = new CTable((TableModel)this.parameterValueModel);
        this.parameterValueTable.setRowHeight(18);
        this.parameterValueTable.setIntercellSpacing(new Dimension(0, 1));
        this.parameterValueTable.setSelectionMode(0);
        this.parameterValueTable.getTableHeader().setReorderingAllowed(false);
        this.parameterValueTable.setPreferredScrollableViewportSize(new Dimension(0, 60));
        this.parameterValueTable.setDefaultRenderer(Object.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
                return super.getTableCellRendererComponent(table, value, selected, focused && !table.isCellEditable(row, column), row, column);
            }
        });
        DefaultCellEditor ed = (DefaultCellEditor)this.parameterValueTable.getDefaultEditor(Object.class);
        ed.setClickCountToStart(1);
        Document doc = ((JTextField)ed.getComponent()).getDocument();
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.documentChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.documentChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.documentChanged();
            }

            private void documentChanged() {
                DefaultCellEditor ed;
                String oldVal;
                String newVal;
                int row = EditorOptionsPrefsPanel.this.parameterValueTable.getEditingRow();
                if (row != -1 && !(newVal = (String)EditorOptionsPrefsPanel.this.parameterValueTable.getValueAt(row, 2)).equals(oldVal = ((JTextField)(ed = (DefaultCellEditor)EditorOptionsPrefsPanel.this.parameterValueTable.getDefaultEditor(Object.class)).getComponent()).getText())) {
                    EditorOptionsPrefsPanel.this.setModified(true);
                }
            }
        });
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).setDocumentFilter(new DocumentFilter(){
                private StringBuffer buffer = new StringBuffer();

                @Override
                public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attrs) throws BadLocationException {
                    String txt = this.filterCharacters(text);
                    if (txt.length() != 0) {
                        fb.insertString(offset, txt, attrs);
                    }
                }

                @Override
                public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                    String txt = this.filterCharacters(text);
                    if (txt.length() != 0) {
                        fb.replace(offset, length, txt, attrs);
                    }
                }

                private String filterCharacters(String text) {
                    this.buffer.setLength(0);
                    for (int i = 0; i < text.length(); ++i) {
                        char ch = text.charAt(i);
                        if (!Character.isDigit(ch)) continue;
                        this.buffer.append(ch);
                    }
                    return this.buffer.toString();
                }
            });
        }
        int w = this.parameterValueTable.getPreferredSize().width;
        TableColumnModel cm = this.parameterValueTable.getColumnModel();
        cm.getColumn(0).setPreferredWidth((int)((double)w * 0.5));
        cm.getColumn(1).setPreferredWidth((int)((double)w * 0.4));
        cm.getColumn(2).setPreferredWidth((int)((double)w * 0.1));
        JScrollPane sp = new JScrollPane((Component)this.parameterValueTable, 22, 31);
        p.add((Component)sp, gbc);
        ActionInfo act = Actions.getAction(SetMaximumTalkersCommand.class.getName());
        ActionParameter param = act.getParameter("talkerCount");
        this.parameterValueModel.addRow(new Object[]{act.getDisplayName(), param.getDisplayName(), ""});
        act = Actions.getAction(SetMaximumCamerasCommand.class.getName());
        param = act.getParameter("cameraCount");
        this.parameterValueModel.addRow(new Object[]{act.getDisplayName(), param.getDisplayName(), ""});
        ChangeListener cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EditorOptionsPrefsPanel.this.setModified(true);
            }
        };
        this.transferQuotaField.addChangeListener(cl);
        this.multimediaQuotaField.addChangeListener(cl);
        this.whiteboardQuotaField.addChangeListener(cl);
        this.maxPlanSizeField.addChangeListener(cl);
    }

    protected void populate(Preferences preferences) {
        if (this.parameterValueTable.isEditing()) {
            ((DefaultCellEditor)this.parameterValueTable.getDefaultEditor(Object.class)).cancelCellEditing();
        }
        String prefix = this.getOwnerPrefix();
        Color c = AgendaPreferences.getProblemColor(prefix, preferences);
        this.problemColorPicker.setColor(c);
        int size = AgendaPreferences.getTransferQuota(prefix, preferences);
        this.transferQuotaField.setValue(size);
        size = AgendaPreferences.getMultimediaQuota(prefix, preferences);
        this.multimediaQuotaField.setValue(size);
        size = AgendaPreferences.getWhiteboardQuota(prefix, preferences);
        this.whiteboardQuotaField.setValue(size);
        size = AgendaPreferences.getMaxPlanSize(prefix, preferences);
        this.maxPlanSizeField.setValue(size);
        int max = AgendaPreferences.getMaxTalkerCount(prefix, preferences);
        this.parameterValueModel.setValueAt(String.valueOf(max), 0, 2);
        max = AgendaPreferences.getMaxCameraCount(prefix, preferences);
        this.parameterValueModel.setValueAt(String.valueOf(max), 1, 2);
    }

    protected void apply(Preferences preferences) {
        if (this.parameterValueTable.isEditing()) {
            ((DefaultCellEditor)this.parameterValueTable.getDefaultEditor(Object.class)).stopCellEditing();
        }
        String prefix = this.getOwnerPrefix();
        Color c = this.problemColorPicker.getColor();
        AgendaPreferences.setProblemColor(prefix, preferences, c);
        Integer size = (Integer)this.transferQuotaField.getValue();
        AgendaPreferences.setTransferQuota(prefix, preferences, size);
        size = (Integer)this.multimediaQuotaField.getValue();
        AgendaPreferences.setMultimediaQuota(prefix, preferences, size);
        size = (Integer)this.whiteboardQuotaField.getValue();
        AgendaPreferences.setWhiteboardQuota(prefix, preferences, size);
        size = (Integer)this.maxPlanSizeField.getValue();
        AgendaPreferences.setMaxPlanSize(prefix, preferences, size);
        int max = Integer.parseInt((String)this.parameterValueModel.getValueAt(0, 2));
        AgendaPreferences.setMaxTalkerCount(prefix, preferences, max);
        max = Integer.parseInt((String)this.parameterValueModel.getValueAt(1, 2));
        AgendaPreferences.setMaxCameraCount(prefix, preferences, max);
    }

    protected void reset(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        AgendaPreferences.setProblemColor(prefix, preferences, AgendaPreferences.PROBLEM_COLOR_DEFAULT);
        AgendaPreferences.setTransferQuota(prefix, preferences, 10);
        AgendaPreferences.setMultimediaQuota(prefix, preferences, 100);
        AgendaPreferences.setWhiteboardQuota(prefix, preferences, 20);
        AgendaPreferences.setMaxPlanSize(prefix, preferences, 100);
        AgendaPreferences.setMaxTalkerCount(prefix, preferences, 6);
        AgendaPreferences.setMaxCameraCount(prefix, preferences, 6);
    }

    private static class SizeEditor
    extends JSpinner.NumberEditor {
        public SizeEditor(JSpinner spinner) {
            super(spinner);
            JFormattedTextField tf = this.getTextField();
            tf.setColumns(4);
            tf.setCaret(new DefaultCaret(){

                @Override
                public boolean isVisible() {
                    return false;
                }
            });
            DefaultFormatter form = (DefaultFormatter)tf.getFormatter();
            form.setAllowsInvalid(false);
            form.setCommitsOnValidEdit(true);
        }
    }
}

