/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import java.awt.Cursor;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DurationEditor
extends JTextField
implements ChangeListener {
    public static final int HOURS_FIELD = 1;
    public static final int MINUTES_FIELD = 2;
    public static final int SECONDS_FIELD = 3;
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    private static NumberFormat hoursFormat;
    private static NumberFormat minutesFormat;
    private static NumberFormat secondsFormat;
    private JSpinner spinner;
    private int currentField = 3;

    public DurationEditor(JSpinner spinner) {
        super("0:00:00", 6);
        this.setHorizontalAlignment(4);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.spinner = spinner;
        if (!(spinner.getModel() instanceof SpinnerNumberModel)) {
            throw new IllegalArgumentException("Spinner model must be instance of SpinnerNumberModel");
        }
        this.getSpinnerModel().addChangeListener(this);
        this.syncCurrentField();
        this.syncModelStepSize();
        this.syncEditorValue();
    }

    public int getCurrentField() {
        return this.currentField;
    }

    public void setCurrentField(int currentField) {
        this.currentField = currentField;
        this.syncCurrentField();
        this.syncModelStepSize();
    }

    protected void syncCurrentField() {
        int n = this.getHoursFieldLength();
        switch (this.currentField) {
            case 1: {
                this.select(0, n);
                break;
            }
            case 2: {
                this.select(n + 1, n + 3);
                break;
            }
            case 3: {
                this.select(n + 4, n + 6);
            }
        }
    }

    protected void syncModelStepSize() {
        SpinnerNumberModel m = this.getSpinnerModel();
        switch (this.currentField) {
            case 1: {
                m.setStepSize(3600);
                break;
            }
            case 2: {
                m.setStepSize(60);
                break;
            }
            case 3: {
                m.setStepSize(1);
            }
        }
    }

    protected void syncEditorValue() {
        int val = ((Number)this.getSpinnerModel().getValue()).intValue();
        int h = val / 3600;
        int m = val % 3600 / 60;
        int s = val % 3600 % 60;
        StringBuffer b = new StringBuffer();
        b.append(hoursFormat.format(h));
        b.append(':');
        b.append(minutesFormat.format(m));
        b.append(':');
        b.append(secondsFormat.format(s));
        this.setText(b.toString());
        this.syncCurrentField();
    }

    protected void selectNextField() {
        if (this.currentField > 1) {
            this.setCurrentField(this.currentField - 1);
        }
    }

    protected void selectPreviousField() {
        if (this.currentField < 3) {
            this.setCurrentField(this.currentField + 1);
        }
    }

    protected void increment() {
        SpinnerNumberModel m = this.getSpinnerModel();
        Number val = (Number)m.getNextValue();
        if (val != null && val.intValue() <= this.getEffectiveMaximum().intValue()) {
            m.setValue(val);
        }
    }

    protected void decrement() {
        SpinnerNumberModel m = this.getSpinnerModel();
        Number val = (Number)m.getPreviousValue();
        if (val != null && val.intValue() >= this.getEffectiveMinimum().intValue()) {
            m.setValue(val);
        }
    }

    protected void appendDigit(char digit) {
        try {
            long newVal;
            SpinnerNumberModel nm = this.getSpinnerModel();
            int val = ((Number)nm.getValue()).intValue();
            int h = val / 3600;
            int m = val % 3600 / 60;
            int s = val % 3600 % 60;
            switch (this.currentField) {
                case 1: {
                    h = Integer.parseInt(hoursFormat.format(h) + digit);
                    if (h * 3600 + m * 60 + s <= this.getEffectiveMaximum().intValue()) break;
                    h = Integer.parseInt(hoursFormat.format(h).substring(1));
                    break;
                }
                case 2: {
                    m = Integer.parseInt(minutesFormat.format(m).substring(1) + digit);
                    newVal = h * 3600 + m * 60 + s;
                    if (m <= 59 && h * 3600 + m * 60 + s <= this.getEffectiveMaximum().intValue()) break;
                    m = Integer.parseInt(String.valueOf(digit));
                    break;
                }
                case 3: {
                    s = Integer.parseInt(secondsFormat.format(s).substring(1) + digit);
                    if (s <= 59 && h * 3600 + m * 60 + s <= this.getEffectiveMaximum().intValue()) break;
                    s = Integer.parseInt(String.valueOf(digit));
                }
            }
            newVal = h * 3600 + m * 60 + s;
            if (newVal >= (long)this.getEffectiveMinimum().intValue() && newVal <= (long)this.getEffectiveMaximum().intValue()) {
                nm.setValue(new Integer((int)newVal));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected SpinnerNumberModel getSpinnerModel() {
        return (SpinnerNumberModel)this.spinner.getModel();
    }

    protected Number getEffectiveMinimum() {
        Number min = (Number)((Object)this.getSpinnerModel().getMinimum());
        return Math.max(min.intValue(), 0);
    }

    protected Number getEffectiveMaximum() {
        Number max = (Number)((Object)this.getSpinnerModel().getMaximum());
        return Math.min(max.intValue(), Integer.MAX_VALUE);
    }

    private int getHoursFieldLength() {
        int val = ((Number)this.getSpinnerModel().getValue()).intValue();
        int h = val / 3600;
        return hoursFormat.format(h).length();
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            int n = this.getHoursFieldLength();
            int pos = this.getUI().viewToModel(this, e.getPoint());
            if (pos <= n) {
                this.setCurrentField(1);
            } else if (pos >= n + 2 && pos <= n + 3) {
                this.setCurrentField(2);
            } else if (pos >= n + 5) {
                this.setCurrentField(3);
            }
            this.requestFocus();
            return;
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 506) {
            return;
        }
        super.processMouseMotionEvent(e);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        char ch;
        int id = e.getID();
        if (id == 401) {
            switch (e.getKeyCode()) {
                case 37: {
                    this.selectNextField();
                    break;
                }
                case 39: {
                    this.selectPreviousField();
                    break;
                }
                case 38: {
                    this.increment();
                    break;
                }
                case 40: {
                    this.decrement();
                }
            }
        } else if (id == 400 && Character.isDigit(ch = e.getKeyChar())) {
            this.appendDigit(ch);
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1004) {
            this.syncCurrentField();
        }
        super.processFocusEvent(e);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.syncEditorValue();
    }

    static {
        secondsFormat = NumberFormat.getIntegerInstance();
        secondsFormat.setMinimumIntegerDigits(2);
        secondsFormat.setGroupingUsed(false);
        minutesFormat = secondsFormat;
        hoursFormat = NumberFormat.getIntegerInstance();
        hoursFormat.setMinimumIntegerDigits(1);
        hoursFormat.setGroupingUsed(false);
    }
}

