/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda.module;

import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaAction;
import com.elluminate.groupware.agenda.AgendaItem;
import com.elluminate.groupware.agenda.AgendaNode;
import com.elluminate.groupware.agenda.AgendaText;
import com.elluminate.groupware.agenda.AgendaTopic;
import com.elluminate.groupware.agenda.event.AgendaEvent;
import com.elluminate.groupware.agenda.event.AgendaListener;
import com.elluminate.groupware.agenda.module.AgendaValidator;
import com.elluminate.groupware.agenda.module.event.AgendaEditorEvent;
import com.elluminate.groupware.agenda.module.event.AgendaEditorListener;
import com.elluminate.groupware.agenda.module.event.AgendaValidatorEvent;
import com.elluminate.groupware.agenda.module.event.AgendaValidatorListener;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

class AgendaEditor
extends JList
implements AgendaListener {
    public static final int MODE_VIEWING = 1;
    public static final int MODE_PRESENTING = 2;
    public static final int MODE_EDITING = 3;
    public static final int LEFT_MARGIN = 23;
    private static final int ICON_SIZE = 16;
    private static final int MOUSE_CLICK_SENSITIVITY = 3;
    private LightweightTimer durationUpdateTimer = new LightweightTimer(2, new Runnable(){

        @Override
        public void run() {
            AgendaNode node = AgendaEditor.this.runningNode;
            if (node != null) {
                AgendaEditor.this.repaintNode(node);
            }
        }
    });
    private RowLayoutTimer rowLayoutTimer = new RowLayoutTimer(new Runnable(){

        @Override
        public void run() {
            AgendaEditor.this.layoutRow(AgendaEditor.this.rowLayoutTimer.getRow());
        }
    });
    private IconProvider iconProvider;
    private Agenda agenda;
    private AgendaValidator validator;
    private AgendaValidatorListener validatorListener = new AgendaValidatorListener(){

        @Override
        public void problemFound(AgendaValidatorEvent e) {
            this.problemChanged(e);
        }

        @Override
        public void problemResolved(AgendaValidatorEvent e) {
            this.problemChanged(e);
        }

        private void problemChanged(AgendaValidatorEvent e) {
            AgendaItem it = e.getItem();
            if (it instanceof AgendaAction) {
                final AgendaAction agendaAct = (AgendaAction)it;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        AgendaEditor.this.repaintNode((AgendaNode)agendaAct);
                    }
                };
                SwingRunnerSupport.invokeOnEventThread((Runnable)r);
            }
        }
    };
    private int mode = 1;
    private Icon coveredNodeIcon = new DefaultCoveredIcon(23, 16);
    private Icon currentNodeIcon = new DefaultCurrentIcon(23, 16);
    private Icon blankNodeIcon = new BlankIcon(23, 16);
    private Color coveredNodeColor = Color.MAGENTA;
    private Color actionHyperlinkColor = Color.BLUE;
    private Color problemColor;
    private Color transparentProblemColor;
    private Font topicFont;
    private SimpleAttributeSet topicStyle = new SimpleAttributeSet();
    private Font actionFont;
    private SimpleAttributeSet actionStyle = new SimpleAttributeSet();
    private Font textFont;
    private SimpleAttributeSet textStyle = new SimpleAttributeSet();
    private int indentSize = 20;
    private boolean durationVisible = true;
    private boolean actionExpandable = false;
    private EventListenerList listenerList = new EventListenerList();
    private int lastWidth;
    private AgendaNode currentNode;
    private AgendaNode runningNode;
    private int hoveredRow = -1;
    private int tempCurrentRow = -1;
    private Point marginPressPoint;
    private int durationPressRow = -1;
    private int iconPressRow = -1;
    private int dragHoveredRow = -1;
    private ArrayList expandedActions = new ArrayList();
    private DropTargetAdapter dropListener;

    public AgendaEditor(IconProvider iconProvider) {
        super(new AgendaModel());
        this.iconProvider = iconProvider;
        this.setSelectionModel(new AgendaSelectionModel());
        this.setOpaque(false);
        this.setBackground(Color.WHITE);
        this.setCellRenderer(new NodeRenderer());
        this.setProblemColor(Color.RED, 64);
        int shortcutMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        InputMap imap = this.getInputMap();
        imap.put(KeyStroke.getKeyStroke(38, shortcutMask), "none");
        imap.put(KeyStroke.getKeyStroke(40, shortcutMask), "none");
        imap.put(KeyStroke.getKeyStroke(37, shortcutMask), "none");
        imap.put(KeyStroke.getKeyStroke(39, shortcutMask), "none");
        this.setTopicFont(null);
        this.setActionFont(null);
        this.setTextFont(null);
        this.dropListener = new DropTargetAdapter(){

            @Override
            public void dragOver(DropTargetDragEvent e) {
                AgendaEditor.this.dragHoveredRow = AgendaEditor.this.locationToIndex(e.getLocation());
            }

            @Override
            public void drop(DropTargetDropEvent e) {
            }
        };
    }

    public synchronized void setValidator(AgendaValidator validator) {
        if (this.validator != null && this.agenda != null) {
            this.validator.removeAgendaValidatorListener(this.agenda, this.validatorListener);
        }
        this.validator = validator;
        if (validator != null && this.agenda != null) {
            validator.addAgendaValidatorListener(this.agenda, this.validatorListener);
        }
    }

    public Agenda getAgenda() {
        return this.agenda;
    }

    public void setAgenda(Agenda agenda) {
        this.setAgenda(agenda, false);
    }

    private synchronized void setAgenda(Agenda agenda, boolean printing) {
        this.durationUpdateTimer.cancel();
        AgendaModel m = this.getAgendaModel();
        m.clear();
        this.expandedActions.clear();
        this.currentNode = null;
        if (this.agenda != null) {
            this.agenda.removeAgendaListener((AgendaListener)this);
            if (this.validator != null) {
                this.validator.removeAgendaValidatorListener(this.agenda, this.validatorListener);
            }
        }
        this.agenda = agenda;
        if (agenda != null) {
            ((NodeRenderer)this.getCellRenderer()).adjustLabelSize(this);
            this.currentNode = agenda.getCurrentNode();
            this.populate(m, agenda);
            if (!printing) {
                AgendaNode node;
                Rectangle b;
                int row;
                agenda.addAgendaListener((AgendaListener)this);
                if (this.validator != null) {
                    this.validator.addAgendaValidatorListener(agenda, this.validatorListener);
                }
                if (this.currentNode != null && (row = m.indexOf(this.currentNode)) != -1 && (b = this.getCellBounds(row, row)) != null) {
                    this.scrollRectToVisible(b);
                }
                if ((node = agenda.getRunningNode()) != null) {
                    this.runningNode = node;
                    this.durationUpdateTimer.scheduleEvery(1000L);
                }
            }
        }
    }

    public void setPrintedAgenda(Agenda agenda) {
        this.setAgenda(agenda, true);
    }

    public AgendaNode[] getSelectedNodes() {
        Object[] a = this.getSelectedValues();
        AgendaNode[] a2 = new AgendaNode[a.length];
        System.arraycopy(a, 0, a2, 0, a.length);
        return a2;
    }

    @Override
    public void setTransferHandler(TransferHandler transferHandler) {
        DropTarget tgt = this.getDropTarget();
        if (tgt != null) {
            tgt.removeDropTargetListener(this.dropListener);
        }
        super.setTransferHandler(transferHandler);
        try {
            tgt = this.getDropTarget();
            if (tgt != null) {
                tgt.addDropTargetListener(this.dropListener);
            }
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    public AgendaNode getDragHoveredNode() {
        if (this.dragHoveredRow != -1) {
            return (AgendaNode)this.getModel().getElementAt(this.dragHoveredRow);
        }
        return null;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        int oldMode = this.mode;
        this.mode = mode;
        if (mode != oldMode) {
            if (mode == 3 || oldMode == 3) {
                AgendaModel m = this.getAgendaModel();
                m.clear();
                if (this.agenda != null) {
                    this.populate(m, this.agenda);
                }
            }
            this.repaint();
        }
    }

    public void setCoveredNodeIcon(Icon coveredNodeIcon) {
        if (coveredNodeIcon != null) {
            this.coveredNodeIcon = coveredNodeIcon;
            this.repaint();
        }
    }

    public Icon getCoveredNodeIcon() {
        return this.coveredNodeIcon;
    }

    public void setCurrentNodeIcon(Icon currentNodeIcon) {
        if (currentNodeIcon != null) {
            this.currentNodeIcon = currentNodeIcon;
            this.repaint();
        }
    }

    public Icon getCurrentNodeIcon() {
        return this.currentNodeIcon;
    }

    public void setCoveredNodeColor(Color coveredNodeColor) {
        if (coveredNodeColor != null) {
            this.coveredNodeColor = coveredNodeColor;
            ((NodeRenderer)this.getCellRenderer()).updateStyles();
            this.repaint();
        }
    }

    public Color getCoveredNodeColor() {
        return this.coveredNodeColor;
    }

    public void setActionHyperlinkColor(Color actionHyperlinkColor) {
        if (actionHyperlinkColor != null) {
            this.actionHyperlinkColor = actionHyperlinkColor;
            ((NodeRenderer)this.getCellRenderer()).updateStyles();
            this.repaint();
        }
    }

    public Color getActionHyperlinkColor() {
        return this.actionHyperlinkColor;
    }

    public void setProblemColor(Color problemColor, int alpha) {
        if (problemColor != null) {
            this.problemColor = problemColor;
            this.transparentProblemColor = new Color(problemColor.getRed(), problemColor.getGreen(), problemColor.getBlue(), alpha);
            this.repaint();
        }
    }

    public Color getProblemColor() {
        return this.problemColor;
    }

    public void setTopicFont(Font topicFont) {
        this.topicFont = topicFont;
        if (topicFont == null) {
            Font f = UIManager.getFont("List.font");
            this.topicFont = f.deriveFont(1);
        }
        AgendaEditor.setStyleAttributes(this.topicStyle, this.topicFont);
        this.getAgendaModel().updateAllRows();
    }

    public Font getTopicFont() {
        return this.topicFont;
    }

    public void setActionFont(Font actionFont) {
        this.actionFont = actionFont;
        if (actionFont == null) {
            this.actionFont = UIManager.getFont("List.font");
        }
        AgendaEditor.setStyleAttributes(this.actionStyle, this.actionFont);
        this.getAgendaModel().updateAllRows();
    }

    public Font getActionFont() {
        return this.actionFont;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
        if (textFont == null) {
            Font f = UIManager.getFont("List.font");
            this.textFont = f.deriveFont(2);
        }
        AgendaEditor.setStyleAttributes(this.textStyle, this.textFont);
        this.getAgendaModel().updateAllRows();
    }

    public Font getTextFont() {
        return this.textFont;
    }

    private static void setStyleAttributes(MutableAttributeSet attributes, Font font) {
        StyleConstants.setFontFamily(attributes, font.getFamily());
        StyleConstants.setBold(attributes, font.isBold());
        StyleConstants.setItalic(attributes, font.isItalic());
        StyleConstants.setFontSize(attributes, font.getSize());
    }

    public void setIndentSize(int indentSize) {
        if (this.indentSize != indentSize) {
            this.indentSize = indentSize;
            this.repaint();
        }
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public void setDurationVisible(boolean durationVisible) {
        if (this.durationVisible != durationVisible) {
            this.durationVisible = durationVisible;
            this.repaint();
        }
    }

    public boolean isDurationVisible() {
        return this.durationVisible;
    }

    public void setActionExpandable(boolean actionExpandable) {
        if (this.actionExpandable != actionExpandable) {
            this.actionExpandable = actionExpandable;
            this.repaint();
        }
    }

    public boolean isActionExpandable() {
        return this.actionExpandable;
    }

    private void populate(AgendaModel model, Agenda agenda) {
        for (int i = 0; i < agenda.getNodeCount(); ++i) {
            AgendaNode node = agenda.getNode(i);
            this.populate(model, node);
        }
    }

    private void populate(AgendaModel model, AgendaNode node) {
        block3: {
            block2: {
                model.addElement(node);
                if (!(node instanceof AgendaTopic)) break block2;
                AgendaTopic topic = (AgendaTopic)node;
                for (int i = 0; i < topic.getNodeCount(); ++i) {
                    this.populate(model, topic.getNode(i));
                }
                break block3;
            }
            if (!(node instanceof AgendaAction) || this.mode != 3 && (!this.actionExpandable || !this.isNodeExpanded((AgendaNode)((AgendaAction)node)))) break block3;
            AgendaAction act = (AgendaAction)node;
            for (int i = 0; i < act.getActionCount(); ++i) {
                this.populate(model, (AgendaNode)act.getAction(i));
            }
        }
    }

    private AgendaModel getAgendaModel() {
        return (AgendaModel)this.getModel();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        if (this.lastWidth != width) {
            this.getAgendaModel().updateAllRows();
        }
        this.lastWidth = width;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Dimension s = this.getSize();
        g.setColor(UIManager.getColor("Panel.background"));
        g.fillRect(0, 0, 23, s.height);
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine(23, 0, 23, s.height - 1);
        super.paintComponent(g);
    }

    @Override
    public int locationToIndex(Point location) {
        Rectangle b;
        int row = super.locationToIndex(location);
        if (row != -1 && (b = this.getCellBounds(row, row)).contains(location)) {
            return row;
        }
        return -1;
    }

    protected void repaintNode(AgendaNode node) {
        int row = this.getAgendaModel().indexOf(node);
        if (row != -1) {
            this.repaintRow(row);
        }
    }

    protected void repaintRow(int row) {
        Rectangle b = this.getCellBounds(row, row);
        if (b != null) {
            this.repaint(b.x, b.y, b.width, b.height);
        }
    }

    protected void layoutRow(int row) {
        this.getAgendaModel().updateRow(row);
    }

    @Override
    public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
        return -1;
    }

    private boolean isUnknownCommand(AgendaAction action) {
        AgendaValidatorEvent[] es;
        if (this.validator != null && (es = this.validator.getProblems((AgendaItem)action)) != null) {
            for (AgendaValidatorEvent e : es) {
                switch (e.getProblem()) {
                    case 12: 
                    case 13: {
                        action.setCommandAvailable(false);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean isNodeExpanded(AgendaNode node) {
        return this.expandedActions.contains(node);
    }

    private void setNodeExpanded(AgendaNode node, boolean expanded) {
        block6: {
            if (!(node instanceof AgendaAction)) break block6;
            AgendaAction act = (AgendaAction)node;
            AgendaModel m = this.getAgendaModel();
            int row = m.indexOf(act);
            if (row != -1) {
                if (expanded && !this.isNodeExpanded(node)) {
                    this.expandedActions.add(act);
                    for (int i = 0; i < act.getActionCount(); ++i) {
                        m.insertElementAt(act.getAction(i), row + 1 + i);
                    }
                } else if (!expanded && this.isNodeExpanded(node)) {
                    this.expandedActions.remove(act);
                    for (int i = act.getActionCount() - 1; i >= 0; --i) {
                        m.removeElement(act.getAction(i));
                    }
                }
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        Point pt;
        int row;
        switch (e.getID()) {
            case 501: {
                this.handleMousePressed(e);
                break;
            }
            case 502: {
                this.handleMouseReleased(e);
                break;
            }
            case 505: {
                this.handleMouseExited(e);
            }
        }
        if (e.isPopupTrigger() && (row = this.locationToIndex(pt = e.getPoint())) != -1 && !this.isSelectedIndex(row)) {
            this.setSelectionInterval(row, row);
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        switch (e.getID()) {
            case 503: {
                this.handleMouseMoved(e);
                break;
            }
            case 506: {
                this.handleMouseDragged(e);
            }
        }
        super.processMouseMotionEvent(e);
    }

    private void handleMousePressed(MouseEvent e) {
        Point pt = e.getPoint();
        int row = this.locationToIndex(pt);
        if (row == -1) {
            this.clearSelection();
            this.requestFocus();
            return;
        }
        if (this.mode != 2) {
            return;
        }
        if (pt.x < 23) {
            this.marginPressPoint = pt;
        } else {
            AgendaNode node = (AgendaNode)this.getModel().getElementAt(row);
            NodeRenderer r = (NodeRenderer)this.getCellRenderer();
            Rectangle iconBounds = r.getIconBounds(node);
            if (this.durationVisible && pt.x > this.getWidth() - r.getDurationWidth(node)) {
                if (node.getDuration() != 0) {
                    this.durationPressRow = row;
                    this.repaintRow(row);
                }
            } else if (this.actionExpandable && iconBounds != null && pt.x > iconBounds.x && pt.x < iconBounds.x + iconBounds.width) {
                this.iconPressRow = row;
            }
        }
    }

    private void handleMouseReleased(MouseEvent e) {
        if (this.mode != 2) {
            return;
        }
        Point oldMarginPressPoint = this.marginPressPoint;
        this.marginPressPoint = null;
        int oldDurationPressRow = this.durationPressRow;
        this.durationPressRow = -1;
        int oldIconPressRow = this.iconPressRow;
        this.iconPressRow = -1;
        int oldTempCurrentRow = this.tempCurrentRow;
        this.tempCurrentRow = -1;
        if (oldMarginPressPoint != null) {
            int row = this.locationToIndex(oldMarginPressPoint);
            if (row != -1) {
                AgendaNode node = (AgendaNode)this.getModel().getElementAt(row);
                this.fireAgendaEditorEvent(1, node, e.getModifiers());
            }
        } else if (oldTempCurrentRow != -1) {
            this.repaintRow(oldTempCurrentRow);
            AgendaNode node = (AgendaNode)this.getModel().getElementAt(oldTempCurrentRow);
            this.fireAgendaEditorEvent(4, node, e.getModifiers());
        } else if (oldDurationPressRow != -1) {
            this.repaintRow(oldDurationPressRow);
            AgendaNode node = (AgendaNode)this.getModel().getElementAt(oldDurationPressRow);
            this.fireAgendaEditorEvent(3, node, e.getModifiers());
        } else if (oldIconPressRow != -1) {
            AgendaNode node;
            this.setNodeExpanded(node, !this.isNodeExpanded(node = (AgendaNode)this.getModel().getElementAt(oldIconPressRow)));
        } else {
            AgendaNode node;
            Point pt = e.getPoint();
            int row = this.locationToIndex(pt);
            if (!(row == -1 || (node = (AgendaNode)this.getModel().getElementAt(row)) instanceof AgendaAction && ((AgendaAction)node).isCompounded())) {
                this.fireAgendaEditorEvent(2, node, e.getModifiers());
            }
        }
    }

    private void handleMouseExited(MouseEvent e) {
        if (this.mode != 2) {
            return;
        }
        int oldRow = this.hoveredRow;
        this.hoveredRow = -1;
        if (oldRow != -1) {
            this.repaintRow(oldRow);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void handleMouseMoved(MouseEvent e) {
        int row;
        if (this.mode != 2) {
            return;
        }
        Point pt = e.getPoint();
        int n = row = pt.x < 23 ? -1 : this.locationToIndex(pt);
        if (row != this.hoveredRow) {
            AgendaAction act;
            AgendaNode node;
            int oldRow = this.hoveredRow;
            this.hoveredRow = row;
            if (oldRow != -1) {
                this.repaintRow(oldRow);
            }
            boolean clickable = false;
            if (this.hoveredRow != -1 && (node = (AgendaNode)this.getAgendaModel().getElementAt(this.hoveredRow)) instanceof AgendaAction && !(act = (AgendaAction)node).isCompounded() && !this.isUnknownCommand(act)) {
                this.repaintRow(this.hoveredRow);
                clickable = true;
            }
            if (clickable) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private void handleMouseDragged(MouseEvent e) {
        if (this.mode != 2) {
            return;
        }
        Point pt = e.getPoint();
        if (this.marginPressPoint != null) {
            if (Math.abs(pt.x - this.marginPressPoint.x) > 3 || Math.abs(pt.y - this.marginPressPoint.y) > 3) {
                this.marginPressPoint = null;
                this.tempCurrentRow = this.locationToIndex(pt);
                if (this.tempCurrentRow != -1) {
                    this.repaintRow(this.tempCurrentRow);
                }
            }
        } else if (this.tempCurrentRow != -1) {
            int row;
            if (pt.x < 0 || pt.x >= this.getWidth()) {
                pt.x = 1;
            }
            if ((row = this.locationToIndex(pt)) != this.tempCurrentRow) {
                int oldRow = this.tempCurrentRow;
                this.tempCurrentRow = row;
                if (oldRow != -1) {
                    this.repaintRow(oldRow);
                }
                if (this.tempCurrentRow != -1) {
                    this.repaintRow(this.tempCurrentRow);
                }
            }
        }
    }

    public void editorChanged(AgendaEvent e) {
    }

    public void agendaPropertyChanged(final AgendaEvent e) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AgendaEditor.this.processAgendaPropertyChanged(e);
            }
        };
        SwingRunnerSupport.invokeOnEventThread((Runnable)r);
    }

    public void processAgendaPropertyChanged(AgendaEvent e) {
        String prop = e.getProperty();
        if (prop.equals("currentitem")) {
            int row;
            Agenda ag = e.getAgenda();
            AgendaNode cur = ag.getCurrentNode();
            AgendaModel m = this.getAgendaModel();
            AgendaNode oldCur = this.currentNode;
            this.currentNode = cur;
            if (oldCur != null && oldCur != cur && (row = m.indexOf(oldCur)) != -1) {
                this.repaintRow(row);
            }
            if (cur != null && (row = m.indexOf(cur)) != -1) {
                this.repaintRow(row);
                Rectangle b = this.getCellBounds(row, row);
                if (b != null) {
                    this.scrollRectToVisible(b);
                }
            }
        } else if (prop.equals("labeltype")) {
            ((NodeRenderer)this.getCellRenderer()).adjustLabelSize(this);
            this.repaint();
        } else if (prop.equals("showicons")) {
            ((NodeRenderer)this.getCellRenderer()).adjustLabelSize(this);
            this.repaint();
        }
    }

    public void itemAdded(final AgendaEvent e) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.processItemAdded(e);
        } else {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AgendaEditor.this.processItemAdded(e);
                }
            });
        }
    }

    private void processItemAdded(AgendaEvent e) {
        AgendaItem it = e.getItem();
        if (it instanceof AgendaNode) {
            AgendaNode node = (AgendaNode)it;
            int index = e.getIndex();
            AgendaModel m = this.getAgendaModel();
            int row = -1;
            AgendaNode parent = node.getParent();
            if (parent == null) {
                Agenda ag = e.getAgenda();
                if (index == -1) {
                    row = m.getSize();
                    m.addElement(node);
                } else {
                    int idx = -1;
                    for (int r = 0; r < m.size(); ++r) {
                        AgendaNode n = (AgendaNode)m.elementAt(r);
                        if (n.getParent() != null || ++idx != index) continue;
                        row = r;
                        break;
                    }
                    if (row != -1) {
                        m.insertElementAt(node, row);
                    }
                }
            } else if (index == -1) {
                for (int r = m.indexOf(parent) + 1; r < m.size(); ++r) {
                    AgendaNode n = (AgendaNode)m.elementAt(r);
                    if (parent.isAncestorOf(n)) continue;
                    row = r;
                    break;
                }
                if (row == -1) {
                    row = m.getSize();
                    m.addElement(node);
                } else {
                    m.insertElementAt(node, row);
                }
            } else {
                int idx = -1;
                for (int r = m.indexOf(parent) + 1; r < m.size(); ++r) {
                    AgendaNode n = (AgendaNode)m.elementAt(r);
                    if (n.getParent() != parent || ++idx != index) continue;
                    row = r;
                    break;
                }
                if (row != -1) {
                    m.insertElementAt(node, row);
                }
            }
            if (row != -1) {
                ListSelectionModel sm = this.getSelectionModel();
                sm.addSelectionInterval(row, row);
                Rectangle b = this.getCellBounds(row, row);
                if (b != null) {
                    this.scrollRectToVisible(b);
                }
            }
        }
    }

    public void itemRemoved(final AgendaEvent e) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.processItemRemoved(e);
        } else {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AgendaEditor.this.processItemRemoved(e);
                }
            });
        }
    }

    private void processItemRemoved(AgendaEvent e) {
        AgendaItem it = e.getItem();
        if (it instanceof AgendaNode) {
            AgendaModel m = this.getAgendaModel();
            m.removeElement(it);
        }
    }

    public void itemPropertyChanged(final AgendaEvent e) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AgendaEditor.this.processItemPropertyChanged(e);
            }
        };
        SwingRunnerSupport.invokeOnEventThread((Runnable)r);
    }

    public void processItemPropertyChanged(AgendaEvent e) {
        AgendaItem it = e.getItem();
        if (it instanceof AgendaNode) {
            int row = this.getAgendaModel().indexOf(it);
            if (row == -1) {
                return;
            }
            String prop = e.getProperty();
            if (prop.equals("covered")) {
                this.repaintRow(row);
            } else if (prop.equals("duration")) {
                this.rowLayoutTimer.updateRow(row);
            } else if (it instanceof AgendaTopic) {
                if (prop.equals("name")) {
                    this.rowLayoutTimer.updateRow(row);
                }
            } else if (it instanceof AgendaAction) {
                if (prop.equals("description")) {
                    this.rowLayoutTimer.updateRow(row);
                } else if (prop.equals("command")) {
                    this.repaintRow(row);
                }
            } else if (it instanceof AgendaText && prop.equals("text")) {
                this.rowLayoutTimer.updateRow(row);
            }
        }
    }

    public void timerStarted(AgendaEvent e) {
        final AgendaNode node = (AgendaNode)e.getItem();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AgendaEditor.this.repaintNode(node);
            }
        };
        SwingRunnerSupport.invokeOnEventThread((Runnable)r);
        this.runningNode = node;
        this.durationUpdateTimer.scheduleEvery(1000L);
    }

    public void timerStopped(AgendaEvent e) {
        this.durationUpdateTimer.cancel();
        this.runningNode = null;
        final AgendaNode node = (AgendaNode)e.getItem();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AgendaEditor.this.repaintNode(node);
            }
        };
        SwingRunnerSupport.invokeOnEventThread((Runnable)r);
    }

    public void transferAdded(AgendaEvent e) {
    }

    public void transferRemoved(AgendaEvent e) {
    }

    public void addAgendaEditorListener(AgendaEditorListener l) {
        this.listenerList.add(AgendaEditorListener.class, l);
    }

    public void removeAgendaEditorListener(AgendaEditorListener l) {
        this.listenerList.remove(AgendaEditorListener.class, l);
    }

    protected void fireAgendaEditorEvent(int eventID, AgendaNode agendaNode, int modifiers) {
        AgendaEditorEvent e = new AgendaEditorEvent(this, eventID, agendaNode, modifiers);
        Object[] ls = this.listenerList.getListenerList();
        block6: for (int i = ls.length - 2; i >= 0; i -= 2) {
            if (ls[i] != AgendaEditorListener.class) continue;
            switch (eventID) {
                case 1: {
                    ((AgendaEditorListener)ls[i + 1]).nodeStatusClicked(e);
                    continue block6;
                }
                case 2: {
                    ((AgendaEditorListener)ls[i + 1]).nodeClicked(e);
                    continue block6;
                }
                case 3: {
                    ((AgendaEditorListener)ls[i + 1]).nodeDurationClicked(e);
                    continue block6;
                }
                case 4: {
                    ((AgendaEditorListener)ls[i + 1]).currentIndicatorMoved(e);
                }
            }
        }
    }

    private static class AgendaModel
    extends DefaultListModel {
        private AgendaModel() {
        }

        public void updateAllRows() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        public void updateRow(int row) {
            this.fireContentsChanged(this, row, row);
        }

        @Override
        public synchronized Object getElementAt(int row) {
            if (row >= this.getSize()) {
                return null;
            }
            return super.getElementAt(row);
        }
    }

    private class AgendaSelectionModel
    extends DefaultListSelectionModel {
        private AgendaSelectionModel() {
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            if (AgendaEditor.this.mode == 3) {
                super.addSelectionInterval(index0, index1);
            }
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            if (AgendaEditor.this.mode == 3) {
                super.setSelectionInterval(index0, index1);
            }
        }
    }

    private class BlankIcon
    implements Icon {
        protected int width;
        protected int height;

        public BlankIcon(int width, int height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public void paintIcon(Component component, Graphics g, int x, int y) {
        }
    }

    private class CompoundIcon
    extends BlankIcon {
        private Icon topIcon;
        private Icon bottomIcon;
        private float transparency;
        private Image offscreen;

        public CompoundIcon(Icon topIcon, Icon bottomIcon, float transparency) {
            super(topIcon.getIconWidth(), topIcon.getIconHeight());
            this.topIcon = topIcon;
            this.bottomIcon = bottomIcon;
            this.transparency = transparency;
        }

        @Override
        public void paintIcon(Component component, Graphics g, int x, int y) {
            if (this.offscreen == null) {
                BufferedImage im = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics2D g2 = im.createGraphics();
                if (g2 != null) {
                    if (this.bottomIcon != null) {
                        this.bottomIcon.paintIcon(component, g2, x, y);
                    }
                    g2.setComposite(AlphaComposite.getInstance(3, this.transparency));
                    if (this.topIcon != null) {
                        this.topIcon.paintIcon(component, g2, x, y);
                    }
                    g2.dispose();
                }
                this.offscreen = im;
            }
            g.drawImage(this.offscreen, x, y, component);
        }
    }

    private class DefaultCoveredIcon
    extends BlankIcon {
        private final int BULLET_SIZE = 6;

        public DefaultCoveredIcon(int width, int height) {
            super(width, height);
            this.BULLET_SIZE = 6;
        }

        @Override
        public void paintIcon(Component component, Graphics g, int x, int y) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(AgendaEditor.this.coveredNodeColor);
            g.fillOval(x + this.width / 2 - 3, y + this.height / 2 - 3, 6, 6);
        }
    }

    private class DefaultCurrentIcon
    extends BlankIcon {
        private boolean transparent;

        public DefaultCurrentIcon(int width, int height) {
            super(width, height);
            this.transparent = false;
        }

        @Override
        public void paintIcon(Component component, Graphics g, int x, int y) {
            int size = Math.min(16, this.height);
            int horiCenter = x + this.width / 2;
            int vertCenter = y + this.height / 2;
            int x0 = horiCenter - size / 2;
            int x2 = x0 + size;
            int x1 = (x0 + x2) / 2;
            int y0 = vertCenter - size / 2;
            int y4 = y0 + size;
            int y2 = (y0 + y4) / 2;
            int y1 = y2 - y2 / 2;
            int y3 = y2 + y2 / 2;
            int[] xs = new int[]{x0, x1, x1, x2, x1, x1, x0};
            int[] ys = new int[]{y1, y1, y0, y2, y4, y3, y3};
            g.setColor(Color.LIGHT_GRAY);
            g.fillPolygon(xs, ys, xs.length);
            g.setColor(Color.GRAY);
            g.drawPolygon(xs, ys, xs.length);
        }
    }

    private static class DurationBubble
    extends JLabel {
        private static final Color BACKGROUND = new Color(187, 187, 187);
        private static final Color RUNNING_BACKGROUND = new Color(208, 111, 111);
        private static final Color BORDER = new Color(153, 153, 153);
        private static final Color RUNNING_BORDER = new Color(176, 44, 38);
        private boolean pressed = false;
        private boolean running = false;

        public DurationBubble() {
            super("", 0);
            this.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 5));
        }

        public void setPressed(boolean pressed) {
            this.pressed = pressed;
        }

        public void setRunning(boolean running) {
            this.running = running;
        }

        @Override
        protected void paintComponent(Graphics g) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Dimension s = this.getSize();
            g.setColor(this.running ? RUNNING_BACKGROUND : BACKGROUND);
            g.fillRoundRect(0, 0, s.width - 1, s.height - 1, s.height - 1, s.height - 1);
            g.setColor(this.running ? RUNNING_BORDER : BORDER);
            g.drawRoundRect(0, 0, s.width - 1, s.height - 1, s.height - 1, s.height - 1);
            if (this.pressed) {
                this.setForeground(Color.BLACK);
            } else {
                this.setForeground(Color.WHITE);
            }
            super.paintComponent(g);
        }
    }

    public static interface IconProvider {
        public Icon getIcon(AgendaItem var1);
    }

    private class NodeRenderer
    extends JComponent
    implements ListCellRenderer {
        private final int RIGHT_CELL_MARGIN = 3;
        private final String LEADER_SYMBOL = "-";
        private final String BULLET_SYMBOL = "\u2022";
        private final Icon UNKNOWN_ACTION_ICON = new UnknownActionIcon();
        private JLabel statusIcon;
        private JLabel decorationLabel;
        private Dimension decorationLabelSize;
        private JTextPane textField;
        private DurationBubble durationBubble;
        private SimpleAttributeSet unknownActionStyle = new SimpleAttributeSet();
        private SimpleAttributeSet hoveredActionStyle = new SimpleAttributeSet();
        private SimpleAttributeSet compoundedActionStyle = new SimpleAttributeSet();
        private SimpleAttributeSet coveredNodeStyle = new SimpleAttributeSet();
        private JList list;
        private AgendaNode node;

        public NodeRenderer() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 11;
            gbc.fill = 2;
            gbc.weightx = 0.0;
            gbc.insets.top = 1;
            gbc.insets.left = 0;
            this.statusIcon = new JLabel();
            this.add((Component)this.statusIcon, gbc);
            gbc.weightx = 0.0;
            gbc.insets.top = 1;
            gbc.insets.left = 6;
            this.decorationLabel = new JLabel((String)null, 4);
            this.decorationLabel.setHorizontalTextPosition(10);
            this.decorationLabel.setIconTextGap(8);
            this.add((Component)this.decorationLabel, gbc);
            gbc.weightx = 100.0;
            gbc.insets.top = 0;
            gbc.insets.left = 6;
            this.textField = new JTextPane();
            this.textField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.textField.setOpaque(true);
            this.add((Component)this.textField, gbc);
            gbc.weightx = 0.0;
            gbc.insets.top = 1;
            gbc.insets.left = 3;
            gbc.insets.right = 3;
            this.durationBubble = new DurationBubble();
            this.add((Component)this.durationBubble, gbc);
            this.updateStyles();
        }

        public void updateStyles() {
            StyleConstants.setStrikeThrough(this.unknownActionStyle, true);
            StyleConstants.setForeground(this.unknownActionStyle, Color.GRAY);
            StyleConstants.setForeground(this.hoveredActionStyle, AgendaEditor.this.actionHyperlinkColor);
            StyleConstants.setUnderline(this.hoveredActionStyle, true);
            StyleConstants.setForeground(this.compoundedActionStyle, Color.GRAY);
            StyleConstants.setForeground(this.coveredNodeStyle, AgendaEditor.this.coveredNodeColor);
        }

        public int getDurationWidth(AgendaNode node) {
            this.durationBubble.setText(this.formatDuration(node.getDuration()));
            return this.durationBubble.getPreferredSize().width + 3;
        }

        public Rectangle getIconBounds(AgendaNode node) {
            if (!AgendaEditor.this.agenda.isShowingIcons() || !(node instanceof AgendaAction)) {
                return null;
            }
            Dimension iconSize = new Dimension(16, 16);
            int x2 = 23 + this.getNodeDepth(node) * AgendaEditor.this.indentSize + this.decorationLabelSize.width + this.decorationLabel.getIconTextGap() + iconSize.width;
            return new Rectangle(x2 - iconSize.width, 1, iconSize.width, iconSize.height);
        }

        public void adjustLabelSize(JList list) {
            this.decorationLabel.setFont(list.getFont());
            this.decorationLabel.setIcon(null);
            this.decorationLabel.setPreferredSize(null);
            switch (AgendaEditor.this.agenda.getLabelType()) {
                case 6: {
                    this.decorationLabel.setText("WWW.");
                    break;
                }
                case 5: {
                    this.decorationLabel.setText("www.");
                    break;
                }
                case 3: 
                case 4: {
                    this.decorationLabel.setText("00.");
                    break;
                }
                case 2: {
                    this.decorationLabel.setText("\u2022");
                    break;
                }
                case 1: {
                    this.decorationLabel.setText("-");
                    break;
                }
                default: {
                    this.decorationLabel.setText(null);
                }
            }
            this.decorationLabelSize = new Dimension(this.decorationLabel.getPreferredSize().width, 16);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focused) {
            this.list = list;
            this.node = null;
            this.setComponentOrientation(list.getComponentOrientation());
            this.textField.setEnabled(list.isEnabled());
            if (value instanceof AgendaNode) {
                this.node = (AgendaNode)value;
                Font font = list.getFont();
                if (this.node == AgendaEditor.this.currentNode) {
                    if (this.node instanceof AgendaAction && !((AgendaAction)this.node).isCommandAvailable()) {
                        this.statusIcon.setIcon(AgendaEditor.this.blankNodeIcon);
                    } else {
                        this.statusIcon.setIcon(AgendaEditor.this.currentNodeIcon != null ? AgendaEditor.this.currentNodeIcon : AgendaEditor.this.blankNodeIcon);
                    }
                } else if (index == AgendaEditor.this.tempCurrentRow && this.node.isCovered()) {
                    this.statusIcon.setIcon(new CompoundIcon(AgendaEditor.this.currentNodeIcon != null ? AgendaEditor.this.currentNodeIcon : AgendaEditor.this.blankNodeIcon, AgendaEditor.this.coveredNodeIcon != null ? AgendaEditor.this.coveredNodeIcon : AgendaEditor.this.blankNodeIcon, 0.35f));
                } else if (index == AgendaEditor.this.tempCurrentRow) {
                    this.statusIcon.setIcon(new CompoundIcon(AgendaEditor.this.currentNodeIcon != null ? AgendaEditor.this.currentNodeIcon : AgendaEditor.this.blankNodeIcon, AgendaEditor.this.blankNodeIcon, 0.35f));
                } else if (this.node.isCovered()) {
                    this.statusIcon.setIcon(AgendaEditor.this.coveredNodeIcon != null ? AgendaEditor.this.coveredNodeIcon : AgendaEditor.this.blankNodeIcon);
                } else {
                    this.statusIcon.setIcon(AgendaEditor.this.blankNodeIcon);
                }
                Dimension s = new Dimension(this.getNodeDepth(this.node) * AgendaEditor.this.indentSize + this.decorationLabelSize.width, this.decorationLabelSize.height);
                if (this.node instanceof AgendaAction && AgendaEditor.this.agenda.isShowingIcons()) {
                    s.width += 16 + this.decorationLabel.getIconTextGap();
                }
                this.decorationLabel.setMinimumSize(s);
                this.decorationLabel.setPreferredSize(s);
                this.decorationLabel.setFont(font);
                switch (AgendaEditor.this.agenda.getLabelType()) {
                    case 6: {
                        this.decorationLabel.setText(this.getLetterLabel(this.node, true));
                        break;
                    }
                    case 5: {
                        this.decorationLabel.setText(this.getLetterLabel(this.node, false));
                        break;
                    }
                    case 4: {
                        this.decorationLabel.setText(this.getLegalLabel(this.node));
                        break;
                    }
                    case 3: {
                        this.decorationLabel.setText(this.getNumberLabel(this.node));
                        break;
                    }
                    case 2: {
                        this.decorationLabel.setText("\u2022");
                        break;
                    }
                    case 1: {
                        this.decorationLabel.setText("-");
                        break;
                    }
                    default: {
                        this.decorationLabel.setText(null);
                    }
                }
                if (this.node instanceof AgendaAction && AgendaEditor.this.agenda.isShowingIcons()) {
                    Icon icon = null;
                    if (AgendaEditor.this.iconProvider != null) {
                        icon = AgendaEditor.this.iconProvider.getIcon((AgendaItem)this.node);
                    }
                    this.decorationLabel.setIcon(icon != null ? icon : this.UNKNOWN_ACTION_ICON);
                } else {
                    this.decorationLabel.setIcon(null);
                }
                if (this.node instanceof AgendaTopic) {
                    this.textField.setText(((AgendaTopic)this.node).getName());
                } else if (this.node instanceof AgendaText) {
                    this.textField.setText(((AgendaText)this.node).getText());
                } else if (this.node instanceof AgendaAction) {
                    this.textField.setText(((AgendaAction)this.node).getDescription());
                }
                SimpleAttributeSet style = null;
                if (this.node instanceof AgendaTopic) {
                    style = AgendaEditor.this.topicStyle;
                } else if (this.node instanceof AgendaAction) {
                    style = AgendaEditor.this.actionStyle;
                } else if (this.node instanceof AgendaText) {
                    style = AgendaEditor.this.textStyle;
                }
                StyledDocument doc = this.textField.getStyledDocument();
                if (style != null) {
                    doc.setCharacterAttributes(0, doc.getLength(), style, true);
                }
                if (selected) {
                    this.textField.setBackground(list.getSelectionBackground());
                    this.textField.setForeground(list.getSelectionForeground());
                } else {
                    this.textField.setBackground(list.getBackground());
                    if (this.node instanceof AgendaAction) {
                        if (AgendaEditor.this.isUnknownCommand((AgendaAction)this.node)) {
                            doc.setCharacterAttributes(0, doc.getLength(), this.unknownActionStyle, false);
                        } else if (index == AgendaEditor.this.hoveredRow && !((AgendaAction)this.node).isCompounded()) {
                            doc.setCharacterAttributes(0, doc.getLength(), this.hoveredActionStyle, false);
                        }
                    } else if (this.node.isCovered()) {
                        doc.setCharacterAttributes(0, doc.getLength(), this.coveredNodeStyle, false);
                    } else if (AgendaEditor.this.mode != 3 && this.node instanceof AgendaAction && ((AgendaAction)this.node).isCompounded()) {
                        doc.setCharacterAttributes(0, doc.getLength(), this.compoundedActionStyle, false);
                    } else {
                        this.textField.setForeground(list.getForeground());
                    }
                }
                if (!(!AgendaEditor.this.durationVisible || this.node instanceof AgendaAction && ((AgendaAction)this.node).isCompounded())) {
                    boolean vis;
                    int dur;
                    if (this.node == AgendaEditor.this.runningNode) {
                        dur = AgendaEditor.this.agenda.getTimeLeft(this.node);
                        vis = true;
                    } else {
                        dur = this.node.getDuration();
                        vis = dur != 0;
                    }
                    this.durationBubble.setVisible(vis);
                    if (vis) {
                        this.durationBubble.setText(this.formatDuration(dur));
                        this.durationBubble.setPressed(index == AgendaEditor.this.durationPressRow);
                        this.durationBubble.setRunning(AgendaEditor.this.agenda.isRunningNode(this.node));
                    }
                } else {
                    this.durationBubble.setVisible(false);
                }
                this.durationBubble.setFont(font.deriveFont(font.getStyle(), font.getSize() - 1));
            }
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (AgendaEditor.this.validator != null && this.node != null && AgendaEditor.this.mode == 3 && AgendaEditor.this.validator.getProblems((AgendaItem)this.node) != null) {
                Dimension s = this.getSize();
                g.setColor(AgendaEditor.this.transparentProblemColor);
                g.fillRect(0, 0, s.width, s.height);
                g.setColor(AgendaEditor.this.problemColor);
                g.drawLine(0, 0, s.width - 1, 0);
                g.drawLine(0, s.height - 1, s.width - 1, s.height - 1);
            }
        }

        private int getNodeDepth(AgendaNode node) {
            int depth = 0;
            for (AgendaNode p = node.getParent(); p != null; p = p.getParent()) {
                ++depth;
            }
            return depth;
        }

        private String getLetterLabel(AgendaNode node, boolean uppercase) {
            int index = 0;
            AgendaNode p = node.getParent();
            if (p == null) {
                index = AgendaEditor.this.agenda.getNodeIndex(node);
            } else if (p instanceof AgendaTopic) {
                index = ((AgendaTopic)p).getNodeIndex(node);
            } else if (p instanceof AgendaAction && node instanceof AgendaAction) {
                index = ((AgendaAction)p).getActionIndex((AgendaAction)node);
            }
            int count = index / 26 + 1;
            char letter = (char)(97 + index % 26);
            if (uppercase) {
                letter = Character.toUpperCase(letter);
            }
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                b.append(letter);
            }
            b.append(".");
            return b.toString();
        }

        private String getLegalLabel(AgendaNode node) {
            StringBuffer b = new StringBuffer();
            AgendaNode n = node;
            while (n != null) {
                int index = 0;
                AgendaNode p = n.getParent();
                if (p == null) {
                    index = AgendaEditor.this.agenda.getNodeIndex(n);
                } else if (p instanceof AgendaTopic) {
                    index = ((AgendaTopic)p).getNodeIndex(n);
                } else if (p instanceof AgendaAction && n instanceof AgendaAction) {
                    index = ((AgendaAction)p).getActionIndex((AgendaAction)n);
                }
                if (b.length() != 0) {
                    b.insert(0, ".");
                }
                b.insert(0, index + 1);
                n = p;
            }
            if (b.indexOf(".") == -1) {
                b.append(".");
            }
            return b.toString();
        }

        private String getNumberLabel(AgendaNode node) {
            int index = 0;
            AgendaNode p = node.getParent();
            if (p == null) {
                index = AgendaEditor.this.agenda.getNodeIndex(node);
            } else if (p instanceof AgendaTopic) {
                index = ((AgendaTopic)p).getNodeIndex(node);
            } else if (p instanceof AgendaAction && node instanceof AgendaAction) {
                index = ((AgendaAction)p).getActionIndex((AgendaAction)node);
            }
            return String.valueOf(index + 1) + ".";
        }

        private String formatDuration(int duration) {
            int h = duration / 3600;
            int r = duration % 3600;
            int m = r / 60;
            int s = r %= 60;
            String t = "";
            if (h != 0) {
                t = t + String.valueOf(h) + ":";
            }
            if (t.length() != 0 && m < 10) {
                t = t + "0";
            }
            t = t + String.valueOf(m) + ":";
            if (s < 10) {
                t = t + "0";
            }
            t = t + String.valueOf(s);
            return t;
        }

        @Override
        public Dimension getPreferredSize() {
            if (!this.isValid()) {
                this.setSize(this.list.getWidth(), Integer.MAX_VALUE);
                this.validate();
            }
            return super.getPreferredSize();
        }

        @Override
        public void repaint() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void revalidate() {
        }
    }

    private static final class RowLayoutTimer
    extends LightweightTimer {
        private int row;

        public RowLayoutTimer(Runnable runnable) {
            super((byte)2, runnable);
        }

        public void updateRow(int row) {
            this.row = row;
            this.scheduleIn(300L);
        }

        public int getRow() {
            return this.row;
        }
    }

    private class UnknownActionIcon
    extends BlankIcon {
        private final Font FONT;
        private final String QUESTION_MARK = "?";

        public UnknownActionIcon() {
            super(16, 16);
            this.FONT = UIManager.getFont("Label.font").deriveFont(1);
            this.QUESTION_MARK = "?";
        }

        @Override
        public void paintIcon(Component component, Graphics g, int x, int y) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.LIGHT_GRAY);
            g.drawOval(x, y, this.width - 1, this.height - 1);
            g.setFont(this.FONT);
            FontMetrics fm = g.getFontMetrics();
            int len = fm.stringWidth("?");
            g.drawString("?", x + (this.width - len) / 2, y + (this.height - fm.getAscent() - fm.getDescent()) / 2 + fm.getAscent());
        }
    }
}

