/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.online.module;

import com.elluminate.classroom.client.GeneralPrefsOwner;
import com.elluminate.groupware.online.module.StringsProperties;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.InvalidPreferenceSettingException;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.net.EndpointCaller;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.net.ProxyUtils;
import com.elluminate.util.net.URLString;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

@Singleton
public class ProxyPrefsPanel
extends AbstractPreferencesPanel {
    public static final String PREF_PROXY = "classroom.proxy";
    private static I18n i18n = I18n.create((Object)new Object(){});
    private String useInherit;
    private String overrideDirect;
    private String overrideHTTPS;
    private String overrideHTTP;
    private String overrideHalfHTTP;
    private String overrideDirectHTTP;
    private String overrideDirectHalfHTTP;
    private String overrideSOCKS;
    private JComboBox methodPopup;
    private JLabel serverLabel;
    private JTextField serverField;
    private JLabel portLabel;
    private JTextField portField;
    private MultilineLabel messageField;
    private boolean valid = false;
    private Map<String, ProxyParams> paramMap = new HashMap<String, ProxyParams>();
    private ProxyParams currentParams = null;

    @Inject
    public ProxyPrefsPanel(GeneralPrefsOwner owner) {
        super((PreferencesPanelOwner)owner, i18n.getString((PropertiesEnum)StringsProperties.PROXYSETTINGS_TITLE));
    }

    protected void createContent() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new GridBagLayout());
        this.add(p, "North");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        this.useInherit = i18n.getString((PropertiesEnum)StringsProperties.PROXYSETTINGS_INHERIT, new Object[]{ProxyUtils.getDefaultProxyType()});
        this.overrideDirect = i18n.getString((PropertiesEnum)StringsProperties.PROXYSETTINGS_DIRECT);
        this.overrideSOCKS = i18n.getString((PropertiesEnum)StringsProperties.PROXYSETTINGS_SOCKSPROXY);
        this.overrideHTTPS = i18n.getString((PropertiesEnum)StringsProperties.PROXYSETTINGS_HTTPSPROXY);
        this.overrideHTTP = i18n.getString((PropertiesEnum)StringsProperties.PROXYSETTINGS_HTTPPROXY);
        this.overrideHalfHTTP = i18n.getString((PropertiesEnum)StringsProperties.PROXYSETTINGS_HALFHTTPPROXY);
        this.overrideDirectHTTP = i18n.getString((PropertiesEnum)StringsProperties.PROXYSETTINGS_DIRECTHTTPPROXY);
        this.overrideDirectHalfHTTP = i18n.getString((PropertiesEnum)StringsProperties.PROXYSETTINGS_DIRECTHALFHTTPPROXY);
        this.paramMap.put(this.useInherit, new ProxyParams("inherit"));
        this.paramMap.put(this.overrideDirect, new ProxyParams(null));
        this.paramMap.put(this.overrideSOCKS, new ProxyParams("socks"));
        this.paramMap.put(this.overrideHTTPS, new ProxyParams("https"));
        this.paramMap.put(this.overrideHTTP, new ProxyParams("http"));
        this.paramMap.put(this.overrideHalfHTTP, new ProxyParams("http"));
        this.paramMap.put(this.overrideDirectHTTP, new ProxyParams(null));
        this.paramMap.put(this.overrideDirectHalfHTTP, new ProxyParams(null));
        gbc.gridy = 0;
        gbc.insets.top = 0;
        gbc.insets.left = 0;
        JLabel methodLabel = new JLabel(i18n.getString((PropertiesEnum)StringsProperties.PROXYSETTINGS_METHODLABEL));
        methodLabel.setLabelFor(this.methodPopup);
        p.add((Component)methodLabel, gbc);
        gbc.insets.left = 6;
        this.methodPopup = new JComboBox();
        this.methodPopup.addItem(this.useInherit);
        this.methodPopup.addItem(this.overrideDirect);
        this.methodPopup.addItem(this.overrideSOCKS);
        if (EndpointCaller.isTunnelMethodAvailable((String)"https")) {
            this.methodPopup.addItem(this.overrideHTTPS);
        }
        if (EndpointCaller.isTunnelMethodAvailable((String)"http")) {
            this.methodPopup.addItem(this.overrideHTTP);
            this.methodPopup.addItem(this.overrideHalfHTTP);
            this.methodPopup.addItem(this.overrideDirectHTTP);
            this.methodPopup.addItem(this.overrideDirectHalfHTTP);
        }
        p.add((Component)this.methodPopup, gbc);
        this.methodPopup.setSelectedIndex(0);
        ++gbc.gridy;
        gbc.insets.top = 6;
        gbc.insets.left = 0;
        this.serverLabel = new JLabel(i18n.getString((PropertiesEnum)StringsProperties.PROXYSETTINGS_SERVERLABEL));
        this.serverLabel.setLabelFor(this.serverField);
        p.add((Component)this.serverLabel, gbc);
        gbc.insets.left = 6;
        this.serverField = new JTextField(20);
        p.add((Component)this.serverField, gbc);
        ++gbc.gridy;
        gbc.insets.top = 6;
        gbc.insets.left = 0;
        this.portLabel = new JLabel(i18n.getString((PropertiesEnum)StringsProperties.PROXYSETTINGS_PORTLABEL));
        this.portLabel.setLabelFor(this.portField);
        p.add((Component)this.portLabel, gbc);
        gbc.insets.left = 6;
        this.portField = new JTextField(4);
        p.add((Component)this.portField, gbc);
        ++gbc.gridy;
        gbc.insets.top = 6;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 100.0;
        gbc.insets.left = 0;
        this.messageField = new MultilineLabel();
        this.messageField.setForeground(new Color(192, 0, 0));
        p.add((Component)this.messageField, gbc);
        this.methodPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxyPrefsPanel.this.doMethodPopup();
            }
        });
        this.serverField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProxyPrefsPanel.this.doServerField();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProxyPrefsPanel.this.doServerField();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProxyPrefsPanel.this.doServerField();
            }
        });
        this.portField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProxyPrefsPanel.this.doPortField();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProxyPrefsPanel.this.doPortField();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProxyPrefsPanel.this.doPortField();
            }
        });
        ((AbstractDocument)this.portField.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
                String txt = this.filter(text);
                if (txt != null && txt.length() > 0) {
                    fb.insertString(offset, txt, attr);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                String txt = this.filter(text);
                if (txt != null && txt.length() > 0) {
                    fb.replace(offset, length, txt, attrs);
                }
            }

            private String filter(String text) {
                if (text == null) {
                    return null;
                }
                StringBuffer b = new StringBuffer();
                for (int i = 0; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if (!Character.isDigit(ch)) continue;
                    b.append(ch);
                }
                return b.toString();
            }
        });
    }

    protected synchronized void populate(Preferences preferences) {
        String pName;
        String hName;
        URLString current = null;
        String url = preferences.getSetting(PREF_PROXY);
        if (url != null) {
            try {
                current = new URLString(url);
            }
            catch (MalformedURLException ex) {
                url = null;
            }
        }
        this.messageField.setText(null);
        this.valid = true;
        if (current == null) {
            this.methodPopup.setSelectedIndex(0);
            String proto = "inherit";
            hName = "proxy";
            pName = String.valueOf(8080);
        } else {
            String proto = current.getProtocol();
            hName = current.getHost();
            if (hName == null) {
                hName = "";
            }
            pName = current.getPort() > 0 ? Integer.toString(current.getPort()) : "";
            int idx = 1;
            if (proto.equals("socks")) {
                idx = 2;
            } else if (proto.equals("https") && EndpointCaller.isTunnelMethodAvailable((String)"https")) {
                idx = 3;
            } else if (proto.equals("http") && EndpointCaller.isTunnelMethodAvailable((String)"http")) {
                String opts = current.getName();
                idx = 4;
                if (opts != null) {
                    StringTokenizer parser = new StringTokenizer(opts, ",");
                    int adjust = 0;
                    while (parser.hasMoreTokens()) {
                        String option = parser.nextToken();
                        if (option.equalsIgnoreCase("duplex=half")) {
                            adjust |= 1;
                            continue;
                        }
                        if (!option.equalsIgnoreCase("route=direct")) continue;
                        adjust |= 2;
                    }
                    idx += adjust;
                }
            } else {
                idx = 1;
            }
            this.methodPopup.setSelectedIndex(idx);
        }
        this.serverField.setText(hName);
        this.portField.setText(pName);
        String method = (String)this.methodPopup.getSelectedItem();
        this.currentParams = this.paramMap.get(method);
        if (method.equals(this.useInherit)) {
            this.currentParams.apply();
        }
        this.enableFields();
        this.checkSettings();
    }

    protected void apply(Preferences preferences) throws InvalidPreferenceSettingException {
        URLString current;
        if (!this.valid) {
            throw new InvalidPreferenceSettingException((AbstractPreferencesPanel)this);
        }
        String host = "none";
        int port = -1;
        String selected = (String)this.methodPopup.getSelectedItem();
        String options = null;
        boolean directOption = false;
        if (selected.equals(this.useInherit)) {
            current = null;
        } else {
            String proto = null;
            if (selected.equals(this.overrideDirect)) {
                proto = "direct";
                host = "none";
                port = 1;
            } else if (selected.equals(this.overrideHTTPS)) {
                proto = "https";
            } else if (selected.equals(this.overrideHTTP)) {
                proto = "http";
            } else if (selected.equals(this.overrideHalfHTTP)) {
                proto = "http";
                options = "duplex=half";
            } else if (selected.equals(this.overrideDirectHTTP)) {
                proto = "http";
                host = "none";
                port = 1;
                directOption = true;
                options = "route=direct";
            } else if (selected.equals(this.overrideDirectHalfHTTP)) {
                proto = "http";
                host = "none";
                port = 1;
                directOption = true;
                options = "duplex=half,route=direct";
            } else if (selected.equals(this.overrideSOCKS)) {
                proto = "socks";
            }
            if (proto != "direct" && !directOption) {
                try {
                    port = Integer.parseInt(this.portField.getText());
                }
                catch (NumberFormatException ex) {
                    return;
                }
                if (port < 1 || port > 65535) {
                    return;
                }
                host = this.serverField.getText();
                if (host == null || host.equals("")) {
                    return;
                }
            }
            current = new URLString(proto, host, port, options);
        }
        if (current == null) {
            preferences.clearSetting(PREF_PROXY);
            ProxyUtils.applyProxy(null);
        } else {
            preferences.setSetting(PREF_PROXY, current.toString());
            ProxyUtils.applyProxy(current);
        }
    }

    protected void reset(Preferences preferences) {
        preferences.clearSetting(PREF_PROXY);
        ProxyUtils.applyProxy(null);
    }

    private void doMethodPopup() {
        this.setModified(true);
        this.enableFields();
        this.checkSettings();
        String method = (String)this.methodPopup.getSelectedItem();
        if (this.currentParams != null) {
            this.currentParams.update();
        }
        this.currentParams = this.paramMap.get(method);
        if (this.currentParams != null) {
            this.currentParams.apply();
        }
    }

    private void doServerField() {
        this.setModified(true);
        this.checkSettings();
    }

    private void doPortField() {
        this.setModified(true);
        this.checkSettings();
    }

    private void enableFields() {
        String which = (String)this.methodPopup.getSelectedItem();
        boolean enabled = !which.equals(this.useInherit) && !which.equals(this.overrideDirect) && !which.equals(this.overrideDirectHTTP) && !which.equals(this.overrideDirectHalfHTTP);
        this.serverLabel.setEnabled(enabled);
        this.serverField.setEnabled(enabled);
        this.portLabel.setEnabled(enabled);
        this.portField.setEnabled(enabled);
    }

    private void checkSettings() {
        String serverErr = null;
        String portErr = null;
        String which = (String)this.methodPopup.getSelectedItem();
        if (!(which.equals(this.useInherit) || which.equals(this.overrideDirect) || which.equals(this.overrideDirectHTTP) || which.equals(this.overrideDirectHalfHTTP))) {
            String host = this.serverField.getText();
            if (host == null || host.trim().length() == 0) {
                serverErr = i18n.getString((PropertiesEnum)StringsProperties.PROXYSETTINGS_SERVERBLANKERROR);
            } else {
                host = host.trim();
                for (int i = 0; i < host.length(); ++i) {
                    char c = host.charAt(i);
                    if (Character.isLetterOrDigit(c) || c == '.' || c == '-') continue;
                    serverErr = i18n.getString((PropertiesEnum)StringsProperties.PROXYSETTINGS_SERVERINVALIDERROR, new Object[]{host.substring(i, i + 1)});
                    break;
                }
            }
            try {
                String portStr = this.portField.getText();
                if (portStr == null || portStr.trim().length() == 0) {
                    portErr = i18n.getString((PropertiesEnum)StringsProperties.PROXYSETTINGS_PORTBLANKERROR);
                } else {
                    int port = Integer.parseInt(portStr);
                    if (port < 1 || port > 65535) {
                        portErr = i18n.getString((PropertiesEnum)StringsProperties.PROXYSETTINGS_PORTRANGEERROR);
                    }
                }
            }
            catch (NumberFormatException nfx) {
                portErr = i18n.getString((PropertiesEnum)StringsProperties.PROXYSETTINGS_PORTRANGEERROR);
            }
        }
        if (serverErr != null || portErr != null) {
            this.valid = false;
            StringBuffer b = new StringBuffer();
            if (serverErr != null) {
                b.append(serverErr);
            }
            if (portErr != null) {
                if (b.length() != 0) {
                    b.append(' ');
                }
                b.append(portErr);
            }
            this.messageField.setText(b.toString());
        } else {
            this.valid = true;
            this.messageField.setText(null);
        }
    }

    class ProxyParams {
        private String host;
        private int port;

        public ProxyParams(String method) {
            if (method == null) {
                this.host = "proxy";
                this.port = 8080;
            } else if (method == "inherit") {
                this.host = ProxyUtils.getDefaultProxyHost();
                this.port = ProxyUtils.getDefaultProxyPort();
            } else {
                this.host = ProxyUtils.getDefaultHostForProxyType((String)method);
                this.port = ProxyUtils.getDefaultPortForProxyType((String)method);
            }
            if (this.host == null) {
                this.host = "proxy";
                this.port = 8080;
            }
        }

        public void update() {
            this.host = ProxyPrefsPanel.this.serverField.getText();
            try {
                this.port = Integer.parseInt(ProxyPrefsPanel.this.portField.getText());
            }
            catch (Throwable t) {
                this.port = 8080;
            }
        }

        public void apply() {
            boolean mod = ProxyPrefsPanel.this.isModified();
            ProxyPrefsPanel.this.serverField.setText(this.host);
            ProxyPrefsPanel.this.portField.setText(Integer.toString(this.port));
            ProxyPrefsPanel.this.setModified(mod);
        }
    }
}

