/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.online.module;

import com.elluminate.gui.component.MediaBorder;
import com.elluminate.jinx.client.OnlineClient;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;

public class ConnectionMonitor
extends JPanel {
    public static final int WIDTH = 59;
    public static final int HEIGHT = 16;
    private static final long TIMEOUT = 45000L;
    public static final long GREEN = 22500L;
    public static final long YELLOW = 33750L;
    public static final long RED = 42750L;
    public static final int UPDATE_INTERVAL = 2000;
    private static final float[] SIN = new float[]{0.0f, 0.3827f, 0.7071f, 0.9239f, 1.0f, 0.9239f, 0.7071f, 0.3827f, 0.0f, -0.3827f, -0.7071f, -0.9239f, -1.0f, -0.9239f, -0.7071f, -0.3829f};
    private static final Color backColor = Color.black;
    private static final Color unlitColor = new Color(32, 32, 32);
    private static final Color greenColor = new Color(40, 169, 64);
    private static final Color yellowColor = new Color(255, 205, 0);
    private static final Color redColor = new Color(255, 40, 0);
    private OnlineClient client = null;
    private Timer timer = null;
    private Image image;
    private AbstractAction action;
    private int stripe = 0;
    private int[] sin = null;

    public ConnectionMonitor(OnlineClient client) {
        this.client = client;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"ConnectionMonitor", (Throwable)e, (boolean)true);
        }
    }

    private void jbInit() throws Exception {
        this.setBorder((Border)new MediaBorder());
        this.setMaximumSize(new Dimension(59, 16));
        this.setMinimumSize(new Dimension(59, 16));
        this.setPreferredSize(new Dimension(59, 16));
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        super.paintComponent(g);
        if (this.image == null) {
            this.sizeCheck();
        }
        Insets ins = this.getInsets();
        g.drawImage(this.image, ins.left, ins.top, null);
    }

    public void start() {
        if (this.timer != null) {
            return;
        }
        this.action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color;
                ConnectionMonitor.this.sizeCheck();
                if (ConnectionMonitor.this.image == null) {
                    return;
                }
                Graphics g = ConnectionMonitor.this.image.getGraphics();
                int w = ConnectionMonitor.this.image.getWidth(null);
                int h = ConnectionMonitor.this.image.getHeight(null);
                long delta = ConnectionMonitor.this.client.getLastMessageInterval();
                if (h < 1 || w < 4) {
                    return;
                }
                g.copyArea(3, 0, w - 3, h, -3, 0);
                g.setColor(backColor);
                g.drawLine(0, 0, 0, h - 1);
                if (!ConnectionMonitor.this.client.isConnected()) {
                    color = unlitColor;
                } else if (delta < 22500L) {
                    color = greenColor;
                } else if (delta < 33750L) {
                    double variation = ((double)delta - 22500.0) / 11250.0;
                    color = ConnectionMonitor.this.getIntermediateColor(greenColor, yellowColor, variation);
                } else if (delta < 42750L) {
                    double variation = ((double)delta - 33750.0) / 9000.0;
                    color = ConnectionMonitor.this.getIntermediateColor(yellowColor, redColor, variation);
                } else {
                    color = redColor;
                }
                int stripe1 = ConnectionMonitor.this.getStripe();
                int stripe2 = ConnectionMonitor.this.getStripe();
                g.setColor(color);
                g.drawLine(w - 3, 1, w - 3, h - 2);
                g.setColor(unlitColor);
                g.fillRect(w - 3, stripe1, 1, 1);
                g.setColor(color);
                g.drawLine(w - 2, 1, w - 2, h - 2);
                g.setColor(unlitColor);
                g.fillRect(w - 2, stripe2, 1, 1);
                g.setColor(backColor);
                g.drawLine(w - 1, 1, w - 1, h - 2);
                g.dispose();
                ConnectionMonitor.this.repaint();
            }
        };
        this.timer = new Timer(2000, this.action);
        this.timer.start();
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public void sizeCheck() {
        Border b = this.getBorder();
        int oldW = 0;
        int oldH = 0;
        int h = this.getHeight();
        int w = this.getWidth();
        if (this.image != null) {
            oldW = this.image.getWidth(null);
            oldH = this.image.getHeight(null);
        }
        if (b != null) {
            Insets insets = this.getBorder().getBorderInsets(this);
            h -= insets.top + insets.bottom;
            w -= insets.left + insets.right;
        }
        if (this.sin == null) {
            this.computeStripe(h);
        }
        if (h == oldH && w == oldW) {
            return;
        }
        if (h < 1 || w < 1) {
            return;
        }
        Image newImage = this.createImage(w, h);
        if (newImage == null) {
            return;
        }
        Graphics g = newImage.getGraphics();
        g.setColor(backColor);
        g.fillRect(0, 0, w, h);
        g.dispose();
        this.image = newImage;
        this.computeStripe(h);
    }

    private void computeStripe(int h) {
        float range = (float)((h & 1) != 0 ? h - 6 : h - 7) / 2.0f;
        float offset = (float)h / 2.0f;
        if (this.sin == null) {
            this.sin = new int[SIN.length];
        }
        for (int i = 0; i < SIN.length; ++i) {
            float dist = SIN[i] * range;
            this.sin[i] = (int)(dist + offset);
        }
    }

    private int getStripe() {
        int s = this.sin[this.stripe++];
        if (this.stripe >= this.sin.length) {
            this.stripe = 0;
        }
        return s;
    }

    private Color getIntermediateColor(Color color1, Color color2, double variation) {
        int r1 = color1.getRed();
        int r2 = color2.getRed();
        int r = r1 + (int)((double)(r2 - r1) * variation);
        int g1 = color1.getGreen();
        int g2 = color2.getGreen();
        int g = g1 + (int)((double)(g2 - g1) * variation);
        int b1 = color1.getBlue();
        int b2 = color2.getBlue();
        int b = b1 + (int)((double)(b2 - b1) * variation);
        return new Color(r, g, b);
    }
}

