/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.online.module;

import com.elluminate.groupware.online.OnlineDebug;
import com.elluminate.groupware.online.module.CallerStatus;
import com.elluminate.groupware.online.module.StringsProperties;
import com.elluminate.gui.component.CDisclosureButton;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ConnectionEvent;
import com.elluminate.jinx.ConnectionListener;
import com.elluminate.jinx.JinxConnectionException;
import com.elluminate.jinx.client.CallStatusEvent;
import com.elluminate.jinx.client.CallStatusListener;
import com.elluminate.jinx.client.Caller;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.net.URLString;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class CallStatus
extends EasyDialog
implements ActionListener,
ConnectionListener,
CallStatusListener {
    I18n i18n = I18n.create((Object)this);
    Frame owner = null;
    JPanel content = new JPanel();
    BorderLayout contentLayout = new BorderLayout();
    JPanel callPanel = new JPanel();
    GridLayout callLayout = new GridLayout();
    LinkedList callers = new LinkedList();
    JPanel messagePanel = new JPanel();
    JProgressBar progressBar = new JProgressBar();
    Client client = null;
    JLabel connectLabel = new JLabel();
    JLabel sslLabel = new JLabel();
    JLabel authLabel = new JLabel();
    CDisclosureButton detailsButton = new CDisclosureButton();
    JButton hideButton = new JButton();
    ImageIcon activeIcon = this.i18n.getIcon("CallStatus.activeIcon");
    ImageIcon okIcon = this.i18n.getIcon("CallStatus.okIcon");
    ImageIcon failIcon = this.i18n.getIcon("CallStatus.failIcon");
    int state = 0;
    URLString url = null;

    public CallStatus() {
        this(null, "");
    }

    public CallStatus(Frame owner, String title) {
        super((Component)owner, title);
        this.owner = owner;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"CallStatus", (Throwable)ex, (boolean)true);
        }
    }

    private void jbInit() throws Exception {
        this.contentLayout.setVgap(6);
        this.content.setLayout(this.contentLayout);
        this.callPanel.setLayout(this.callLayout);
        this.progressBar.setIndeterminate(true);
        this.connectLabel.setText(this.i18n.getString((PropertiesEnum)StringsProperties.CALLSTATUS_CONNECT));
        this.authLabel.setText(this.i18n.getString((PropertiesEnum)StringsProperties.CALLSTATUS_AUTHENTICATE));
        this.sslLabel.setText(this.i18n.getString((PropertiesEnum)StringsProperties.CALLSTATUS_SECURE));
        this.hideButton.setText(this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_HIDE));
        this.detailsButton.setText(this.i18n.getString((PropertiesEnum)StringsProperties.ONLINEMODULE_DETAILS));
        this.callLayout.setVgap(6);
        this.callLayout.setColumns(1);
        this.callLayout.setRows(0);
        this.messagePanel.setLayout(new BorderLayout(0, 6));
        JPanel actionsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 100.0;
        gbc.gridx = 0;
        actionsPanel.add((Component)this.connectLabel, gbc);
        gbc.insets.top = 6;
        JPanel p = new JPanel(new BorderLayout());
        p.setPreferredSize(this.authLabel.getPreferredSize());
        p.add((Component)this.authLabel, "Center");
        actionsPanel.add((Component)p, gbc);
        p = new JPanel(new BorderLayout());
        p.setPreferredSize(this.sslLabel.getPreferredSize());
        p.add((Component)this.sslLabel, "Center");
        actionsPanel.add((Component)p, gbc);
        this.messagePanel.add((Component)actionsPanel, "North");
        this.messagePanel.add((Component)this.progressBar, "South");
        this.detailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CallStatus.this.doDetails();
            }
        });
        this.hideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CallStatus.this.doClose();
            }
        });
        JPanel centerPanel = new JPanel(new FlowLayout(0, 0, 0));
        centerPanel.add((Component)this.detailsButton, "South");
        this.content.add((Component)this.messagePanel, "North");
        this.content.add((Component)centerPanel, "Center");
        this.content.add((Component)this.callPanel, "South");
        this.setContent(this.content);
        this.addCancelButton(this.hideButton);
        this.setInitialFocus(this.hideButton);
    }

    public void addCaller(Caller caller) {
        CallerStatus cStat = new CallerStatus(caller);
        this.callers.add(cStat);
        this.callPanel.add(cStat);
    }

    public void setClient(Client theClient) {
        if (this.client != null) {
            this.client.removeConnectionListener((ConnectionListener)this);
        }
        this.client = theClient;
        if (this.client != null) {
            this.client.addConnectionListener((ConnectionListener)this);
        }
    }

    public void setURL(URLString url) {
        if (this.url != null) {
            throw new IllegalStateException("Only one url per connection.");
        }
        this.url = url;
    }

    public void show() {
        long start = System.currentTimeMillis();
        Timer timer = new Timer(250, this);
        for (CallerStatus cStat : this.callers) {
            cStat.setStart(start);
        }
        timer.start();
        super.show();
        timer.stop();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (CallerStatus cStat : this.callers) {
            cStat.tick();
        }
    }

    private void doDetails() {
        int width = this.getSize().width;
        this.callPanel.setVisible(this.detailsButton.isSelected());
        this.setSize(width, this.getPreferredSize().height);
        this.validate();
    }

    public void doClose() {
        if (this.client != null) {
            this.client.removeConnectionListener((ConnectionListener)this);
            this.client = null;
        }
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                CallStatus.this.setVisible(false);
                CallStatus.this.dispose();
            }
        });
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.doClose();
        }
    }

    public static CallStatus showStatus(Frame parent, String title, URLString url, Caller[] callers, Client client) {
        final CallStatus status = new CallStatus(parent, title);
        status.setURL(url);
        status.setClient(client);
        for (int i = 0; i < callers.length; ++i) {
            status.addCaller(callers[i]);
        }
        status.pack();
        status.setLocationRelativeTo(parent);
        int width = status.getSize().width;
        status.callPanel.setVisible(false);
        status.setSize(width, status.getPreferredSize().height);
        status.authLabel.setVisible(false);
        status.sslLabel.setVisible(false);
        WorkerThread t = new WorkerThread("Call Status Thread"){

            public void run() {
                status.show();
            }
        };
        t.start();
        return status;
    }

    public void callStatusChanged(final CallStatusEvent event) {
        if (OnlineDebug.ONLINE.show()) {
            switch (event.getStatus()) {
                case 1: {
                    System.out.println("Status of the jinx Call : Calling");
                    break;
                }
                case 2: {
                    System.out.println("Status of the jinx Call : Connected");
                    break;
                }
                case 3: {
                    System.out.println("Status of the jinx Call : Securing");
                    break;
                }
                case 4: {
                    System.out.println("Status of the jinx Call : Secured");
                    break;
                }
                case 5: {
                    System.out.println("Status of the jinx Call : Authenticating");
                    break;
                }
                case 6: {
                    System.out.println("Status of the jinx Call : Authenticated");
                    break;
                }
                case -1: {
                    System.out.println("Status of the jinx Call : Failed");
                }
            }
        }
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                block0 : switch (event.getStatus()) {
                    case 1: {
                        CallStatus.this.connectLabel.setIcon(CallStatus.this.activeIcon);
                        CallStatus.this.connectLabel.setVisible(true);
                        break;
                    }
                    case 2: {
                        CallStatus.this.connectLabel.setIcon(CallStatus.this.okIcon);
                        break;
                    }
                    case 3: {
                        CallStatus.this.sslLabel.setIcon(CallStatus.this.activeIcon);
                        CallStatus.this.sslLabel.setVisible(true);
                        break;
                    }
                    case 4: {
                        CallStatus.this.sslLabel.setIcon(CallStatus.this.okIcon);
                        break;
                    }
                    case 5: {
                        CallStatus.this.authLabel.setIcon(CallStatus.this.activeIcon);
                        CallStatus.this.authLabel.setVisible(true);
                        break;
                    }
                    case 6: {
                        CallStatus.this.authLabel.setIcon(CallStatus.this.okIcon);
                        break;
                    }
                    case -1: {
                        switch (CallStatus.this.state) {
                            case 1: {
                                CallStatus.this.connectLabel.setIcon(CallStatus.this.failIcon);
                                break block0;
                            }
                            case 3: {
                                CallStatus.this.sslLabel.setIcon(CallStatus.this.failIcon);
                                break block0;
                            }
                            case 5: {
                                CallStatus.this.authLabel.setIcon(CallStatus.this.failIcon);
                            }
                        }
                    }
                }
                CallStatus.this.state = event.getStatus();
            }
        });
    }

    public void connectionStatusChanged(ConnectionEvent event) throws JinxConnectionException {
        this.doClose();
        if (OnlineDebug.ONLINE.show()) {
            for (int i = 0; i < this.callers.size(); ++i) {
                Caller caller = ((CallerStatus)this.callers.get((int)i)).theCaller;
                if (caller.getEndpoint() == null) continue;
                System.out.println("The client is connected( " + caller.getTarget() + ")");
            }
        }
    }
}

