/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.recorder.module;

import com.elluminate.classroom.client.messaging.MessagePublisher;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageRouter;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.groupware.recorder.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

@Singleton
public class RecorderPublisher {
    private final String UNIQUE_NAME = "RecorderPublisher";
    private final String DISPLAY_NAME;
    private final Icon icon;
    public static final String RECORDER_STARTED = "recorder-started";
    public static final String RECORDER_PAUSED = "recorder-paused";
    private final MessagePublisher publisher;
    private final MessagePublisherMetadata metadata;
    private final I18n i18n;
    private final MessageRouter router;
    private String modName;
    private String modDisplayName;
    private Map<String, MessageType> msgTypes = new HashMap<String, MessageType>();

    @Inject
    public RecorderPublisher(MessagePublisher pub, MessagePublisherMetadata meta, MessageRouter rtr, I18n localization, ModulePublisherInfo mod) {
        this.publisher = pub;
        this.metadata = meta;
        this.router = rtr;
        this.i18n = localization;
        this.DISPLAY_NAME = this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERPUBLISHER_DISPLAYNAME);
        this.icon = mod.getModuleIcon();
        this.modName = mod.getNameOfModule();
        this.modDisplayName = mod.getDisplayNameOfModule();
        this.initializePublisher();
    }

    public void sendRecorderStatusMessage(boolean isEnabled) {
        if (isEnabled) {
            this.sendRecorderStartedMessage(this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_RECORDING_STARTED_MESSAGE), false);
        } else {
            this.sendRecorderPausedMessage(this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_RECORDING_PAUSED_MESSAGE), false);
        }
    }

    private void sendRecorderStartedMessage(String message, boolean isMe) {
        this.sendRouterMsg(message, this.msgTypes.get(RECORDER_STARTED), isMe);
    }

    private void sendRecorderPausedMessage(String message, boolean isMe) {
        this.sendRouterMsg(message, this.msgTypes.get(RECORDER_PAUSED), isMe);
    }

    private void sendRouterMsg(String message, MessageType type, boolean isMe) {
        this.publisher.sendTextMessage(message, type, isMe);
    }

    private void initializePublisher() {
        this.initMessageTypes();
        this.setMetadata();
        this.publisher.setPublisherMetadata(this.metadata);
        this.router.registerPublisher(this.publisher);
    }

    private void setMetadata() {
        this.metadata.setPublisherDisplayName(this.DISPLAY_NAME);
        this.metadata.setPublisherUniqueName("RecorderPublisher");
        this.metadata.setPublisherIcon(this.icon);
        this.metadata.setModuleName(this.modName);
        this.metadata.setModuleDisplayName(this.modDisplayName);
        this.metadata.setPublisherSupportedMessageTypes(new ArrayList<MessageType>(this.msgTypes.values()));
    }

    private void initMessageTypes() {
        this.msgTypes.put(RECORDER_STARTED, new MessageType(RECORDER_STARTED, this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERPUBLISHER_TYPE_STARTED), 5));
        this.msgTypes.put(RECORDER_PAUSED, new MessageType(RECORDER_PAUSED, this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERPUBLISHER_TYPE_PAUSED), 5));
    }
}

