/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.recorder.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.StringFeature;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.recorder.module.AddRecordingIndexEntryCmd;
import com.elluminate.groupware.recorder.module.PauseRecordingCmd;
import com.elluminate.groupware.recorder.module.RecReminderPrefsPanel;
import com.elluminate.groupware.recorder.module.RecorderBean;
import com.elluminate.groupware.recorder.module.StartRecordingCmd;
import com.elluminate.groupware.recorder.module.StringsProperties;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientGroupEvent;
import com.elluminate.jinx.ClientGroupListener;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

@Singleton
public class RecorderModule
extends AbstractClientModule
implements ModulePublisherInfo,
PropertyChangeListener,
PreferencesPanelOwner {
    private static final String MODULE_NAME = "Recorder";
    static final String PREF_SHOW_RECORD_REMINDER = ".showRecordReminder";
    static final boolean DEFAULT_SHOW_RECORD_REMINDER = true;
    private RecorderBean rBean = null;
    private Client client = null;
    private ClientList clients = null;
    private ClientGroupListener groupListener;
    private Provider<RecorderBean> beanProvider;
    private Provider<StartRecordingCmd> startCmdProvider;
    private Provider<PauseRecordingCmd> pauseCmdProvider;
    private Provider<AddRecordingIndexEntryCmd> indexCmdProvider;
    private Preferences preferences;
    private ClientProvider clientProvider;
    private ConferencingEngine confEngine;
    private Provider<RecReminderPrefsPanel> prefsProvider;
    private I18n i18n;
    private String prefix = this.getClass().getName();
    private String prefName = this.prefix + ".showRecordReminder";
    private ActionFeature indexFeature;
    private BooleanFeature startFeature;
    private StringFeature statusFeature;
    private ActionFeature clearFeature;
    private ComponentFeature prefsFeature;
    private FeatureBroker broker;
    private boolean updating = false;
    private ChairProtocol chairProtocol;
    private PropertyChangeListener prefsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            RecorderModule.this.preferenceChange(e);
        }
    };

    @Inject
    public RecorderModule() {
        this.groupListener = new ClientGroupListener(){

            public void clientGroupChanged(ClientGroupEvent e) {
                RecorderModule.this.updateFeatures();
            }

            public void clientGroupCreated(ClientGroupEvent e) {
            }

            public void clientGroupDeleted(ClientGroupEvent e) {
            }

            public void clientGroupRenamed(ClientGroupEvent e) {
            }
        };
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initComponentRegistrar(ComponentRegistrar registrar) {
        registrar.registerComponent((Object)this);
    }

    @Inject
    public void initRecorderBeanProvider(Provider<RecorderBean> bp) {
        this.beanProvider = bp;
    }

    @Inject
    public void initStartCmdProvider(Provider<StartRecordingCmd> cp) {
        this.startCmdProvider = cp;
    }

    @Inject
    public void initPauseCmdProvider(Provider<PauseRecordingCmd> cp) {
        this.pauseCmdProvider = cp;
    }

    @Inject
    public void initIndexCmdProvider(Provider<AddRecordingIndexEntryCmd> cp) {
        this.indexCmdProvider = cp;
    }

    @Inject
    public void initPreferences(Preferences prefs) {
        this.preferences = prefs;
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    public void initConferencingEngine(ConferencingEngine ce) {
        this.confEngine = ce;
    }

    @Inject
    public void initPrefsPanel(Provider<RecReminderPrefsPanel> prefsProv) {
        this.prefsProvider = prefsProv;
    }

    @Inject
    public void initI18n(I18n i18n) {
        this.i18n = i18n;
    }

    @Inject
    public void initChairProtocol(ChairProtocol cp) {
        this.chairProtocol = cp;
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getDisplayNameOfModule() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERMODULE_PREFTITLE);
    }

    public Icon getModuleIcon() {
        return this.i18n.getIcon("RecorderModule.moduleIcon");
    }

    protected RecorderBean getRecorderBean() {
        return this.rBean;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("recorder.forced")) {
            this.updateFeatures();
        } else if (e.getPropertyName().equals("chair")) {
            this.updateFeatures();
        }
    }

    private void preferenceChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals(this.prefName)) {
            boolean showRecordReminderPreference = Preferences.booleanValue((Object)e.getNewValue(), (boolean)true);
            if (this.rBean != null) {
                this.rBean.setRecordReminderPreference(showRecordReminderPreference);
            }
        }
    }

    protected void reminderCheckBoxChanged(boolean reminderCheckboxStatus) {
        this.preferences.setSetting(this.prefName, reminderCheckboxStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFeatures() {
        if (this.rBean != null) {
            boolean isChair = this.chairProtocol.fetchChair(this.clients).isMe();
            boolean isForced = this.rBean.isForced();
            boolean isRecording = this.rBean.isRecording();
            boolean isInMainRoom = this.clients.getMyGroupID() == 0;
            RecorderModule recorderModule = this;
            synchronized (recorderModule) {
                if (this.updating) {
                    return;
                }
                this.updating = true;
            }
            this.indexFeature.setEnabled(isChair && isRecording);
            this.startFeature.setEnabled(isChair && !isForced && isInMainRoom);
            this.clearFeature.setEnabled(isChair);
            this.startFeature.setValue((Object)isRecording);
            this.startFeature.setDescription(isRecording ? this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_RECORDONTIP) : this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_RECORDOFFTIP));
            this.broker.setFeaturePublished((Feature)this.startFeature, isChair);
            this.broker.setFeaturePublished((Feature)this.statusFeature, !isChair && isRecording);
            this.broker.setFeaturePublished((Feature)this.clearFeature, isChair);
            this.broker.setFeaturePublished((Feature)this.indexFeature, isChair);
            recorderModule = this;
            synchronized (recorderModule) {
                this.updating = false;
            }
        }
    }

    private boolean createFeatures() {
        if (this.indexFeature != null) {
            return false;
        }
        this.indexFeature = this.broker.createActionFeature((Object)this, "/recorder/index", this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_ADDINDEXMENUITEM), this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_ADDINDEXMENUITEM));
        this.indexFeature.setInteractive(true);
        this.indexFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (RecorderModule.this.chairProtocol.fetchChair(RecorderModule.this.clients).isMe() && !RecorderModule.this.updating) {
                    RecorderModule.this.rBean.addCustomIndexEntry();
                }
            }
        });
        this.startFeature = this.broker.createBooleanFeature((Object)this, "/recorder/start", true, false, this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_RECORD), this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_RECORDOFFTIP));
        this.startFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_RECORDING));
        this.startFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                if (RecorderModule.this.chairProtocol.fetchChair(RecorderModule.this.clients).isMe() && !RecorderModule.this.updating) {
                    RecorderModule.this.rBean.setEnabledRecorder((Boolean)RecorderModule.this.startFeature.getValue(), true);
                    RecorderModule.this.updateFeatures();
                }
            }
        });
        this.startFeature.setTrueIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.RECORDERBEAN_RECORDICON));
        this.statusFeature = this.broker.createStringFeature((Object)this, "/recorder/status", false, this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_RECORDING), null, null);
        this.statusFeature.setIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.RECORDERBEAN_RECORDICON));
        this.statusFeature.setEnabled(true);
        this.clearFeature = this.broker.createActionFeature((Object)this, "/recorder/clear", this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_CLEARMENU), this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERBEAN_CLEARMENU));
        this.clearFeature.setInteractive(true);
        this.clearFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (RecorderModule.this.chairProtocol.fetchChair(RecorderModule.this.clients).isMe() && !RecorderModule.this.updating) {
                    RecorderModule.this.rBean.clearRecording();
                    RecorderModule.this.updateFeatures();
                }
            }
        });
        this.clearFeature.setEnabled(true);
        this.prefsFeature = this.broker.createComponentFeature((Object)this, "/recorder/prefs", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return (Component)RecorderModule.this.prefsProvider.get();
            }
        }, this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERMODULE_PREFTITLE), this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERMODULE_PREFTITLE));
        this.prefsFeature.setEnabled(true);
        return true;
    }

    public void start() {
        this.preferences.addSettingChangeListener(this.prefName, this.prefsListener);
        this.confEngine.registerCommand(this.startCmdProvider);
        this.confEngine.registerCommand(this.pauseCmdProvider);
        this.confEngine.registerCommand(this.indexCmdProvider);
    }

    public void attach() {
        this.rBean = (RecorderBean)this.beanProvider.get();
        boolean showRecordReminderPreference = this.preferences.getBooleanSetting(this.prefName, true);
        this.rBean.setRecordReminderPreference(showRecordReminderPreference);
        this.client = this.clientProvider.get();
        this.client.addClientGroupListener(this.groupListener);
        this.clients = this.client.getClientList();
        this.clients.addPropertyChangeListener("recorder.forced", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
    }

    public void setupUI() {
        this.createFeatures();
        this.broker.addFeature((Feature)this.prefsFeature);
    }

    public void cleanupUI() {
        this.broker.removeFeature((Feature)this.prefsFeature);
    }

    public void detach() {
        if (this.client != null && this.rBean != null) {
            this.client.removeClientGroupListener(this.groupListener);
            this.client = null;
            this.clients.removePropertyChangeListener("recorder.forced", (PropertyChangeListener)this);
            this.clients = null;
            this.rBean.dispose();
            this.rBean = null;
        }
    }

    public void stop() {
        this.preferences.removeSettingChangeListener(this.prefName, this.prefsListener);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getTitle() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.RECORDERMODULE_PREFTITLE);
    }

    public Icon getIcon() {
        return this.i18n.getIcon("RecorderModule.moduleIcon");
    }
}

