/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.recorder.module;

import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.recorder.module.StringsProperties;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class RecReminderPrefsPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = 1L;
    private I18n i18n;
    private JCheckBox recordReminderCheckBox;
    private ClientProvider clientProvider;

    @Inject
    public RecReminderPrefsPanel(PreferencesPanelOwner owner, I18n i18n) {
        super(owner, i18n.getString((PropertiesEnum)StringsProperties.REMINDERPREFSPANEL_TITLE));
        this.i18n = i18n;
    }

    @Inject
    public void initClientProvider(ClientProvider prov) {
        this.clientProvider = prov;
    }

    protected void createContent() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new GridBagLayout());
        this.add(p, "North");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weightx = 100.0;
        this.recordReminderCheckBox = new JCheckBox();
        this.recordReminderCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecReminderPrefsPanel.this.setModified(true);
            }
        });
        p.add((Component)this.recordReminderCheckBox, gbc);
    }

    protected void populate(Preferences preferences) {
        ClientList clients = this.clientProvider.get().getClientList();
        String mod = LabelProps.get((PropertyAccessAPI)clients, (String)"Label.moderator");
        this.recordReminderCheckBox.setText(this.i18n.getString((PropertiesEnum)StringsProperties.REMINDERPREFSPANEL_REMINDTORECORD, new Object[]{mod}));
        String prefix = this.getOwnerPrefix();
        String pName = prefix + ".showRecordReminder";
        boolean recordReminderPreference = preferences.getBooleanSetting(pName, true);
        this.recordReminderCheckBox.setSelected(recordReminderPreference);
    }

    protected void apply(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        String pName = prefix + ".showRecordReminder";
        boolean recordReminderPreference = this.recordReminderCheckBox.isSelected();
        preferences.setSetting(pName, recordReminderPreference);
    }

    protected void reset(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        String pName = prefix + ".showRecordReminder";
        boolean recordReminderPreference = true;
        preferences.setSetting(pName, recordReminderPreference);
    }
}

