/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.caption.module.captioner;

import com.elluminate.groupware.caption.module.CaptionBuffer;
import com.elluminate.groupware.caption.module.Captioner;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;

public class DummyCaptioner
implements Captioner,
Runnable {
    private Thread thread = null;
    private CaptionBuffer buffer = null;
    private JTextPane pane = null;
    private StyledDocument doc = null;
    private String txt = "Mary had a little lamb,\nits fleece was white as snow,\nand everywhere that Mary went,\nthe lamb was sure to go.\n";
    private int idx = 0;
    private int rem = this.txt.length();

    @Override
    public String getName() {
        return "Dummy";
    }

    @Override
    public boolean isDefaultCaptioner() {
        return false;
    }

    @Override
    public void setup(Component parent, JTextPane text) {
    }

    @Override
    public void start(JTextPane text, CaptionBuffer buf) {
        this.pane = text;
        this.buffer = buf;
        this.doc = text.getStyledDocument();
        this.thread = new WorkerThread((Runnable)this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void stop(JTextPane text) {
        this.thread.interrupt();
        this.thread = null;
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            int nc = Math.min(this.rem, 4);
            String sub = this.txt.substring(this.idx, this.idx + nc);
            this.buffer.append(sub);
            try {
                this.doc.insertString(this.doc.getLength(), sub, null);
                this.pane.setCaretPosition(this.doc.getLength());
            }
            catch (BadLocationException blx) {
                LogSupport.exception((Object)this, (String)"run", (Throwable)blx, (boolean)true);
            }
            this.idx += nc;
            this.rem -= nc;
            if (this.rem == 0) {
                this.idx = 0;
                this.rem = this.txt.length();
            }
            try {
                Thread.sleep(350L);
            }
            catch (Throwable t) {
                break;
            }
        }
    }
}

