/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.concurrentmap;

import com.hazelcast.core.Member;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.Constants;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.PartitionManager;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.base.DistributedLock;
import com.hazelcast.impl.base.SystemLog;
import com.hazelcast.impl.partition.MigratingPartition;
import com.hazelcast.impl.partition.PartitionInfo;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.Data;
import java.util.HashSet;
import java.util.Set;

public class MapSystemLogFactory {
    public static SystemLog newScheduleRequest(Request request, Record record) {
        int scheduledActionCount = record == null ? 0 : record.getScheduledActionCount();
        DistributedLock lock = record == null ? null : record.getLock();
        return new RequestScheduled(request.name, request.operation, request.caller, lock, scheduledActionCount);
    }

    public static SystemLog newRedoLog(Node node, Request request, Constants.RedoType redoType, boolean isCaller) {
        HashSet<Member> members = new HashSet<Member>(node.getClusterImpl().getMembers());
        Data key = request.key;
        PartitionInfo partitionInfo = null;
        PartitionManager pm = node.concurrentMapManager.getPartitionManager();
        if (key != null) {
            partitionInfo = new PartitionInfo(pm.getPartition(node.concurrentMapManager.getPartitionId(key)));
        }
        Address endpoint = isCaller ? request.target : request.caller;
        boolean connected = false;
        if (endpoint != null && !endpoint.equals(node.getThisAddress())) {
            Connection targetConnection = node.connectionManager.getConnection(endpoint);
            connected = targetConnection != null && targetConnection.live();
        }
        return new RedoLog(request.name, key, request.operation, endpoint, connected, members, partitionInfo, request.redoCount, pm.getMigratingPartition(), redoType, isCaller);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RedoLog
    extends SystemLog {
        final String name;
        final Data key;
        final ClusterOperation operation;
        final Address endpoint;
        final boolean connected;
        final Set<Member> members;
        final PartitionInfo partition;
        final MigratingPartition migratingPartition;
        final int redoCount;
        final Constants.RedoType redoType;
        final boolean caller;

        RedoLog(String name, Data key, ClusterOperation operation, Address endpoint, boolean connected, Set<Member> members, PartitionInfo partition, int redoCount, MigratingPartition migratingPartition, Constants.RedoType redoType, boolean caller) {
            this.name = name;
            this.key = key;
            this.operation = operation;
            this.endpoint = endpoint;
            this.connected = connected;
            this.members = members;
            this.partition = partition;
            this.redoCount = redoCount;
            this.migratingPartition = migratingPartition;
            this.redoType = redoType;
            this.caller = caller;
        }

        private boolean contains(Address address) {
            for (Member member : this.members) {
                MemberImpl m = (MemberImpl)member;
                if (!m.getAddress().equals(address)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("RedoLog{");
            sb.append("name=").append(this.name).append(", ");
            sb.append("redoType=").append((Object)this.redoType).append(", ");
            sb.append("operation=").append((Object)this.operation).append(this.caller ? ", target=" : ", caller=").append(this.endpoint).append(" / connected=").append(this.connected).append(", redoCount=").append(this.redoCount).append(", migrating=").append(this.migratingPartition).append("\n").append("partition=").append(this.partition).append("\n");
            if (this.partition != null) {
                for (int i = 0; i < 7; ++i) {
                    Address replicaAddress = this.partition.getReplicaAddress(i);
                    if (replicaAddress == null || this.contains(replicaAddress)) continue;
                    sb.append(replicaAddress).append(" not a member!\n");
                }
            }
            sb.append("}");
            return sb.toString();
        }
    }

    static class RequestScheduled
    extends SystemLog {
        private final String name;
        private final ClusterOperation operation;
        private final Address caller;
        private final DistributedLock lock;
        private final int size;

        public RequestScheduled(String name, ClusterOperation operation, Address caller, DistributedLock lock, int size) {
            this.name = name;
            this.operation = operation;
            this.caller = caller;
            this.lock = lock;
            this.size = size;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("RequestScheduled[").append(this.size).append(']');
            sb.append(" {name='").append(this.name).append('\'');
            sb.append(", caller=").append(this.caller);
            sb.append(", operation=").append((Object)this.operation);
            sb.append(", lock=").append(this.lock);
            sb.append('}');
            return sb.toString();
        }
    }
}

