/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.net;

import com.elluminate.util.log.LogSupport;
import com.elluminate.util.net.HttpHeaders;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public class HttpResponse
extends HttpHeaders {
    public static final int CT_CONTINUATION = 100;
    public static final int CT_SUCCESS = 200;
    public static final int CT_REDIRECT = 300;
    public static final int CT_ERROR = 400;
    public static final int CT_FATAL = 500;
    public static final int CONTINUE = 100;
    public static final int SWITCHING_PROTOCOLS = 101;
    public static final int OK = 200;
    public static final int CREATED = 201;
    public static final int ACCEPTED = 202;
    public static final int NON_AUTHORITATIVE_INFO = 203;
    public static final int NO_CONTENT = 204;
    public static final int RESET_CONTENT = 205;
    public static final int PARTIAL_CONTENT = 206;
    public static final int MULTIPLE_CHOICES = 300;
    public static final int MOVED_PERMANENTLY = 301;
    public static final int FOUND = 302;
    public static final int SEE_OTHER = 303;
    public static final int NOT_MODIFIED = 304;
    public static final int USE_PROXY = 305;
    public static final int TEMPORARY_REDIRECT = 307;
    public static final int BAD_REQUEST = 400;
    public static final int UNAUTHORIZED = 401;
    public static final int PAYMENT_REQUIRED = 402;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int METHOD_NOT_ALLOWED = 405;
    public static final int NOT_ACCEPTABLE = 406;
    public static final int PROXY_AUTH_REQUIRED = 407;
    public static final int REQUEST_TIMEOUT = 408;
    public static final int CONFLICT = 409;
    public static final int GONE = 410;
    public static final int LENGTH_REQUIRED = 411;
    public static final int PRECONDITION_FAILED = 412;
    public static final int REQUEST_TOO_LARGE = 413;
    public static final int URI_TOO_LONG = 414;
    public static final int UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int RANGE_NOT_SATISFIABLE = 416;
    public static final int EXPECTATION_FAILED = 417;
    public static final int INTERNAL_SERVER_ERROR = 500;
    public static final int NOT_IMPLEMENTED = 501;
    public static final int BAD_GATEWAY = 502;
    public static final int SERVICE_UNAVAILABLE = 503;
    public static final int GATEWAY_TIMEOUT = 504;
    public static final int UNSUPPORTED_VERSION = 505;
    public static final int INVALID = -1;
    protected boolean writable = false;
    protected boolean readable = false;
    protected boolean sent = false;
    protected int code = -1;
    protected String msg = "";
    protected boolean close = true;
    protected int length = 0;
    protected int httpVer = 10;
    protected boolean debug = false;

    public HttpResponse() {
    }

    public HttpResponse(int code, String msg, int length, boolean close, int httpVer, boolean debug) {
        this.init(code, msg, length, close, httpVer, debug);
    }

    public HttpResponse(DataInputStream istr, boolean debug) throws IOException {
        this.init(istr, debug);
    }

    public void init(int code, String msg, int length, boolean close, int httpVer, boolean debug) {
        this.code = code;
        this.msg = msg;
        this.close = close;
        this.length = length;
        this.httpVer = httpVer;
        this.debug = debug;
        switch (httpVer) {
            case 10: {
                if (close) {
                    this.setHeader("Connection", "Close");
                    break;
                }
                this.setHeader("Connection", "Keep-Alive");
                break;
            }
            case 11: {
                if (!close) break;
                this.setHeader("Connection", "Close");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown HTTP version: " + httpVer);
            }
        }
        if (length > 0) {
            this.setHeader("Content-Type", "image/jpeg");
        }
        this.setHeader("Content-Length", Integer.toString(length));
        this.writable = true;
    }

    public void init(DataInputStream istr, boolean debug) throws IOException {
        this.code = -1;
        String line = istr.readLine();
        this.debug = debug;
        if (line == null) {
            throw new EOFException();
        }
        if (this.parseResponseLine(line)) {
            this.parseHeaders(istr, debug);
            this.evaluateHeaders();
        }
    }

    public int getHTTPVersion() {
        return this.httpVer;
    }

    public int getCodeType() {
        return this.code / 100 * 100;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.msg;
    }

    public boolean isDone() {
        return this.close;
    }

    public int getLength() {
        return this.length;
    }

    public void send(DataOutputStream str) throws IOException {
        if (!this.sent && this.writable) {
            byte[] bytes;
            String httpHdr = this.toString();
            if (this.debug) {
                StringTokenizer lines = new StringTokenizer(httpHdr, "\n");
                while (lines.hasMoreTokens()) {
                    String token = lines.nextToken();
                    if (this.context != null) {
                        LogSupport.message(this, this.context, token);
                        continue;
                    }
                    LogSupport.message(this, "send", token);
                }
            }
            try {
                bytes = httpHdr.getBytes("ASCII7");
            }
            catch (UnsupportedEncodingException ex) {
                bytes = httpHdr.getBytes();
            }
            str.write(bytes);
            this.sent = true;
        }
        if (!this.sent) {
            throw new IllegalStateException("Attempt to send a write-protected response.");
        }
        this.readable = false;
        this.writable = false;
    }

    public void trySend(DataOutputStream str) {
        try {
            this.send(str);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void validate() throws IOException {
        if (this.code != 200) {
            throw new IOException("Error response - " + this.toString());
        }
    }

    public String toString() {
        StringBuffer hdr = new StringBuffer();
        if (this.httpVer == 10) {
            hdr.append("HTTP/1.0 ");
        } else {
            hdr.append("HTTP/1.1 ");
        }
        hdr.append(this.code);
        hdr.append(" ");
        hdr.append(this.msg);
        hdr.append("\r\n");
        this.encodeHeaders(hdr);
        hdr.append("\r\n");
        return hdr.toString();
    }

    protected boolean parseResponseLine(String line) {
        if (this.debug) {
            if (this.context != null) {
                LogSupport.message(this, this.context, line);
            } else {
                LogSupport.message(this, "parseResponseLine", line);
            }
        }
        StringTokenizer parser = new StringTokenizer(line, " ");
        this.readable = true;
        if (!parser.hasMoreTokens()) {
            this.code = 400;
            return false;
        }
        String token = parser.nextToken();
        if (token.equalsIgnoreCase("http/1.0")) {
            this.httpVer = 10;
        } else if (token.equalsIgnoreCase("http/1.1")) {
            this.httpVer = 11;
        } else {
            this.code = 505;
            return false;
        }
        if (!parser.hasMoreTokens()) {
            this.code = 400;
            return false;
        }
        token = parser.nextToken();
        try {
            this.code = Integer.parseInt(token);
        }
        catch (NumberFormatException ex) {
            this.code = 400;
            return false;
        }
        if (parser.hasMoreTokens()) {
            this.msg = parser.nextToken("");
        }
        return true;
    }

    protected void evaluateHeaders() {
        this.close = this.httpVer == 10;
        String token = this.getHeader("Proxy-Connection");
        if (token == null) {
            token = this.getHeader("Connection");
        }
        if (token != null) {
            if (token.equalsIgnoreCase("keep-alive")) {
                this.close = false;
            } else if (token.equalsIgnoreCase("close")) {
                this.close = true;
            }
        }
        token = this.getHeader("Content-Length", "0");
        try {
            this.length = Integer.parseInt(token);
        }
        catch (NumberFormatException ex) {
            this.close = true;
            this.code = 400;
        }
    }
}

