/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.net;

import com.elluminate.util.log.LogSupport;
import com.elluminate.util.net.HttpHeaderComparator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.TreeMap;

public class HttpHeaders {
    public static final int HTTP_10 = 10;
    public static final int HTTP_11 = 11;
    protected TreeMap<String, String> headers = new TreeMap(new HttpHeaderComparator());
    protected String context = null;

    public void clear() {
        this.headers.clear();
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public String getHeader(String name, String dft) {
        String value = this.getHeader(name);
        if (value == null) {
            value = dft;
        }
        return value;
    }

    protected void parseHeaders(DataInputStream istr, boolean debug) throws IOException {
        String line;
        String last = null;
        while ((line = istr.readLine()) != null && line.length() != 0) {
            last = this.parseHeaderLine(line, last, debug);
        }
    }

    protected String parseHeaderLine(String line, String last, boolean debug) throws IOException {
        if (debug) {
            if (this.context == null) {
                LogSupport.message(this, "parseHeaderLine", line);
            } else {
                LogSupport.message(this, this.context, line);
            }
        }
        if (line.startsWith(" ") || line.startsWith("\t")) {
            if (last == null) {
                throw new IOException("Invalid contination.");
            }
            String value = this.headers.get(last);
            value = value + " " + line.trim();
            this.headers.put(last, value);
        } else {
            int colon = line.indexOf(58);
            if (colon <= 0) {
                throw new IOException("Invalid request header '" + line + "'");
            }
            String name = line.substring(0, colon).trim();
            String value = line.substring(colon + 1).trim();
            String prev = this.headers.get(name);
            if (prev != null) {
                value = prev + ", " + value;
            }
            this.headers.put(name, value);
            last = name;
        }
        return last;
    }

    protected void writeHeaders(DataOutputStream ostr) throws IOException {
        String hdrs = this.encodeHeaders();
        byte[] bytes = null;
        try {
            bytes = hdrs.getBytes("ASCII7");
        }
        catch (Exception ex) {
            bytes = hdrs.getBytes();
        }
        ostr.write(bytes);
    }

    protected String encodeHeaders() {
        StringBuffer buf = new StringBuffer();
        this.encodeHeaders(buf);
        return buf.toString();
    }

    protected void encodeHeaders(StringBuffer buf) {
        for (String key : this.headers.keySet()) {
            String value = this.headers.get(key);
            buf.append(key);
            buf.append(": ");
            buf.append(value);
            buf.append("\r\n");
        }
    }

    public void setContext(String c) {
        this.context = c;
    }
}

