/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.log;

import com.elluminate.util.log.ExTRASupport;
import com.elluminate.util.log.HistoryBuffer;
import com.elluminate.util.log.LogConstants;
import com.elluminate.util.log.LogEmitter;
import com.elluminate.util.log.Logger;
import com.elluminate.util.log.PrintStreamTap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class LogSupport
implements LogConstants {
    private static final int DFT_HISTORY_LEN = 50;
    private static final HistoryBuffer history = new HistoryBuffer(50);
    private static final PrintStream sysOut = System.out;
    private static final PrintStream sysErr = System.err;
    private static final PrintStreamTap outTap = new PrintStreamTap(sysOut, history);
    private static final PrintStreamTap errTap = new PrintStreamTap(sysErr, history);
    private static byte destination = 1;
    private static File logFile = null;
    private static String fileSuffix = null;
    private static PrintStream logStrm = null;
    private static long maxLogLen = -1L;
    private static volatile Logger instance;
    private static volatile LogEmitter dftEmitter;

    public static void initialize() {
        try {
            ExTRASupport.isExtraConfigured();
        }
        catch (Throwable t) {
            t.printStackTrace(sysErr);
        }
        LogSupport.createInstance();
    }

    static void initialize(Logger iLogger, LogEmitter iEmitter) {
        dftEmitter = iEmitter;
        instance = iLogger;
        LogSupport.initialize();
    }

    public static void terminate() {
        LogSupport.stopInstance();
    }

    public static PrintStream getSystemOut() {
        return sysOut;
    }

    public static PrintStream getSystemErr() {
        return sysErr;
    }

    public static byte getDestination() {
        return destination;
    }

    public static boolean isLoggingToConsole() {
        return (destination & 1) == 1;
    }

    public static synchronized void setLoggingToConsole(boolean b) {
        byte oldDest;
        destination = b ? (byte)(destination | 1) : (byte)(destination & 0xFFFFFFFE);
        if (destination != (oldDest = destination)) {
            outTap.setEchoing(LogSupport.isLoggingToConsole());
            errTap.setEchoing(LogSupport.isLoggingToConsole());
        }
    }

    public static boolean isLoggingToFile() {
        return (destination & 2) == 2 && logStrm != null;
    }

    public static synchronized void setLoggingToFile(boolean b) {
        if (b) {
            destination = (byte)(destination | 2);
        } else {
            destination = (byte)(destination & 0xFFFFFFFD);
            LogSupport.closeLogStream();
        }
    }

    public static synchronized void setDestination(byte dest) {
        destination = dest;
    }

    public static File getLogFile() {
        return logFile;
    }

    public static PrintStream getLogStream() {
        return logStrm;
    }

    public static void setLogFile(File f) throws IOException {
        LogSupport.setLogFile(f, 2000000L);
    }

    public static synchronized void setLogFile(File f, long rollOverLen) throws IOException {
        if (f == logFile) {
            return;
        }
        if (f != null && f.equals(logFile)) {
            return;
        }
        FileOutputStream str = null;
        PrintStream print = null;
        if (f != null) {
            f = f.getCanonicalFile();
            str = new FileOutputStream(f, true);
            print = new PrintStream(str);
        }
        LogSupport.closeLogStream();
        logFile = f;
        maxLogLen = rollOverLen;
        if (f == null) {
            return;
        }
        LogSupport.setLogStream(print);
        String name = f.getName();
        int dot = name.lastIndexOf(46);
        fileSuffix = dot >= 0 ? name.substring(dot + 1) : null;
        destination = (byte)(destination | 2);
    }

    private static void setLogStream(PrintStream strm) {
        LogSupport.closeLogStream();
        logStrm = strm;
        LogSupport.addSystemTap(strm);
    }

    public static synchronized void clearLogFile() {
        LogSupport.closeLogStream();
        logFile = null;
        fileSuffix = null;
        destination = (byte)(destination & 0xFFFFFFFE);
    }

    private static void closeLogStream() {
        if (logStrm != null) {
            LogSupport.removeSystemTap(logStrm);
            logStrm.close();
            logStrm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAndRotate(int msgLen) {
        if (!LogSupport.isLoggingToFile()) {
            return;
        }
        Class<LogSupport> clazz = LogSupport.class;
        synchronized (LogSupport.class) {
            if (maxLogLen > 0L && logFile.length() + (long)msgLen >= maxLogLen) {
                LogSupport.rotateLogs();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void rotateLogs() {
        block6: {
            if (logFile == null) {
                return;
            }
            if (logStrm == null) {
                return;
            }
            LogSupport.closeLogStream();
            LogSupport.rename(logFile, fileSuffix);
            FileOutputStream str = null;
            try {
                str = new FileOutputStream(logFile.getCanonicalPath(), true);
                LogSupport.setLogStream(new PrintStream(str));
            }
            catch (Exception ex) {
                System.err.println("Unable to reopen log file after rotation.\n  " + ex.getMessage());
                LogSupport.closeLogStream();
                maxLogLen = -1L;
                logFile = null;
                if (str == null) break block6;
                try {
                    str.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static void rename(File logfile, String suffix) {
        String base;
        String name = logfile.getName();
        if (suffix != null) {
            String tail = "." + suffix;
            if (name.endsWith(tail)) {
                base = name.substring(0, name.length() - tail.length());
            } else {
                base = name;
                suffix = null;
            }
        } else {
            base = name;
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
        String dt = fmt.format(new Date());
        String nextName = suffix != null ? base + "." + dt + "." + suffix : base + "." + dt;
        File nextFile = new File(logfile.getParent(), nextName);
        if (!logfile.renameTo(nextFile)) {
            System.err.println("rename failed");
        }
    }

    public static void addSystemTap(PrintStream strm) {
        outTap.addTap(strm);
        errTap.addTap(strm);
    }

    public static void removeSystemTap(PrintStream strm) {
        outTap.removeTap(strm);
        errTap.removeTap(strm);
    }

    public static String getHistory() {
        StringBuilder buf = new StringBuilder();
        String[] data = history.getAll();
        for (int ix = 0; ix < data.length; ++ix) {
            buf.append(data[ix]);
            buf.append("\n");
        }
        return buf.toString();
    }

    public static void replayHistory(PrintStream strm) {
        if (strm == outTap) {
            strm = outTap.getSourceStream();
        } else if (strm == errTap) {
            strm = errTap.getSourceStream();
        }
        if (strm == null) {
            return;
        }
        String[] data = history.getAll();
        for (int ix = 0; ix < data.length; ++ix) {
            strm.println(data[ix]);
        }
    }

    public static void log(String msg) {
        LogSupport.getInstance().log(msg);
    }

    public static void proxyLog(String forGrp, String forThread, String msg) {
        LogSupport.getInstance().log(forGrp, forThread, msg);
    }

    public static void log(Object src, String method, String msg) {
        LogSupport.getInstance().log(src, method, msg);
    }

    public static void proxyLog(String forGrp, String forThread, Object src, String method, String msg) {
        LogSupport.getInstance().proxyLog(forGrp, forThread, src, method, msg);
    }

    public static void message(String msg) {
        LogSupport.getInstance().message(msg);
    }

    public static void proxyMessage(String forGrp, String forThread, String msg) {
        LogSupport.getInstance().proxyMessage(forGrp, forThread, msg);
    }

    public static void message(Object src, String method, String msg) {
        LogSupport.getInstance().message(src, method, msg);
    }

    public static void message(Object src, String method, String msg, long time) {
        LogSupport.getInstance().message(src, method, msg, time);
    }

    public static void proxyMessage(String forGrp, String forThread, Object src, String method, String msg) {
        LogSupport.getInstance().proxyMessage(forGrp, forThread, src, method, msg);
    }

    public static void error(String msg) {
        LogSupport.getInstance().error(msg);
    }

    public static void proxyError(String forGrp, String forThread, String msg) {
        LogSupport.getInstance().proxyError(forGrp, forThread, msg);
    }

    public static void error(Object src, String method, String msg) {
        LogSupport.getInstance().error(src, method, msg);
    }

    public static void proxyError(String forGrp, String forThread, Object src, String method, String msg) {
        LogSupport.getInstance().proxyError(forGrp, forThread, src, method, msg);
    }

    public static void exception(Object src, String method, Throwable ex, boolean trace) {
        LogSupport.getInstance().exception(src, method, ex, trace);
    }

    public static void proxyException(String forGrp, String forThread, Object src, String method, Throwable ex, boolean trace) {
        LogSupport.getInstance().proxyException(forGrp, forThread, src, method, ex, trace);
    }

    public static void exception(Object src, String method, Throwable ex, boolean trace, String msg) {
        LogSupport.getInstance().exception(src, method, ex, trace, msg);
    }

    public static void proxyException(String forGrp, String forThread, Object src, String method, Throwable ex, boolean trace, String msg) {
        LogSupport.getInstance().proxyException(forGrp, forThread, src, method, ex, trace, msg);
    }

    public static Logger getInstance() {
        if (instance == null) {
            LogSupport.createInstance();
        }
        return instance;
    }

    public static LogEmitter getEmitter() {
        if (instance == null) {
            LogSupport.createInstance();
        }
        return dftEmitter;
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            dftEmitter = new LogEmitter();
            instance = new Logger(dftEmitter);
        }
    }

    private static synchronized void stopInstance() {
        if (dftEmitter != null) {
            dftEmitter.terminate();
        }
    }

    static {
        System.setOut(outTap);
        System.setErr(errTap);
        instance = null;
        dftEmitter = null;
    }
}

