/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.image.gif;

import com.elluminate.util.image.ImageInfo;
import com.elluminate.util.image.gif.AnimationFrame;
import com.elluminate.util.image.gif.GifFile;
import com.elluminate.util.image.gif.GifImage;
import java.awt.Image;

public class ImageObject {
    private AnimationFrame[] imageArray;
    private long[] animationTimes = new long[0];
    private int frameCount = 0;
    private long cycleTime = 0L;
    private int pixelCountSum = 0;
    private GifFile gifFile;
    private int width;
    private int height;
    private boolean scaled;
    private String mimeType;

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("ImageObject: " + this.width + "x" + this.height + " " + this.gifFile + ", frames: " + this.imageArray.length);
        return str.toString();
    }

    public ImageObject(GifFile gifFile, String name) throws InterruptedException {
        this.gifFile = gifFile;
        this.frameCount = gifFile.getImageCount();
        this.width = gifFile.getWidth();
        this.height = gifFile.getHeight();
        this.imageArray = new AnimationFrame[this.frameCount];
        for (int i = 0; i < this.imageArray.length; ++i) {
            GifImage gifImage = gifFile.getGifImage(i);
            this.cycleTime += Math.max(10L, gifImage.getDelay());
            this.imageArray[i] = new AnimationFrame(gifImage, this.cycleTime, i);
            this.pixelCountSum += this.imageArray[i].getPixelCount();
        }
    }

    public ImageObject(GifFile gifFile, String name, int w, int h) throws InterruptedException {
        this.gifFile = gifFile;
        this.frameCount = gifFile.getImageCount();
        this.width = w;
        this.height = h;
        this.imageArray = new AnimationFrame[this.frameCount];
        for (int i = 0; i < this.imageArray.length; ++i) {
            GifImage gifImage = gifFile.getGifImage(i);
            Image orig = gifImage.getImage();
            Image scaled = orig.getScaledInstance(w, h, 4);
            this.cycleTime += Math.max(10L, gifImage.getDelay());
            this.imageArray[i] = new AnimationFrame(scaled, gifImage.getLeftOffset(), gifImage.getTopOffset(), gifImage.getDelay(), this.cycleTime, i);
            this.pixelCountSum += this.imageArray[i].getPixelCount();
            orig.flush();
        }
    }

    public ImageObject(Image image, String name) {
        this.frameCount = 1;
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        this.imageArray = new AnimationFrame[this.frameCount];
        this.imageArray[0] = new AnimationFrame(image, 0, 0, 0L, 0L, 0);
        this.pixelCountSum = this.imageArray[0].getPixelCount();
    }

    public ImageObject(ImageObject oldObject, String name, int desiredWidth, int desiredHeight, boolean retainAspect, boolean scaleUp, boolean scaleDown) {
        int newHeight;
        int newWidth;
        double scaleWidth = (double)desiredWidth / (double)this.width;
        double scaleHeight = (double)desiredHeight / (double)this.height;
        if (scaleDown && desiredWidth > this.width || desiredHeight > this.height || scaleUp && desiredWidth < this.width || desiredHeight < this.height) {
            if (retainAspect) {
                if (scaleWidth < scaleHeight) {
                    newWidth = (int)(scaleWidth * (double)this.width);
                    newHeight = (int)(scaleWidth * (double)this.height);
                } else {
                    newWidth = (int)(scaleHeight * (double)this.width);
                    newHeight = (int)(scaleHeight * (double)this.height);
                }
            } else {
                newWidth = (int)(scaleWidth * (double)this.width);
                newHeight = (int)(scaleHeight * (double)this.height);
            }
        } else {
            newWidth = this.width;
            newHeight = this.height;
        }
        this.frameCount = oldObject.getFrameCount();
        this.imageArray = new AnimationFrame[this.frameCount];
        for (int i = 0; i < this.frameCount; ++i) {
            Image image = oldObject.imageArray[i].getImage();
            this.imageArray[i] = new AnimationFrame(image.getScaledInstance(newWidth, newHeight, 4), oldObject.imageArray[i].getLeftOffset(), oldObject.imageArray[i].getTopOffset(), oldObject.imageArray[i].getAnimationTime(), oldObject.imageArray[i].getAnimationEnd(), i);
        }
    }

    public ImageObject(ImageInfo imgInfo, String name) {
        this(imgInfo.getImage(), name);
        this.scaled = imgInfo.isScaled();
        this.mimeType = imgInfo.getMimeType();
    }

    public boolean isScaled() {
        return this.scaled;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public void flush() {
        for (int i = 0; i < this.imageArray.length; ++i) {
            if (this.imageArray[i] == null) continue;
            this.imageArray[i].flush();
            this.imageArray[i] = null;
        }
    }

    public AnimationFrame getAnimationFrame(int imageIndex) {
        return this.imageArray[imageIndex];
    }

    public AnimationFrame getAnimationFrame() {
        return this.imageArray[0];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPixelSum() {
        return this.pixelCountSum;
    }
}

